/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.ArrayList;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;

public class FunctionStyleMacro
extends ObjectStyleMacro {
    private static final char[] VA_ARGS_CHARARRAY = "__VA_ARGS__".toCharArray();
    private static final char[] ELLIPSIS_CHARARRAY = "...".toString().toCharArray();
    public char[][] arglist;
    private char[] sig = null;
    private boolean hasVarArgs = false;
    private boolean hasGCCVarArgs = false;
    private int varArgsPosition = -1;

    public FunctionStyleMacro(char[] name, char[] expansion, char[][] arglist) {
        super(name, expansion);
        this.arglist = arglist;
        if (arglist != null && arglist.length > 0 && arglist[0] != null) {
            int last = -1;
            if (arglist[arglist.length - 1] == null) {
                int largest = arglist.length - 1;
                int smallest = 0;
                int j = arglist.length / 2;
                while (last == -1) {
                    if (arglist[j] == null) {
                        largest = j;
                        j = smallest + (largest - smallest) / 2;
                        continue;
                    }
                    smallest = j;
                    if (((j = smallest + (largest - smallest) / 2) + 1 != arglist.length || arglist[j] == null) && (arglist[j] == null || arglist[j + 1] != null)) continue;
                    last = j;
                }
            } else {
                last = arglist.length - 1;
            }
            if (arglist[last] != null && CharArrayUtils.equals(arglist[last], ELLIPSIS_CHARARRAY)) {
                this.hasVarArgs = true;
                this.varArgsPosition = last;
                arglist[last] = VA_ARGS_CHARARRAY;
            } else if (arglist[last] != null && CharArrayUtils.equals(arglist[last], arglist[last].length - ELLIPSIS_CHARARRAY.length, ELLIPSIS_CHARARRAY.length, ELLIPSIS_CHARARRAY)) {
                this.hasGCCVarArgs = true;
                this.varArgsPosition = last;
                char[] swap = new char[arglist[last].length - ELLIPSIS_CHARARRAY.length];
                System.arraycopy(arglist[last], 0, swap, 0, swap.length);
                arglist[last] = swap;
            }
        }
    }

    public char[][] getOriginalParameters() {
        if (this.varArgsPosition == -1) {
            return this.arglist;
        }
        ArrayList<char[]> result = new ArrayList<char[]>(this.arglist.length);
        int i = 0;
        while (i < this.arglist.length) {
            char[] var = this.arglist[i];
            if (var != null) {
                if (i != this.varArgsPosition) {
                    result.add(var);
                } else if (CharArrayUtils.equals(var, VA_ARGS_CHARARRAY)) {
                    result.add(ELLIPSIS_CHARARRAY);
                } else {
                    char[] varell = new char[var.length + ELLIPSIS_CHARARRAY.length];
                    System.arraycopy(var, 0, varell, 0, var.length);
                    System.arraycopy(ELLIPSIS_CHARARRAY, 0, varell, var.length, ELLIPSIS_CHARARRAY.length);
                    result.add(varell);
                }
            }
            ++i;
        }
        return (char[][])result.toArray((T[])new char[result.size()][]);
    }

    public char[] getSignature() {
        if (this.sig != null) {
            return this.sig;
        }
        int len = this.name.length + 2;
        int i = 0;
        while (i < this.arglist.length && this.arglist[i] != null) {
            if (i + 1 < this.arglist.length && this.arglist[i + 1] != null) {
                ++len;
            }
            len += this.arglist[i].length;
            ++i;
        }
        this.sig = new char[len];
        System.arraycopy(this.name, 0, this.sig, 0, this.name.length);
        this.sig[this.name.length] = 40;
        int idx = this.name.length + 1;
        int i2 = 0;
        while (i2 < this.arglist.length && this.arglist[i2] != null) {
            System.arraycopy(this.arglist[i2], 0, this.sig, idx, this.arglist[i2].length);
            idx += this.arglist[i2].length;
            if (i2 + 1 < this.arglist.length && this.arglist[i2 + 1] != null) {
                this.sig[idx++] = 44;
            }
            ++i2;
        }
        this.sig[idx] = 41;
        return this.sig;
    }

    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    public boolean hasGCCVarArgs() {
        return this.hasGCCVarArgs;
    }

    public int getVarArgsPosition() {
        return this.varArgsPosition;
    }

    public class Expansion {
        public final CharArrayObjectMap definitions;

        public Expansion() {
            this.definitions = new CharArrayObjectMap(FunctionStyleMacro.this.arglist.length);
        }
    }
}

