/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.ParserMessages;

public class ScannerASTProblem
extends ASTNode
implements IASTProblem {
    private final char[] arg;
    private final int id;
    private final boolean isError;
    private final boolean isWarning;
    private String message = null;
    protected static final Map errorMessages = new HashMap();
    protected static final String PROBLEM_PATTERN = "BaseProblemFactory.problemPattern";

    static {
        errorMessages.put(new Integer(0x2000001), ParserMessages.getString("ScannerProblemFactory.error.preproc.error"));
        errorMessages.put(new Integer(0x200000E), ParserMessages.getString("ScannerProblemFactory.error.preproc.warning"));
        errorMessages.put(new Integer(0x2000002), ParserMessages.getString("ScannerProblemFactory.error.preproc.inclusionNotFound"));
        errorMessages.put(new Integer(0x2000003), ParserMessages.getString("ScannerProblemFactory.error.preproc.definitionNotFound"));
        errorMessages.put(new Integer(0x2000005), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroDefn"));
        errorMessages.put(new Integer(0x2000007), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroRedefn"));
        errorMessages.put(new Integer(0x2000004), ParserMessages.getString("ScannerProblemFactory.error.preproc.unbalancedConditional"));
        errorMessages.put(new Integer(0x2000008), ParserMessages.getString("ScannerProblemFactory.error.preproc.conditionalEval"));
        errorMessages.put(new Integer(0x2000009), ParserMessages.getString("ScannerProblemFactory.error.preproc.macroUsage"));
        errorMessages.put(new Integer(0x200000B), ParserMessages.getString("ScannerProblemFactory.error.preproc.circularInclusion"));
        errorMessages.put(new Integer(0x2000006), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidDirective"));
        errorMessages.put(new Integer(0x200000A), ParserMessages.getString("ScannerProblemFactory.error.preproc.macroPasting"));
        errorMessages.put(new Integer(0x200000C), ParserMessages.getString("ScannerProblemFactory.error.preproc.missingRParen"));
        errorMessages.put(new Integer(0x200000D), ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidVaArgs"));
        errorMessages.put(new Integer(0x1000003), ParserMessages.getString("ScannerProblemFactory.error.scanner.invalidEscapeChar"));
        errorMessages.put(new Integer(0x1000002), ParserMessages.getString("ScannerProblemFactory.error.scanner.unboundedString"));
        errorMessages.put(new Integer(0x1000004), ParserMessages.getString("ScannerProblemFactory.error.scanner.badFloatingPoint"));
        errorMessages.put(new Integer(0x1000005), ParserMessages.getString("ScannerProblemFactory.error.scanner.badHexFormat"));
        errorMessages.put(new Integer(0x1000007), ParserMessages.getString("ScannerProblemFactory.error.scanner.badOctalFormat"));
        errorMessages.put(new Integer(0x1000008), ParserMessages.getString("ScannerProblemFactory.error.scanner.badDecimalFormat"));
        errorMessages.put(new Integer(0x1000009), ParserMessages.getString("ScannerProblemFactory.error.scanner.assignmentNotAllowed"));
        errorMessages.put(new Integer(0x100000A), ParserMessages.getString("ScannerProblemFactory.error.scanner.divideByZero"));
        errorMessages.put(new Integer(0x100000B), ParserMessages.getString("ScannerProblemFactory.error.scanner.missingRParen"));
        errorMessages.put(new Integer(0x100000C), ParserMessages.getString("ScannerProblemFactory.error.scanner.expressionSyntaxError"));
        errorMessages.put(new Integer(0x100000D), ParserMessages.getString("ScannerProblemFactory.error.scanner.illegalIdentifier"));
        errorMessages.put(new Integer(0x100000E), ParserMessages.getString("ScannerProblemFactory.error.scanner.badConditionalExpression"));
        errorMessages.put(new Integer(0x1000006), ParserMessages.getString("ScannerProblemFactory.error.scanner.unexpectedEOF"));
        errorMessages.put(new Integer(0x1000001), ParserMessages.getString("ScannerProblemFactory.error.scanner.badCharacter"));
        errorMessages.put(new Integer(0x4000001), ParserMessages.getString("ParserProblemFactory.error.syntax.syntaxError"));
    }

    public ScannerASTProblem(int id, char[] arg, boolean warn, boolean error) {
        this.id = id;
        this.arg = arg;
        this.isWarning = warn;
        this.isError = error;
    }

    public int getID() {
        return this.id;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        String msg = (String)errorMessages.get(new Integer(this.id));
        if (msg == null) {
            msg = "";
        }
        if (this.arg != null) {
            msg = MessageFormat.format(msg, new String(this.arg));
        }
        IASTFileLocation f = this.getFileLocation();
        String file = null;
        int line = 0;
        if (f == null) {
            file = "";
        } else {
            file = f.getFileName();
            line = f.getStartingLineNumber();
        }
        Object[] args = new Object[]{msg, file, new Integer(line)};
        this.message = ParserMessages.getFormattedString(PROBLEM_PATTERN, args);
        return this.message;
    }

    public boolean checkCategory(int bitmask) {
        return (this.id & bitmask) != 0;
    }

    public String getArguments() {
        return this.arg != null ? String.valueOf(this.arg) : "";
    }
}

