/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.HashSet;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMUpdateTask;

public class IndexUpdatePolicy {
    public static final int POST_CHANGE = 0;
    public static final int POST_BUILD = 1;
    public static final int MANUAL = 2;
    private final ICProject fCProject;
    private int fKind;
    private HashSet fAdded = new HashSet();
    private HashSet fChanged = new HashSet();
    private HashSet fRemoved = new HashSet();
    private IPDOMIndexer fIndexer;
    private boolean fReindexRequested;

    public IndexUpdatePolicy(ICProject project, int kind) {
        this.fCProject = project;
        this.fKind = this.getLegalPolicy(kind);
    }

    private int getLegalPolicy(int kind) {
        switch (kind) {
            case 0: 
            case 1: 
            case 2: {
                return kind;
            }
        }
        return 0;
    }

    public ICProject getProject() {
        return this.fCProject;
    }

    public void clearTUs() {
        this.fAdded.clear();
        this.fChanged.clear();
        this.fRemoved.clear();
    }

    public boolean hasTUs() {
        return !this.fAdded.isEmpty() || !this.fChanged.isEmpty() || !this.fRemoved.isEmpty();
    }

    private ITranslationUnit[] getAdded() {
        return this.fAdded.toArray(new ITranslationUnit[this.fAdded.size()]);
    }

    private ITranslationUnit[] getChanged() {
        return this.fChanged.toArray(new ITranslationUnit[this.fChanged.size()]);
    }

    private ITranslationUnit[] getRemoved() {
        return this.fRemoved.toArray(new ITranslationUnit[this.fRemoved.size()]);
    }

    public void setIndexer(IPDOMIndexer indexer) {
        this.fIndexer = indexer;
    }

    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    public IPDOMIndexerTask handleDelta(ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        ITranslationUnit tu;
        if (this.isNullIndexer()) {
            return null;
        }
        switch (this.fKind) {
            case 2: {
                return null;
            }
            case 0: {
                if (this.fIndexer == null) break;
                return this.fIndexer.createTask(added, changed, removed);
            }
        }
        int i = 0;
        while (i < removed.length) {
            tu = removed[i];
            this.fAdded.remove(tu);
            this.fChanged.remove(tu);
            this.fRemoved.add(tu);
            ++i;
        }
        i = 0;
        while (i < added.length) {
            tu = added[i];
            if (!this.fChanged.contains(tu)) {
                this.fAdded.add(tu);
            }
            this.fRemoved.remove(tu);
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            tu = changed[i];
            if (!this.fAdded.contains(tu)) {
                this.fChanged.add(tu);
            }
            this.fRemoved.remove(tu);
            ++i;
        }
        return null;
    }

    public IPDOMIndexerTask createTask() {
        IPDOMIndexerTask task = null;
        if (this.fIndexer != null && this.hasTUs()) {
            if (this.fKind != 2 && !this.isNullIndexer()) {
                task = this.fIndexer.createTask(this.getAdded(), this.getChanged(), this.getRemoved());
            }
            this.clearTUs();
        }
        return task;
    }

    private boolean isNullIndexer() {
        return this.fIndexer != null && this.fIndexer.getID().equals("org.eclipse.cdt.core.nullindexer");
    }

    public IPDOMIndexerTask changePolicy(int updatePolicy) {
        int oldPolicy = this.fKind;
        this.fKind = this.getLegalPolicy(updatePolicy);
        IPDOMIndexerTask task = null;
        if (this.fKind == 2 || this.isNullIndexer()) {
            this.clearTUs();
        } else if (this.fIndexer != null) {
            if (oldPolicy == 2) {
                task = new PDOMUpdateTask(this.fIndexer, 2);
                this.clearTUs();
            } else if (this.fKind == 0) {
                task = this.createTask();
            }
        }
        return task;
    }

    public void requestInitialReindex() {
        this.fReindexRequested = true;
    }

    public void clearInitialFlags() {
        this.fReindexRequested = false;
    }

    public boolean isInitialRebuildRequested() {
        return this.fReindexRequested;
    }
}

