/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PDOMProxy
implements IPDOM {
    private PDOM fDelegate;
    private int fReadLockCount;
    private Set fListeners = new HashSet();
    static /* synthetic */ Class class$0;

    public synchronized void acquireReadLock() throws InterruptedException {
        if (this.fDelegate != null) {
            this.fDelegate.acquireReadLock();
        } else {
            ++this.fReadLockCount;
        }
    }

    public IIndexMacro[] findMacros(char[] name, boolean isPrefix, boolean caseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findMacros(name, isPrefix, caseSensitive, filter, monitor);
        }
        return IIndexMacro.EMPTY_INDEX_MACRO_ARRAY;
    }

    public synchronized IIndexFragmentBinding adaptBinding(IBinding binding) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.adaptBinding(binding);
        }
        return null;
    }

    public synchronized IIndexFragmentBinding adaptBinding(IIndexFragmentBinding proxy) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.adaptBinding(proxy);
        }
        return null;
    }

    public synchronized IIndexFragmentBinding findBinding(IASTName astName) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBinding(astName);
        }
        return null;
    }

    public synchronized IIndexFragmentBinding[] findBindings(char[][] names, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindings(names, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    public synchronized IIndexFragmentBinding[] findBindings(Pattern[] patterns, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindings(patterns, isFullyQualified, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    public synchronized IIndexFragmentBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindingsForPrefix(prefix, filescope, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    public synchronized IIndexFragmentInclude[] findIncludedBy(IIndexFragmentFile file) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findIncludedBy(file);
        }
        return new IIndexFragmentInclude[0];
    }

    public synchronized IIndexFragmentName[] findNames(IIndexFragmentBinding binding, int flags) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findNames(binding, flags);
        }
        return IIndexFragmentName.EMPTY_NAME_ARRAY;
    }

    public synchronized long getCacheHits() {
        if (this.fDelegate != null) {
            return this.fDelegate.getCacheHits();
        }
        return 0L;
    }

    public synchronized long getCacheMisses() {
        if (this.fDelegate != null) {
            return this.fDelegate.getCacheMisses();
        }
        return 0L;
    }

    public synchronized IIndexFragmentFile getFile(IIndexFileLocation location) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getFile(location);
        }
        return null;
    }

    public synchronized long getLastWriteAccess() {
        if (this.fDelegate != null) {
            return this.fDelegate.getLastWriteAccess();
        }
        return 0L;
    }

    public synchronized IIndexLinkage[] getLinkages() {
        if (this.fDelegate != null) {
            return this.fDelegate.getLinkages();
        }
        return new IIndexLinkage[0];
    }

    public synchronized String getProperty(String propertyName) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getProperty(propertyName);
        }
        return null;
    }

    public synchronized void releaseReadLock() {
        if (this.fDelegate != null) {
            this.fDelegate.releaseReadLock();
        } else {
            --this.fReadLockCount;
        }
    }

    public synchronized void resetCacheCounters() {
        if (this.fDelegate != null) {
            this.fDelegate.resetCacheCounters();
        }
    }

    public synchronized Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.PDOMProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.isAssignableFrom(clazz)) {
            return this;
        }
        return null;
    }

    public synchronized void addListener(PDOM.IListener listener) {
        if (this.fDelegate != null) {
            this.fDelegate.addListener(listener);
        } else {
            this.fListeners.add(listener);
        }
    }

    public synchronized PDOMLinkage[] getLinkageImpls() {
        if (this.fDelegate != null) {
            return this.fDelegate.getLinkageImpls();
        }
        return new PDOMLinkage[0];
    }

    public synchronized void removeListener(PDOM.IListener listener) {
        if (this.fDelegate != null) {
            this.fDelegate.removeListener(listener);
        } else {
            this.fListeners.remove(listener);
        }
    }

    public synchronized void setDelegate(WritablePDOM pdom) {
        PDOM.IListener listener;
        Iterator iterator;
        this.fDelegate = pdom;
        try {
            while (this.fReadLockCount-- > 0) {
                pdom.acquireReadLock();
            }
            iterator = this.fListeners.iterator();
            while (iterator.hasNext()) {
                listener = (PDOM.IListener)iterator.next();
                pdom.addListener(listener);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            listener = (PDOM.IListener)iterator.next();
            listener.handleChange(this.fDelegate);
        }
    }
}

