/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBase;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypedef;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPBase
implements ICPPBase,
ICPPInternalBase {
    private static final int BASECLASS_SPECIFIER = 0;
    private static final int NEXTBASE = 4;
    private static final int FLAGS = 8;
    protected static final int RECORD_SIZE = 9;
    protected final PDOM pdom;
    protected final int record;

    public PDOMCPPBase(PDOM pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMCPPBase(PDOM pdom, PDOMName baseClassSpec, boolean isVirtual, int visibility) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(9);
        int baserec = baseClassSpec != null ? baseClassSpec.getRecord() : 0;
        db.putInt(this.record + 0, baserec);
        byte flags = (byte)(visibility | (isVirtual ? 4 : 0));
        db.putByte(this.record + 8, flags);
    }

    public int getRecord() {
        return this.record;
    }

    public void setNextBase(PDOMCPPBase nextBase) throws CoreException {
        int rec = nextBase != null ? nextBase.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 4, rec);
    }

    public PDOMCPPBase getNextBase() throws CoreException {
        int rec = this.pdom.getDB().getInt(this.record + 4);
        return rec != 0 ? new PDOMCPPBase(this.pdom, rec) : null;
    }

    private int getFlags() throws CoreException {
        return this.pdom.getDB().getByte(this.record + 8);
    }

    public PDOMName getBaseClassSpecifierNameImpl() {
        try {
            int rec = this.pdom.getDB().getInt(this.record + 0);
            if (rec != 0) {
                return new PDOMName(this.pdom, rec);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public IName getBaseClassSpecifierName() {
        return this.getBaseClassSpecifierNameImpl();
    }

    public IBinding getBaseClass() {
        try {
            PDOMName name = this.getBaseClassSpecifierNameImpl();
            if (name != null) {
                PDOMBinding b = name.getPDOMBinding();
                while (b instanceof PDOMCPPTypedef && ((PDOMCPPTypedef)b).getType() instanceof PDOMBinding) {
                    b = (PDOMBinding)((Object)((PDOMCPPTypedef)b).getType());
                }
                return b;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public int getVisibility() {
        try {
            return this.getFlags() & 3;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public boolean isVirtual() {
        try {
            return (this.getFlags() & 4) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public void delete() throws CoreException {
        this.pdom.getDB().free(this.record);
    }

    public void setBaseClass(IBinding binding) {
        throw new PDOMNotImplementedError();
    }

    public Object clone() {
        return new PDOMCPPBaseClone(this);
    }

    private static class PDOMCPPBaseClone
    implements ICPPBase,
    ICPPInternalBase {
        private ICPPBase base;
        private IBinding baseClass = null;

        public PDOMCPPBaseClone(ICPPBase base) {
            this.base = base;
        }

        public IBinding getBaseClass() throws DOMException {
            if (this.baseClass == null) {
                return this.base.getBaseClass();
            }
            return this.baseClass;
        }

        public IName getBaseClassSpecifierName() {
            return this.base.getBaseClassSpecifierName();
        }

        public int getVisibility() throws DOMException {
            return this.base.getVisibility();
        }

        public boolean isVirtual() throws DOMException {
            return this.base.isVirtual();
        }

        public void setBaseClass(IBinding binding) {
            this.baseClass = binding;
        }

        public Object clone() {
            return new PDOMCPPBaseClone(this);
        }
    }
}

