/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPFunctionType
extends PDOMCFunctionType
implements ICPPFunctionType {
    private static final int FLAGS = 16;
    private static final int RECORD_SIZE = 20;

    protected PDOMCPPFunctionType(PDOM pdom, int offset) {
        super(pdom, offset);
    }

    protected PDOMCPPFunctionType(PDOM pdom, PDOMNode parent, ICPPFunctionType type) throws CoreException {
        super(pdom, parent, type);
        byte modifiers = PDOMCAnnotation.encodeCVQualifiers(type);
        pdom.getDB().putInt(this.getRecord() + 16, modifiers);
    }

    public boolean isConst() {
        return this.getBit(this.getInt(this.record + 16), 0);
    }

    public boolean isVolatile() {
        return this.getBit(this.getInt(this.record + 16), 1);
    }

    protected int getRecordSize() {
        return 20;
    }

    public boolean isSameType(IType type) {
        if (type instanceof ICPPFunctionType && super.isSameType(type)) {
            ICPPFunctionType ft = (ICPPFunctionType)type;
            return this.isConst() == ft.isConst() && this.isVolatile() == ft.isVolatile();
        }
        return false;
    }

    public int getNodeType() {
        return 43;
    }
}

