/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.export;

import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.export.IExportProjectProvider;
import org.eclipse.cdt.internal.core.pdom.export.CLIUtil;
import org.eclipse.cdt.internal.core.pdom.export.GeneratePDOM;
import org.eclipse.cdt.internal.core.pdom.export.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class GeneratePDOMApplication
implements IApplication {
    private static final String EXPORT_PROJECT_PROVIDER = "ExportProjectProvider";
    private static final String DEFAULT_PROJECT_PROVIDER;
    public static final String OPT_PROJECTPROVIDER = "-pprovider";
    public static final String OPT_TARGET = "-target";
    public static final String OPT_QUIET = "-quiet";
    public static final String OPT_INDEXER_ID = "-indexer";
    public static final int ECODE_EXPECTED_FAILURE = 1;
    private static Map projectInitializers;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.index.export.ExternalExportProjectProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DEFAULT_PROJECT_PROVIDER = clazz.getName();
    }

    public Object start(IApplicationContext context) throws CoreException {
        Object result = IApplication.EXIT_OK;
        try {
            result = this.startImpl(context);
        }
        catch (CoreException ce) {
            IStatus s = ce.getStatus();
            if (s.getCode() == 1) {
                this.output(s.getMessage());
            }
            throw ce;
        }
        return result;
    }

    private Object startImpl(IApplicationContext context) throws CoreException {
        IExportProjectProvider pprovider;
        String pproviderFQN;
        String[] appArgs = (String[])context.getArguments().get("application.args");
        Map arguments = CLIUtil.parseToMap(appArgs);
        this.output(Messages.GeneratePDOMApplication_Initializing);
        this.setupCLIProgressProvider();
        if (!arguments.containsKey(OPT_PROJECTPROVIDER)) {
            this.output(MessageFormat.format(Messages.GeneratePDOMApplication_UsingDefaultProjectProvider, DEFAULT_PROJECT_PROVIDER));
            pproviderFQN = DEFAULT_PROJECT_PROVIDER;
        } else {
            pproviderFQN = (String)CLIUtil.getArg(arguments, OPT_PROJECTPROVIDER, 1).get(0);
        }
        String target = (String)CLIUtil.getArg(arguments, OPT_TARGET, 1).get(0);
        boolean quiet = arguments.get(OPT_QUIET) != null;
        String indexerID = "org.eclipse.cdt.core.fastIndexer";
        String[] indexerIDs = (String[])arguments.get(OPT_INDEXER_ID);
        if (indexerIDs != null) {
            if (indexerIDs.length == 1) {
                indexerID = indexerIDs[0];
            } else if (indexerIDs.length > 1) {
                GeneratePDOMApplication.fail(MessageFormat.format(Messages.GeneratePDOMApplication_InvalidIndexerID, OPT_INDEXER_ID));
            }
        }
        if (!quiet) {
            System.setProperty("org.eclipse.cdt.core/debug/indexer/activity", Boolean.TRUE.toString());
            System.setProperty("org.eclipse.cdt.core/debug/indexer/problems", Boolean.TRUE.toString());
            System.setProperty("org.eclipse.cdt.core/debug/indexer/statistics", Boolean.TRUE.toString());
        }
        if ((pprovider = GeneratePDOMApplication.getExportProjectProvider(pproviderFQN)) == null) {
            GeneratePDOMApplication.fail(MessageFormat.format(Messages.GeneratePDOMApplication_CouldNotFindInitializer, pproviderFQN));
        }
        File targetLocation = new File(target);
        GeneratePDOM generate = new GeneratePDOM(pprovider, appArgs, targetLocation, indexerID);
        this.output(Messages.GeneratePDOMApplication_GenerationStarts);
        generate.run();
        this.output(Messages.GeneratePDOMApplication_GenerationEnds);
        return null;
    }

    protected void output(String s) {
        System.out.println(s);
    }

    public void stop() {
    }

    public static final void fail(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.cdt.core", 1, message, null);
        CCorePlugin.log((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    private static synchronized IExportProjectProvider getExportProjectProvider(String fqn) {
        if (projectInitializers == null) {
            projectInitializers = new HashMap();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint indexExtensions = registry.getExtensionPoint("org.eclipse.cdt.core.CIndex");
            IExtension[] extensions = indexExtensions.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] ce = extension.getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    if (ce[j].getName().equals(EXPORT_PROJECT_PROVIDER)) {
                        try {
                            IExportProjectProvider epp = (IExportProjectProvider)ce[j].createExecutableExtension("class");
                            projectInitializers.put(epp.getClass().getName(), epp);
                        }
                        catch (CoreException cee) {
                            CCorePlugin.log(cee);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        IExportProjectProvider initer = (IExportProjectProvider)projectInitializers.get(fqn);
        return initer;
    }

    private void setupCLIProgressProvider() {
        ProgressProvider pp = new ProgressProvider(){

            public IProgressMonitor createMonitor(Job job) {
                return new IndexingStreamProgressMonitor(System.out);
            }

            public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
                return new NullProgressMonitor();
            }

            public IProgressMonitor createProgressGroup() {
                return new NullProgressMonitor();
            }

            class IndexingStreamProgressMonitor
            extends StreamProgressMonitor {
                public IndexingStreamProgressMonitor(PrintStream writer) {
                    super(writer);
                }

                protected boolean shouldOutput() {
                    return this.taskName != null && this.taskName.equals(CCorePlugin.getResourceString("pdom.indexer.task"));
                }
            }
        };
        Job.getJobManager().setProgressProvider(pp);
    }

    static class StreamProgressMonitor
    implements IProgressMonitor {
        volatile boolean canceled;
        volatile int totalWork;
        volatile double worked;
        final PrintStream writer;
        volatile String taskName;
        volatile String subTask;
        Object mutex = new Object();

        StreamProgressMonitor(PrintStream writer) {
            this.writer = writer;
            this.totalWork = -1;
        }

        protected boolean shouldOutput() {
            return true;
        }

        public void done() {
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void beginTask(String name, int totalWork) {
            this.taskName = name;
            this.totalWork = totalWork;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void internalWorked(double work) {
            Object object = this.mutex;
            synchronized (object) {
                int pc;
                this.worked += work;
                int n = pc = this.totalWork < 1 ? 0 : (int)(this.worked * 100.0 / (double)this.totalWork);
                if (this.shouldOutput()) {
                    this.writer.println(String.valueOf(pc) + "% " + this.subTask);
                }
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean value) {
            this.canceled = value;
        }

        public void setTaskName(String name) {
            this.taskName = name;
        }

        public void subTask(String name) {
            this.subTask = name;
        }
    }
}

