/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.util.XmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.CStorage;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.w3c.dom.Element;

public class InternalXmlStorageElement
extends XmlStorageElement {
    boolean fIsDirty;
    Element fElement;
    private boolean fIsReadOnly;
    private List fStorageList;

    public InternalXmlStorageElement(Element element, ICStorageElement parent, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters, boolean readOnly) {
        super(element, parent, alowReferencingParent, attributeFilters, childFilters);
        this.fElement = element;
        this.fIsReadOnly = readOnly;
    }

    public InternalXmlStorageElement(Element element, ICStorageElement parent, boolean alowReferencingParent, boolean readOnly) {
        super(element, parent, alowReferencingParent);
        this.fElement = element;
        this.fIsReadOnly = readOnly;
    }

    public InternalXmlStorageElement(Element element, boolean readOnly) {
        super(element);
        this.fElement = element;
        this.fIsReadOnly = readOnly;
    }

    void storageCreated(CStorage storage) {
        List list = this.getStorageList(true);
        list.add(storage);
    }

    private List getStorageList(boolean create) {
        if (this.fStorageList == null && create) {
            this.fStorageList = new ArrayList();
        }
        return this.fStorageList;
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.setReadOnly(readOnly, true);
    }

    public void setReadOnly(boolean readOnly, boolean keepModify) {
        this.fIsReadOnly = readOnly;
        this.fIsDirty &= keepModify;
        ICStorageElement[] children = this.getChildren(false);
        int i = 0;
        while (i < children.length) {
            ((InternalXmlStorageElement)children[i]).setReadOnly(readOnly, keepModify);
            ++i;
        }
    }

    public boolean isDirty() {
        if (this.fIsDirty) {
            return true;
        }
        List list = this.getStorageList(false);
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                CStorage storage = (CStorage)iter.next();
                if (!storage.isDirty()) continue;
                return true;
            }
        }
        ICStorageElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (((InternalXmlStorageElement)children[i]).isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDirty(boolean dirty) {
        this.fIsDirty = dirty;
        if (!dirty) {
            List list = this.getStorageList(false);
            if (list != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    CStorage storage = (CStorage)iter.next();
                    storage.setDirty(false);
                }
            }
            ICStorageElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                ((InternalXmlStorageElement)children[i]).setDirty(false);
                ++i;
            }
        }
    }

    public void clear() {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        super.clear();
        this.fIsDirty = true;
    }

    protected XmlStorageElement createChild(Element element, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        return new InternalXmlStorageElement(element, this, alowReferencingParent, attributeFilters, childFilters, this.fIsReadOnly);
    }

    public ICStorageElement createChild(String name, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsDirty = true;
        return super.createChild(name, alowReferencingParent, attributeFilters, childFilters);
    }

    public ICStorageElement createChild(String name) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsDirty = true;
        return super.createChild(name);
    }

    public void removeAttribute(String name) {
        this.fIsDirty = true;
        super.removeAttribute(name);
    }

    public void setAttribute(String name, String value) {
        this.fIsDirty = true;
        super.setAttribute(name, value);
    }

    public void setValue(String value) {
        this.fIsDirty = true;
        super.setValue(value);
    }

    protected void removed() {
        super.removed();
    }

    public ICStorageElement importChild(ICStorageElement el) throws UnsupportedOperationException {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsDirty = true;
        return super.importChild(el);
    }

    public void removeChild(ICStorageElement el) {
        if (this.fIsReadOnly) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsDirty = true;
        super.removeChild(el);
    }
}

