/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.testplugin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.DiffUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class ManagedBuildTestHelper {
    private static final String rcbsToolId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs");
    private static final String rcbsToolName = new String("Resource Custom Build Step");
    private static final String rcbsToolInputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.inputtype");
    private static final String rcbsToolInputTypeName = new String("Resource Custom Build Step Input Type");
    private static final String rcbsToolOutputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.outputtype");
    private static final String rcbsToolOutputTypeName = new String("Resource Custom Build Step Output Type");
    private static final String PATH_SEPERATOR = ";";

    public static IProject createProject(String name, IPath location, String projectId, String projectTypeId) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject newProjectHandle = root.getProject(name);
        IProject project = null;
        if (!newProjectHandle.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (projectId.equals(ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID)) {
                ManagedBuildTestHelper.createNewManagedProject(newProjectHandle, name, location, projectId, projectTypeId);
                project = newProjectHandle;
            } else {
                IWorkspaceDescription workspaceDesc = workspace.getDescription();
                workspaceDesc.setAutoBuilding(false);
                workspace.setDescription(workspaceDesc);
                IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
                project = CCorePlugin.getDefault().createCProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
            }
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            project = newProjectHandle;
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    public static IProject createProject(String name, String projectTypeId) {
        try {
            return ManagedBuildTestHelper.createProject(name, null, ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID, projectTypeId);
        }
        catch (CoreException e) {
            TestCase.fail((String)e.getLocalizedMessage());
            return null;
        }
    }

    public static IFile createFile(IProject project, String name) {
        return ManagedBuildTestHelper.createFile(project, name, new ByteArrayInputStream(new byte[0]));
    }

    public static IFile createFile(IProject project, String name, String contents) {
        return ManagedBuildTestHelper.createFile(project, name, new ByteArrayInputStream(contents.getBytes()));
    }

    public static IFile createFile(IProject project, String name, InputStream contents) {
        IFile file = project.getFile(name);
        if (!file.exists()) {
            try {
                IFolder rc;
                IPath dirPath = file.getFullPath().removeLastSegments(1).removeFirstSegments(1);
                if (dirPath.segmentCount() > 0 && !(rc = project.getFolder(dirPath)).exists()) {
                    rc.create(true, true, null);
                }
                file.create(contents, false, null);
            }
            catch (CoreException e) {
                TestCase.fail((String)e.getLocalizedMessage());
            }
        }
        return file;
    }

    public static IFolder createFolder(IProject project, String name) {
        IFolder folder = project.getFolder(name);
        if (!folder.exists()) {
            try {
                IFolder rc;
                IPath dirPath = folder.getFullPath().removeLastSegments(1).removeFirstSegments(1);
                if (dirPath.segmentCount() > 0 && !(rc = project.getFolder(dirPath)).exists()) {
                    rc.create(true, true, null);
                }
                folder.create(true, false, null);
            }
            catch (CoreException e) {
                TestCase.fail((String)e.getLocalizedMessage());
            }
        }
        return folder;
    }

    public static void removeProject(String name) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject project = root.getProject(name);
        if (project.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    System.gc();
                    System.runFinalization();
                    project.delete(true, true, null);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            try {
                workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            }
            catch (CoreException e2) {
                Assert.fail((String)("failed to remove the project: " + e2.getLocalizedMessage()));
            }
        }
    }

    public static IProject loadProject(String name, String path) {
        IPath zipPath = new Path("resources").append(path).append(name).append(name).addFileExtension("zip");
        File zipFile = CTestPlugin.getFileInPlugin(zipPath);
        if (zipFile == null) {
            zipPath = new Path("resources").append(path).append(name).addFileExtension("zip");
            zipFile = CTestPlugin.getFileInPlugin(zipPath);
        }
        if (zipFile == null) {
            Assert.fail((String)("zip file " + zipPath.toString() + " is missing."));
            return null;
        }
        try {
            return ManagedBuildTestHelper.createProject(name, zipFile, null, null);
        }
        catch (Exception e) {
            Assert.fail((String)("fail to create the project: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public static IProject createProject(String projectName, File zip, IPath location, String projectTypeId) throws CoreException, InvocationTargetException, IOException {
        IPath destPath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project.exists()) {
            ManagedBuildTestHelper.removeProject(projectName);
        }
        IPath iPath = destPath = location != null ? location : project.getFullPath();
        if (zip != null) {
            ManagedBuildTestHelper.importFilesFromZip(new ZipFile(zip), destPath, null);
        }
        return ManagedBuildTestHelper.createProject(projectName, location, ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID, projectTypeId);
    }

    public static void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        try {
            ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "ALL";
                }
            });
            op.run(monitor);
        }
        catch (InterruptedException interruptedException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public static IProject createNewManagedProject(IProject newProjectHandle, String name, final IPath location, final String projectId, final String projectTypeId) throws CoreException {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject project = newProjectHandle;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IWorkspaceDescription workspaceDesc = workspace.getDescription();
                workspaceDesc.setAutoBuilding(false);
                workspace.setDescription(workspaceDesc);
                IProjectDescription description = workspace.newProjectDescription(project.getName());
                if (location != null) {
                    description.setLocation(location);
                }
                CCorePlugin.getDefault().createCProject(description, project, (IProgressMonitor)new NullProgressMonitor(), projectId);
                ManagedBuildTestHelper.addManagedBuildNature(project);
                ManagedBuildManager.getDefinedProjectTypes();
                IProjectType projType = ManagedBuildManager.getProjectType((String)projectTypeId);
                Assert.assertNotNull((Object)projType);
                IManagedProject newProject = null;
                try {
                    newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
                }
                catch (Exception exception) {
                    Assert.fail((String)("Failed to create managed project for: " + project.getName()));
                }
                Assert.assertEquals((String)newProject.getName(), (String)projType.getName());
                Assert.assertFalse((boolean)newProject.equals(projType));
                ManagedBuildManager.setNewProjectVersion((IProject)project);
                IConfiguration defaultConfig = null;
                IConfiguration[] configs = projType.getConfigurations();
                int i = 0;
                while (i < configs.length) {
                    if (i == 0) {
                        defaultConfig = newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
                    } else {
                        newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
                    }
                    ++i;
                }
                ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultConfig);
                IConfiguration[] cfgs = newProject.getConfigurations();
                int i2 = 0;
                while (i2 < cfgs.length) {
                    cfgs[i2].setArtifactName(newProject.getDefaultArtifactName());
                    ++i2;
                }
                ManagedBuildManager.getBuildInfo((IResource)project).setValid(true);
            }
        };
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
        }
        catch (CoreException e2) {
            Assert.fail((String)e2.getLocalizedMessage());
        }
        IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)project);
        if (initResult.getCode() != 0) {
            Assert.fail((String)("Initializing build information failed for: " + project.getName() + " because: " + initResult.getMessage()));
        }
        return project;
    }

    public static void addManagedBuildNature(IProject project) {
        ManagedBuildManager.createBuildInfo((IResource)project);
        try {
            ManagedCProjectNature.addManagedNature((IProject)project, (IProgressMonitor)new NullProgressMonitor());
            ManagedCProjectNature.addManagedBuilder((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Assert.fail((String)("Test failed on adding managed build nature or builder: " + e.getLocalizedMessage()));
        }
        ICDescriptor desc = null;
        try {
            desc = CCorePlugin.getDefault().getCProjectDescription(project, true);
            desc.remove("org.eclipse.cdt.core.ScannerInfoProvider");
            desc.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
        }
        catch (CoreException e) {
            Assert.fail((String)("Test failed on adding managed builder as scanner info provider: " + e.getLocalizedMessage()));
        }
        try {
            desc.saveProjectData();
        }
        catch (CoreException e) {
            Assert.fail((String)("Test failed on saving the ICDescriptor data: " + e.getLocalizedMessage()));
        }
    }

    public static boolean compareBenchmarks(final IProject project, IPath testDir, IPath[] files) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.refreshLocal(2, monitor);
            }
        };
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            Assert.fail((String)("File " + files[0].lastSegment() + " - project refresh failed."));
        }
        int i = 0;
        while (i < files.length) {
            IPath testFile = testDir.append(files[i]);
            IPath benchmarkFile = Path.fromOSString((String)("Benchmarks/" + files[i]));
            StringBuffer testBuffer = ManagedBuildTestHelper.readContentsStripLineEnds(project, testFile);
            StringBuffer benchmarkBuffer = ManagedBuildTestHelper.readContentsStripLineEnds(project, benchmarkFile);
            if (!testBuffer.toString().equals(benchmarkBuffer.toString())) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("File ").append(testFile.lastSegment()).append(" does not match its benchmark.\n ");
                buffer.append("expected:\n ");
                buffer.append("\"").append(benchmarkBuffer).append("\"");
                buffer.append("\n\n ");
                buffer.append("but was:\n ");
                buffer.append("\"").append(testBuffer).append("\"");
                buffer.append("\n\n ");
                buffer.append(">>>>>>>>>>>>>>>start diff: \n");
                String location1 = ManagedBuildTestHelper.getFileLocation(project, benchmarkFile);
                String location2 = ManagedBuildTestHelper.getFileLocation(project, testFile);
                String diff = DiffUtil.getInstance().diff(location1, location2);
                if (diff == null) {
                    diff = "!diff failed!";
                }
                buffer.append(diff);
                buffer.append("\n<<<<<<<<<<<end diff");
                buffer.append("\n\n ");
                Assert.fail((String)buffer.toString());
            }
            ++i;
        }
        return true;
    }

    public static boolean compareBenchmarks(IProject project, IPath testDir, String[] fileNames) {
        return ManagedBuildTestHelper.compareBenchmarks(project, testDir, new Path("benchmarks").append(testDir), fileNames);
    }

    public static boolean compareBenchmarks(final IProject project, IPath testDir, IPath benchmarkDir, String[] fileNames) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.refreshLocal(2, monitor);
            }
        };
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            Assert.fail((String)("File " + fileNames[0] + " - project refresh failed."));
        }
        IFolder testFolder = (IFolder)project.findMember(testDir);
        IFolder bmFolder = (IFolder)project.findMember(benchmarkDir);
        return ManagedBuildTestHelper.compareBenchmarks(testFolder, bmFolder, fileNames);
    }

    public static boolean compareBenchmarks(IFolder testFolder, IFolder bmFolder, String[] fileNames) {
        Assert.assertNotNull((Object)testFolder);
        Assert.assertNotNull((Object)bmFolder);
        int i = 0;
        while (i < fileNames.length) {
            IFile tFile = testFolder.getFile(fileNames[i]);
            IFile bmFile = bmFolder.getFile(fileNames[i]);
            if (tFile.exists() || bmFile.exists()) {
                ManagedBuildTestHelper.compareBenchmarks(tFile, bmFile);
            }
            ++i;
        }
        return true;
    }

    public static boolean compareBenchmarks(IFile tFile, IFile bmFile) {
        StringBuffer testBuffer = ManagedBuildTestHelper.readContentsStripLineEnds(tFile);
        StringBuffer benchmarkBuffer = ManagedBuildTestHelper.readContentsStripLineEnds(bmFile);
        if (!testBuffer.toString().equals(benchmarkBuffer.toString())) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("File ").append(tFile.getName()).append(" does not match its benchmark.\n ");
            buffer.append("expected:\n ");
            buffer.append("\"").append(benchmarkBuffer).append("\"");
            buffer.append("\n\n ");
            buffer.append("but was:\n ");
            buffer.append("\"").append(testBuffer).append("\"");
            buffer.append("\n\n ");
            buffer.append(">>>>>>>>>>>>>>>start diff: \n");
            String location1 = ManagedBuildTestHelper.getFileLocation(bmFile.getProject(), bmFile.getProjectRelativePath());
            String location2 = ManagedBuildTestHelper.getFileLocation(tFile.getProject(), tFile.getProjectRelativePath());
            String diff = DiffUtil.getInstance().diff(location1, location2);
            if (diff == null) {
                diff = "!diff failed!";
            }
            buffer.append(diff);
            buffer.append("\n<<<<<<<<<<<end diff");
            buffer.append("\n\n ");
            Assert.fail((String)buffer.toString());
        }
        return true;
    }

    public static boolean verifyFilesDoNotExist(final IProject project, IPath testDir, IPath[] files) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.refreshLocal(2, monitor);
            }
        };
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            Assert.fail((String)("File " + files[0].lastSegment() + " - project refresh failed."));
        }
        int i = 0;
        while (i < files.length) {
            IPath testFile = testDir.append(files[i]);
            IPath fullPath = project.getLocation().append(testFile);
            try {
                if (fullPath.toFile().exists()) {
                    Assert.fail((String)("File " + testFile.lastSegment() + " unexpectedly found."));
                    return false;
                }
            }
            catch (Exception exception) {
                Assert.fail((String)("File " + fullPath.toString() + " could not be referenced."));
            }
            ++i;
        }
        return true;
    }

    public static String getFileLocation(IProject project, IPath path) {
        return project.getLocation().append(path).toString();
    }

    public static StringBuffer readContentsStripLineEnds(IFile file) {
        return ManagedBuildTestHelper.readContentsStripLineEnds(file.getProject(), file.getProjectRelativePath());
    }

    public static StringBuffer readContentsStripLineEnds(IProject project, IPath path) {
        StringBuffer buff = new StringBuffer();
        IPath fullPath = project.getLocation().append(path);
        try {
            int c;
            FileReader input = null;
            try {
                input = new FileReader(fullPath.toFile());
            }
            catch (Exception e) {
                Assert.fail((String)("File " + fullPath.toString() + " could not be read: " + e.getLocalizedMessage()));
            }
            while ((c = input.read()) != -1) {
                if (c != 13 && c != 10) {
                    buff.append((char)c);
                }
                if (c != -1) continue;
            }
            input.close();
        }
        catch (Exception exception) {
            Assert.fail((String)("File " + fullPath.toString() + " could not be read."));
        }
        return buff;
    }

    public static IPath copyFilesToTempDir(IPath srcDir, IPath tmpSubDir, IPath[] files) {
        IPath tmpSrcDir = null;
        String userDirStr = System.getProperty("user.home");
        if (userDirStr != null) {
            IPath userDir = Path.fromOSString((String)userDirStr);
            tmpSrcDir = userDir.append(tmpSubDir);
            if (userDir.toString().equalsIgnoreCase(tmpSrcDir.toString())) {
                Assert.fail((String)"Temporary sub-directory cannot be the empty string.");
            } else {
                boolean succeed;
                File tmpSrcDirFile = tmpSrcDir.toFile();
                if (tmpSrcDirFile.exists()) {
                    if (tmpSrcDir.lastSegment().equals(tmpSubDir.lastSegment())) {
                        ManagedBuildTestHelper.deleteDirectory(tmpSrcDirFile);
                    } else {
                        Assert.fail((String)("Temporary directory " + tmpSrcDirFile.toString() + " already exists."));
                    }
                }
                if (succeed = tmpSrcDirFile.mkdir()) {
                    int i = 0;
                    while (i < files.length) {
                        IPath file = files[i];
                        IPath srcFile = srcDir.append(file);
                        FileReader srcReader = null;
                        try {
                            srcReader = new FileReader(srcFile.toFile());
                        }
                        catch (Exception exception) {
                            Assert.fail((String)("File " + file.toString() + " could not be read."));
                        }
                        if (file.segmentCount() > 1) {
                            IPath newDir = tmpSrcDir;
                            do {
                                IPath dir = file.uptoSegment(1);
                                newDir = newDir.append(dir);
                                file = file.removeFirstSegments(1);
                                succeed = newDir.toFile().mkdir();
                            } while (file.segmentCount() > 1);
                        }
                        IPath destFile = tmpSrcDir.append(files[i]);
                        FileWriter writer = null;
                        try {
                            writer = new FileWriter(destFile.toFile());
                        }
                        catch (Exception exception) {
                            Assert.fail((String)("File " + files[i].toString() + " could not be written."));
                        }
                        try {
                            int c;
                            while ((c = srcReader.read()) != -1) {
                                writer.write(c);
                                if (c != -1) continue;
                            }
                            srcReader.close();
                            writer.close();
                        }
                        catch (Exception exception) {
                            Assert.fail((String)("File " + file.toString() + " could not be copied."));
                        }
                        ++i;
                    }
                }
            }
        }
        return tmpSrcDir;
    }

    public static void deleteTempDir(IPath tmpSubDir, IPath[] files) {
        IPath tmpSrcDir = null;
        String userDirStr = System.getProperty("user.home");
        if (userDirStr != null) {
            IPath userDir = Path.fromOSString((String)userDirStr);
            tmpSrcDir = userDir.append(tmpSubDir);
            if (userDir.toString().equalsIgnoreCase(tmpSrcDir.toString())) {
                Assert.fail((String)"Temporary sub-directory cannot be the empty string.");
            } else {
                File tmpSrcDirFile = tmpSrcDir.toFile();
                if (!tmpSrcDirFile.exists()) {
                    Assert.fail((String)("Temporary directory " + tmpSrcDirFile.toString() + " does not exist."));
                } else {
                    int i = 0;
                    while (i < files.length) {
                        IPath thisFile = tmpSrcDir.append(files[i]);
                        thisFile.toFile().delete();
                        ++i;
                    }
                    tmpSrcDirFile.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void delete(ICProject cproject) {
        try {
            cproject.getProject().delete(true, true, null);
            return;
        }
        catch (CoreException coreException) {
            try {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                try {
                    System.gc();
                    System.runFinalization();
                    cproject.getProject().delete(true, true, null);
                    throw throwable;
                }
                catch (CoreException e2) {
                    Assert.fail((String)ManagedBuildTestHelper.getMessage(e2.getStatus()));
                }
                throw throwable;
            }
            {
                Object var1_3 = null;
            }
            try {}
            catch (CoreException e2) {
                Assert.fail((String)ManagedBuildTestHelper.getMessage(e2.getStatus()));
                return;
            }
            System.gc();
            System.runFinalization();
            cproject.getProject().delete(true, true, null);
            return;
        }
    }

    private static String getMessage(IStatus status) {
        StringBuffer message = new StringBuffer("[");
        message.append(status.getMessage());
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                message.append(ManagedBuildTestHelper.getMessage(children[i]));
                ++i;
            }
        }
        message.append("]");
        return message.toString();
    }

    private static void deleteDirectory(File dir) {
        File[] toDelete = dir.listFiles();
        int i = 0;
        while (i < toDelete.length) {
            File fileToDelete = toDelete[i];
            if (fileToDelete.isDirectory()) {
                ManagedBuildTestHelper.deleteDirectory(fileToDelete);
            }
            fileToDelete.delete();
            ++i;
        }
        dir.delete();
    }

    public static ITool createRcbsTool(IConfiguration cfg, String file, String inputs, String outputs, String cmds) {
        IProject project = cfg.getOwner().getProject();
        IResource f = project.findMember(file);
        Assert.assertTrue((String)"file does not exist", (f != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"resource is not a file", (int)f.getType(), (int)1);
        return ManagedBuildTestHelper.createRcbsTool(cfg, (IFile)f, inputs, outputs, cmds);
    }

    public static ITool createRcbsTool(IConfiguration cfg, IFile file, String inputs, String outputs, String cmds) {
        IResourceConfiguration rcCfg = cfg.getResourceConfiguration(file.getFullPath().toString());
        if (rcCfg == null) {
            rcCfg = cfg.createResourceConfiguration(file);
        }
        Assert.assertTrue((String)"failed to create resource configuration", (rcCfg != null ? 1 : 0) != 0);
        ITool tool = ManagedBuildTestHelper.getRcbsTool(rcCfg, true);
        ManagedBuildTestHelper.setRcbsInputs(tool, inputs);
        ManagedBuildTestHelper.setRcbsOutputs(tool, outputs);
        tool.setToolCommand(cmds);
        tool.setAnnouncement("default test rcbs announcement");
        rcCfg.setRcbsApplicability(1);
        return tool;
    }

    public static ITool setRcbsInputs(ITool tool, String inputs) {
        tool.getInputTypes()[0].getAdditionalInputs()[0].setPaths(inputs);
        return tool;
    }

    public static ITool setRcbsOutputs(ITool tool, String outputs) {
        tool.getOutputTypes()[0].setOutputNames(outputs);
        return tool;
    }

    public static ITool getRcbsTool(IResourceConfiguration rcConfig, boolean create) {
        ITool[] rcbsTools = ManagedBuildTestHelper.getRcbsTools(rcConfig);
        ITool rcbsTool = null;
        if (rcbsTools != null) {
            rcbsTool = rcbsTools[0];
        } else if (create) {
            rcbsTool = rcConfig.createTool(null, String.valueOf(rcbsToolId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolName, false);
            rcbsTool.setCustomBuildStep(true);
            IInputType rcbsToolInputType = rcbsTool.createInputType(null, String.valueOf(rcbsToolInputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolInputTypeName, false);
            IAdditionalInput rcbsToolInputTypeAdditionalInput = rcbsToolInputType.createAdditionalInput(new String());
            rcbsToolInputTypeAdditionalInput.setKind(3);
            rcbsTool.createOutputType(null, String.valueOf(rcbsToolOutputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolOutputTypeName, false);
        }
        return rcbsTool;
    }

    public static ITool[] getRcbsTools(IResourceConfiguration rcConfig) {
        ArrayList<ITool> list = new ArrayList<ITool>();
        ITool[] tools = rcConfig.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            if (tool.getCustomBuildStep() && !tool.isExtensionElement()) {
                list.add(tool);
            }
            ++i;
        }
        if (list.size() != 0) {
            return list.toArray(new ITool[list.size()]);
        }
        return null;
    }

    public static boolean setObjs(IConfiguration cfg, String[] objs) {
        return ManagedBuildTestHelper.setOption(cfg, 7, (Object)objs);
    }

    public static boolean setLibs(IConfiguration cfg, String[] objs) {
        return ManagedBuildTestHelper.setOption(cfg, 6, (Object)objs);
    }

    public static boolean setOption(IConfiguration cfg, int type, Object value) {
        return ManagedBuildTestHelper.setOption(cfg.getFilteredTools(), type, value);
    }

    public static boolean setOption(IResourceConfiguration rcCfg, int type, Object value) {
        return ManagedBuildTestHelper.setOption(rcCfg.getToolsToInvoke()[0], type, value);
    }

    public static boolean setOption(ITool[] tools, int type, Object value) {
        int i = 0;
        while (i < tools.length) {
            if (ManagedBuildTestHelper.setOption(tools[i], type, value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IBuildObject[] getOption(IConfiguration cfg, int type) {
        return ManagedBuildTestHelper.getOption(cfg.getFilteredTools(), type);
    }

    public static IBuildObject[] getOption(IResourceConfiguration rcCfg, int type, Object value) {
        return ManagedBuildTestHelper.getOption(new ITool[]{rcCfg.getToolsToInvoke()[0]}, type);
    }

    public static IBuildObject[] getOption(ITool[] tools, int type) {
        int i = 0;
        while (i < tools.length) {
            IOption option = ManagedBuildTestHelper.getOption((IHoldsOptions)tools[i], type);
            if (option != null) {
                return new IBuildObject[]{tools[i], option};
            }
            ++i;
        }
        return null;
    }

    public static IOption getOption(IHoldsOptions tool, int type) {
        IOption[] opts = tool.getOptions();
        int i = 0;
        while (i < opts.length) {
            IOption option = opts[i];
            try {
                if (option.getValueType() == type) {
                    return option;
                }
            }
            catch (BuildException buildException) {}
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setOption(ITool tool, int type, Object value) {
        IOption option = ManagedBuildTestHelper.getOption((IHoldsOptions)tool, type);
        if (option == null) {
            return false;
        }
        IBuildObject obj = tool.getParent();
        IConfiguration cfg = null;
        IResourceConfiguration rcCfg = null;
        if (obj instanceof IToolChain) {
            cfg = ((IToolChain)obj).getParent();
        } else {
            rcCfg = (IResourceConfiguration)obj;
        }
        try {
            if (option.getValueType() != type) return false;
            switch (type) {
                case 0: {
                    boolean val = (Boolean)value;
                    if (rcCfg != null) {
                        rcCfg.setOption((IHoldsOptions)tool, option, val);
                        return true;
                    }
                    cfg.setOption((IHoldsOptions)tool, option, val);
                    return true;
                }
                case 1: 
                case 2: {
                    String val = (String)value;
                    if (rcCfg != null) {
                        rcCfg.setOption((IHoldsOptions)tool, option, val);
                        return true;
                    }
                    cfg.setOption((IHoldsOptions)tool, option, val);
                    return true;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    String[] val = (String[])value;
                    if (rcCfg != null) {
                        rcCfg.setOption((IHoldsOptions)tool, option, val);
                        return true;
                    }
                    cfg.setOption((IHoldsOptions)tool, option, val);
                    return true;
                }
            }
            Assert.fail((String)"wrong option type passed");
            return false;
        }
        catch (BuildException buildException) {}
        return false;
    }
}

