/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FolderSelectionDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;

    public FolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        Button button = new Button(result, 8);
        button.setText(CPathEntryMessages.getString("FolderSelectionDialog.button"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FolderSelectionDialog.this.newFolderButtonPressed();
            }
        });
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button);
        this.fNewFolderButton = button;
        FolderSelectionDialog.applyDialogFont((Control)result);
        return result;
    }

    private void updateNewFolderButtonState() {
        Object first;
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        this.fSelectedContainer = null;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)first;
        }
        this.fNewFolderButton.setEnabled(this.fSelectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog dialog = new NewFolderDialog(this.getShell(), this.fSelectedContainer);
        if (dialog.open() == 0) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh((Object)this.fSelectedContainer);
            Object createdFolder = dialog.getResult()[0];
            treeViewer.reveal(createdFolder);
            treeViewer.setSelection((ISelection)new StructuredSelection(createdFolder));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNewFolderButtonState();
    }
}

