/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.dnd.CDTViewerDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class ResourceTransferDropAdapter
extends CDTViewerDropAdapter
implements TransferDropTargetListener {
    static /* synthetic */ Class class$0;

    public ResourceTransferDropAdapter(StructuredViewer viewer) {
        super(viewer, 24);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof ICElement || target instanceof IResource;
    }

    public void validateDrop(Object target, DropTargetEvent event, int op) {
        IContainer destination = this.getDestination(target);
        if (destination == null) {
            event.detail = 0;
        } else {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources.length == 0) {
                event.detail = 0;
            } else if (op == 1) {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
                if (operation.validateDestination(destination, selectedResources) == null) {
                    event.detail = op;
                }
            } else {
                MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
                if (operation.validateDestination(destination, selectedResources) == null) {
                    event.detail = 2;
                }
            }
        }
    }

    public void drop(Object dropTarget, DropTargetEvent event) {
        int op = event.detail;
        event.detail = 0;
        Object data = event.data;
        if (data == null || !(data instanceof IResource[])) {
            return;
        }
        IContainer target = this.getDestination(dropTarget);
        if (target == null) {
            return;
        }
        IResource[] sources = (IResource[])data;
        if (op == 1) {
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
            operation.copyResources(sources, target);
        } else {
            ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), "Move Resource Action", "Move Resource Action");
            sources = checker.checkReadOnlyResources(sources);
            MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
            operation.copyResources(sources, target);
        }
    }

    private IContainer getDestination(Object dropTarget) {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof ICElement) {
            return this.getDestination(((ICElement)dropTarget).getResource());
        }
        return null;
    }

    private IResource[] getSelectedResources() {
        ArrayList selectedResources = new ArrayList();
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator i = ssel.iterator();
            while (i.hasNext()) {
                IResource r;
                Object o = i.next();
                if (o instanceof IResource) {
                    selectedResources.add(o);
                    continue;
                }
                if (!(o instanceof IAdaptable)) continue;
                IAdaptable a = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((r = (IResource)a.getAdapter((Class)clazz)) == null) continue;
                selectedResources.add(r);
            }
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    protected Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

