/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dnd;

import java.io.File;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorDropTargetListener;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class TextEditorDropAdapter
extends DropTargetAdapter
implements ITextEditorDropTargetListener {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Point fDropSelection;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.internal.ui.dnd.TextEditorDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TextEditorDropAdapter(ITextViewer viewer, ITextEditor editor) {
        this.fViewer = viewer;
        this.fEditor = editor;
    }

    public void drop(DropTargetEvent event) {
        try {
            TransferData dataType = event.currentDataType;
            if (TextEditorDropAdapter.isFileDataType(dataType)) {
                if (!$assertionsDisabled && !(event.data instanceof String[])) {
                    throw new AssertionError();
                }
                this.dropFiles((String[])event.data);
            } else if (TextEditorDropAdapter.isMarkerDataType(dataType)) {
                if (!$assertionsDisabled && !(event.data instanceof IMarker[])) {
                    throw new AssertionError();
                }
                this.dropMarkers((IMarker[])event.data);
            } else if (TextEditorDropAdapter.isTextDataType(dataType)) {
                if (!$assertionsDisabled && !(event.data instanceof String)) {
                    throw new AssertionError();
                }
                int offset = this.getOffsetAtLocation(event.x, event.y, true);
                this.dropText((String)event.data, offset);
            }
        }
        catch (CoreException exc) {
            ExceptionHandler.handle(exc, CUIMessages.getString("TextEditorDropAdapter.error.title"), CUIMessages.getString("TextEditorDropAdapter.error.message"));
        }
    }

    public void dragEnter(DropTargetEvent event) {
        TransferData dataType = event.currentDataType;
        if (TextEditorDropAdapter.isFileDataType(dataType)) {
            event.detail = 1;
            event.feedback = 0;
        } else if (TextEditorDropAdapter.isMarkerDataType(dataType)) {
            event.detail = 1;
            event.feedback = 0;
        } else if (TextEditorDropAdapter.isTextDataType(dataType)) {
            if (this.isDocumentEditable()) {
                if (event.detail == 16) {
                    event.detail = this.getAcceptableOperation(event.operations);
                }
                this.fDropSelection = this.fViewer.getTextWidget().getSelection();
            } else {
                event.detail = 0;
            }
        }
    }

    public void dragOver(DropTargetEvent event) {
        TransferData dataType = event.currentDataType;
        if (TextEditorDropAdapter.isFileDataType(dataType)) {
            event.detail = 1;
            event.feedback = 0;
        } else if (TextEditorDropAdapter.isMarkerDataType(dataType)) {
            event.detail = 1;
            event.feedback = 0;
        } else if (TextEditorDropAdapter.isTextDataType(dataType)) {
            if (this.isDocumentEditable()) {
                int offset;
                if ((event.operations & event.detail) == 0) {
                    event.detail = this.getAcceptableOperation(event.operations);
                }
                if ((offset = this.getOffsetAtLocation(event.x, event.y, true)) < 0) {
                    event.detail = 0;
                }
            } else {
                event.detail = 0;
            }
            event.feedback |= 8;
        }
    }

    private static boolean isFileDataType(TransferData dataType) {
        return FileTransfer.getInstance().isSupportedType(dataType);
    }

    private static boolean isTextDataType(TransferData dataType) {
        return TextTransfer.getInstance().isSupportedType(dataType);
    }

    private static boolean isMarkerDataType(TransferData dataType) {
        return MarkerTransfer.getInstance().isSupportedType(dataType);
    }

    public void dropAccept(DropTargetEvent event) {
        int widgetOffset;
        IDocument doc;
        TransferData dataType = event.currentDataType;
        if (TextEditorDropAdapter.isTextDataType(dataType) && (doc = this.fViewer.getDocument()).containsPositionCategory("dragSelectionCategory") && (widgetOffset = this.getOffsetAtLocation(event.x, event.y, true)) != -1) {
            int documentOffset = this.getDocumentOffset(widgetOffset);
            try {
                Position[] dragSource = doc.getPositions("dragSelectionCategory");
                if (dragSource.length == 0 || event.detail == 2 && dragSource[0].includes(documentOffset)) {
                    event.detail = 0;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                event.detail = 0;
            }
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        TransferData dataType = event.currentDataType;
        if (TextEditorDropAdapter.isFileDataType(dataType)) {
            event.detail = 1;
            event.feedback = 0;
        } else if (TextEditorDropAdapter.isMarkerDataType(dataType)) {
            event.detail = 1;
            event.feedback = 0;
        } else if (TextEditorDropAdapter.isTextDataType(dataType)) {
            if (this.isDocumentEditable()) {
                if (event.detail == 16) {
                    event.detail = this.getAcceptableOperation(event.operations);
                }
            } else {
                event.detail = 0;
            }
        }
    }

    private int getAcceptableOperation(int operations) {
        if ((operations & 2) != 0 && this.isDocumentEditable()) {
            return 2;
        }
        if ((operations & 1) != 0) {
            return 1;
        }
        return 0;
    }

    public void dragLeave(DropTargetEvent event) {
        this.fDropSelection = null;
    }

    private void dropText(String text, int offset) throws CoreException {
        IDocument d = this.fViewer.getDocument();
        try {
            int docLength;
            int docOffset;
            Point selection = this.fDropSelection;
            if (selection != null && selection.x <= offset && offset < selection.y) {
                docOffset = this.getDocumentOffset(selection.x);
                docLength = this.getDocumentOffset(selection.y) - docOffset;
            } else {
                docOffset = this.getDocumentOffset(offset);
                docLength = 0;
            }
            d.replace(docOffset, docLength, text);
            this.fViewer.setSelectedRange(docOffset, text.length());
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, e.getLocalizedMessage(), (Throwable)e));
        }
    }

    private void dropFiles(String[] fileNames) throws CoreException {
        int i = 0;
        while (i < fileNames.length) {
            Path path = new Path(fileNames[i]);
            File file = path.toFile();
            if (!file.isFile()) {
                throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, CUIMessages.getFormattedString("TextEditorDropAdapter.noFile", fileNames[i]), null));
            }
            if (!file.canRead()) {
                throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, CUIMessages.getFormattedString("TextEditorDropAdapter.unreadableFile", fileNames[i]), null));
            }
            EditorUtility.openInEditor((IPath)path, null);
            ++i;
        }
    }

    private void dropMarkers(IMarker[] markers) throws PartInitException {
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IDE.openEditor((IWorkbenchPage)this.getPage(), (IMarker)marker);
            ++i;
        }
    }

    private IWorkbenchPage getPage() {
        if (this.fEditor != null) {
            return this.fEditor.getSite().getPage();
        }
        return CUIPlugin.getActivePage();
    }

    private int getOffsetAtLocation(int x, int y, boolean absolute) {
        StyledText textWidget = this.fViewer.getTextWidget();
        StyledTextContent content = textWidget.getContent();
        Point location = absolute ? textWidget.toControl(x, y) : new Point(x, y);
        int line = (textWidget.getTopPixel() + location.y) / textWidget.getLineHeight();
        if (line >= content.getLineCount()) {
            return content.getCharCount();
        }
        int lineOffset = content.getOffsetAtLine(line);
        String lineText = content.getLine(line);
        Point endOfLine = textWidget.getLocationAtOffset(lineOffset + lineText.length());
        if (location.x >= endOfLine.x) {
            return lineOffset + lineText.length();
        }
        try {
            return textWidget.getOffsetAtLocation(location);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    private int getDocumentOffset(int widgetOffset) {
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        IRegion visible = this.fViewer.getVisibleRegion();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset + visible.getOffset();
    }

    private boolean isDocumentEditable() {
        if (this.fEditor instanceof ITextEditorExtension) {
            return !((ITextEditorExtension)this.fEditor).isEditorInputReadOnly();
        }
        return this.fViewer.isEditable();
    }

    public Transfer[] getTransfers() {
        return new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance(), MarkerTransfer.getInstance()};
    }

    protected static ITextEditorDropTargetListener create(ITextEditor textEditor) {
        ITextViewer textViewer;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jface.text.ITextViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((textViewer = (ITextViewer)textEditor.getAdapter((Class)clazz)) == null) {
            ITextOperationTarget target;
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (ITextOperationTarget)textEditor.getAdapter((Class)clazz2)) instanceof ITextViewer) {
                textViewer = (ITextViewer)target;
            }
        }
        if (textViewer == null) {
            return null;
        }
        return new TextEditorDropAdapter(textViewer, textEditor);
    }

    public static class Factory
    implements IAdapterFactory {
        private static final Class[] CLASSES;

        static {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditorDropTargetListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            CLASSES = classArray;
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (adaptableObject instanceof ITextEditor) {
                return TextEditorDropAdapter.create((ITextEditor)adaptableObject);
            }
            return null;
        }

        public Class[] getAdapterList() {
            return CLASSES;
        }
    }
}

