/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private CDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(CDocumentProvider provider) {
        Assert.isNotNull((Object)((Object)provider));
        this.fDocumentProvider = provider;
    }

    public void connect(IEditorInput input) throws CoreException {
        this.fDocumentProvider.connect(input);
    }

    public void disconnect(IEditorInput input) {
        this.fDocumentProvider.disconnect(input);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.fIsShuttingDown) return;
        this.fIsShuttingDown = true;
        try {
            if (this.fMap != null) {
                this.fMap.clear();
                this.fMap = null;
            }
            this.fDocumentProvider.shutdown();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fIsShuttingDown = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fIsShuttingDown = false;
            return;
        }
    }

    public IWorkingCopy getWorkingCopy(IEditorInput input) {
        IWorkingCopy unit = this.fMap == null ? null : (IWorkingCopy)this.fMap.get(input);
        return unit != null ? unit : this.fDocumentProvider.getWorkingCopy(input);
    }

    public void setWorkingCopy(IEditorInput input, IWorkingCopy workingCopy) {
        if (this.fDocumentProvider.getDocument(input) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(input, workingCopy);
        }
    }

    public void removeWorkingCopy(IEditorInput input) {
        this.fMap.remove(input);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

