/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBFile;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;

public class IBNode
implements IAdaptable {
    private IBNode fParent;
    private IBFile fRepresentedFile;
    private IBFile fDirectiveFile;
    private int fDirectiveCharacterOffset;
    private int fDirectiveLength;
    private int fHashCode;
    private boolean fIsSystemInclude = false;
    private boolean fIsActive = true;
    private boolean fIsRecursive;
    private long fTimestamp;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.ui.includebrowser.IBNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public IBNode(IBNode parent, IBFile represents, IBFile fileOfDirective, int charOffset, int length, long timestamp) {
        if (!$assertionsDisabled && represents == null) {
            throw new AssertionError();
        }
        this.fParent = parent;
        this.fRepresentedFile = represents;
        this.fDirectiveFile = fileOfDirective;
        this.fDirectiveCharacterOffset = charOffset;
        this.fDirectiveLength = length;
        this.fIsRecursive = this.computeIsRecursive(this.fParent, represents.getLocation());
        this.fHashCode = this.computeHashCode();
        this.fTimestamp = timestamp;
    }

    private int computeHashCode() {
        int hashCode = 0;
        if (this.fParent != null) {
            hashCode = this.fParent.hashCode() * 31;
        }
        return hashCode += this.fRepresentedFile.hashCode();
    }

    public int hashCode() {
        return this.fHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IBNode)) {
            return false;
        }
        IBNode rhs = (IBNode)o;
        if (this.fHashCode != rhs.fHashCode) {
            return false;
        }
        return CoreUtility.safeEquals(this.fRepresentedFile, rhs.fRepresentedFile);
    }

    private boolean computeIsRecursive(IBNode parent, IIndexFileLocation ifl) {
        if (parent == null || ifl == null) {
            return false;
        }
        if (ifl.equals(parent.getRepresentedFile().getLocation())) {
            return true;
        }
        return this.computeIsRecursive(parent.fParent, ifl);
    }

    public IBNode getParent() {
        return this.fParent;
    }

    public IBFile getRepresentedFile() {
        return this.fRepresentedFile;
    }

    public boolean isSystemInclude() {
        return this.fIsSystemInclude;
    }

    public void setIsSystemInclude(boolean isSystemInclude) {
        this.fIsSystemInclude = isSystemInclude;
    }

    public boolean isActiveCode() {
        return this.fIsActive;
    }

    public void setIsActiveCode(boolean isActiveCode) {
        this.fIsActive = isActiveCode;
    }

    public boolean isRecursive() {
        return this.fIsRecursive;
    }

    public int getDirectiveCharacterOffset() {
        return this.fDirectiveCharacterOffset;
    }

    public int getDirectiveLength() {
        return this.fDirectiveLength;
    }

    public IBFile getDirectiveFile() {
        return this.fDirectiveFile;
    }

    public String getDirectiveName() {
        return this.fRepresentedFile.getName();
    }

    public Object getAdapter(Class adapter) {
        if (this.fRepresentedFile != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.core.model.ITranslationUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.isAssignableFrom(clazz)) {
                return this.fRepresentedFile.getTranslationUnit();
            }
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.isAssignableFrom(clazz2)) {
                return this.fRepresentedFile.getResource();
            }
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("org.eclipse.cdt.core.index.IIndexFileLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.isAssignableFrom(clazz3)) {
                return this.fRepresentedFile.getLocation();
            }
        }
        return null;
    }

    public ITranslationUnit getRepresentedTranslationUnit() {
        return this.fRepresentedFile == null ? null : this.fRepresentedFile.getTranslationUnit();
    }

    public IPath getRepresentedPath() {
        if (this.fRepresentedFile == null) {
            return null;
        }
        IIndexFileLocation ifl = this.fRepresentedFile.getLocation();
        if (ifl != null) {
            return IndexLocationFactory.getPath((IIndexFileLocation)ifl);
        }
        return null;
    }

    public IIndexFileLocation getRepresentedIFL() {
        return this.fRepresentedFile == null ? null : this.fRepresentedFile.getLocation();
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public ICProject getCProject() {
        ITranslationUnit tu = this.getRepresentedTranslationUnit();
        if (tu != null) {
            return tu.getCProject();
        }
        IBNode parent = this.getParent();
        if (parent != null) {
            return parent.getCProject();
        }
        return null;
    }
}

