/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.cdt.internal.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.CSourcePreviewerUpdater;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;

class CEditorColoringConfigurationBlock
extends AbstractConfigurationBlock {
    private static final String BOLD = "_bold";
    private static final String ITALIC = "_italic";
    private static final String STRIKETHROUGH = "_strikethrough";
    private static final String UNDERLINE = "_underline";
    private final String[][] fSyntaxColorListModel = new String[][]{{PreferencesMessages.CEditorColoringConfigurationBlock_MultiLine, "c_multi_line_comment"}, {PreferencesMessages.CEditorColoringConfigurationBlock_singleLine, "c_single_line_comment"}, {PreferencesMessages.CEditorColoringConfigurationBlock_cCommentTaskTags, "c_comment_task_tag"}, {PreferencesMessages.CEditorColoringConfigurationBlock_ppDirectives, "pp_directive"}, {PreferencesMessages.CEditorColoringConfigurationBlock_ppOthers, "pp_default"}, {PreferencesMessages.CEditorColoringConfigurationBlock_ppHeaders, "pp_header"}, {PreferencesMessages.CEditorColoringConfigurationBlock_keywords, "c_keyword"}, {PreferencesMessages.CEditorColoringConfigurationBlock_builtInTypes, "c_type"}, {PreferencesMessages.CEditorColoringConfigurationBlock_operators, "c_operators"}, {PreferencesMessages.CEditorColoringConfigurationBlock_strings, "c_string"}, {PreferencesMessages.CEditorColoringConfigurationBlock_braces, "c_braces"}, {PreferencesMessages.CEditorColoringConfigurationBlock_numbers, "c_numbers"}, {PreferencesMessages.CEditorColoringConfigurationBlock_others, "c_default"}};
    private final String fCodeCategory = PreferencesMessages.CEditorColoringConfigurationBlock_coloring_category_code;
    private final String fCommentsCategory = PreferencesMessages.CEditorColoringConfigurationBlock_coloring_category_comments;
    private final String fPreprocessorCategory = PreferencesMessages.CEditorColoringConfigurationBlock_coloring_category_preprocessor;
    private ColorSelector fSyntaxForegroundColorEditor;
    private Label fColorEditorLabel;
    private Button fEnableSemanticHighlightingCheckbox;
    private Button fBoldCheckBox;
    private Button fEnableCheckbox;
    private Button fItalicCheckBox;
    private Button fStrikethroughCheckBox;
    private Button fUnderlineCheckBox;
    private final List fListModel = new ArrayList();
    private StructuredViewer fListViewer;
    private SemanticHighlightingManager fSemanticHighlightingManager;
    private CSourceViewer fPreviewViewer;
    private IColorManager fColorManager = new CColorManager(false);
    private FontMetrics fFontMetrics;

    public CEditorColoringConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fListModel.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + BOLD, String.valueOf(this.fSyntaxColorListModel[i][1]) + ITALIC, String.valueOf(this.fSyntaxColorListModel[i][1]) + STRIKETHROUGH, String.valueOf(this.fSyntaxColorListModel[i][1]) + UNDERLINE));
            ++i;
        }
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i2 = 0;
        int n2 = semanticHighlightings.length;
        while (i2 < n2) {
            this.fListModel.add(new SemanticHighlightingColorListItem(semanticHighlightings[i2].getDisplayName(), SemanticHighlightings.getColorPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getBoldPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getItalicPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlightings[i2]), SemanticHighlightings.getEnabledPreferenceKey(semanticHighlightings[i2])));
            ++i2;
        }
        store.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "semanticHighlighting.enabled"));
        int i = 0;
        int n = this.fListModel.size();
        while (i < n) {
            HighlightingColorListItem item = (HighlightingColorListItem)this.fListModel.get(i);
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, item.getColorKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getBoldKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getItalicKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getStrikethroughKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, item.getUnderlineKey()));
            if (item instanceof SemanticHighlightingColorListItem) {
                overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, ((SemanticHighlightingColorListItem)item).getEnableKey()));
            }
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        return this.createSyntaxPage(parent);
    }

    private int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    private int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    public void initialize() {
        super.initialize();
        this.fListViewer.setInput((Object)this.fListModel);
        this.fListViewer.setSelection((ISelection)new StructuredSelection((Object)this.fCodeCategory));
    }

    public void performDefaults() {
        super.performDefaults();
        this.fListViewer.refresh();
        this.handleSyntaxColorListSelection();
        this.uninstallSemanticHighlighting();
        this.installSemanticHighlighting();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        this.uninstallSemanticHighlighting();
        this.fColorManager.dispose();
        super.dispose();
    }

    private void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        if (item == null) {
            this.fEnableCheckbox.setEnabled(false);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(false);
            this.fColorEditorLabel.setEnabled(false);
            this.fBoldCheckBox.setEnabled(false);
            this.fItalicCheckBox.setEnabled(false);
            this.fStrikethroughCheckBox.setEnabled(false);
            this.fUnderlineCheckBox.setEnabled(false);
            return;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getBoldKey()));
        this.fItalicCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getItalicKey()));
        this.fStrikethroughCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getStrikethroughKey()));
        this.fUnderlineCheckBox.setSelection(this.getPreferenceStore().getBoolean(item.getUnderlineKey()));
        if (item instanceof SemanticHighlightingColorListItem) {
            boolean semanticHighlightingEnabled = this.getPreferenceStore().getBoolean("semanticHighlighting.enabled");
            this.fEnableCheckbox.setEnabled(semanticHighlightingEnabled);
            boolean enable = semanticHighlightingEnabled && this.getPreferenceStore().getBoolean(((SemanticHighlightingColorListItem)item).getEnableKey());
            this.fEnableCheckbox.setSelection(enable);
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
            this.fColorEditorLabel.setEnabled(enable);
            this.fBoldCheckBox.setEnabled(enable);
            this.fItalicCheckBox.setEnabled(enable);
            this.fStrikethroughCheckBox.setEnabled(enable);
            this.fUnderlineCheckBox.setEnabled(enable);
        } else {
            this.fSyntaxForegroundColorEditor.getButton().setEnabled(true);
            this.fColorEditorLabel.setEnabled(true);
            this.fBoldCheckBox.setEnabled(true);
            this.fItalicCheckBox.setEnabled(true);
            this.fStrikethroughCheckBox.setEnabled(true);
            this.fUnderlineCheckBox.setEnabled(true);
            this.fEnableCheckbox.setEnabled(false);
            this.fEnableCheckbox.setSelection(true);
        }
    }

    private Control createSyntaxPage(final Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        colorComposite.setLayout((Layout)layout);
        Link link = new Link(colorComposite, 0);
        link.setText(PreferencesMessages.CEditorColoringConfigurationBlock_link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)e.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        gridData.horizontalSpan = 2;
        link.setLayoutData((Object)gridData);
        this.addFiller(colorComposite, 1);
        this.fEnableSemanticHighlightingCheckbox = this.addCheckBox(colorComposite, PreferencesMessages.CEditorColoringConfigurationBlock_enable_semantic_highlighting, "semanticHighlighting.enabled", 0);
        Label label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.CEditorColoringConfigurationBlock_coloring_element);
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 1, true, false);
        editorComposite.setLayoutData((Object)gd);
        this.fListViewer = new TreeViewer(editorComposite, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fListViewer.setSorter(new ViewerSorter(){

            public int category(Object element) {
                if (CEditorColoringConfigurationBlock.this.fCodeCategory.equals(element)) {
                    return 0;
                }
                if (CEditorColoringConfigurationBlock.this.fCommentsCategory.equals(element)) {
                    return 2;
                }
                if (CEditorColoringConfigurationBlock.this.fPreprocessorCategory.equals(element)) {
                    return 3;
                }
                return 0;
            }
        });
        gd = new GridData(1, 1, false, true);
        gd.heightHint = this.convertHeightInCharsToPixels(9);
        int maxWidth = 0;
        Iterator it = this.fListModel.iterator();
        while (it.hasNext()) {
            HighlightingColorListItem item = (HighlightingColorListItem)it.next();
            maxWidth = Math.max(maxWidth, this.convertWidthInCharsToPixels(item.getDisplayName().length()));
        }
        ScrollBar vBar = ((Scrollable)this.fListViewer.getControl()).getVerticalBar();
        if (vBar != null) {
            maxWidth += vBar.getSize().x * 3;
        }
        gd.widthHint = maxWidth;
        this.fListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        this.fEnableCheckbox = new Button(stylesComposite, 32);
        this.fEnableCheckbox.setText(PreferencesMessages.CEditorColoringConfigurationBlock_enable);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fEnableCheckbox.setLayoutData((Object)gd);
        this.fColorEditorLabel = new Label(stylesComposite, 16384);
        this.fColorEditorLabel.setText(PreferencesMessages.CEditorColoringConfigurationBlock_color);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        this.fColorEditorLabel.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(32);
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(PreferencesMessages.CEditorColoringConfigurationBlock_bold);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(PreferencesMessages.CEditorColoringConfigurationBlock_italic);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fStrikethroughCheckBox = new Button(stylesComposite, 32);
        this.fStrikethroughCheckBox.setText(PreferencesMessages.CEditorColoringConfigurationBlock_strikethrough);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fStrikethroughCheckBox.setLayoutData((Object)gd);
        this.fUnderlineCheckBox = new Button(stylesComposite, 32);
        this.fUnderlineCheckBox.setText(PreferencesMessages.CEditorColoringConfigurationBlock_underline);
        gd = new GridData(32);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        this.fUnderlineCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText(PreferencesMessages.CEditorColoringConfigurationBlock_preview);
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CEditorColoringConfigurationBlock.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = CEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)CEditorColoringConfigurationBlock.this.getPreferenceStore(), (String)item.getColorKey(), (RGB)CEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = CEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                CEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getBoldKey(), CEditorColoringConfigurationBlock.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = CEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                CEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getItalicKey(), CEditorColoringConfigurationBlock.this.fItalicCheckBox.getSelection());
            }
        });
        this.fStrikethroughCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = CEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                CEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getStrikethroughKey(), CEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.getSelection());
            }
        });
        this.fUnderlineCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = CEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                CEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(item.getUnderlineKey(), CEditorColoringConfigurationBlock.this.fUnderlineCheckBox.getSelection());
            }
        });
        this.fEnableCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = CEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (item instanceof SemanticHighlightingColorListItem) {
                    boolean enable = CEditorColoringConfigurationBlock.this.fEnableCheckbox.getSelection();
                    CEditorColoringConfigurationBlock.this.getPreferenceStore().setValue(((SemanticHighlightingColorListItem)item).getEnableKey(), enable);
                    CEditorColoringConfigurationBlock.this.fEnableCheckbox.setSelection(enable);
                    CEditorColoringConfigurationBlock.this.fSyntaxForegroundColorEditor.getButton().setEnabled(enable);
                    CEditorColoringConfigurationBlock.this.fColorEditorLabel.setEnabled(enable);
                    CEditorColoringConfigurationBlock.this.fBoldCheckBox.setEnabled(enable);
                    CEditorColoringConfigurationBlock.this.fItalicCheckBox.setEnabled(enable);
                    CEditorColoringConfigurationBlock.this.fStrikethroughCheckBox.setEnabled(enable);
                    CEditorColoringConfigurationBlock.this.fUnderlineCheckBox.setEnabled(enable);
                    CEditorColoringConfigurationBlock.this.uninstallSemanticHighlighting();
                    CEditorColoringConfigurationBlock.this.installSemanticHighlighting();
                }
            }
        });
        this.fEnableSemanticHighlightingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = CEditorColoringConfigurationBlock.this.getHighlightingColorListItem();
                if (item instanceof SemanticHighlightingColorListItem) {
                    CEditorColoringConfigurationBlock.this.fListViewer.refresh();
                    CEditorColoringConfigurationBlock.this.handleSyntaxColorListSelection();
                    CEditorColoringConfigurationBlock.this.uninstallSemanticHighlighting();
                    CEditorColoringConfigurationBlock.this.installSemanticHighlighting();
                }
            }
        });
        colorComposite.layout(false);
        return colorComposite;
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Control createPreviewer(Composite parent) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        this.fPreviewViewer = new CSourceViewer(parent, null, null, false, 2816, (IPreferenceStore)store);
        SimpleCSourceViewerConfiguration configuration = new SimpleCSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, "___c_partitioning", false);
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        this.fPreviewViewer.getTextWidget().setFont(font);
        CSourcePreviewerUpdater.registerPreviewer((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)store);
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        CUIPlugin.getDefault().getTextTools().setupCDocumentPartitioner((IDocument)document, "___c_partitioning");
        this.fPreviewViewer.setDocument((IDocument)document);
        this.installSemanticHighlighting();
        return this.fPreviewViewer.getControl();
    }

    /*
     * Exception decompiling
     */
    private String loadPreviewContentFromFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 115->118)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void installSemanticHighlighting() {
        if (this.fSemanticHighlightingManager == null) {
            this.fSemanticHighlightingManager = new SemanticHighlightingManager();
            this.fSemanticHighlightingManager.install(this.fPreviewViewer, this.fColorManager, this.getPreferenceStore(), this.createPreviewerRanges());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticHighlightingManager != null) {
            this.fSemanticHighlightingManager.uninstall();
            this.fSemanticHighlightingManager = null;
        }
    }

    private SemanticHighlightingManager.HighlightedRange[][] createPreviewerRanges() {
        return new SemanticHighlightingManager.HighlightedRange[][]{{this.createHighlightedRange(2, 8, 5, "macroDefinition")}, {this.createHighlightedRange(3, 16, 3, "namespace")}, {this.createHighlightedRange(5, 21, 4, "typedef")}, {this.createHighlightedRange(6, 11, 6, "functionDeclaration"), this.createHighlightedRange(6, 11, 6, "function")}, {this.createHighlightedRange(6, 18, 4, "typedef")}, {this.createHighlightedRange(6, 23, 9, "parameterVariable")}, {this.createHighlightedRange(7, 6, 9, "parameterVariable")}, {this.createHighlightedRange(7, 22, 7, "externalSDK"), this.createHighlightedRange(7, 22, 7, "function")}, {this.createHighlightedRange(7, 30, 6, "globalVariable")}, {this.createHighlightedRange(8, 9, 9, "parameterVariable")}, {this.createHighlightedRange(10, 6, 7, "class")}, {this.createHighlightedRange(12, 7, 6, "enum")}, {this.createHighlightedRange(12, 16, 4, "enumerator")}, {this.createHighlightedRange(12, 22, 3, "enumerator")}, {this.createHighlightedRange(12, 27, 3, "enumerator")}, {this.createHighlightedRange(13, 14, 11, "staticField"), this.createHighlightedRange(13, 14, 11, "field")}, {this.createHighlightedRange(14, 6, 5, "field")}, {this.createHighlightedRange(15, 10, 6, "enum")}, {this.createHighlightedRange(15, 17, 7, "methodDeclaration"), this.createHighlightedRange(15, 17, 7, "method")}, {this.createHighlightedRange(16, 7, 6, "methodDeclaration"), this.createHighlightedRange(16, 7, 6, "method")}, {this.createHighlightedRange(16, 14, 6, "enum")}, {this.createHighlightedRange(16, 21, 1, "parameterVariable")}, {this.createHighlightedRange(17, 8, 5, "localVariableDeclaration")}, {this.createHighlightedRange(17, 20, 5, "macroSubstitution")}, {this.createHighlightedRange(18, 0, 5, "label")}, {this.createHighlightedRange(18, 7, 6, "function")}, {this.createHighlightedRange(18, 14, 5, "localVariable")}, {this.createHighlightedRange(19, 4, 7, "method")}, {this.createHighlightedRange(20, 4, 12, "staticMethod"), this.createHighlightedRange(20, 4, 12, "method")}, {this.createHighlightedRange(21, 4, 7, "problem")}, {this.createHighlightedRange(23, 14, 12, "methodDeclaration"), this.createHighlightedRange(23, 14, 12, "method")}};
    }

    private SemanticHighlightingManager.HighlightedRange createHighlightedRange(int line, int column, int length, String key) {
        try {
            IDocument document = this.fPreviewViewer.getDocument();
            int offset = document.getLineOffset(line) + column;
            return new SemanticHighlightingManager.HighlightedRange(offset, length, key);
        }
        catch (BadLocationException x) {
            CUIPlugin.getDefault().log(x);
            return null;
        }
    }

    private HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fListViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof String) {
            return null;
        }
        return (HighlightingColorListItem)element;
    }

    private void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private class ColorListContentProvider
    implements ITreeContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new String[]{CEditorColoringConfigurationBlock.this.fCodeCategory, CEditorColoringConfigurationBlock.this.fCommentsCategory, CEditorColoringConfigurationBlock.this.fPreprocessorCategory};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                String entry = (String)parentElement;
                if (CEditorColoringConfigurationBlock.this.fCodeCategory.equals(entry)) {
                    return CEditorColoringConfigurationBlock.this.fListModel.subList(6, CEditorColoringConfigurationBlock.this.fListModel.size()).toArray();
                }
                if (CEditorColoringConfigurationBlock.this.fCommentsCategory.equals(entry)) {
                    return CEditorColoringConfigurationBlock.this.fListModel.subList(0, 3).toArray();
                }
                if (CEditorColoringConfigurationBlock.this.fPreprocessorCategory.equals(entry)) {
                    return CEditorColoringConfigurationBlock.this.fListModel.subList(3, 6).toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return null;
            }
            int index = CEditorColoringConfigurationBlock.this.fListModel.indexOf(element);
            if (index >= 6) {
                return CEditorColoringConfigurationBlock.this.fCodeCategory;
            }
            if (index >= 3) {
                return CEditorColoringConfigurationBlock.this.fPreprocessorCategory;
            }
            return CEditorColoringConfigurationBlock.this.fCommentsCategory;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof SemanticHighlightingColorListItem && !CEditorColoringConfigurationBlock.this.getPreferenceStore().getBoolean("semanticHighlighting.enabled")) {
                return Display.getDefault().getSystemColor(15);
            }
            return null;
        }
    }

    private static class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private String fStrikethroughKey;
        private String fUnderlineKey;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fStrikethroughKey = strikethroughKey;
            this.fUnderlineKey = underlineKey;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }
    }

    private static class SemanticHighlightingColorListItem
    extends HighlightingColorListItem {
        private final String fEnableKey;

        public SemanticHighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey, String enableKey) {
            super(displayName, colorKey, boldKey, italicKey, strikethroughKey, underlineKey);
            this.fEnableKey = enableKey;
        }

        public String getEnableKey() {
            return this.fEnableKey;
        }
    }
}

