/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElement;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class PDOMSearchLabelProvider
extends LabelProvider {
    private final AbstractTextSearchViewPage fPage;
    private final TypeInfoLabelProvider fTypeInfoLabelProvider = new TypeInfoLabelProvider(20);
    private final CUILabelProvider fCElementLabelProvider = new CUILabelProvider(0, 2);

    public PDOMSearchLabelProvider(AbstractTextSearchViewPage page) {
        this.fPage = page;
    }

    public Image getImage(Object element) {
        if (element instanceof PDOMSearchElement) {
            return this.fTypeInfoLabelProvider.getImage(((PDOMSearchElement)element).getTypeInfo());
        }
        if (element instanceof IIndexFileLocation || element instanceof URI) {
            return CPluginImages.get("org.eclipse.cdt.ui.include_obj.gif");
        }
        if (element == IPDOMSearchContentProvider.URI_CONTAINER) {
            return CPluginImages.get("org.eclipse.cdt.ui.includes_container.gif");
        }
        if (element instanceof IPath) {
            return CPluginImages.get("org.eclipse.cdt.ui.hfolder_obj.gif");
        }
        if (element instanceof IStatus) {
            IStatus status = (IStatus)element;
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            switch (status.getSeverity()) {
                case 2: {
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                case 4: {
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
            }
            return sharedImages.getImage("IMG_OBJS_INFO_TSK");
        }
        return this.fCElementLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        IPath path;
        if (element instanceof PDOMSearchElement) {
            return this.fTypeInfoLabelProvider.getText(((PDOMSearchElement)element).getTypeInfo());
        }
        if (element instanceof IPath) {
            return ((IPath)element).toString();
        }
        if (element instanceof IIndexFileLocation && (path = IndexLocationFactory.getPath((IIndexFileLocation)((IIndexFileLocation)element))) != null) {
            return path.lastSegment();
        }
        if (element instanceof URI) {
            return ((URI)element).toString();
        }
        if (element instanceof IStatus) {
            return ((IStatus)element).getMessage();
        }
        return this.fCElementLabelProvider.getText(element);
    }

    protected int getMatchCount(Object element) {
        return this.fPage.getInput().getMatchCount(element);
    }
}

