/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchElement;
import org.eclipse.cdt.internal.ui.search.PDOMSearchListContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchListLabelProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchTreeContentProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchTreeLabelProvider;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDOMSearchViewPage
extends AbstractTextSearchViewPage {
    private IPDOMSearchContentProvider contentProvider;

    public PDOMSearchViewPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public PDOMSearchViewPage() {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new PDOMSearchTreeContentProvider();
        viewer.setComparator((ViewerComparator)new SearchViewerComparator());
        viewer.setContentProvider((IContentProvider)((PDOMSearchTreeContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new PDOMSearchTreeLabelProvider(this));
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new PDOMSearchListContentProvider();
        viewer.setComparator((ViewerComparator)new SearchViewerComparator());
        viewer.setContentProvider((IContentProvider)((PDOMSearchListContentProvider)this.contentProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new PDOMSearchListLabelProvider(this));
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (!(match instanceof PDOMSearchMatch)) {
            return;
        }
        try {
            Object element = ((PDOMSearchMatch)match).getElement();
            IIndexFileLocation ifl = ((PDOMSearchElement)element).getLocation();
            IPath path = IndexLocationFactory.getPath((IIndexFileLocation)ifl);
            IEditorPart editor = EditorUtility.openInEditor(path, null);
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    private class SearchViewerComparator
    extends ViewerComparator {
        private SearchViewerComparator() {
        }

        public int category(Object element) {
            if (element instanceof IStatus) {
                return -1000;
            }
            if (element instanceof PDOMSearchElement) {
                PDOMSearchElement searchElement = (PDOMSearchElement)element;
                int type = searchElement.getTypeInfo().getCElementType();
                if (type < 0) {
                    type = 0;
                }
                return type;
            }
            if (element instanceof ICElement) {
                int type = ((ICElement)element).getElementType();
                if (type < 0) {
                    type = 0;
                }
                return Math.min(Math.max(0, type), 900);
            }
            if (element instanceof IPath || element instanceof IIndexFileLocation) {
                return 999;
            }
            if (element == IPDOMSearchContentProvider.URI_CONTAINER) {
                return 1000;
            }
            return 2000;
        }
    }
}

