/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.editor.IndentUtil;
import org.eclipse.cdt.internal.ui.text.CCommentAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.CIndenter;
import org.eclipse.cdt.internal.ui.text.FastCPartitionScanner;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditorExtension3;

public class CAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String MULTILINE_COMMENT_CLOSE = "*/";
    private static final String LINE_COMMENT = "//";
    private boolean fCloseBrace;
    private boolean fIsSmartMode;
    private String fPartitioning;
    private final ICProject fProject;
    static /* synthetic */ Class class$0;

    public CAutoIndentStrategy(String partitioning, ICProject project) {
        this.fPartitioning = partitioning;
        this.fProject = project;
    }

    private int getBracketCount(IDocument d, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketcount = 0;
        block7: while (start < end) {
            char curr = d.getChar(start);
            ++start;
            switch (curr) {
                case '/': {
                    if (start >= end) break;
                    char next = d.getChar(start);
                    if (next == '*') {
                        start = this.getCommentEnd(d, start + 1, end);
                        break;
                    }
                    if (next != '/') break;
                    start = end;
                    break;
                }
                case '*': {
                    char next;
                    if (start >= end || (next = d.getChar(start)) != '/') continue block7;
                    bracketcount = 0;
                    ++start;
                    break;
                }
                case '{': {
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketcount;
                    break;
                }
                case '\"': 
                case '\'': {
                    start = this.getStringEnd(d, start, end, curr);
                }
            }
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int reference;
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            CHeuristicScanner scanner = new CHeuristicScanner(d);
            ITypedRegion partition = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)p, (boolean)false);
            if ("__c_preprocessor".equals(partition.getType())) {
                scanner = new CHeuristicScanner(d, this.fPartitioning, "__c_preprocessor");
            }
            CIndenter indenter = new CIndenter(d, scanner, this.fProject);
            if (whiteend == c.offset && (indLine = d.getLineOfOffset(reference = indenter.findReferencePosition(c.offset, false, true, false, false, false))) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length += c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        try {
            int line;
            int lineOffset;
            CHeuristicScanner scanner = new CHeuristicScanner(d);
            ITypedRegion partition = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)p, (boolean)false);
            if ("__c_preprocessor".equals(partition.getType())) {
                scanner = new CHeuristicScanner(d, this.fPartitioning, "__c_preprocessor");
            }
            if (d.get(lineOffset = d.getLineOffset(line = d.getLineOfOffset(c.offset)), c.offset - lineOffset).trim().length() != 0) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = d.getLineOfOffset(pos);
            if (lastLine < line) {
                CIndenter indenter = new CIndenter(d, scanner, this.fProject);
                StringBuffer indent = indenter.computeIndentation(p, true);
                String toDelete = d.get(lineOffset, c.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    c.text = indent.append(c.text).toString();
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        int addIndent = 0;
        CHeuristicScanner scanner = new CHeuristicScanner(d);
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)c.offset, (boolean)false);
            if ("__c_preprocessor".equals(partition.getType()) && d.get(c.offset - 1, 1).charAt(0) == '\\') {
                scanner = new CHeuristicScanner(d, this.fPartitioning, "__c_preprocessor");
                addIndent = 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        int p = c.offset == docLength ? c.offset - 1 : c.offset;
        CIndenter indenter = new CIndenter(d, scanner, this.fProject);
        StringBuffer indent = indenter.computeIndentation(c.offset);
        if (indent == null) {
            indent = new StringBuffer();
        }
        if (addIndent > 0 && indent.length() == 0) {
            indent = indenter.createReusingIndent(indent, addIndent);
        }
        try {
            int firstCharPos;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            if (this.getBracketCount(d, start, c.offset, true) > 0 && this.fCloseBrace && !this.isClosedBrace(d, c.offset, c.length)) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                if ((c.offset == 0 || CAutoIndentStrategy.computeAnonymousPosition(d, c.offset - 1, this.fPartitioning, lineEnd) == -1) && lineEnd - contentStart > 0) {
                    c.length = lineEnd - c.offset;
                    buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
                }
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                if (reference != null) {
                    buf.append(reference);
                }
                buf.append('}');
                int bound = c.offset > 200 ? c.offset - 200 : -2;
                int bracePos = scanner.findOpeningPeer(c.offset - 1, bound, '{', '}');
                if (bracePos != -1 && (scanner.looksLikeCompositeTypeDefinitionBackward(bracePos, bound) || scanner.previousToken(bracePos - 1, bound) == 12)) {
                    buf.append(';');
                }
            } else if (c.offset > start && contentStart < lineEnd && d.getChar(contentStart) == '}' && (firstCharPos = scanner.findNonWhitespaceBackward(c.offset - 1, start)) != -1 && d.getChar(firstCharPos) == '{') {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                StringBuffer reference = null;
                int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
                reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
                buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
                if (reference != null) {
                    buf.append(reference);
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    private static int computeAnonymousPosition(IDocument document, int offset, String partitioning, int max) {
        int openingParen;
        int startScan;
        CHeuristicScanner scanner = new CHeuristicScanner(document);
        int pos = offset;
        int length = max;
        int scanTo = scanner.scanForward(pos, length, '}');
        if (scanTo == -1) {
            scanTo = length;
        }
        int closingParen = CAutoIndentStrategy.findClosingParenToLeft(scanner, pos) - 1;
        while ((closingParen = scanner.scanForward(startScan = closingParen + 1, scanTo, ')')) != -1 && (openingParen = scanner.findOpeningPeer(closingParen - 1, '(', ')')) >= 1) {
            if (openingParen <= pos) continue;
        }
        return -1;
    }

    private static int findClosingParenToLeft(CHeuristicScanner scanner, int position) {
        if (position < 1) {
            return position;
        }
        if (scanner.previousToken(position - 1, -2) == 6) {
            return scanner.getPosition() + 1;
        }
        return position;
    }

    private boolean isClosedBrace(IDocument document, int offset, int length) {
        CompilationUnitInfo info = CAutoIndentStrategy.getCompilationUnitForMethod(document, offset, this.fPartitioning);
        if (info == null) {
            return false;
        }
        return CAutoIndentStrategy.getBlockBalance(document, offset, this.fPartitioning) <= 0;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private static void installCPartitioner(Document document) {
        String[] types = new String[]{"__c_multiline_comment", "__c_singleline_comment", "__c_string", "__c_character", "__c_preprocessor", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new FastCPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("___c_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeCPartitioner(Document document) {
        document.setDocumentPartitioner("___c_partitioning", null);
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        int newOffset = command.offset;
        int newLength = command.length;
        String newText = command.text;
        try {
            CHeuristicScanner scanner = new CHeuristicScanner(document);
            CIndenter indenter = new CIndenter(document, scanner, this.fProject);
            int offset = newOffset;
            int refOffset = indenter.findReferencePosition(offset);
            if (refOffset == -1) {
                return;
            }
            int peerOffset = this.getPeerPosition(document, command);
            if ((peerOffset = indenter.findReferencePosition(peerOffset)) == -1) {
                return;
            }
            refOffset = Math.min(refOffset, peerOffset);
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(offset);
            String notSelected = document.get(line.getOffset(), offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                newLength += notSelected.length();
                newOffset = line.getOffset();
                firstLine = 0;
            }
            IRegion refLine = document.getLineInformationOfOffset(refOffset);
            String prefix = document.get(refLine.getOffset(), newOffset - refLine.getOffset());
            Document temp = new Document(String.valueOf(prefix) + newText);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            scanner = new CHeuristicScanner((IDocument)temp);
            indenter = new CIndenter((IDocument)temp, scanner, this.fProject);
            CAutoIndentStrategy.installCPartitioner(temp);
            boolean isIndentDetected = false;
            StringBuffer addition = new StringBuffer();
            int insertLength = 0;
            int first = document.computeNumberOfLines(prefix) + firstLine;
            int lines = temp.getNumberOfLines();
            boolean changed = false;
            boolean indentInsideLineComments = IndentUtil.indentInsideLineComments(this.fProject);
            int l = first;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        String current = IndentUtil.getCurrentIndent((IDocument)temp, l, indentInsideLineComments);
                        StringBuffer correct = new StringBuffer(IndentUtil.computeIndent((IDocument)temp, l, indenter, scanner));
                        if (correct == null) {
                            return;
                        }
                        insertLength = this.subtractIndent(correct, current, addition);
                        if (temp.get(lineOffset, lineLength).trim().length() != 0) {
                            isIndentDetected = true;
                            if (insertLength == 0) {
                                if (firstLine == 0) {
                                    command.offset = newOffset;
                                    command.length = newLength;
                                    if (changed) break;
                                }
                                return;
                            }
                            CAutoIndentStrategy.removeCPartitioner(temp);
                        } else {
                            boolean bl = changed = insertLength != 0;
                        }
                    }
                    if (insertLength > 0) {
                        CAutoIndentStrategy.addIndent(temp, l, addition, indentInsideLineComments);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength, indentInsideLineComments);
                    }
                }
                ++l;
            }
            temp.stopRewriteSession(session);
            newText = temp.get(prefix.length(), temp.getLength() - prefix.length());
            command.offset = newOffset;
            command.length = newLength;
            command.text = newText;
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference) {
        int c2;
        int c1 = this.computeVisualLength(correct);
        int diff = c1 - (c2 = this.computeVisualLength(current));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c);
        }
        return diff;
    }

    private static void addIndent(Document document, int line, CharSequence indent, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        if (indentInsideLineComments) {
            while (insert < endOffset - 2 && document.get(insert, 2).equals(LINE_COMMENT)) {
                insert += 2;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        if (indentInsideLineComments) {
            while (from < endOffset - 2 && document.get(from, 2).equals(LINE_COMMENT)) {
                from += 2;
            }
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, null);
    }

    private int computeVisualLength(CharSequence seq) {
        int size = 0;
        int tablen = this.getVisualTabLengthPreference();
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tablen != 0) {
                    size += tablen - size % tablen;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private int computeVisualLength(char ch) {
        if (ch == '\t') {
            return this.getVisualTabLengthPreference();
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return CodeFormatterUtil.getTabWidth(this.fProject);
    }

    private int getPeerPosition(IDocument document, DocumentCommand command) {
        if (document.getLength() == 0) {
            return 0;
        }
        Document pasted = new Document(command.text);
        CAutoIndentStrategy.installCPartitioner(pasted);
        int firstPeer = command.offset;
        CHeuristicScanner pScanner = new CHeuristicScanner((IDocument)pasted);
        CHeuristicScanner dScanner = new CHeuristicScanner(document);
        int afterToken = dScanner.nextToken(command.offset + command.length, -2);
        try {
            switch (afterToken) {
                case 2: {
                    pasted.replace(pasted.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    pasted.replace(pasted.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    pasted.replace(pasted.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        int pPos = 0;
        int dPos = Math.max(0, command.offset - 1);
        block16: while (true) {
            int token = pScanner.nextToken(pPos, -2);
            pPos = pScanner.getPosition();
            switch (token) {
                case 1: 
                case 3: 
                case 5: {
                    if ((pPos = CAutoIndentStrategy.skipScope(pScanner, pPos, token)) != -1) continue block16;
                    return firstPeer;
                }
                case 2: {
                    int peer = dScanner.findOpeningPeer(dPos, '{', '}');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 4: {
                    int peer = dScanner.findOpeningPeer(dPos, '[', ']');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 6: {
                    int peer = dScanner.findOpeningPeer(dPos, '(', ')');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 1013: 
                case 1022: {
                    CIndenter indenter = new CIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, false, false, true, false);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case 1023: 
                case 1024: 
                case 1025: {
                    CIndenter indenter = new CIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, false, false, false, true);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block16;
                }
                case -1: {
                    return firstPeer;
                }
            }
        }
    }

    private static int skipScope(CHeuristicScanner scanner, int pos, int token) {
        int closeToken;
        int openToken = token;
        switch (token) {
            case 5: {
                closeToken = 6;
                break;
            }
            case 3: {
                closeToken = 4;
                break;
            }
            case 1: {
                closeToken = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int depth = 1;
        int p = pos;
        while (true) {
            int tok = scanner.nextToken(p, -2);
            p = scanner.getPosition();
            if (tok == openToken) {
                ++depth;
                continue;
            }
            if (tok == closeToken) {
                if (--depth != 0) continue;
                return p + 1;
            }
            if (tok == -1) break;
        }
        return -1;
    }

    private void smartIndentOnKeypress(IDocument document, DocumentCommand command) {
        switch (command.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(document, command);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(document, command);
                break;
            }
            case 'e': {
                this.smartIndentUponE(document, command);
                break;
            }
            case ':': {
                this.smartIndentAfterColumn(document, command);
                break;
            }
            case '#': {
                this.smartIndentAfterHash(document, command);
            }
        }
    }

    private void smartIndentUponE(IDocument doc, DocumentCommand c) {
        if (c.offset < 4 || doc.getLength() == 0) {
            return;
        }
        try {
            String content = doc.get(c.offset - 3, 3);
            if (content.equals("els")) {
                CHeuristicScanner scanner = new CHeuristicScanner(doc);
                int p = c.offset - 3;
                int line = doc.getLineOfOffset(p);
                int lineOffset = doc.getLineOffset(line);
                if (doc.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = doc.getLineOfOffset(pos);
                if (lastLine < line) {
                    CIndenter indenter = new CIndenter(doc, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, true, false, false, false, false);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = doc.getLineOfOffset(ref);
                    String indent = this.getIndentOfLine(doc, refLine);
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "else";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
            if (content.equals("cas")) {
                CHeuristicScanner scanner = new CHeuristicScanner(doc);
                int p = c.offset - 3;
                int line = doc.getLineOfOffset(p);
                int lineOffset = doc.getLineOffset(line);
                if (doc.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = doc.getLineOfOffset(pos);
                if (lastLine < line) {
                    CIndenter indenter = new CIndenter(doc, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, false, false, false, true, false);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = doc.getLineOfOffset(ref);
                    int nextToken = scanner.nextToken(ref, -2);
                    String indent = nextToken == 1013 || nextToken == 1022 ? this.getIndentOfLine(doc, refLine) : indenter.computeIndentation(p).toString();
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "case";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    private void smartIndentAfterColumn(IDocument doc, DocumentCommand c) {
        try {
            int offset = c.offset;
            int line = doc.getLineOfOffset(offset);
            IRegion startLine = doc.getLineInformationOfOffset(offset);
            int lineOffset = startLine.getOffset();
            CHeuristicScanner scanner = new CHeuristicScanner(doc);
            int prevToken = scanner.previousToken(offset - 1, lineOffset);
            switch (prevToken) {
                case 1022: 
                case 1023: 
                case 1024: 
                case 1025: {
                    break;
                }
                default: {
                    return;
                }
            }
            int p = scanner.getPosition() + 1;
            if (doc.get(lineOffset, p - lineOffset).trim().length() != 0) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = doc.getLineOfOffset(pos);
            if (lastLine < line) {
                CIndenter indenter = new CIndenter(doc, scanner, this.fProject);
                int ref = prevToken == 1022 ? indenter.findReferencePosition(p, false, false, false, true, false) : indenter.findReferencePosition(p, false, false, false, false, true);
                if (ref == -1) {
                    return;
                }
                int refLine = doc.getLineOfOffset(ref);
                int nextToken = scanner.nextToken(ref, -2);
                String indent = nextToken == 1013 || nextToken == 1022 || nextToken == 1025 || nextToken == 1024 || nextToken == 1023 ? this.getIndentOfLine(doc, refLine) : indenter.computeIndentation(p).toString();
                if (indent != null) {
                    c.text = String.valueOf(indent.toString()) + doc.get(p, offset - p) + c.text;
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
            return;
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
            return;
        }
    }

    private void smartIndentAfterHash(IDocument doc, DocumentCommand c) {
        try {
            IRegion startLine;
            String indent;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)this.fPartitioning, (int)c.offset, (boolean)false);
            if ("__dftl_partition_content_type".equals(partition.getType()) && (indent = doc.get((startLine = doc.getLineInformationOfOffset(c.offset)).getOffset(), c.offset - startLine.getOffset())).trim().length() == 0) {
                c.offset -= indent.length();
                c.length += indent.length();
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.fIsSmartMode) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            if (this.isAppendToOpenMultilineComment(d, c)) {
                CCommentAutoIndentStrategy.commentIndentAfterNewLine(d, c);
            } else {
                this.smartIndentAfterNewLine(d, c);
            }
        } else if ("/".equals(c.text) && this.isAppendToOpenMultilineComment(d, c)) {
            CCommentAutoIndentStrategy.commentIndentForCommentEnd(d, c);
        } else if (c.text.length() == 1) {
            this.smartIndentOnKeypress(d, c);
        } else if (c.text.length() > 1 && CAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
    }

    private boolean isAppendToOpenMultilineComment(IDocument d, DocumentCommand c) {
        if (d.getLength() >= 2 && c.offset == d.getLength()) {
            try {
                String contentType = TextUtilities.getContentType((IDocument)d, (String)this.fPartitioning, (int)(c.offset - 1), (boolean)false);
                if ("__c_multiline_comment".equals(contentType)) {
                    return !d.get(c.offset - 2, 2).equals(MULTILINE_COMMENT_CLOSE);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private static IPreferenceStore getPreferenceStore() {
        return CUIPlugin.getDefault().getCombinedPreferenceStore();
    }

    private void clearCachedValues() {
        IPreferenceStore preferenceStore = CAutoIndentStrategy.getPreferenceStore();
        this.fCloseBrace = preferenceStore.getBoolean("closeBraces");
        this.fIsSmartMode = this.computeSmartMode();
    }

    private boolean computeSmartMode() {
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null) {
            IEditorPart part = page.getActiveEditor();
            if (part instanceof MultiPageEditorPart) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditorExtension3");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                part = (IEditorPart)part.getAdapter((Class)clazz);
            }
            if (part instanceof ITextEditorExtension3) {
                ITextEditorExtension3 extension = (ITextEditorExtension3)part;
                return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
            }
            if (part == null) {
                return true;
            }
        }
        return false;
    }

    private static CompilationUnitInfo getCompilationUnitForMethod(IDocument document, int offset, String partitioning) {
        IRegion sourceRange;
        block3: {
            try {
                CHeuristicScanner scanner = new CHeuristicScanner(document);
                sourceRange = scanner.findSurroundingBlock(offset);
                if (sourceRange != null) break block3;
                return null;
            }
            catch (BadLocationException e) {
                CUIPlugin.getDefault().log(e);
                return null;
            }
        }
        String source = document.get(sourceRange.getOffset(), sourceRange.getLength());
        StringBuffer contents = new StringBuffer();
        contents.append("class ____C{void ____m()");
        int methodOffset = contents.length();
        contents.append(source);
        contents.append("};");
        char[] buffer = contents.toString().toCharArray();
        return new CompilationUnitInfo(buffer, sourceRange.getOffset() - methodOffset);
    }

    private static int getBlockBalance(IDocument document, int offset, String partitioning) {
        if (offset < 1) {
            return -1;
        }
        if (offset >= document.getLength()) {
            return 1;
        }
        int begin = offset;
        int end = offset - 1;
        CHeuristicScanner scanner = new CHeuristicScanner(document);
        do {
            begin = scanner.findOpeningPeer(begin - 1, '{', '}');
            end = scanner.findClosingPeer(end + 1, '{', '}');
            if (begin == -1 && end == -1) {
                return 0;
            }
            if (begin != -1) continue;
            return -1;
        } while (end != -1);
        return 1;
    }

    private static class CompilationUnitInfo {
        char[] buffer;
        int delta;

        CompilationUnitInfo(char[] buffer, int delta) {
            this.buffer = buffer;
            this.delta = delta;
        }
    }
}

