/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.CElementHyperlinkDetector;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.CAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CCodeScanner;
import org.eclipse.cdt.internal.ui.text.CCommentAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.CDoubleClickSelector;
import org.eclipse.cdt.internal.ui.text.CFormattingStrategy;
import org.eclipse.cdt.internal.ui.text.COutlineInformationControl;
import org.eclipse.cdt.internal.ui.text.CPreprocessorScanner;
import org.eclipse.cdt.internal.ui.text.CPresentationReconciler;
import org.eclipse.cdt.internal.ui.text.CReconciler;
import org.eclipse.cdt.internal.ui.text.CReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.CStringAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CStringDoubleClickSelector;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.cdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.PartitionDamager;
import org.eclipse.cdt.internal.ui.text.SingleTokenCScanner;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverProxy;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistProcessor;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.internal.ui.typehierarchy.THInformationControl;
import org.eclipse.cdt.internal.ui.typehierarchy.THInformationProvider;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ILanguageUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private CTextTools fTextTools;
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private AbstractCScanner fCodeScanner;
    private AbstractCScanner fMultilineCommentScanner;
    private AbstractCScanner fSinglelineCommentScanner;
    private AbstractCScanner fStringScanner;
    private AbstractCScanner fPreprocessorScanner;
    private IColorManager fColorManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getPreprocessorScanner(ILanguage language) {
        CPreprocessorScanner scanner;
        if (this.fPreprocessorScanner != null) {
            return this.fPreprocessorScanner;
        }
        if (this.isNewSetup()) {
            scanner = null;
            if (language instanceof ICLanguageKeywords) {
                scanner = new CPreprocessorScanner(this.getColorManager(), this.fPreferenceStore, (ICLanguageKeywords)language);
            }
            if (scanner == null) {
                scanner = new CPreprocessorScanner(this.getColorManager(), this.fPreferenceStore, (ICLanguageKeywords)GPPLanguage.getDefault());
            }
        } else {
            if (language instanceof ICLanguageKeywords) {
                return this.fTextTools.getCPreprocessorScanner();
            }
            return this.fTextTools.getCppPreprocessorScanner();
        }
        this.fPreprocessorScanner = scanner;
        return this.fPreprocessorScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    public ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        IInformationControlCreator outlineControlCreator = this.getOutlineControlCreator();
        InformationPresenter presenter = new InformationPresenter(outlineControlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        CElementContentProvider provider = new CElementContentProvider(this.getEditor());
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_character");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_preprocessor");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    public IInformationPresenter getHierarchyPresenter(ISourceViewer sourceViewer) {
        IInformationControlCreator hierarchyControlCreator = this.getHierarchyControlCreator();
        InformationPresenter presenter = new InformationPresenter(hierarchyControlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        THInformationProvider provider = new THInformationProvider(this.getEditor());
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_character");
        presenter.setInformationProvider((IInformationProvider)provider, "__c_preprocessor");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fMultilineCommentScanner = new CCommentScanner(this.getColorManager(), this.fPreferenceStore, "c_multi_line_comment");
        this.fSinglelineCommentScanner = new CCommentScanner(this.getColorManager(), this.fPreferenceStore, "c_single_line_comment");
        this.fStringScanner = new SingleTokenCScanner(this.getColorManager(), this.fPreferenceStore, "c_string");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        CPresentationReconciler reconciler = new CPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        ILanguage language = this.getLanguage();
        RuleBasedScanner scanner = this.getCodeScanner(language);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_character");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPreprocessorScanner(language));
        reconciler.setDamager(new PartitionDamager(), "__c_preprocessor");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_preprocessor");
        return reconciler;
    }

    protected RuleBasedScanner getCodeScanner(ILanguage language) {
        if (this.fCodeScanner != null) {
            return this.fCodeScanner;
        }
        if (this.isNewSetup()) {
            CCodeScanner scanner = null;
            if (language instanceof ICLanguageKeywords) {
                ICLanguageKeywords cLang = (ICLanguageKeywords)language;
                scanner = new CCodeScanner(this.getColorManager(), this.fPreferenceStore, cLang);
            } else if (language != null) {
                ILanguageUI languageUI;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.ui.ILanguageUI");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((languageUI = (ILanguageUI)language.getAdapter((Class)clazz)) != null) {
                    scanner = languageUI.getCodeScanner();
                }
            }
            if (scanner == null) {
                scanner = new CCodeScanner(this.getColorManager(), this.fPreferenceStore, (ICLanguageKeywords)GPPLanguage.getDefault());
            }
            if (scanner instanceof AbstractCScanner) {
                this.fCodeScanner = scanner;
            }
            return scanner;
        }
        if (language instanceof ICLanguageKeywords) {
            return this.fTextTools.getCCodeScanner();
        }
        return this.fTextTools.getCppCodeScanner();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() == null) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
        CContentAssistProcessor processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), sourceViewer, assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), sourceViewer, assistant, "__c_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_multiline_comment");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), sourceViewer, assistant, "__c_singleline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_singleline_comment");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), sourceViewer, assistant, "__c_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_string");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), sourceViewer, assistant, "__c_preprocessor");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_preprocessor");
        ContentAssistPreference.configure(assistant, this.fPreferenceStore);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fTextEditor != null) {
            CReconciler reconciler = new CReconciler(this.fTextEditor, new CReconcilingStrategy(this.fTextEditor));
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        if ("__c_multiline_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new CCommentAutoIndentStrategy()};
        }
        if ("__c_string".equals(contentType)) {
            return new IAutoEditStrategy[]{new CStringAutoIndentStrategy(partitioning, this.getProject())};
        }
        return new IAutoEditStrategy[]{new CAutoIndentStrategy(partitioning, this.getProject())};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__c_multiline_comment".equals(contentType) || "__c_singleline_comment".equals(contentType)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if ("__c_string".equals(contentType) || "__c_character".equals(contentType)) {
            return new CStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        if ("__c_preprocessor".equals(contentType)) {
            return new CStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer), new CDoubleClickSelector());
        }
        return new CDoubleClickSelector();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        ICProject project = this.getProject();
        int tabWidth = CodeFormatterUtil.getTabWidth(project);
        int indentWidth = CodeFormatterUtil.getIndentWidth(project);
        int spaceEquivalents = Math.min(tabWidth, indentWidth);
        boolean useSpaces = project == null ? "space".equals(CCorePlugin.getOption((String)"org.eclipse.cdt.core.formatter.tabulation.char")) || tabWidth > indentWidth : "space".equals(project.getOption("org.eclipse.cdt.core.formatter.tabulation.char", true)) || tabWidth > indentWidth;
        int i = 0;
        while (i <= spaceEquivalents) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < spaceEquivalents) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != spaceEquivalents) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    private ICProject getProject() {
        ITextEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        IWorkingCopy element = null;
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider instanceof CDocumentProvider) {
            CDocumentProvider cudp = (CDocumentProvider)provider;
            element = cudp.getWorkingCopy(input);
        }
        if (element == null) {
            return null;
        }
        return element.getCProject();
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return CodeFormatterUtil.getTabWidth(this.getProject());
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return CSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        CEditorTextHoverDescriptor[] hoverDescs = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        CEditorTextHoverDescriptor[] hoverDescs = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new CEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__c_multiline_comment", "__c_singleline_comment", "__c_string", "__c_character", "__c_preprocessor"};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new CFormattingStrategy());
        return formatter;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        if (this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event)) {
            return true;
        }
        if (this.fCodeScanner != null && this.fCodeScanner.affectsBehavior(event)) {
            return true;
        }
        return this.fPreprocessorScanner != null && this.fPreprocessorScanner.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        Assert.isTrue((!this.isNewSetup() ? 1 : 0) != 0);
        this.fTextTools.adaptToPreferenceChange(event);
    }

    protected IPreferenceStore getPreferenceStore() {
        Assert.isTrue((!this.isNewSetup() ? 1 : 0) != 0);
        return this.fPreferenceStore;
    }

    private boolean isNewSetup() {
        return this.fTextTools == null;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return this.getInformationControlCreator(sourceViewer, true);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer, final boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        return super.getInformationPresenter(sourceViewer);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner != null && this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fPreprocessorScanner != null && this.fPreprocessorScanner.affectsBehavior(event)) {
            this.fPreprocessorScanner.adaptToPreferenceChange(event);
        }
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fTextEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        detectors[0] = new CElementHyperlinkDetector(this.fTextEditor);
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i + 1] = inheritedDetectors[i];
            ++i;
        }
        return detectors;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    private IInformationControlCreator getOutlineControlCreator() {
        IInformationControlCreator conrolCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new COutlineInformationControl(parent, shellStyle, treeStyle);
            }
        };
        return conrolCreator;
    }

    private IInformationControlCreator getHierarchyControlCreator() {
        IInformationControlCreator conrolCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new THInformationControl(parent, shellStyle, treeStyle);
            }
        };
        return conrolCreator;
    }

    protected ILanguage getLanguage() {
        block13: {
            if (this.fTextEditor == null) {
                return GPPLanguage.getDefault();
            }
            IWorkingCopy element = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fTextEditor.getEditorInput());
            if (element instanceof ITranslationUnit) {
                try {
                    return ((ITranslationUnit)element).getLanguage();
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                    break block13;
                }
            }
            IContentType contentType = null;
            IEditorInput input = this.fTextEditor.getEditorInput();
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                contentType = CCorePlugin.getContentType((IProject)file.getProject(), (String)file.getName());
            } else if (input instanceof IPathEditorInput) {
                IPath path = ((IPathEditorInput)input).getPath();
                contentType = CCorePlugin.getContentType((String)path.lastSegment());
            } else {
                ILocationProvider locationProvider;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((locationProvider = (ILocationProvider)input.getAdapter((Class)clazz)) != null) {
                    IPath path = locationProvider.getPath((Object)input);
                    contentType = CCorePlugin.getContentType((String)path.lastSegment());
                }
            }
            if (contentType != null) {
                return LanguageManager.getInstance().getLanguage(contentType);
            }
        }
        return GPPLanguage.getDefault();
    }

    public void resetScanners() {
        this.fCodeScanner = null;
        this.fPreprocessorScanner = null;
    }
}

