/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplates;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;

public class DOMCompletionProposalComputer
extends ParsingBasedProposalComputer {
    protected List computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) {
        ArrayList proposals = new ArrayList();
        if (this.inPreprocessorDirective(context)) {
            this.addMacroProposals(context, prefix, proposals);
        } else {
            boolean handleMacros = false;
            IASTName[] names = completionNode.getNames();
            int i = 0;
            while (i < names.length) {
                IASTCompletionContext astContext;
                if (names[i].getTranslationUnit() != null && (astContext = names[i].getCompletionContext()) != null) {
                    IBinding[] bindings;
                    if (astContext instanceof IASTIdExpression || astContext instanceof IASTNamedTypeSpecifier) {
                        handleMacros = prefix.length() > 0;
                    }
                    if ((bindings = astContext.findBindings(names[i], !context.isContextInformationStyle())) != null) {
                        int j = 0;
                        while (j < bindings.length) {
                            this.handleBinding(bindings[j], context, astContext, proposals);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (handleMacros) {
                this.addMacroProposals(context, prefix, proposals);
            }
        }
        return proposals;
    }

    private boolean inPreprocessorDirective(CContentAssistInvocationContext context) {
        IDocument doc = context.getViewer().getDocument();
        int offset = context.getParseOffset();
        if (offset > 0 && offset == doc.getLength()) {
            --offset;
        }
        try {
            return "__c_preprocessor".equals(TextUtilities.getContentType((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)false));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void addMacroProposals(CContentAssistInvocationContext context, String prefix, List proposals) {
        int i;
        char[] prefixChars = prefix.toCharArray();
        IASTCompletionNode completionNode = context.getCompletionNode();
        IASTPreprocessorMacroDefinition[] macros = completionNode.getTranslationUnit().getMacroDefinitions();
        if (macros != null) {
            i = 0;
            while (i < macros.length) {
                if (CharArrayUtils.equals((char[])macros[i].getName().toCharArray(), (int)0, (int)prefixChars.length, (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(macros[i], context, proposals);
                }
                ++i;
            }
        }
        if ((macros = completionNode.getTranslationUnit().getBuiltinMacroDefinitions()) != null) {
            i = 0;
            while (i < macros.length) {
                if (CharArrayUtils.equals((char[])macros[i].getName().toCharArray(), (int)0, (int)prefixChars.length, (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(macros[i], context, proposals);
                }
                ++i;
            }
        }
    }

    private void handleMacro(IASTPreprocessorMacroDefinition macro, CContentAssistInvocationContext context, List proposals) {
        String macroName = macro.getName().toString();
        Image image = this.getImage(CElementImageProvider.getMacroImageDescriptor());
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition functionMacro = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            StringBuffer repStringBuff = new StringBuffer();
            repStringBuff.append(macroName);
            repStringBuff.append('(');
            StringBuffer args = new StringBuffer();
            IASTFunctionStyleMacroParameter[] params = functionMacro.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    if (i > 0) {
                        args.append(", ");
                    }
                    args.append(params[i].getParameter());
                    ++i;
                }
            }
            String argString = args.toString();
            StringBuffer descStringBuff = new StringBuffer(repStringBuff.toString());
            descStringBuff.append(argString);
            descStringBuff.append(')');
            repStringBuff.append(')');
            String repString = repStringBuff.toString();
            String descString = descStringBuff.toString();
            CCompletionProposal proposal = this.createProposal(repString, descString, image, context);
            if (!context.isContextInformationStyle()) {
                proposal.setCursorPosition(repString.length() - 1);
            }
            if (argString.length() > 0) {
                CProposalContextInformation info = new CProposalContextInformation(image, descString, argString);
                info.setContextInformationPosition(context.getContextInformationOffset());
                proposal.setContextInformation(info);
            }
            proposals.add(proposal);
        } else {
            proposals.add(this.createProposal(macroName, macroName, image, context));
        }
    }

    protected void handleBinding(IBinding binding, CContentAssistInvocationContext cContext, IASTCompletionContext astContext, List proposals) {
        if ((binding instanceof CPPImplicitFunction || binding instanceof CPPTemplates.CPPImplicitFunctionTemplate || binding instanceof CPPImplicitTypedef) && !(binding instanceof CPPImplicitMethod)) {
            return;
        }
        if (!this.isAnonymousBinding(binding)) {
            if (binding instanceof ICPPClassType) {
                this.handleClass((ICPPClassType)binding, astContext, cContext, proposals);
            } else if (binding instanceof IFunction) {
                this.handleFunction((IFunction)binding, cContext, proposals);
            } else if (!cContext.isContextInformationStyle()) {
                if (binding instanceof IVariable) {
                    this.handleVariable((IVariable)binding, cContext, proposals);
                } else if (binding instanceof ICPPNamespace) {
                    this.handleNamespace((ICPPNamespace)binding, astContext, cContext, proposals);
                } else {
                    proposals.add(this.createProposal(binding.getName(), binding.getName(), this.getImage(binding), cContext));
                }
            }
        }
    }

    private boolean isAnonymousBinding(IBinding binding) {
        char[] name = binding.getNameCharArray();
        return name.length == 0 || name[0] == '{';
    }

    private void handleClass(ICPPClassType classType, IASTCompletionContext astContext, CContentAssistInvocationContext context, List proposals) {
        if (context.isContextInformationStyle()) {
            try {
                ICPPConstructor[] constructors = classType.getConstructors();
                int i = 0;
                while (i < constructors.length) {
                    this.handleFunction((IFunction)constructors[i], context, proposals);
                    ++i;
                }
            }
            catch (DOMException dOMException) {}
        } else {
            IASTName name;
            if (astContext instanceof IASTName && !(astContext instanceof ICPPASTQualifiedName) && (name = (IASTName)astContext).getParent() instanceof IASTDeclarator) {
                proposals.add(this.createProposal(String.valueOf(classType.getName()) + "::", classType.getName(), this.getImage((IBinding)classType), context));
            }
            proposals.add(this.createProposal(classType.getName(), classType.getName(), this.getImage((IBinding)classType), context));
        }
    }

    private void handleFunction(IFunction function, CContentAssistInvocationContext context, List proposals) {
        Image image = this.getImage((IBinding)function);
        StringBuffer repStringBuff = new StringBuffer();
        repStringBuff.append(function.getName());
        repStringBuff.append('(');
        StringBuffer dispargs = new StringBuffer();
        StringBuffer idargs = new StringBuffer();
        String returnTypeStr = null;
        try {
            IType returnType;
            IParameter[] params = function.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    IType paramType = params[i].getType();
                    if (i > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    idargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    String paramName = params[i].getName();
                    if (paramName != null && paramName.length() > 0) {
                        dispargs.append(' ');
                        dispargs.append(paramName);
                    }
                    ++i;
                }
            }
            if (function.takesVarArgs()) {
                if (params.length > 0) {
                    dispargs.append(',');
                    idargs.append(',');
                }
                dispargs.append("...");
                idargs.append("...");
            } else if (params.length == 0) {
                dispargs.append("void");
                idargs.append("void");
            }
            IFunctionType functionType = function.getType();
            if (functionType != null && (returnType = functionType.getReturnType()) != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)returnType, (boolean)false);
            }
        }
        catch (DOMException dOMException) {}
        String dispargString = dispargs.toString();
        String idargString = idargs.toString();
        StringBuffer dispStringBuff = new StringBuffer(repStringBuff.toString());
        dispStringBuff.append(dispargString);
        dispStringBuff.append(')');
        if (returnTypeStr != null && returnTypeStr.length() > 0) {
            dispStringBuff.append(' ');
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuffer idStringBuff = new StringBuffer(repStringBuff.toString());
        idStringBuff.append(idargString);
        idStringBuff.append(')');
        String idString = idStringBuff.toString();
        repStringBuff.append(')');
        String repString = repStringBuff.toString();
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, image, context);
        if (!context.isContextInformationStyle()) {
            proposal.setCursorPosition(repString.length() - 1);
        }
        if (dispargString.length() > 0) {
            CProposalContextInformation info = new CProposalContextInformation(image, dispString, dispargString);
            info.setContextInformationPosition(context.getContextInformationOffset());
            proposal.setContextInformation(info);
        }
        proposals.add(proposal);
    }

    private void handleVariable(IVariable variable, CContentAssistInvocationContext context, List proposals) {
        StringBuffer repStringBuff = new StringBuffer();
        repStringBuff.append(variable.getName());
        String returnTypeStr = "<unknown>";
        try {
            IType varType = variable.getType();
            if (varType != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)varType, (boolean)false);
            }
        }
        catch (DOMException dOMException) {}
        StringBuffer dispStringBuff = new StringBuffer(repStringBuff.toString());
        if (returnTypeStr != null) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuffer idStringBuff = new StringBuffer(repStringBuff.toString());
        String idString = idStringBuff.toString();
        String repString = repStringBuff.toString();
        Image image = this.getImage((IBinding)variable);
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, image, context);
        proposals.add(proposal);
    }

    private void handleNamespace(ICPPNamespace namespace, IASTCompletionContext astContext, CContentAssistInvocationContext cContext, List proposals) {
        if (astContext instanceof ICPPASTQualifiedName) {
            IASTCompletionContext parent = ((ICPPASTQualifiedName)astContext).getCompletionContext();
            this.handleNamespace(namespace, parent, cContext, proposals);
            return;
        }
        StringBuffer repStringBuff = new StringBuffer();
        repStringBuff.append(namespace.getName());
        if (!(astContext instanceof ICPPASTUsingDeclaration) && !(astContext instanceof ICPPASTUsingDirective)) {
            repStringBuff.append("::");
        }
        String repString = repStringBuff.toString();
        proposals.add(this.createProposal(repString, namespace.getName(), this.getImage((IBinding)namespace), cContext));
    }

    private CCompletionProposal createProposal(String repString, String dispString, Image image, CContentAssistInvocationContext context) {
        return this.createProposal(repString, dispString, null, image, context);
    }

    private CCompletionProposal createProposal(String repString, String dispString, String idString, Image image, CContentAssistInvocationContext context) {
        int parseOffset = context.getParseOffset();
        int invocationOffset = context.getInvocationOffset();
        boolean doReplacement = !context.isContextInformationStyle();
        int repLength = doReplacement ? context.getCompletionNode().getLength() : 0;
        int repOffset = doReplacement ? parseOffset - repLength : invocationOffset;
        repString = doReplacement ? repString : "";
        return new CCompletionProposal(repString, repOffset, repLength, image, dispString, idString, 1, context.getViewer());
    }

    private Image getImage(ImageDescriptor desc) {
        return desc != null ? CUIPlugin.getImageDescriptorRegistry().get(desc) : null;
    }

    private Image getImage(IBinding binding) {
        ImageDescriptor imageDescriptor = null;
        try {
            ICPPDelegate[] delegates;
            if (binding instanceof ITypedef) {
                imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
            } else if (binding instanceof ICompositeType) {
                if (((ICompositeType)binding).getKey() == 3 || binding instanceof ICPPClassTemplate) {
                    imageDescriptor = CElementImageProvider.getClassImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 1) {
                    imageDescriptor = CElementImageProvider.getStructImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 2) {
                    imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
                }
            } else if (binding instanceof ICPPMethod) {
                switch (((ICPPMethod)binding).getVisibility()) {
                    case 3: {
                        imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PRIVATE);
                        break;
                    }
                    case 2: {
                        imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PROTECTED);
                        break;
                    }
                    default: {
                        imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PUBLIC);
                        break;
                    }
                }
            } else if (binding instanceof IFunction) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPField) {
                switch (((ICPPField)binding).getVisibility()) {
                    case 3: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PRIVATE);
                        break;
                    }
                    case 2: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PROTECTED);
                        break;
                    }
                    default: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
                        break;
                    }
                }
            } else if (binding instanceof IField) {
                imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
            } else if (binding instanceof IVariable) {
                imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
            } else if (binding instanceof IEnumeration) {
                imageDescriptor = CElementImageProvider.getEnumerationImageDescriptor();
            } else if (binding instanceof IEnumerator) {
                imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
            } else if (binding instanceof ICPPNamespace) {
                imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
            } else if (binding instanceof ICPPFunctionTemplate) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPUsingDeclaration && (delegates = ((ICPPUsingDeclaration)binding).getDelegates()).length > 0) {
                return this.getImage((IBinding)delegates[0]);
            }
        }
        catch (DOMException dOMException) {}
        return imageDescriptor != null ? CUIPlugin.getImageDescriptorRegistry().get(imageDescriptor) : null;
    }
}

