/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContext;
import org.eclipse.cdt.internal.corext.template.c.TranslationUnitContextType;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.text.c.hover.SourceViewerInformationControl;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private TemplateContextType fContextType;
    private ArrayList fProposals = new ArrayList();
    private final Map fPositions = new HashMap();

    public TemplateEngine(TemplateContextType contextType) {
        Assert.isNotNull((Object)contextType);
        this.fContextType = contextType;
    }

    public TemplateEngine() {
        this.fContextType = CUIPlugin.getDefault().getTemplateContextRegistry().getContextType("org.eclipse.cdt.ui.text.templates.c");
        if (this.fContextType == null) {
            this.fContextType = new CContextType();
            CUIPlugin.getDefault().getTemplateContextRegistry().addContextType(this.fContextType);
        }
    }

    public void reset() {
        this.fProposals.clear();
        Iterator it = this.fPositions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IDocument doc = (IDocument)entry.getKey();
            Position position = (Position)entry.getValue();
            doc.removePosition(position);
        }
        this.fPositions.clear();
    }

    public List getResults() {
        return this.fProposals;
    }

    public void complete(ITextViewer viewer, int completionPosition, ITranslationUnit translationUnit) {
        if (!(this.fContextType instanceof TranslationUnitContextType)) {
            return;
        }
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
        if (multipleLinesSelected) {
            try {
                IRegion startLine = document.getLineInformationOfOffset(selection.x);
                IRegion endLine = document.getLineInformationOfOffset(selection.x + selection.y - 1);
                completionPosition = selection.x = startLine.getOffset();
                selection.y = endLine.getOffset() + endLine.getLength() - startLine.getOffset();
            }
            catch (BadLocationException badLocationException) {}
        }
        Position position = new Position(completionPosition, selection.y);
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
                document.addPosition(position);
                this.fPositions.put(document, position);
            }
            catch (BadLocationException badLocationException) {}
        }
        TranslationUnitContext context = ((TranslationUnitContextType)this.fContextType).createContext(document, position, translationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = CUIPlugin.getDefault().getTemplateStore().getTemplates();
        if (selection.y == 0) {
            int i = 0;
            while (i != templates.length) {
                if (context.canEvaluate(templates[i])) {
                    this.fProposals.add(new CTemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, CPluginImages.get("org.eclipse.cdt.ui.template_obj.gif")));
                }
                ++i;
            }
        } else {
            if (multipleLinesSelected || context.getKey().length() == 0) {
                context.setForceEvaluation(true);
            }
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template) && template.getContextTypeId().equals(context.getContextType().getId()) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new CTemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, CPluginImages.get("org.eclipse.cdt.ui.template_obj.gif")));
                }
                ++i;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public class CTemplateProposal
    extends TemplateProposal
    implements ICCompletionProposal {
        public IInformationControlCreator getInformationControlCreator() {
            return new IInformationControlCreator(this){
                final /* synthetic */ CTemplateProposal this$1;
                {
                    this.this$1 = cTemplateProposal;
                }

                public IInformationControl createInformationControl(Shell parent) {
                    int shellStyle = 16;
                    int style = 768;
                    return new SourceViewerInformationControl(parent, shellStyle, style);
                }
            };
        }

        public CTemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
            super(template, context, region, image, 90);
        }

        public String getIdString() {
            return this.getDisplayString();
        }
    }
}

