/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.typehierarchy.ITHModelPresenter;
import org.eclipse.cdt.internal.ui.typehierarchy.Messages;
import org.eclipse.cdt.internal.ui.typehierarchy.THGraph;
import org.eclipse.cdt.internal.ui.typehierarchy.THGraphEdge;
import org.eclipse.cdt.internal.ui.typehierarchy.THGraphNode;
import org.eclipse.cdt.internal.ui.typehierarchy.THNode;
import org.eclipse.cdt.internal.ui.typehierarchy.THSchedulingRule;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilterUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

class THHierarchyModel {
    static final int TYPE_HIERARCHY = 0;
    static final int SUB_TYPE_HIERARCHY = 1;
    static final int SUPER_TYPE_HIERARCHY = 2;
    static final int END_OF_COMPUTATION = 0;
    private static final ISchedulingRule RULE = new THSchedulingRule();
    private static final Object[] NO_CHILDREN = new Object[0];
    private ICElement fInput;
    private int fHierarchyKind;
    private boolean fShowInheritedMembers;
    private THGraph fGraph;
    private THNode[] fRootNodes;
    private THNode fSelectedTypeNode;
    private ICElement fTypeToSelect;
    private ICElement fSelectedMember;
    private String fMemberSignatureToSelect;
    private Job fJob;
    private Display fDisplay;
    private ITHModelPresenter fView;
    private WorkingSetFilterUI fFilter;

    public THHierarchyModel(ITHModelPresenter view, Display display) {
        this.fDisplay = display;
        this.fView = view;
    }

    public ICElement getInput() {
        return this.fInput;
    }

    public int getHierarchyKind() {
        return this.fHierarchyKind;
    }

    public void setHierarchyKind(int hierarchyKind) {
        this.fHierarchyKind = hierarchyKind;
        this.computeNodes();
    }

    public boolean isShowInheritedMembers() {
        return this.fShowInheritedMembers;
    }

    public void setShowInheritedMembers(boolean showInheritedMembers) {
        this.fShowInheritedMembers = showInheritedMembers;
        this.updateSelectedMember();
        this.updateImplementors();
    }

    public Object[] getHierarchyRootElements() {
        if (this.fRootNodes == null) {
            return new Object[]{"..."};
        }
        return this.fRootNodes;
    }

    public void setWorkingSetFilter(WorkingSetFilterUI filterUI) {
        this.fFilter = filterUI;
        this.computeNodes();
    }

    public synchronized void setInput(ICElement input, ICElement member) {
        this.stopGraphComputation();
        this.fInput = input;
        this.fSelectedMember = member;
        this.fMemberSignatureToSelect = TypeHierarchyUI.getLocalElementSignature(this.fSelectedMember);
        this.fRootNodes = null;
        this.fSelectedTypeNode = null;
        this.fTypeToSelect = input;
    }

    public synchronized void computeGraph() {
        if (this.fJob != null) {
            this.fJob.cancel();
        }
        this.fJob = new BackgroundJob();
        this.fJob.setRule(RULE);
        IWorkbenchSiteProgressService ps = this.fView.getProgressService();
        if (ps != null) {
            ps.schedule(this.fJob, 0L, true);
        } else {
            this.fJob.schedule();
        }
    }

    public synchronized void stopGraphComputation() {
        if (this.fJob != null) {
            this.fJob.cancel();
        }
        this.fJob = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus onComputeGraph(Job job, IProgressMonitor monitor) {
        THGraph graph = new THGraph();
        try {
            try {
                IIndex index;
                block13: {
                    block12: {
                        block11: {
                            IStatus iStatus;
                            ICProject[] scope = CoreModel.getDefault().getCModel().getCProjects();
                            index = CCorePlugin.getIndexManager().getIndex(scope);
                            index.acquireReadLock();
                            try {
                                if (!monitor.isCanceled()) break block11;
                                iStatus = Status.CANCEL_STATUS;
                                Object var6_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_13 = null;
                                index.releaseReadLock();
                                throw throwable;
                            }
                            index.releaseReadLock();
                            Object var9_15 = null;
                            this.onJobDone(graph, job);
                            return iStatus;
                        }
                        graph.defineInputNode(index, this.fInput);
                        graph.addSuperClasses(index, monitor);
                        if (!monitor.isCanceled()) break block12;
                        IStatus iStatus = Status.CANCEL_STATUS;
                        Object var6_11 = null;
                        index.releaseReadLock();
                        Object var9_16 = null;
                        this.onJobDone(graph, job);
                        return iStatus;
                    }
                    graph.addSubClasses(index, monitor);
                    if (!monitor.isCanceled()) break block13;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    Object var6_12 = null;
                    index.releaseReadLock();
                    Object var9_17 = null;
                    this.onJobDone(graph, job);
                    return iStatus;
                }
                Object var6_14 = null;
                index.releaseReadLock();
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
            }
            catch (InterruptedException interruptedException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                Object var9_18 = null;
                this.onJobDone(graph, job);
                return iStatus;
            }
            Object var9_20 = null;
            this.onJobDone(graph, job);
            return Status.OK_STATUS;
        }
        catch (Throwable throwable) {
            Object var9_19 = null;
            this.onJobDone(graph, job);
            throw throwable;
        }
    }

    protected void computeNodes() {
        THGraphNode gnode;
        Object node;
        if (this.fGraph == null) {
            return;
        }
        boolean fwd = this.fHierarchyKind == 2;
        ArrayList<THNode> stack = new ArrayList<THNode>();
        ArrayList<THNode> roots = new ArrayList<THNode>();
        ArrayList<Object> leafs = new ArrayList<Object>();
        THGraphNode inputNode = this.fGraph.getInputNode();
        Set<THGraphNode> groots = this.fHierarchyKind == 0 ? this.fGraph.getLeaveNodes() : ((node = this.fGraph.getInputNode()) != null ? Collections.singleton(node) : Collections.EMPTY_SET);
        Iterator iterator = groots.iterator();
        while (iterator.hasNext()) {
            gnode = (THGraphNode)iterator.next();
            THNode node2 = this.createNode(null, gnode, inputNode);
            roots.add(node2);
            stack.add(node2);
        }
        while (!stack.isEmpty()) {
            List edges;
            node = (THNode)stack.remove(stack.size() - 1);
            gnode = this.fGraph.getNode(((THNode)node).getElement());
            List list = edges = fwd ? gnode.getOutgoing() : gnode.getIncoming();
            if (edges.isEmpty()) {
                leafs.add(node);
                continue;
            }
            Iterator iterator2 = edges.iterator();
            while (iterator2.hasNext()) {
                THGraphEdge edge = (THGraphEdge)iterator2.next();
                THGraphNode gchildNode = fwd ? edge.getEndNode() : edge.getStartNode();
                THNode childNode = this.createNode((THNode)node, gchildNode, inputNode);
                ((THNode)node).addChild(childNode);
                stack.add(childNode);
            }
        }
        this.fRootNodes = roots.toArray(new THNode[roots.size()]);
        this.removeFilteredLeafs(this.fRootNodes);
        this.fSelectedTypeNode = this.findSelection(this.fRootNodes);
        if (this.fSelectedTypeNode != null) {
            this.fTypeToSelect = this.fSelectedTypeNode.getElement();
            this.updateSelectedMember();
        }
        this.updateImplementors();
    }

    private void removeFilteredLeafs(THNode[] rootNodes) {
        int i = 0;
        while (i < rootNodes.length) {
            THNode node = rootNodes[i];
            node.removeFilteredLeafs();
            ++i;
        }
    }

    private THNode findSelection(THNode[] searchme) {
        THNode[] result = new THNode[2];
        this.findSelection(searchme, result);
        if (result[0] != null) {
            return result[0];
        }
        return result[1];
    }

    private void findSelection(THNode[] seachme, THNode[] result) {
        int i = 0;
        while (i < seachme.length) {
            this.findSelection(seachme[i], result);
            if (result[0] != null) break;
            ++i;
        }
    }

    private void findSelection(THNode node, THNode[] result) {
        if (node.equals(this.fSelectedTypeNode)) {
            result[0] = node;
            return;
        }
        if (result[1] == null && node.getElement().equals(this.fTypeToSelect)) {
            result[1] = node;
        }
        THNode[] children = node.getChildren();
        this.findSelection(children, result);
    }

    private void updateSelectedMember() {
        ICElement[] members;
        THGraphNode gnode;
        ICElement oldSelection = this.fSelectedMember;
        this.fSelectedMember = null;
        if (this.fSelectedTypeNode != null && this.fMemberSignatureToSelect != null && (gnode = this.fGraph.getNode(this.fSelectedTypeNode.getElement())) != null && (members = gnode.getMembers(this.fShowInheritedMembers)) != null) {
            ICElement member;
            int i = 0;
            while (i < members.length) {
                member = members[i];
                if (member.equals(oldSelection)) {
                    this.fSelectedMember = member;
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < members.length) {
                member = members[i];
                if (this.fMemberSignatureToSelect.equals(TypeHierarchyUI.getLocalElementSignature(member))) {
                    this.fSelectedMember = member;
                    return;
                }
                ++i;
            }
        }
    }

    private THNode createNode(THNode parent, THGraphNode gnode, THGraphNode inputNode) {
        ICElement element = gnode.getElement();
        THNode node = new THNode(parent, element);
        if (gnode != inputNode && this.fFilter != null && !this.fFilter.isPartOfWorkingSet(element)) {
            node.setIsFiltered(true);
        }
        return node;
    }

    private synchronized void onJobDone(final THGraph graph, Job job) {
        if (this.fJob == job) {
            this.fJob = null;
            this.fDisplay.asyncExec(new Runnable(){

                public void run() {
                    THHierarchyModel.this.fGraph = graph;
                    THGraphNode inputNode = THHierarchyModel.this.fGraph.getInputNode();
                    if (!THHierarchyModel.this.fGraph.isFileIndexed()) {
                        THHierarchyModel.this.fView.setMessage(IndexUI.getFleNotIndexedMessage(THHierarchyModel.this.fInput));
                    } else if (inputNode == null) {
                        THHierarchyModel.this.fView.setMessage(Messages.THHierarchyModel_errorComputingHierarchy);
                    } else {
                        if (THHierarchyModel.this.fTypeToSelect == THHierarchyModel.this.fInput) {
                            THHierarchyModel.this.fTypeToSelect = inputNode.getElement();
                        }
                        THHierarchyModel.this.fInput = inputNode.getElement();
                    }
                    THHierarchyModel.this.computeNodes();
                    THHierarchyModel.this.notifyEvent(0);
                }
            });
        }
    }

    private void notifyEvent(int event) {
        this.fView.onEvent(event);
    }

    public synchronized void refresh() {
        this.computeGraph();
    }

    public boolean isComputed() {
        return this.fRootNodes != null;
    }

    public THNode getSelectionInHierarchy() {
        return this.fSelectedTypeNode;
    }

    public void onHierarchySelectionChanged(THNode node) {
        this.fSelectedTypeNode = node;
        if (node != null) {
            this.fTypeToSelect = node.getElement();
        }
        this.updateSelectedMember();
        this.updateImplementors();
    }

    public Object[] getMembers() {
        THGraphNode gnode;
        Object[] result;
        if (this.fSelectedTypeNode != null && (result = (gnode = this.fGraph.getNode(this.fSelectedTypeNode.getElement())).getMembers(this.fShowInheritedMembers)) != null) {
            return result;
        }
        return NO_CHILDREN;
    }

    public void onMemberSelectionChanged(ICElement elem) {
        this.fSelectedMember = elem;
        if (this.fSelectedMember != null) {
            this.fMemberSignatureToSelect = TypeHierarchyUI.getLocalElementSignature(this.fSelectedMember);
        }
        this.updateImplementors();
    }

    private void updateImplementors() {
        if (this.fRootNodes != null) {
            int i = 0;
            while (i < this.fRootNodes.length) {
                THNode node = this.fRootNodes[i];
                this.updateImplementors(node);
                ++i;
            }
        }
    }

    private void updateImplementors(THNode node) {
        node.setIsImplementor(this.isImplementor(node.getElement()));
        THNode[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            THNode child = children[i];
            this.updateImplementors(child);
            ++i;
        }
    }

    private boolean isImplementor(ICElement element) {
        ICElement[] members;
        if (element == null || this.fSelectedMember == null || this.fMemberSignatureToSelect == null) {
            return false;
        }
        THGraphNode gnode = this.fGraph.getNode(element);
        if (gnode != null && (members = gnode.getMembers(false)) != null) {
            int i = 0;
            while (i < members.length) {
                ICElement member = members[i];
                if (member == this.fSelectedMember) {
                    return true;
                }
                if (this.fMemberSignatureToSelect.equals(TypeHierarchyUI.getLocalElementSignature(member))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public ICElement getSelectedMember() {
        return this.fSelectedMember;
    }

    public boolean hasTrivialHierarchy() {
        if (this.fRootNodes == null || this.fRootNodes.length == 0) {
            return true;
        }
        return this.fRootNodes.length == 1 && !this.fRootNodes[0].hasChildren();
    }

    public class BackgroundJob
    extends Job {
        public BackgroundJob() {
            super(Messages.THHierarchyModel_Job_title);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return THHierarchyModel.this.onComputeGraph(this, monitor);
        }
    }
}

