/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.core.runtime.IAdaptable;

public class THNode
implements IAdaptable {
    private THNode fParent;
    private ICElement fElement;
    private List fChildren = Collections.EMPTY_LIST;
    private int fHashCode;
    private boolean fIsFiltered;
    private boolean fIsImplementor;
    static /* synthetic */ Class class$0;

    public THNode(THNode parent, ICElement decl) {
        this.fParent = parent;
        this.fElement = decl;
        this.fHashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        int hashCode = 0;
        if (this.fParent != null) {
            hashCode = this.fParent.hashCode() * 31;
        }
        if (this.fElement != null) {
            hashCode += this.fElement.hashCode();
        }
        return hashCode;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof THNode)) {
            return false;
        }
        THNode rhs = (THNode)o;
        if (this.fHashCode != rhs.fHashCode) {
            return false;
        }
        return CoreUtility.safeEquals(this.fElement, rhs.fElement);
    }

    public THNode getParent() {
        return this.fParent;
    }

    public ICElement getElement() {
        return this.fElement;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.isAssignableFrom(clazz)) {
            return this.getElement();
        }
        return null;
    }

    public boolean isFiltered() {
        return this.fIsFiltered;
    }

    public void setIsFiltered(boolean val) {
        this.fIsFiltered = val;
    }

    public void addChild(THNode childNode) {
        if (this.fChildren.isEmpty()) {
            this.fChildren = new ArrayList();
        }
        this.fChildren.add(childNode);
    }

    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public THNode[] getChildren() {
        return this.fChildren.toArray(new THNode[this.fChildren.size()]);
    }

    public void setIsImplementor(boolean val) {
        this.fIsImplementor = val;
    }

    public boolean isImplementor() {
        return this.fIsImplementor;
    }

    public void removeFilteredLeafs() {
        Iterator iterator = this.fChildren.iterator();
        while (iterator.hasNext()) {
            THNode child = (THNode)iterator.next();
            child.removeFilteredLeafs();
            if (!child.isFiltered() || child.hasChildren()) continue;
            iterator.remove();
        }
    }
}

