/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;

public class FindNameForSelectionVisitor
extends ASTVisitor {
    private String fFilePath;
    private int fOffset;
    private int fEndOffset;
    private IASTName fSelectedName;

    public FindNameForSelectionVisitor(String filePath, int selectionStart, int selectionLength) {
        this.fFilePath = filePath;
        this.fOffset = selectionStart;
        this.fEndOffset = selectionStart + selectionLength;
        this.shouldVisitDeclarations = true;
        this.shouldVisitNames = true;
    }

    public IASTName getSelectedName() {
        return this.fSelectedName;
    }

    public int visit(IASTDeclaration declaration) {
        IASTFileLocation loc = declaration.getFileLocation();
        if (loc == null || !loc.getFileName().equals(this.fFilePath)) {
            return 1;
        }
        int offset = loc.getNodeOffset();
        int endoffset = offset + loc.getNodeLength();
        if (endoffset < this.fOffset || this.fEndOffset < offset) {
            return 1;
        }
        return 3;
    }

    public int visit(IASTName name) {
        IASTFileLocation loc = name.getFileLocation();
        if (loc == null) {
            return 3;
        }
        if (!loc.getFileName().equals(this.fFilePath)) {
            return 1;
        }
        int offset = loc.getNodeOffset();
        int endoffset = offset + loc.getNodeLength();
        if (this.fOffset <= offset && endoffset <= this.fEndOffset) {
            this.fSelectedName = name;
            return 2;
        }
        if (offset <= this.fOffset && this.fEndOffset <= endoffset) {
            this.fSelectedName = name;
            return 3;
        }
        return 3;
    }
}

