/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTListComparator;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractLangsListTab
extends AbstractCPropertyTab {
    protected Table table;
    protected TableViewer tv;
    protected Tree langTree;
    protected TreeColumn langCol;
    protected Button showBIButton;
    protected boolean toAllCfgs = false;
    protected boolean toAllLang = false;
    protected ICLanguageSetting lang;
    protected LinkedList incs;
    protected ArrayList exported;
    protected SashForm sashForm;
    protected static final String[] BUTTONS;
    protected static final String[] BUTTSYM;
    private static final Image IMG_FS;
    private static final Image IMG_WS;
    private static final Image IMG_MK;
    private static final int[] DEFAULT_SASH_WEIGHTS;

    static {
        String[] stringArray = new String[7];
        stringArray[0] = ADD_STR;
        stringArray[1] = EDIT_STR;
        stringArray[2] = DEL_STR;
        stringArray[3] = UIMessages.getString("AbstractLangsListTab.2");
        stringArray[5] = MOVEUP_STR;
        stringArray[6] = MOVEDOWN_STR;
        BUTTONS = stringArray;
        BUTTSYM = new String[]{ADD_STR, EDIT_STR, DEL_STR, UIMessages.getString("AbstractLangsListTab.2")};
        IMG_FS = CPluginImages.get("org.eclipse.cdt.ui.filesyst.gif");
        IMG_WS = CPluginImages.get("org.eclipse.cdt.ui.workspace.gif");
        IMG_MK = CPluginImages.get("org.eclipse.cdt.ui.define_obj.gif");
        DEFAULT_SASH_WEIGHTS = new int[]{10, 30};
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        this.sashForm.setLayout((Layout)layout);
        this.addTree((Composite)this.sashForm).setLayoutData((Object)new GridData(1040));
        this.table = new Table((Composite)this.sashForm, 68098);
        GridData gd = new GridData(1808);
        gd.widthHint = 255;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        this.sashForm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Point currentSize;
                if (event.detail == 1) {
                    return;
                }
                int shift = event.x - AbstractLangsListTab.this.sashForm.getBounds().x;
                GridData data = (GridData)AbstractLangsListTab.this.langTree.getLayoutData();
                if (data.widthHint + shift < 20) {
                    return;
                }
                Point computedSize = AbstractLangsListTab.this.usercomp.getShell().computeSize(-1, -1);
                boolean customSize = !computedSize.equals((Object)(currentSize = AbstractLangsListTab.this.usercomp.getShell().getSize()));
                data.widthHint = data.widthHint;
                AbstractLangsListTab.this.sashForm.layout(true);
                computedSize = AbstractLangsListTab.this.usercomp.getShell().computeSize(-1, -1);
                if (customSize) {
                    computedSize.x = Math.max(computedSize.x, currentSize.x);
                }
                computedSize.y = Math.max(computedSize.y, currentSize.y);
                if (computedSize.equals((Object)currentSize)) {
                    return;
                }
            }
        });
        this.tv = new TableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new RichLabelProvider());
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLangsListTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AbstractLangsListTab.this.buttonIsEnabled(1) && AbstractLangsListTab.this.table.getSelectionIndex() != -1) {
                    AbstractLangsListTab.this.buttonPressed(1);
                }
            }
        });
        this.setupLabel(this.usercomp, "", 1, 0);
        this.showBIButton = this.setupCheck(this.usercomp, UIMessages.getString("AbstractLangsListTab.0"), 1, 768);
        this.showBIButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractLangsListTab.this.update();
            }
        });
        this.additionalTableSet();
        this.initButtons(this.getKind() == 4 ? BUTTSYM : BUTTONS);
        this.updateData(this.getResDesc());
    }

    protected void updateButtons() {
        ICLanguageSettingEntry ent;
        boolean canMoveDown;
        int index = this.table.getSelectionIndex();
        int[] ids = this.table.getSelectionIndices();
        boolean canAdd = this.langTree.getItemCount() > 0;
        boolean canExport = index != -1;
        boolean canEdit = canExport && ids.length == 1;
        boolean canDelete = canExport;
        if (canExport) {
            ICLanguageSettingEntry ent2 = (ICLanguageSettingEntry)this.table.getItem(index).getData();
            if (ent2.isBuiltIn() || ent2.isReadOnly()) {
                canEdit = false;
            }
            if (ent2.isReadOnly()) {
                canDelete = false;
            }
            if (this.exported.contains(ent2)) {
                this.buttonSetText(3, UIMessages.getString("AbstractLangsListTab.4"));
            } else {
                this.buttonSetText(3, UIMessages.getString("AbstractLangsListTab.2"));
            }
        } else {
            this.buttonSetText(3, UIMessages.getString("AbstractLangsListTab.2"));
        }
        boolean canMoveUp = canEdit && index > 0;
        boolean bl = canMoveDown = canEdit && index < this.table.getItemCount() - 1;
        if (canMoveDown && this.showBIButton.getSelection() && (ent = (ICLanguageSettingEntry)this.table.getItem(index + 1).getData()).isBuiltIn()) {
            canMoveDown = false;
        }
        this.buttonSetEnabled(0, canAdd);
        this.buttonSetEnabled(1, canEdit);
        this.buttonSetEnabled(2, canDelete);
        this.buttonSetEnabled(3, canExport);
        this.buttonSetEnabled(5, canMoveUp);
        this.buttonSetEnabled(6, canMoveDown);
    }

    private Tree addTree(Composite comp) {
        this.langTree = new Tree(comp, 2308);
        this.langTree.setLayoutData((Object)new GridData(1040));
        this.langTree.setHeaderVisible(true);
        this.langTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICLanguageSetting ls;
                TreeItem[] items = AbstractLangsListTab.this.langTree.getSelection();
                if (items.length > 0 && (ls = (ICLanguageSetting)items[0].getData()) != null) {
                    AbstractLangsListTab.this.lang = ls;
                    AbstractLangsListTab.this.update();
                }
            }
        });
        this.langTree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int x = AbstractLangsListTab.this.langTree.getBounds().width - 5;
                if (AbstractLangsListTab.this.langCol.getWidth() != x) {
                    AbstractLangsListTab.this.langCol.setWidth(x);
                }
            }
        });
        this.langCol = new TreeColumn(this.langTree, 0);
        this.langCol.setText(UIMessages.getString("AbstractLangsListTab.1"));
        this.langCol.setWidth(200);
        this.langCol.setResizable(false);
        this.langTree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UIMessages.getString("AbstractLangsListTab.1");
            }
        });
        return this.langTree;
    }

    public abstract int getKind();

    public abstract ICLanguageSettingEntry doAdd();

    public abstract ICLanguageSettingEntry doEdit(ICLanguageSettingEntry var1);

    public void additionalTableSet() {
    }

    public void update() {
        this.update(0);
    }

    public void update(int shift) {
        if (this.lang != null) {
            int x = this.table.getSelectionIndex();
            x = x == -1 ? 0 : (x += shift);
            this.incs = new LinkedList();
            List lst = this.lang.getSettingEntriesList(this.getKind());
            if (lst != null) {
                Iterator it = lst.iterator();
                while (it.hasNext()) {
                    ICLanguageSettingEntry ent = (ICLanguageSettingEntry)it.next();
                    if (ent.isBuiltIn()) continue;
                    this.incs.add(ent);
                }
                if (this.showBIButton.getSelection()) {
                    ArrayList<ICLanguageSettingEntry> lstS = new ArrayList<ICLanguageSettingEntry>();
                    it = lst.iterator();
                    while (it.hasNext()) {
                        ICLanguageSettingEntry ent = (ICLanguageSettingEntry)it.next();
                        if (!ent.isBuiltIn()) continue;
                        lstS.add(ent);
                    }
                    this.incs.addAll(lstS);
                }
            }
            this.tv.setInput((Object)this.incs.toArray(new Object[this.incs.size()]));
            if (this.table.getItemCount() > x) {
                this.table.select(x);
            } else if (this.table.getItemCount() > 0) {
                this.table.select(0);
            }
        }
        this.updateButtons();
    }

    public void updateData(ICResourceDescription cfg) {
        if (cfg == null || !this.canBeVisible()) {
            return;
        }
        this.updateExport();
        this.langTree.removeAll();
        TreeItem firstItem = null;
        ICLanguageSetting[] ls = this.getLangSetting(cfg);
        if (ls != null) {
            Arrays.sort(ls, CDTListComparator.getInstance());
            int i = 0;
            while (i < ls.length) {
                if ((ls[i].getSupportedEntryKinds() & this.getKind()) != 0) {
                    TreeItem t = new TreeItem(this.langTree, 0);
                    String s = ls[i].getLanguageId();
                    if (s != null && !s.equals("")) {
                        ILanguageDescriptor ld = LanguageManager.getInstance().getLanguageDescriptor(s);
                        s = ld == null ? null : ld.getName();
                    }
                    if (s == null || s.equals("")) {
                        s = ls[i].getName();
                    }
                    t.setText(0, s);
                    t.setData((Object)ls[i]);
                    if (firstItem == null) {
                        firstItem = t;
                        this.lang = ls[i];
                    }
                }
                ++i;
            }
            if (firstItem != null && this.table != null) {
                this.langTree.setSelection(firstItem);
            }
        }
        this.update();
    }

    private void updateExport() {
        this.exported = new ArrayList();
        ICExternalSetting[] vals = this.getResDesc().getConfiguration().getExternalSettings();
        if (vals != null && vals.length != 0) {
            int i = 0;
            while (i < vals.length) {
                ICSettingEntry[] ents = vals[i].getEntries(this.getKind());
                if (ents != null && ents.length != 0) {
                    int j = 0;
                    while (j < ents.length) {
                        this.exported.add(ents[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void buttonPressed(int i) {
        int n = this.table.getSelectionIndex();
        int[] ids = this.table.getSelectionIndices();
        switch (i) {
            case 0: {
                this.toAllCfgs = false;
                this.toAllLang = false;
                ICLanguageSettingEntry ent = this.doAdd();
                if (ent == null) break;
                if (this.toAllCfgs || this.toAllLang) {
                    this.addToAll(ent);
                } else {
                    this.incs.add(ent);
                    this.lang.setSettingEntries(this.getKind(), (List)this.incs);
                }
                this.update();
                break;
            }
            case 1: {
                if (n == -1) {
                    return;
                }
                ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
                if (old.isReadOnly()) {
                    return;
                }
                ICLanguageSettingEntry ent = this.doEdit(old);
                if (ent == null) break;
                int toModify = this.incs.indexOf(old);
                this.incs.remove(toModify);
                this.incs.add(toModify, ent);
                this.lang.setSettingEntries(this.getKind(), (List)this.incs);
                this.update();
                break;
            }
            case 2: {
                ICLanguageSettingEntry old;
                if (n == -1) {
                    return;
                }
                int x = ids.length - 1;
                while (x >= 0) {
                    old = (ICLanguageSettingEntry)this.table.getItem(ids[x]).getData();
                    if (!old.isReadOnly()) {
                        this.incs.remove(old);
                    }
                    --x;
                }
                old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
                if (old.isReadOnly()) {
                    return;
                }
                this.incs.remove(old);
                this.lang.setSettingEntries(this.getKind(), (List)this.incs);
                this.update();
                break;
            }
            case 3: {
                if (n == -1) {
                    return;
                }
                ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
                int x = ids.length - 1;
                while (x >= 0) {
                    old = (ICLanguageSettingEntry)this.table.getItem(ids[x]).getData();
                    if (this.exported.contains(old)) {
                        this.deleteExportSetting((ICSettingEntry)old);
                    } else {
                        this.page.getResDesc().getConfiguration().createExternalSetting(new String[]{this.lang.getId()}, null, null, (ICSettingEntry[])new ICLanguageSettingEntry[]{old});
                    }
                    --x;
                }
                this.updateExport();
                this.update();
                break;
            }
            case 5: 
            case 6: {
                ICLanguageSettingEntry old = (ICLanguageSettingEntry)this.table.getItem(n).getData();
                int x = this.incs.indexOf(old);
                if (x < 0) break;
                if (i == 6) {
                    ++x;
                }
                old = (ICLanguageSettingEntry)this.incs.get(x);
                ICLanguageSettingEntry old2 = (ICLanguageSettingEntry)this.incs.get(x - 1);
                this.incs.remove(x);
                this.incs.remove(x - 1);
                this.incs.add(x - 1, old);
                this.incs.add(x, old2);
                this.lang.setSettingEntries(this.getKind(), (List)this.incs);
                this.update(i == 5 ? -1 : 1);
                break;
            }
        }
    }

    private void deleteExportSetting(ICSettingEntry ent) {
        ICConfigurationDescription cfg = this.getResDesc().getConfiguration();
        ICExternalSetting[] vals = cfg.getExternalSettings();
        if (vals != null && vals.length != 0) {
            int i = 0;
            while (i < vals.length) {
                ICSettingEntry[] ents = vals[i].getEntries(this.getKind());
                if (ents != null && ents.length != 0) {
                    int j = 0;
                    while (j < ents.length) {
                        if (ents[j].equalsByName(ent)) {
                            ICSettingEntry[] arr = new ICSettingEntry[ents.length - 1];
                            int index = 0;
                            int k = 0;
                            while (k < ents.length) {
                                if (k != j) {
                                    arr[index++] = ents[k];
                                }
                                ++k;
                            }
                            cfg.removeExternalSetting(vals[i]);
                            cfg.createExternalSetting(vals[i].getCompatibleLanguageIds(), vals[i].getCompatibleContentTypeIds(), vals[i].getCompatibleExtensions(), arr);
                            return;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void addToAll(ICLanguageSettingEntry ent) {
        ICConfigurationDescription[] cfgs = this.page.getCfgsEditable();
        ICResourceDescription cur_cfg = this.page.getResDesc();
        String id = this.lang.getName();
        int i = 0;
        while (i < cfgs.length) {
            ICResourceDescription rcfg = this.page.getResDesc(cfgs[i]);
            if (rcfg != null && (this.toAllCfgs || cur_cfg.equals(rcfg))) {
                ICLanguageSetting[] ls = this.getLangSetting(rcfg);
                int j = 0;
                while (j < ls.length) {
                    if (id == ls[j].getName() || this.toAllLang) {
                        List lst = ls[j].getSettingEntriesList(this.getKind());
                        lst.add(ent);
                        ls[j].setSettingEntries(this.getKind(), lst);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        ICLanguageSetting[] sr = this.getLangSetting(src);
        ICLanguageSetting[] ds = this.getLangSetting(dst);
        if (sr == null || ds == null || sr.length != ds.length) {
            return;
        }
        int i = 0;
        while (i < sr.length) {
            ds[i].setSettingEntries(this.getKind(), sr[i].getSettingEntries(this.getKind()));
            ++i;
        }
    }

    protected void performDefaults() {
        TreeItem[] tis = this.langTree.getItems();
        int i = 0;
        while (i < tis.length) {
            Object ob = tis[i].getData();
            if (ob != null && ob instanceof ICLanguageSetting) {
                ((ICLanguageSetting)ob).setSettingEntries(this.getKind(), null);
            }
            ++i;
        }
        this.updateData(this.getResDesc());
    }

    public ICLanguageSetting[] getLangSetting(ICResourceDescription rcDes) {
        switch (rcDes.getType()) {
            case 1: 
            case 2: 
            case 4: {
                ICFolderDescription foDes = (ICFolderDescription)rcDes;
                return foDes.getLanguageSettings();
            }
            case 8: {
                ICLanguageSetting[] iCLanguageSettingArray;
                ICFileDescription fiDes = (ICFileDescription)rcDes;
                ICLanguageSetting ls = fiDes.getLanguageSetting();
                if (ls != null) {
                    ICLanguageSetting[] iCLanguageSettingArray2 = new ICLanguageSetting[1];
                    iCLanguageSettingArray = iCLanguageSettingArray2;
                    iCLanguageSettingArray2[0] = ls;
                } else {
                    iCLanguageSettingArray = null;
                }
                return iCLanguageSettingArray;
            }
        }
        return null;
    }

    public boolean canBeVisible() {
        if (this.getResDesc() == null) {
            return true;
        }
        ICLanguageSetting[] ls = this.getLangSetting(this.getResDesc());
        if (ls == null) {
            return false;
        }
        int i = 0;
        while (i < ls.length) {
            if ((ls[i].getSupportedEntryKinds() & this.getKind()) != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class RichLabelProvider
    extends LabelProvider
    implements IFontProvider,
    ITableLabelProvider {
        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex > 0) {
                return null;
            }
            if (!(element instanceof ICLanguageSettingEntry)) {
                return null;
            }
            ICLanguageSettingEntry le = (ICLanguageSettingEntry)element;
            if (le.getKind() == 4) {
                return IMG_MK;
            }
            if ((le.getFlags() & 8) != 0) {
                return IMG_WS;
            }
            return IMG_FS;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof ICLanguageSettingEntry)) {
                return columnIndex == 0 ? element.toString() : "";
            }
            ICLanguageSettingEntry le = (ICLanguageSettingEntry)element;
            if (columnIndex == 0) {
                String s = le.getName();
                if (AbstractLangsListTab.this.exported.contains(le)) {
                    s = String.valueOf(s) + UIMessages.getString("AbstractLangsListTab.3");
                }
                return s;
            }
            if (le.getKind() == 4) {
                switch (columnIndex) {
                    case 1: {
                        return le.getValue();
                    }
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            if (!(element instanceof ICLanguageSettingEntry)) {
                return null;
            }
            ICLanguageSettingEntry le = (ICLanguageSettingEntry)element;
            if (le.isBuiltIn()) {
                return null;
            }
            if (le.isReadOnly()) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
            }
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        }
    }
}

