/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IContributedEnvironment;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTListComparator;
import org.eclipse.cdt.ui.newui.EnvDialog;
import org.eclipse.cdt.ui.newui.PrefPage_Abstract;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class EnvironmentTab
extends AbstractCPropertyTab {
    private static final String PREFIX = "EnvironmentBlock";
    private static final String LABEL = "EnvironmentBlock.label";
    private static final String VALUE_UNDEF = "EnvironmentBlock.label.value.undef";
    private static final String SEMI = ";";
    private static final String LBR = " [";
    private static final String RBR = "]";
    private static final UserDefinedEnvironmentSupplier fUserSupplier = EnvironmentVariableManager.fUserSupplier;
    private Table table;
    private TableViewer tv;
    private ArrayList data = new ArrayList();
    private Button b1;
    private Button b2;
    private static final IContributedEnvironment ce = CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment();
    private ICConfigurationDescription cfgd = null;
    private StorableEnvironment vars = null;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        Label l1 = new Label(this.usercomp, 16384);
        l1.setText(UIMessages.getString("EnvironmentTab.0"));
        l1.setLayoutData((Object)new GridData(768));
        this.table = new Table(this.usercomp, 67906);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EnvironmentTab.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (EnvironmentTab.this.buttonIsEnabled(2) && EnvironmentTab.this.table.getSelectionIndex() != -1) {
                    EnvironmentTab.this.buttonPressed(2);
                }
            }
        });
        this.tv = new TableViewer(this.table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement != null && inputElement instanceof ArrayList) {
                    ArrayList ar = (ArrayList)inputElement;
                    return ar.toArray(new TabData[0]);
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new EnvironmentLabelProvider(true));
        TableColumn tc = new TableColumn(this.table, 16384);
        tc.setText(UIMessages.getString("EnvironmentTab.1"));
        tc.setWidth(200);
        tc = new TableColumn(this.table, 16384);
        tc.setText(UIMessages.getString("EnvironmentTab.2"));
        tc.setWidth(200);
        this.table.setLayoutData((Object)new GridData(1808));
        this.b1 = new Button(this.usercomp, 16);
        this.b1.setText(UIMessages.getString("EnvironmentTab.3"));
        this.b1.setLayoutData((Object)new GridData(768));
        this.b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnvironmentTab.this.cfgd != null) {
                    ce.setAppendEnvironment(true, EnvironmentTab.this.cfgd);
                } else {
                    EnvironmentTab.this.vars.setAppendContributedEnvironment(true);
                }
                EnvironmentTab.this.updateData();
            }
        });
        this.b2 = new Button(this.usercomp, 16);
        this.b2.setText(UIMessages.getString("EnvironmentTab.4"));
        this.b2.setLayoutData((Object)new GridData(768));
        this.b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnvironmentTab.this.cfgd != null) {
                    ce.setAppendEnvironment(false, EnvironmentTab.this.cfgd);
                } else {
                    EnvironmentTab.this.vars.setAppendContributedEnvironment(false);
                }
                EnvironmentTab.this.updateData();
            }
        });
        this.initButtons(new String[]{UIMessages.getString("EnvironmentTab.5"), UIMessages.getString("EnvironmentTab.6"), UIMessages.getString("EnvironmentTab.7"), UIMessages.getString("EnvironmentTab.8"), UIMessages.getString("EnvironmentTab.9")});
    }

    public void buttonPressed(int i) {
        IEnvironmentVariable var = null;
        int n = this.table.getSelectionIndex();
        switch (i) {
            case 0: {
                EnvDialog dlg = new EnvDialog(this.usercomp.getShell(), var, UIMessages.getString("EnvironmentTab.10"), true, this.cfgd);
                if (dlg.open() != 0 || dlg.t1.trim().length() <= 0) break;
                ICConfigurationDescription[] cfgs = dlg.toAll ? this.page.getCfgsEditable() : new ICConfigurationDescription[]{this.cfgd};
                if (this.cfgd == null) {
                    this.vars.createVariable(dlg.t1.trim(), dlg.t2.trim(), 4, SEMI);
                } else {
                    int x = 0;
                    while (x < cfgs.length) {
                        ce.addVariable(dlg.t1.trim(), dlg.t2.trim(), 4, SEMI, cfgs[x]);
                        ++x;
                    }
                }
                this.updateData();
                break;
            }
            case 1: {
                this.handleEnvSelectButtonSelected();
                this.updateData();
                break;
            }
            case 2: {
                if (n == -1) {
                    return;
                }
                var = ((TabData)this.tv.getElementAt((int)n)).var;
                EnvDialog dlg = new EnvDialog(this.usercomp.getShell(), var, UIMessages.getString("EnvironmentTab.11"), false, this.cfgd);
                if (dlg.open() != 0) break;
                if (this.cfgd != null) {
                    ce.addVariable(dlg.t1.trim(), dlg.t2.trim(), 1, var.getDelimiter(), this.cfgd);
                } else {
                    this.vars.createVariable(dlg.t1.trim(), dlg.t2.trim(), 1, var.getDelimiter());
                }
                this.updateData();
                this.table.setSelection(n);
                break;
            }
            case 3: {
                if (n == -1) {
                    return;
                }
                int[] idx = this.table.getSelectionIndices();
                int j = 0;
                while (j < idx.length) {
                    var = ((TabData)this.tv.getElementAt((int)idx[j])).var;
                    if (this.cfgd == null) {
                        this.vars.deleteVariable(var.getName());
                    } else {
                        ce.removeVariable(var.getName(), this.cfgd);
                    }
                    ++j;
                }
                this.updateData();
                break;
            }
            case 4: {
                if (n == -1) {
                    return;
                }
                int[] idx = this.table.getSelectionIndices();
                int j = 0;
                while (j < idx.length) {
                    var = ((TabData)this.tv.getElementAt((int)idx[j])).var;
                    if (this.cfgd == null) {
                        this.vars.createVariable(var.getName(), null, 2, var.getDelimiter());
                    } else {
                        ce.addVariable(var.getName(), null, 2, var.getDelimiter(), this.cfgd);
                    }
                    ++j;
                }
                this.updateData();
                this.table.setSelection(n);
            }
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        int pos = this.table.getSelectionIndex();
        this.buttonSetEnabled(2, pos != -1);
        this.buttonSetEnabled(3, pos != -1);
        this.buttonSetEnabled(4, pos != -1);
    }

    public void updateData(ICResourceDescription _cfgd) {
        ICConfigurationDescription iCConfigurationDescription = this.cfgd = _cfgd != null ? _cfgd.getConfiguration() : null;
        if (this.cfgd == null && this.vars == null) {
            this.vars = fUserSupplier.getWorkspaceEnvironmentCopy();
        }
        this.updateData();
    }

    private void updateData() {
        IEnvironmentVariable[] _vars = null;
        if (this.cfgd != null) {
            this.b1.setSelection(ce.appendEnvironment(this.cfgd));
            this.b2.setSelection(!ce.appendEnvironment(this.cfgd));
            _vars = ce.getVariables(this.cfgd);
        } else {
            this.b1.setSelection(this.vars.appendContributedEnvironment());
            this.b2.setSelection(!this.vars.appendContributedEnvironment());
            _vars = this.vars.getVariables();
        }
        this.data.clear();
        if (_vars != null) {
            int i = 0;
            while (i < _vars.length) {
                this.data.add(new TabData(_vars[i], false));
                ++i;
            }
        }
        this.tv.setInput((Object)this.data);
        this.updateButtons();
    }

    public void performApply(ICResourceDescription _src, ICResourceDescription _dst) {
        ICConfigurationDescription src = _src.getConfiguration();
        ICConfigurationDescription dst = _dst.getConfiguration();
        ce.setAppendEnvironment(ce.appendEnvironment(src), dst);
        IEnvironmentVariable[] v = ce.getVariables(dst);
        int i = 0;
        while (i < v.length) {
            ce.removeVariable(v[i].getName(), dst);
            ++i;
        }
        v = ce.getVariables(src);
        i = 0;
        while (i < v.length) {
            if (ce.isUserVariable(src, v[i])) {
                ce.addVariable(v[i].getName(), v[i].getValue(), v[i].getOperation(), v[i].getDelimiter(), dst);
            }
            ++i;
        }
    }

    private void handleEnvSelectButtonSelected() {
        Properties v = EnvironmentReader.getEnvVars();
        MyListSelectionDialog dialog = new MyListSelectionDialog(this.usercomp.getShell(), v, this.createSelectionDialogContentProvider());
        dialog.setTitle(UIMessages.getString("EnvironmentTab.14"));
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            ICConfigurationDescription[] cfgs = dialog.toAll ? this.page.getCfgsEditable() : new ICConfigurationDescription[]{this.cfgd};
            int i = 0;
            while (i < selected.length) {
                String name = (String)selected[i];
                String value = "";
                int x = name.indexOf(LBR);
                if (x >= 0) {
                    value = name.substring(x + 2, name.length() - 1);
                    name = name.substring(0, x);
                }
                if (this.cfgd == null) {
                    this.vars.createVariable(name, value);
                } else {
                    int y = 0;
                    while (y < cfgs.length) {
                        ce.addVariable(name, value, 4, SEMI, cfgs[y]);
                        ++y;
                    }
                }
                ++i;
            }
        }
    }

    private IStructuredContentProvider createSelectionDialogContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] els = null;
                if (inputElement instanceof Map) {
                    Map m = (Map)inputElement;
                    els = new String[m.size()];
                    int index = 0;
                    Iterator iterator = m.keySet().iterator();
                    while (iterator.hasNext()) {
                        String k = (String)iterator.next();
                        els[index] = TextProcessor.process((String)(String.valueOf(k) + EnvironmentTab.LBR + (String)m.get(k) + EnvironmentTab.RBR));
                        ++index;
                    }
                }
                Arrays.sort(els, CDTListComparator.getInstance());
                return els;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    protected void performOK() {
        if (this.vars != null && fUserSupplier.setWorkspaceEnvironment(this.vars) && this.page instanceof PrefPage_Abstract) {
            PrefPage_Abstract.isChanged = true;
        }
        this.vars = null;
        super.performOK();
    }

    protected void performCancel() {
        this.vars = null;
        super.performCancel();
    }

    protected void performDefaults() {
        ce.restoreDefaults(this.cfgd);
        this.vars = null;
        this.updateData();
    }

    private class EnvironmentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    ITableFontProvider,
    IColorProvider {
        public EnvironmentLabelProvider(boolean user) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TabData td = (TabData)element;
            switch (columnIndex) {
                case 0: {
                    return td.var.getName();
                }
                case 1: {
                    if (td.var.getOperation() == 2) {
                        return UIMessages.getString(EnvironmentTab.VALUE_UNDEF);
                    }
                    return td.var.getValue();
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            return this.getFont(element, 0);
        }

        public Font getFont(Object element, int columnIndex) {
            TabData td = (TabData)element;
            Font f = null;
            if (EnvironmentTab.this.cfgd == null || ce.isUserVariable(EnvironmentTab.this.cfgd, td.var)) {
                f = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    if (td.var.getOperation() != 2) break;
                    f = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
                }
            }
            return f;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class MyListSelectionDialog
    extends ListSelectionDialog {
        public boolean toAll;

        public MyListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider) {
            super(parentShell, input, contentProvider, (ILabelProvider)new LabelProvider(){}, UIMessages.getString("EnvironmentTab.12"));
            this.toAll = false;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Button b = new Button(composite, 32);
            b.setText(UIMessages.getString("EnvironmentTab.13"));
            b.setLayoutData((Object)new GridData(768));
            if (EnvironmentTab.this.cfgd == null) {
                b.setVisible(false);
            } else {
                b.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ MyListSelectionDialog this$1;
                    {
                        this.this$1 = myListSelectionDialog;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$1.toAll = ((Button)e.widget).getSelection();
                    }
                });
            }
            return composite;
        }
    }

    private class TabData {
        IEnvironmentVariable var;
        boolean changed;

        TabData(IEnvironmentVariable _var, boolean _changed) {
            this.var = _var;
            this.changed = _changed;
        }
    }
}

