/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.pages;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.IWizardDataPage;
import org.eclipse.cdt.ui.templateengine.event.PatternEvent;
import org.eclipse.cdt.ui.templateengine.event.PatternEventListener;
import org.eclipse.cdt.ui.templateengine.pages.UIPage;
import org.eclipse.cdt.ui.templateengine.uitree.UIElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UIWizardPage
extends UIPage
implements IWizardDataPage,
PatternEventListener {
    HashMap validInvalid;
    private String name;
    private IWizard wizard = null;
    private boolean isPageComplete;
    private IWizardPage previousPage = null;
    private IWizardPage nextPage = null;

    public UIWizardPage(String title, String pageName, UIElement uiElement, Map valueStore) {
        super(title, uiElement, valueStore);
        this.name = pageName;
        this.validInvalid = new HashMap();
        this.isPageComplete = uiElement.isValid();
    }

    public boolean canFlipToNextPage() {
        boolean retVal = false;
        if (this.isPageComplete() && this.getNextPage() != null) {
            retVal = true;
        }
        return retVal;
    }

    protected IWizardContainer getContainer() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getContainer();
    }

    protected IDialogSettings getDialogSettings() {
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getDialogSettings();
    }

    public Image getImage() {
        Image result = super.getImage();
        if (result == null && this.wizard != null) {
            return this.wizard.getDefaultPageImage();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public IWizardPage getNextPage() {
        if (this.nextPage != null) {
            return this.nextPage;
        }
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getNextPage((IWizardPage)this);
    }

    public void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    public IWizardPage getPreviousPage() {
        if (this.previousPage != null) {
            return this.previousPage;
        }
        if (this.wizard == null) {
            return null;
        }
        return this.wizard.getPreviousPage((IWizardPage)this);
    }

    public Shell getShell() {
        IWizardContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        return container.getShell();
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    protected boolean isCurrentPage() {
        boolean retVal = false;
        if (this.getContainer() != null && this == this.getContainer().getCurrentPage()) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    public void setPageComplete(boolean complete) {
        this.isPageComplete = complete;
        if (this.isCurrentPage()) {
            this.getContainer().updateButtons();
        }
    }

    public void setPreviousPage(IWizardPage page) {
        this.previousPage = page;
    }

    public void setWizard(IWizard newWizard) {
        this.wizard = newWizard;
    }

    public String toString() {
        return this.name;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        super.getComposite().addPatternListener(this);
        this.setPageComplete(super.getComposite().isValid());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(super.getControl(), this.pageId);
    }

    public void patternPerformed(PatternEvent patternEvent) {
        if (!patternEvent.getValid()) {
            this.validInvalid.put(patternEvent.getSource(), patternEvent.toString());
            this.setErrorMessage(this.getErrorString());
            this.setPageComplete(this.validInvalid.isEmpty() && super.getComposite().isValid());
        } else {
            this.validInvalid.remove(patternEvent.getSource());
            this.setPageComplete(this.validInvalid.isEmpty() && super.getComposite().isValid());
            if (this.validInvalid.isEmpty()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.getErrorString());
            }
        }
        this.getContainer().updateMessage();
    }

    private String getErrorString() {
        Iterator iterator = this.validInvalid.keySet().iterator();
        String message = "";
        if (iterator.hasNext()) {
            message = (String)this.validInvalid.get(iterator.next());
        }
        return message;
    }
}

