/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.PageLayout;
import org.eclipse.cdt.ui.newui.ProjectContentsArea;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.ui.wizards.CNewWizard;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.EntryDescriptor;
import org.eclipse.cdt.ui.wizards.IWizardItemsListListener;
import org.eclipse.cdt.ui.wizards.IWizardWithMemory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class CDTMainWizardPage
extends WizardPage
implements IWizardItemsListListener {
    private static final Image IMG_CATEGORY = CPluginImages.get("org.eclipse.cdt.ui.fldr_obj.gif");
    private static final Image IMG_ITEM = CPluginImages.get("org.eclipse.cdt.ui.variable_obj.gif");
    public static final String PAGE_ID = "org.eclipse.cdt.managedbuilder.ui.wizard.NewModelProjectWizardPage";
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.CDTWizard";
    private static final String ELEMENT_NAME = "wizard";
    private static final String CLASS_NAME = "class";
    private static final String HELP_CTX = "org.eclipse.ui.ide.new_project_wizard_page_context";
    public static final String DESC = "EntryDescriptor";
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private String initialProjectFieldValue;
    private Text projectNameField;
    private Tree tree;
    private Composite right;
    private Button show_sup;
    private Label right_label;
    private ProjectContentsArea locationArea;
    public CWizardHandler h_selected = null;

    public CDTMainWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_CTX);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.locationArea = new ProjectContentsArea(this.getErrorReporter(), composite);
        if (this.initialProjectFieldValue != null) {
            this.locationArea.updateProjectName(this.initialProjectFieldValue);
        }
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.createDynamicGroup(composite);
        this.switchTo(CDTMainWizardPage.updateData(this.tree, this.right, this.show_sup, this, this.getWizard()), CDTMainWizardPage.getDescriptor(this.tree));
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createDynamicGroup(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        c.setLayout((Layout)new GridLayout(2, true));
        Label l1 = new Label(c, 0);
        l1.setText(UIMessages.getString("CMainWizardPage.0"));
        l1.setFont(parent.getFont());
        l1.setLayoutData((Object)new GridData(1));
        this.right_label = new Label(c, 0);
        this.right_label.setFont(parent.getFont());
        this.right_label.setLayoutData((Object)new GridData(1));
        this.tree = new Tree(c, 2052);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] tis = CDTMainWizardPage.this.tree.getSelection();
                if (tis == null || tis.length == 0) {
                    return;
                }
                CDTMainWizardPage.this.switchTo((CWizardHandler)tis[0].getData(), (EntryDescriptor)tis[0].getData(CDTMainWizardPage.DESC));
                CDTMainWizardPage.this.setPageComplete(CDTMainWizardPage.this.validatePage());
            }
        });
        this.tree.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UIMessages.getString("CMainWizardPage.0");
            }
        });
        this.right = new Composite(c, 0);
        this.right.setLayoutData((Object)new GridData(1808));
        this.right.setLayout((Layout)new PageLayout());
        this.show_sup = new Button(c, 32);
        this.show_sup.setText(UIMessages.getString("CMainWizardPage.1"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.show_sup.setLayoutData((Object)gd);
        this.show_sup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CDTMainWizardPage.this.h_selected != null) {
                    CDTMainWizardPage.this.h_selected.setSupportedOnly(CDTMainWizardPage.this.show_sup.getSelection());
                }
                CDTMainWizardPage.this.switchTo(CDTMainWizardPage.updateData(CDTMainWizardPage.this.tree, CDTMainWizardPage.this.right, CDTMainWizardPage.this.show_sup, CDTMainWizardPage.this, CDTMainWizardPage.this.getWizard()), CDTMainWizardPage.getDescriptor(CDTMainWizardPage.this.tree));
            }
        });
        this.show_sup.setSelection(!CDTPrefUtil.getBool("wizard.show.unsupported.disable"));
    }

    private ProjectContentsArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsArea.IErrorMessageReporter(){

            public void reportError(String errorMessage) {
                boolean valid;
                CDTMainWizardPage.this.setErrorMessage(errorMessage);
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = CDTMainWizardPage.this.validatePage();
                }
                CDTMainWizardPage.this.setPageComplete(valid);
            }
        };
    }

    public IWizardPage getNextPage() {
        if (this.h_selected == null) {
            return null;
        }
        return this.h_selected.getSpecificPage();
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(UIMessages.getString("CMainWizardPage.8"));
        projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                CDTMainWizardPage.this.locationArea.updateProjectName(CDTMainWizardPage.this.getProjectNameFieldValue());
                CDTMainWizardPage.this.setPageComplete(CDTMainWizardPage.this.validatePage());
            }
        });
    }

    private IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    public IPath getProjectLocation() {
        if (this.locationArea.isDefault()) {
            return null;
        }
        return new Path(this.locationArea.getProjectLocation());
    }

    public String getProjectLocationPath() {
        return this.locationArea.getProjectLocation();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            if (this.locationArea != null) {
                this.locationArea.updateProjectName(name.trim());
            }
        }
    }

    protected boolean validatePage() {
        IStatus locationStatus;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.setMessage(null);
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.length() == 0) {
            this.setErrorMessage(UIMessages.getString("CMainWizardPage.9"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        if (projectFieldContents.indexOf(35) >= 0) {
            this.setErrorMessage(UIMessages.getString("CDTMainWizardPage.0"));
            return false;
        }
        boolean bad = true;
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            IWizardWithMemory w;
            if (this.getWizard() instanceof IWizardWithMemory && (w = (IWizardWithMemory)this.getWizard()).getLastProjectName() != null && w.getLastProjectName().equals(this.getProjectName())) {
                bad = false;
            }
            if (bad) {
                this.setErrorMessage(UIMessages.getString("CMainWizardPage.10"));
                return false;
            }
        }
        if (bad) {
            File f;
            IPath p = this.getProjectLocation();
            if (p == null) {
                p = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                p = p.append(this.getProjectName());
            }
            if ((f = p.toFile()).exists()) {
                if (f.isDirectory()) {
                    this.setMessage(UIMessages.getString("CMainWizardPage.7"), 2);
                    return true;
                }
                this.setErrorMessage(UIMessages.getString("CMainWizardPage.6"));
                return false;
            }
        }
        if (!this.locationArea.isDefault() && !(locationStatus = workspace.validateProjectLocationURI(handle, this.locationArea.getProjectLocationURI())).isOK()) {
            this.setErrorMessage(locationStatus.getMessage());
            return false;
        }
        if (this.tree.getItemCount() == 0) {
            this.setErrorMessage(UIMessages.getString("CMainWizardPage.3"));
            return false;
        }
        if (this.h_selected == null) {
            this.setErrorMessage(null);
            return false;
        }
        String s = this.h_selected.getErrorMessage();
        if (s != null) {
            this.setErrorMessage(s);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }

    public static CWizardHandler updateData(Tree tree, Composite right, Button show_sup, IWizardItemsListListener ls, IWizard wizard) {
        TreeItem[] sel = tree.getSelection();
        String savedStr = sel.length > 0 ? sel[0].getText() : null;
        tree.removeAll();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions == null) {
            return null;
        }
        ArrayList<EntryDescriptor> items = new ArrayList<EntryDescriptor>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int k = 0;
            while (k < elements.length) {
                if (elements[k].getName().equals(ELEMENT_NAME)) {
                    CNewWizard w = null;
                    try {
                        w = (CNewWizard)elements[k].createExecutableExtension(CLASS_NAME);
                    }
                    catch (CoreException e) {
                        System.out.println(String.valueOf(UIMessages.getString("CMainWizardPage.5")) + e.getLocalizedMessage());
                        return null;
                    }
                    if (w == null) {
                        return null;
                    }
                    w.setDependentControl(right, ls);
                    EntryDescriptor[] wd = w.createItems(show_sup.getSelection(), wizard);
                    int x = 0;
                    while (x < wd.length) {
                        items.add(wd[x]);
                        ++x;
                    }
                }
                ++k;
            }
            ++i;
        }
        CDTMainWizardPage.addItemsToTree(tree, items);
        if (tree.getItemCount() > 0) {
            TreeItem target = tree.getItem(0);
            if (savedStr != null) {
                TreeItem[] all = tree.getItems();
                int i2 = 0;
                while (i2 < all.length) {
                    if (savedStr.equals(all[i2].getText())) {
                        target = all[i2];
                        break;
                    }
                    ++i2;
                }
            }
            tree.setSelection(target);
            return (CWizardHandler)target.getData();
        }
        return null;
    }

    private static void addItemsToTree(Tree tree, ArrayList items) {
        boolean found;
        ArrayList<TreeItem> placedTreeItemsList = new ArrayList<TreeItem>(items.size());
        ArrayList<EntryDescriptor> placedEntryDescriptorsList = new ArrayList<EntryDescriptor>(items.size());
        Iterator it = items.iterator();
        while (it.hasNext()) {
            EntryDescriptor wd = (EntryDescriptor)it.next();
            if (wd.getParentId() != null) continue;
            wd.setPath(wd.getId());
            TreeItem ti = new TreeItem(tree, 0);
            ti.setText(wd.getName());
            ti.setData((Object)wd.getHandler());
            ti.setData(DESC, (Object)wd);
            ti.setImage(CDTMainWizardPage.calcImage(wd));
            placedTreeItemsList.add(ti);
            placedEntryDescriptorsList.add(wd);
        }
        do {
            found = false;
            Iterator it2 = items.iterator();
            block2: while (it2.hasNext()) {
                EntryDescriptor wd1 = (EntryDescriptor)it2.next();
                if (wd1.getParentId() == null) continue;
                int i = 0;
                while (i < placedEntryDescriptorsList.size()) {
                    EntryDescriptor wd2 = (EntryDescriptor)placedEntryDescriptorsList.get(i);
                    if (wd2.getId().equals(wd1.getParentId())) {
                        found = true;
                        wd1.setParentId(null);
                        CWizardHandler h = wd2.getHandler();
                        if (h == null && !wd1.isCategory()) continue block2;
                        wd1.setPath(String.valueOf(wd2.getPath()) + "/" + wd1.getId());
                        wd1.setParent(wd2);
                        if (wd1.getHandler() == null && !wd1.isCategory()) {
                            wd1.setHandler((CWizardHandler)h.clone());
                        }
                        if (h != null && !h.isApplicable(wd1)) continue block2;
                        TreeItem p = (TreeItem)placedTreeItemsList.get(i);
                        TreeItem ti = new TreeItem(p, 0);
                        ti.setText(wd1.getName());
                        ti.setData((Object)wd1.getHandler());
                        ti.setData(DESC, (Object)wd1);
                        ti.setImage(CDTMainWizardPage.calcImage(wd1));
                        placedTreeItemsList.add(ti);
                        placedEntryDescriptorsList.add(wd1);
                        continue block2;
                    }
                    ++i;
                }
            }
        } while (found);
    }

    private void switchTo(CWizardHandler h, EntryDescriptor ed) {
        if (h == null) {
            h = ed.getHandler();
        }
        try {
            if (h != null && ed != null) {
                h.initialize(ed);
            }
        }
        catch (CoreException coreException) {
            h = null;
        }
        if (this.h_selected != null) {
            this.h_selected.handleUnSelection();
        }
        this.h_selected = h;
        if (h == null) {
            return;
        }
        this.right_label.setText(this.h_selected.getHeader());
        this.h_selected.handleSelection();
        this.h_selected.setSupportedOnly(this.show_sup.getSelection());
    }

    public static EntryDescriptor getDescriptor(Tree _tree) {
        TreeItem[] sel = _tree.getSelection();
        if (sel == null || sel.length == 0) {
            return null;
        }
        return (EntryDescriptor)sel[0].getData(DESC);
    }

    public void toolChainListChanged(int count) {
        this.setPageComplete(this.validatePage());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }

    private static Image calcImage(EntryDescriptor ed) {
        if (ed.getImage() != null) {
            return ed.getImage();
        }
        if (ed.isCategory()) {
            return IMG_CATEGORY;
        }
        return IMG_ITEM;
    }
}

