/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.internal.core.scannerconfig2;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgScannerConfigUtil;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;

public class CfgScannerConfigInfoFactory2 {
    private static final QualifiedName CONTAINER_INFO_PROPERTY = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "ScannerConfigBuilderInfo2Container");

    public static ICfgScannerConfigBuilderInfo2Set create(IConfiguration cfg) {
        Configuration c = (Configuration)cfg;
        ICfgScannerConfigBuilderInfo2Set container = c.getCfgScannerConfigInfo();
        if (container == null) {
            container = new CfgInfo(c);
            c.setCfgScannerConfigInfo(container);
        }
        return container;
    }

    public static void save(BuildConfigurationData data, ICProjectDescription des, ICProjectDescription baseDescription, boolean force) throws CoreException {
        ContainerInfo info = (ContainerInfo)des.getSessionProperty(CONTAINER_INFO_PROPERTY);
        if (info != null) {
            if (info.matches(baseDescription)) {
                IScannerConfigBuilderInfo2Set baseContainer = info.fContainer;
                baseContainer.save();
            }
            des.setSessionProperty(CONTAINER_INFO_PROPERTY, null);
        } else if (force) {
            Configuration cfg = (Configuration)data.getConfiguration();
            CfgInfo cfgInfo = new CfgInfo(cfg);
            cfg.setCfgScannerConfigInfo(cfgInfo);
            cfgInfo.getInfoMap();
            cfgInfo.fContainer.save();
            des.setSessionProperty(CONTAINER_INFO_PROPERTY, null);
        }
    }

    public static void savePreference(IConfiguration cfg) throws CoreException {
        IScannerConfigBuilderInfo2Set baseContainer;
        ICfgScannerConfigBuilderInfo2Set container = ((Configuration)cfg).getCfgScannerConfigInfo();
        if (container != null && (baseContainer = ((CfgInfo)container).fContainer) != null) {
            baseContainer.save();
        }
    }

    private static class CfgInfo
    implements ICfgScannerConfigBuilderInfo2Set {
        private Configuration cfg;
        private IScannerConfigBuilderInfo2Set fContainer;

        CfgInfo(Configuration cfg) {
            this.cfg = cfg;
        }

        public CfgInfoContext[] getContexts() {
            Map map = this.createMap();
            return map.keySet().toArray(new CfgInfoContext[map.size()]);
        }

        public IScannerConfigBuilderInfo2 getInfo(CfgInfoContext context) {
            return (IScannerConfigBuilderInfo2)this.createMap().get(context);
        }

        public boolean isPerRcTypeDiscovery() {
            return this.cfg.isPerRcTypeDiscovery();
        }

        private IScannerConfigBuilderInfo2Set getContainer() throws CoreException {
            if (this.fContainer == null) {
                if (!this.cfg.isPreference()) {
                    ICProjectDescription projDes;
                    ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(this.cfg);
                    if (cfgDes != null && (projDes = cfgDes.getProjectDescription()) != null) {
                        ContainerInfo cInfo = (ContainerInfo)projDes.getSessionProperty(CONTAINER_INFO_PROPERTY);
                        if (cInfo != null && cInfo.matches(projDes)) {
                            this.fContainer = cInfo.fContainer;
                        } else {
                            this.fContainer = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((IProject)this.cfg.getOwner().getProject());
                            cInfo = new ContainerInfo(projDes, this.fContainer);
                            projDes.setSessionProperty(CONTAINER_INFO_PROPERTY, (Object)cInfo);
                        }
                    }
                    if (this.fContainer == null) {
                        this.fContainer = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((IProject)this.cfg.getOwner().getProject());
                    }
                } else {
                    Preferences prefs = MakeCorePlugin.getDefault().getPluginPreferences();
                    this.fContainer = ScannerConfigProfileManager.createScannerConfigBuildInfo2Set((Preferences)prefs, (boolean)false);
                }
            }
            return this.fContainer;
        }

        private Map createMap() {
            HashMap<CfgInfoContext, IScannerConfigBuilderInfo2> map = new HashMap<CfgInfoContext, IScannerConfigBuilderInfo2>();
            try {
                IScannerConfigBuilderInfo2Set container = this.getContainer();
                boolean isPerRcType = this.cfg.isPerRcTypeDiscovery();
                Map baseMap = container.getInfoMap();
                if (!isPerRcType) {
                    CfgInfoContext c = new CfgInfoContext(this.cfg);
                    InfoContext baseContext = c.toInfoContext();
                    IScannerConfigBuilderInfo2 info = container.getInfo(baseContext);
                    if (info == null) {
                        String id = this.cfg.getDiscoveryProfileId();
                        if (id == null) {
                            id = CfgScannerConfigUtil.getFirstProfileId(this.cfg.getFilteredTools());
                        }
                        IScannerConfigBuilderInfo2 prefInfo = null;
                        if (!this.cfg.isPreference()) {
                            IConfiguration prefCfg = ManagedBuildManager.getPreferenceConfiguration(false);
                            ICfgScannerConfigBuilderInfo2Set prefContainer = CfgScannerConfigInfoFactory2.create(prefCfg);
                            prefInfo = prefContainer.getInfo(new CfgInfoContext(prefCfg));
                        }
                        info = prefInfo == null ? (id != null ? container.createInfo(baseContext, id) : container.createInfo(baseContext)) : (id != null ? container.createInfo(baseContext, prefInfo, id) : container.createInfo(baseContext, prefInfo, prefInfo.getSelectedProfileId()));
                    }
                    map.put(new CfgInfoContext(this.cfg), info);
                } else {
                    Map configMap = this.getConfigInfoMap(baseMap);
                    IResourceInfo[] rcInfos = this.cfg.getResourceInfos();
                    int i = 0;
                    while (i < rcInfos.length) {
                        IResourceInfo rcInfo = rcInfos[i];
                        ITool[] tools = rcInfo instanceof IFolderInfo ? ((IFolderInfo)rcInfo).getFilteredTools() : ((IFileInfo)rcInfo).getToolsToInvoke();
                        int k = 0;
                        while (k < tools.length) {
                            Tool tool = (Tool)tools[k];
                            IInputType[] types = tool.getInputTypes();
                            if (types.length != 0) {
                                int t = 0;
                                while (t < types.length) {
                                    InputType type = (InputType)types[t];
                                    CfgInfoContext context = new CfgInfoContext(rcInfo, tool, type);
                                    if ((context = CfgScannerConfigUtil.adjustPerRcTypeContext(context)) != null && context.getResourceInfo() != null) {
                                        IScannerConfigBuilderInfo2 info = (IScannerConfigBuilderInfo2)configMap.get(context);
                                        if (info == null && !type.isExtensionElement() && type.getSuperClass() != null) {
                                            CfgInfoContext superContext = new CfgInfoContext(rcInfo, tool, type.getSuperClass());
                                            if ((superContext = CfgScannerConfigUtil.adjustPerRcTypeContext(superContext)) != null && superContext.getResourceInfo() != null) {
                                                info = (IScannerConfigBuilderInfo2)configMap.get(superContext);
                                            }
                                            String id = CfgScannerConfigUtil.getDefaultProfileId(context, true);
                                            InfoContext baseContext = context.toInfoContext();
                                            info = info == null ? (id != null ? container.createInfo(baseContext, id) : container.createInfo(baseContext)) : (id != null ? container.createInfo(baseContext, info, id) : container.createInfo(baseContext, info));
                                        }
                                        if (info != null) {
                                            map.put(context, info);
                                        }
                                    }
                                    ++t;
                                }
                            } else {
                                CfgInfoContext context = new CfgInfoContext(rcInfo, tool, null);
                                if ((context = CfgScannerConfigUtil.adjustPerRcTypeContext(context)) != null && context.getResourceInfo() != null) {
                                    IScannerConfigBuilderInfo2 info = (IScannerConfigBuilderInfo2)configMap.get(context);
                                    if (info == null) {
                                        String id = CfgScannerConfigUtil.getDefaultProfileId(context, true);
                                        InfoContext baseContext = context.toInfoContext();
                                        info = id != null ? container.createInfo(baseContext, id) : container.createInfo(baseContext);
                                    }
                                    if (info != null) {
                                        map.put(context, info);
                                    }
                                }
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (!configMap.isEmpty()) {
                        Iterator iter = configMap.entrySet().iterator();
                        while (iter.hasNext()) {
                            InfoContext baseC;
                            CfgInfoContext c;
                            Map.Entry entry = iter.next();
                            if (map.containsKey(entry.getKey()) || (c = (CfgInfoContext)entry.getKey()).getResourceInfo() == null && c.getTool() == null && c.getInputType() == null || (baseC = c.toInfoContext()).isDefaultContext()) continue;
                            container.removeInfo(baseC);
                        }
                    }
                }
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            return map;
        }

        private Map getConfigInfoMap(Map baseMap) {
            HashMap<CfgInfoContext, IScannerConfigBuilderInfo2> map = new HashMap<CfgInfoContext, IScannerConfigBuilderInfo2>();
            Iterator iter = baseMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                InfoContext baseContext = (InfoContext)entry.getKey();
                CfgInfoContext c = CfgInfoContext.fromInfoContext(this.cfg, baseContext);
                if (c == null) continue;
                IScannerConfigBuilderInfo2 info = (IScannerConfigBuilderInfo2)entry.getValue();
                map.put(c, info);
            }
            return map;
        }

        public Map getInfoMap() {
            return this.createMap();
        }

        public void setPerRcTypeDiscovery(boolean on) {
            this.cfg.setPerRcTypeDiscovery(on);
        }

        public IScannerConfigBuilderInfo2 applyInfo(CfgInfoContext context, IScannerConfigBuilderInfo2 base) {
            try {
                IScannerConfigBuilderInfo2 newInfo;
                IScannerConfigBuilderInfo2Set container = this.getContainer();
                InfoContext baseContext = context.toInfoContext();
                if (base != null) {
                    newInfo = container.createInfo(baseContext, base);
                } else {
                    if (!baseContext.isDefaultContext()) {
                        container.removeInfo(baseContext);
                    }
                    newInfo = this.getInfo(context);
                }
                return newInfo;
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
                return null;
            }
        }

        public IConfiguration getConfiguration() {
            return this.cfg;
        }

        public boolean isProfileSupported(CfgInfoContext context, String profileId) {
            if (!this.isPerRcTypeDiscovery()) {
                return true;
            }
            return !CfgScannerConfigProfileManager.isPerFileProfile(profileId);
        }
    }

    private static class ContainerInfo {
        int fCode;
        IScannerConfigBuilderInfo2Set fContainer;

        ContainerInfo(ICProjectDescription des, IScannerConfigBuilderInfo2Set container) {
            this.fCode = des.hashCode();
            this.fContainer = container;
        }

        public boolean matches(ICProjectDescription des) {
            return des.hashCode() == this.fCode;
        }
    }
}

