/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class ResourceChangeHandler
implements IResourceChangeListener,
ISaveParticipant {
    private Map fRmProjectToBuildInfoMap = new HashMap();

    public void sendClose(IProject project) {
        this.sendClose(ManagedBuildManager.getBuildInfo((IResource)project, false));
    }

    private void sendClose(IManagedBuildInfo info) {
        IManagedProject managedProj;
        if (info != null && (managedProj = info.getManagedProject()) != null) {
            IConfiguration[] cfgs = managedProj.getConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                ManagedBuildManager.performValueHandlerEvent(cfgs[i], 2, true);
                ++i;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            switch (event.getType()) {
                case 2: {
                    IResource proj = event.getResource();
                    if (!(proj instanceof IProject)) break;
                    this.sendClose((IProject)proj);
                    break;
                }
                case 4: {
                    IResource rc = event.getResource();
                    if (rc instanceof IProject) {
                        IProject project = (IProject)rc;
                        try {
                            IManagedBuildInfo info;
                            if (project.hasNature(ManagedCProjectNature.MNG_NATURE_ID) && (info = ManagedBuildManager.getBuildInfo((IResource)project)) != null) {
                                this.fRmProjectToBuildInfoMap.put(project, info);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                case 1: 
                case 16: {
                    IResourceDelta resDelta = event.getDelta();
                    if (resDelta == null) break;
                    try {
                        ResourceConfigurationChecker rcChecker = new ResourceConfigurationChecker(resDelta);
                        resDelta.accept((IResourceDeltaVisitor)rcChecker);
                        this.initInfoSerialization(rcChecker.getModifiedProjects());
                    }
                    catch (CoreException e) {
                        CCorePlugin.log((Throwable)e);
                    }
                    break;
                }
            }
        }
    }

    private void initInfoSerialization(final IProject[] projects) {
        ISchedulingRule buildInfoSaveRule;
        if (projects.length == 0) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceRuleFactory ruleFactory = workspace.getRuleFactory();
        if (projects.length == 1) {
            buildInfoSaveRule = ruleFactory.modifyRule((IResource)projects[0]);
        } else {
            ISchedulingRule[] rules = new ISchedulingRule[projects.length];
            int i = 0;
            while (i < rules.length) {
                rules[i] = ruleFactory.modifyRule((IResource)projects[i]);
                ++i;
            }
            buildInfoSaveRule = MultiRule.combine((ISchedulingRule[])rules);
        }
        Job savingJob = new Job(ManagedMakeMessages.getResourceString("ResourceChangeHandler.buildInfoSerializationJob")){

            protected IStatus run(IProgressMonitor monitor) {
                int i = 0;
                while (i < projects.length) {
                    ManagedBuildManager.saveBuildInfo(projects[i], true);
                    ++i;
                }
                return new Status(0, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
            }
        };
        savingJob.setRule(buildInfoSaveRule);
        savingJob.schedule();
    }

    private boolean updateResourceConfigurations(IManagedBuildInfo info, IPath oldPath, IPath newPath) {
        IConfiguration[] configs;
        IManagedProject mngProj;
        boolean changed = false;
        if (!oldPath.equals((Object)newPath) && (mngProj = info.getManagedProject()) != null && (configs = mngProj.getConfigurations()) != null && configs.length > 0) {
            int i = 0;
            while (i < configs.length) {
                if (this.updateResourceConfiguration(configs[i], oldPath, newPath)) {
                    changed = true;
                }
                ++i;
            }
        }
        return changed;
    }

    private boolean removeResourceConfigurations(IManagedBuildInfo info, IPath path) {
        IConfiguration[] configs;
        boolean changed = false;
        IManagedProject mngProj = info.getManagedProject();
        if (mngProj != null && (configs = mngProj.getConfigurations()) != null && configs.length > 0) {
            int i = 0;
            while (i < configs.length) {
                if (this.removeResourceConfiguration(configs[i], path)) {
                    changed = true;
                }
                ++i;
            }
        }
        return changed;
    }

    private boolean updateResourceConfiguration(IConfiguration config, IPath oldPath, IPath newPath) {
        IResourceConfiguration rcCfg = config.getResourceConfiguration(oldPath.toString());
        if (rcCfg != null && !oldPath.equals((Object)newPath)) {
            rcCfg.setResourcePath(newPath.toString());
            return true;
        }
        return false;
    }

    private boolean removeResourceConfiguration(IConfiguration config, IPath path) {
        IResourceConfiguration rcCfg = config.getResourceConfiguration(path.toString());
        if (rcCfg != null) {
            config.removeResourceConfiguration(rcCfg);
            return true;
        }
        return false;
    }

    public void saving(ISaveContext context) throws CoreException {
        PropertyManager.getInstance().serialize();
        context.needDelta();
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    private class ResourceConfigurationChecker
    implements IResourceDeltaVisitor {
        private IResourceDelta fRootDelta;
        private HashMap fBuildFileGeneratorMap = new HashMap();
        private HashSet fValidatedFilesSet = new HashSet();
        private HashSet fModifiedProjects = new HashSet();

        public ResourceConfigurationChecker(IResourceDelta rootDelta) {
            this.fRootDelta = rootDelta;
        }

        public IProject[] getModifiedProjects() {
            return this.fModifiedProjects.toArray(new IProject[this.fModifiedProjects.size()]);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource dResource = delta.getResource();
            int rcType = dResource.getType();
            if (rcType == 4 || rcType == 2) {
                IManagedBuilderMakefileGenerator makeGen;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = null;
                IResource rcToCheck = null;
                switch (delta.getKind()) {
                    case 2: {
                        if (rcType == 4) {
                            IManagedBuildInfo info = (IManagedBuildInfo)ResourceChangeHandler.this.fRmProjectToBuildInfoMap.remove(dResource);
                            if ((delta.getFlags() & 0x2000) == 0) {
                                if (info == null) break;
                                ResourceChangeHandler.this.sendClose(info);
                                PropertyManager.getInstance().clearProperties(info.getManagedProject());
                                break;
                            }
                        }
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x2000) != 0) {
                            IPath path = delta.getMovedToPath();
                            if (path == null || (project = root.findMember(path.segment(0)).getProject()) == null || rcType != 2) break;
                            rcToCheck = root.getFolder(this.substituteProject(dResource.getFullPath(), project.getName()));
                            break;
                        }
                    }
                    default: {
                        project = dResource.getProject();
                        if (rcType != 2) break;
                        rcToCheck = dResource;
                    }
                }
                return project != null && (makeGen = this.getInitializedGenerator(project)) != null && (rcToCheck == null || !makeGen.isGeneratedResource(rcToCheck));
            }
            if (rcType == 1 && !dResource.isDerived()) {
                int flags = delta.getFlags();
                switch (delta.getKind()) {
                    case 2: {
                        if ((flags & 0x2000) == 0) {
                            this.handleDeleteFile(dResource.getFullPath());
                            break;
                        }
                    }
                    case 1: 
                    case 4: {
                        IPath path;
                        if ((flags & 0x2000) != 0) {
                            IPath path2 = delta.getMovedToPath();
                            if (path2 == null) break;
                            this.handleRenamedFile(dResource.getFullPath(), path2);
                            break;
                        }
                        if ((flags & 0x1000) == 0 || (path = delta.getMovedFromPath()) == null) break;
                        this.handleRenamedFile(path, dResource.getFullPath());
                        break;
                    }
                }
                return false;
            }
            return true;
        }

        private IPath substituteProject(IPath path, String projectName) {
            return new Path(projectName).makeAbsolute().append(path.removeFirstSegments(1));
        }

        private void handleRenamedFile(IPath fromPath, IPath toPath) {
            IManagedBuilderMakefileGenerator toMakeGen;
            if (!this.fValidatedFilesSet.add(fromPath)) {
                return;
            }
            IProject fromProject = this.findModifiedProject(fromPath.segment(0));
            if (fromProject == null) {
                return;
            }
            IManagedBuilderMakefileGenerator fromMakeGen = this.getInitializedGenerator(fromProject);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (fromMakeGen == null || fromMakeGen.isGeneratedResource((IResource)root.getFile(this.substituteProject(fromPath, fromProject.getName())))) {
                return;
            }
            IManagedBuildInfo fromInfo = fromProject != null ? ManagedBuildManager.getBuildInfo((IResource)fromProject) : null;
            IProject toProject = root.findMember(toPath.uptoSegment(1)).getProject();
            IManagedBuildInfo toInfo = toProject != null ? ManagedBuildManager.getBuildInfo((IResource)toProject) : null;
            IManagedBuilderMakefileGenerator iManagedBuilderMakefileGenerator = toMakeGen = toProject != null ? this.getInitializedGenerator(toProject) : null;
            if (toMakeGen != null && toMakeGen.isGeneratedResource((IResource)root.getFile(toPath))) {
                toInfo = null;
            }
            if (fromInfo == toInfo) {
                if (ResourceChangeHandler.this.updateResourceConfigurations(fromInfo, fromPath, toPath) && toProject != null) {
                    this.fModifiedProjects.add(toProject);
                }
            } else {
                if (fromInfo != null) {
                    // empty if block
                }
                if (fromInfo != null && ResourceChangeHandler.this.removeResourceConfigurations(fromInfo, fromPath) && fromProject != null) {
                    this.fModifiedProjects.add(fromProject);
                }
            }
        }

        private void handleDeleteFile(IPath path) {
            IManagedBuildInfo info;
            IProject project = this.findModifiedProject(path.segment(0));
            if (project != null && (info = ManagedBuildManager.getBuildInfo((IResource)project)) != null && ResourceChangeHandler.this.removeResourceConfigurations(info, path)) {
                this.fModifiedProjects.add(project);
            }
        }

        private IProject findModifiedProject(String oldProjectName) {
            IResourceDelta projectDelta = this.fRootDelta.findMember((IPath)new Path(oldProjectName));
            boolean replaced = false;
            if (projectDelta != null) {
                switch (projectDelta.getKind()) {
                    case 2: {
                        if ((projectDelta.getFlags() & 0x2000) == 0) {
                            return null;
                        }
                    }
                    case 4: {
                        IPath path;
                        if ((projectDelta.getFlags() & 0x2000) == 0 || (path = projectDelta.getMovedToPath()) == null) break;
                        return ResourcesPlugin.getWorkspace().getRoot().findMember(path).getProject();
                    }
                }
            }
            IProject[] project = new IProject[1];
            try {
                this.fRootDelta.accept(new IResourceDeltaVisitor(this, oldProjectName, project){
                    final /* synthetic */ ResourceConfigurationChecker this$1;
                    private final /* synthetic */ String val$oldProjectName;
                    private final /* synthetic */ IProject[] val$project;
                    {
                        this.this$1 = resourceConfigurationChecker;
                        this.val$oldProjectName = string;
                        this.val$project = iProjectArray;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource dResource = delta.getResource();
                        int rcType = dResource.getType();
                        if (rcType == 8) {
                            return true;
                        }
                        if (rcType == 4) {
                            switch (delta.getKind()) {
                                case 1: 
                                case 4: {
                                    IPath path;
                                    if ((delta.getFlags() & 0x1000) == 0 || (path = delta.getMovedFromPath()) == null || !path.segment(0).equals(this.val$oldProjectName)) break;
                                    this.val$project[0] = dResource.getProject();
                                    break;
                                }
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException coreException) {}
            if (project[0] == null && !replaced) {
                project[0] = ResourcesPlugin.getWorkspace().getRoot().findMember(oldProjectName).getProject();
            }
            return project[0];
        }

        private IManagedBuilderMakefileGenerator getInitializedGenerator(IProject project) {
            IManagedBuilderMakefileGenerator makeGen;
            block5: {
                makeGen = (IManagedBuilderMakefileGenerator)this.fBuildFileGeneratorMap.get(project);
                if (makeGen == null) {
                    IConfiguration defaultCfg;
                    block6: {
                        try {
                            if (!project.hasNature(ManagedCProjectNature.MNG_NATURE_ID)) break block5;
                            if (ManagedBuildManager.canGetBuildInfo((IResource)project)) break block6;
                            return null;
                        }
                        catch (CoreException coreException) {
                            return null;
                        }
                    }
                    IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                    if (buildInfo != null && (defaultCfg = buildInfo.getDefaultConfiguration()) != null) {
                        makeGen = ManagedBuildManager.getBuildfileGenerator(defaultCfg);
                        makeGen.initialize(project, buildInfo, (IProgressMonitor)new NullProgressMonitor());
                        this.fBuildFileGeneratorMap.put(project, makeGen);
                    }
                }
            }
            return makeGen;
        }
    }
}

