/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ConflictSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.FolderInfoModification;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.Messages;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IConfigurationModification;

public class ConfigurationModification
extends FolderInfoModification
implements IConfigurationModification {
    private IBuilder fSelectedBuilder;
    private IBuilder fRealBuilder;
    private boolean fCompatibilityInfoInited;
    private Map fCompatibleBuilders;
    private Map fInCompatibleBuilders;
    private ToolChainModificationManager.ConflictMatchSet fConflicts;
    private IBuilder[] fAllSysBuilders;
    private BuilderCompatibilityInfoElement fCurrentBuilderCompatibilityInfo;

    public ConfigurationModification(FolderInfo foInfo) {
        super(foInfo);
        this.setBuilder(foInfo.getParent().getBuilder());
    }

    public ConfigurationModification(FolderInfo foInfo, ConfigurationModification base) {
        super(foInfo, base);
        this.fSelectedBuilder = base.fSelectedBuilder;
        if (!this.fSelectedBuilder.isExtensionElement()) {
            this.fSelectedBuilder = ManagedBuildManager.getExtensionBuilder(this.fSelectedBuilder);
        }
        this.fRealBuilder = base.fRealBuilder;
    }

    public IBuilder getBuilder() {
        return this.fSelectedBuilder;
    }

    public IBuilder getRealBuilder() {
        return this.fRealBuilder;
    }

    public CompatibilityStatus getBuilderCompatibilityStatus() {
        return this.getCurrentBuilderCompatibilityInfo().getCompatibilityStatus();
    }

    /*
     * Exception decompiling
     */
    private ToolChainModificationManager.ConflictMatchSet getParentConflictMatchSet() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 60->63)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IBuilder[] getAllSysBuilders() {
        if (this.fAllSysBuilders == null) {
            this.fAllSysBuilders = ManagedBuildManager.getRealBuilders();
        }
        return this.fAllSysBuilders;
    }

    private void initCompatibilityInfo() {
        if (this.fCompatibilityInfoInited) {
            return;
        }
        this.fCompatibleBuilders = new HashMap();
        this.fInCompatibleBuilders = new HashMap();
        ToolChainModificationManager.ConflictMatchSet conflicts = this.getParentConflictMatchSet();
        Builder[] sysBs = (Builder[])this.getAllSysBuilders();
        Map conflictMap = conflicts.fObjToConflictListMap;
        int i = 0;
        while (i < sysBs.length) {
            Builder b = sysBs[i];
            List l = (List)conflictMap.get(b);
            BuilderCompatibilityInfoElement info = new BuilderCompatibilityInfoElement(b, l);
            if (info.isCompatible()) {
                this.fCompatibleBuilders.put(b, info);
            } else {
                this.fInCompatibleBuilders.put(b, info);
            }
            ++i;
        }
        this.fCompatibilityInfoInited = true;
    }

    private BuilderCompatibilityInfoElement getCurrentBuilderCompatibilityInfo() {
        if (this.fCurrentBuilderCompatibilityInfo == null) {
            this.initCompatibilityInfo();
            BuilderCompatibilityInfoElement info = (BuilderCompatibilityInfoElement)this.fCompatibleBuilders.get(this.fRealBuilder);
            if (info == null) {
                info = (BuilderCompatibilityInfoElement)this.fInCompatibleBuilders.get(this.fRealBuilder);
            }
            this.fCurrentBuilderCompatibilityInfo = info;
        }
        return this.fCurrentBuilderCompatibilityInfo;
    }

    public IBuilder[] getCompatibleBuilders() {
        this.initCompatibilityInfo();
        ArrayList<Builder> l = new ArrayList<Builder>(this.fCompatibleBuilders.size());
        IConfiguration cfg = this.getResourceInfo().getParent();
        Iterator iter = this.fCompatibleBuilders.keySet().iterator();
        while (iter.hasNext()) {
            Builder b = (Builder)iter.next();
            if (b == this.fRealBuilder || !cfg.isBuilderCompatible(b)) continue;
            l.add(b);
        }
        return l.toArray(new Builder[l.size()]);
    }

    public boolean isBuilderCompatible() {
        BuilderCompatibilityInfoElement be = this.getCurrentBuilderCompatibilityInfo();
        return be == null ? false : be.isCompatible();
    }

    public void setBuilder(IBuilder builder) {
        if (builder == this.fSelectedBuilder) {
            return;
        }
        this.fSelectedBuilder = builder;
        IBuilder realBuilder = ManagedBuildManager.getRealBuilder(builder);
        if (realBuilder == this.fRealBuilder) {
            return;
        }
        this.fRealBuilder = realBuilder;
        this.fCompletePathMapStorage = null;
        PerTypeMapStorage storage = this.getCompleteObjectStore();
        TcModificationUtil.applyBuilder(storage, this.getResourceInfo().getPath(), this.fSelectedBuilder);
        this.clearBuilderCompatibilityInfo();
        this.clearToolChainCompatibilityInfo();
        this.clearToolCompatibilityInfo();
    }

    public void setToolChain(IToolChain tc, boolean force) {
        this.setBuilder(tc.getBuilder());
        super.setToolChain(tc, force);
    }

    public void changeProjectTools(ITool removeTool, ITool addTool) {
        this.clearBuilderCompatibilityInfo();
        super.changeProjectTools(removeTool, addTool);
    }

    protected void clearBuilderCompatibilityInfo() {
        this.fInCompatibleBuilders = null;
        this.fCompatibleBuilders = null;
        this.fCompatibilityInfoInited = false;
        this.fCurrentBuilderCompatibilityInfo = null;
    }

    public static class BuilderCompatibilityInfoElement {
        private Builder fBuilder;
        private List fErrComflictMatchList;
        private CompatibilityStatus fStatus;

        BuilderCompatibilityInfoElement(Builder builder, List errConflictList) {
            this.fBuilder = builder;
            if (errConflictList != null && errConflictList.size() != 0) {
                this.fErrComflictMatchList = errConflictList;
            }
        }

        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                String message;
                int severity;
                if (this.fErrComflictMatchList != null) {
                    severity = 4;
                    message = Messages.getString("ConfigurationModification.0");
                } else {
                    severity = 0;
                    message = "";
                }
                this.fStatus = new CompatibilityStatus(severity, message, new ConflictSet(this.fBuilder, this.fErrComflictMatchList, null));
            }
            return this.fStatus;
        }

        public boolean isCompatible() {
            return this.fErrComflictMatchList == null;
        }
    }
}

