/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.c99;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.c99.IKeywordMap;
import org.eclipse.cdt.core.model.ICLanguageKeywords;

public class C99KeywordMap
implements IKeywordMap,
ICLanguageKeywords {
    private Map keywords = new HashMap();
    private Set builtinTypes = new HashSet();
    private Set preprocessorKeywords = new HashSet();
    public static final String AUTO = "auto";
    public static final String BREAK = "break";
    public static final String CASE = "case";
    public static final String CHAR = "char";
    public static final String CONST = "const";
    public static final String CONTINUE = "continue";
    public static final String DEFAULT = "default";
    public static final String DO = "do";
    public static final String DOUBLE = "double";
    public static final String ELSE = "else";
    public static final String ENUM = "enum";
    public static final String EXTERN = "extern";
    public static final String FLOAT = "float";
    public static final String FOR = "for";
    public static final String GOTO = "goto";
    public static final String IF = "if";
    public static final String INLINE = "inline";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String REGISTER = "register";
    public static final String RESTRICT = "restrict";
    public static final String RETURN = "return";
    public static final String SHORT = "short";
    public static final String SIGNED = "signed";
    public static final String SIZEOF = "sizeof";
    public static final String STATIC = "static";
    public static final String STRUCT = "struct";
    public static final String SWITCH = "switch";
    public static final String TYPEDEF = "typedef";
    public static final String UNION = "union";
    public static final String UNSIGNED = "unsigned";
    public static final String VOID = "void";
    public static final String VOLATILE = "volatile";
    public static final String WHILE = "while";
    public static final String _BOOL = "_Bool";
    public static final String _COMPLEX = "_Complex";
    public static final String _IMAGINARY = "_Imaginary";
    public static final String POUND_DEFINE = "#define";
    public static final String POUND_UNDEF = "#undef";
    public static final String POUND_IF = "#if";
    public static final String POUND_IFDEF = "#ifdef";
    public static final String POUND_IFNDEF = "#ifndef";
    public static final String POUND_ELSE = "#else";
    public static final String POUND_ENDIF = "#endif";
    public static final String POUND_INCLUDE = "#include";
    public static final String POUND_LINE = "#line";
    public static final String POUND_ERROR = "#error";
    public static final String POUND_PRAGMA = "#pragma";
    public static final String POUND_ELIF = "#elif";
    public static final String POUND_BLANK = "#";
    public static final String POUND_INCLUDE_NEXT = "include_next";

    public C99KeywordMap() {
        this.addKeywords();
        this.addBuiltinTypes();
        this.addPreprocessorKeywords();
    }

    public Integer getKeywordKind(String identifier) {
        return (Integer)this.keywords.get(identifier);
    }

    private void addKeywords() {
        this.putKeyword(AUTO, 10);
        this.putKeyword(BREAK, 53);
        this.putKeyword(CASE, 54);
        this.putKeyword(CHAR, 31);
        this.putKeyword(CONST, 5);
        this.putKeyword(CONTINUE, 55);
        this.putKeyword(DEFAULT, 56);
        this.putKeyword(DO, 57);
        this.putKeyword(DOUBLE, 32);
        this.putKeyword(ELSE, 79);
        this.putKeyword(ENUM, 44);
        this.putKeyword(EXTERN, 11);
        this.putKeyword(FLOAT, 33);
        this.putKeyword(FOR, 58);
        this.putKeyword(GOTO, 59);
        this.putKeyword(IF, 60);
        this.putKeyword(INLINE, 12);
        this.putKeyword(INT, 34);
        this.putKeyword(LONG, 35);
        this.putKeyword(REGISTER, 13);
        this.putKeyword(RESTRICT, 6);
        this.putKeyword(RETURN, 61);
        this.putKeyword(SHORT, 36);
        this.putKeyword(SIGNED, 37);
        this.putKeyword(SIZEOF, 20);
        this.putKeyword(STATIC, 9);
        this.putKeyword(STRUCT, 45);
        this.putKeyword(SWITCH, 62);
        this.putKeyword(TYPEDEF, 14);
        this.putKeyword(UNION, 46);
        this.putKeyword(UNSIGNED, 38);
        this.putKeyword(VOID, 39);
        this.putKeyword(VOLATILE, 7);
        this.putKeyword(WHILE, 50);
        this.putKeyword(_BOOL, 40);
        this.putKeyword(_COMPLEX, 41);
        this.putKeyword(_IMAGINARY, 42);
    }

    private void addBuiltinTypes() {
        this.addBuiltinType(CHAR);
        this.addBuiltinType(DOUBLE);
        this.addBuiltinType(FLOAT);
        this.addBuiltinType(INT);
        this.addBuiltinType(LONG);
        this.addBuiltinType(SHORT);
        this.addBuiltinType(SIGNED);
        this.addBuiltinType(UNSIGNED);
        this.addBuiltinType(VOID);
        this.addBuiltinType(_BOOL);
        this.addBuiltinType(_COMPLEX);
        this.addBuiltinType(_IMAGINARY);
    }

    private void addPreprocessorKeywords() {
        this.addPreprocessorKeyword(POUND_DEFINE);
        this.addPreprocessorKeyword(POUND_UNDEF);
        this.addPreprocessorKeyword(POUND_IF);
        this.addPreprocessorKeyword(POUND_IFDEF);
        this.addPreprocessorKeyword(POUND_IFNDEF);
        this.addPreprocessorKeyword(POUND_ELSE);
        this.addPreprocessorKeyword(POUND_ENDIF);
        this.addPreprocessorKeyword(POUND_INCLUDE);
        this.addPreprocessorKeyword(POUND_LINE);
        this.addPreprocessorKeyword(POUND_ERROR);
        this.addPreprocessorKeyword(POUND_PRAGMA);
        this.addPreprocessorKeyword(POUND_ELIF);
        this.addPreprocessorKeyword(POUND_BLANK);
        this.addPreprocessorKeyword(POUND_INCLUDE_NEXT);
    }

    protected void putKeyword(String keyword, int kind) {
        this.keywords.put(keyword, new Integer(kind));
    }

    protected void addBuiltinType(String type) {
        this.builtinTypes.add(type);
    }

    protected void addPreprocessorKeyword(String keyword) {
        this.preprocessorKeywords.add(keyword);
    }

    public String[] getKeywords() {
        return this.keywords.keySet().toArray(new String[0]);
    }

    public String[] getBuiltinTypes() {
        return this.builtinTypes.toArray(new String[0]);
    }

    public String[] getPreprocessorKeywords() {
        return this.preprocessorKeywords.toArray(new String[0]);
    }
}

