/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.c99;

import java.util.Iterator;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTFieldDesignator;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.dom.c99.IASTNodeFactory;
import org.eclipse.cdt.core.dom.c99.IParserActionTokenProvider;
import org.eclipse.cdt.core.dom.parser.c99.ASTStack;
import org.eclipse.cdt.core.dom.parser.c99.C99ASTNodeFactory;
import org.eclipse.cdt.core.dom.parser.c99.C99TokenMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.parser.c99.ASTCompletionNode;
import org.eclipse.cdt.internal.core.dom.parser.c99.C99Parsersym;

public class C99ParserAction
implements C99Parsersym {
    private static final char[] EMPTY_CHAR_ARRAY;
    private final ASTStack astStack = new ASTStack();
    private final IASTNodeFactory nodeFactory;
    private final IParserActionTokenProvider parser;
    private final C99TokenMap tokenMap;
    private boolean encounteredRecoverableProblem = false;
    private ASTCompletionNode completionNode;
    protected int ruleOffset;
    protected int ruleLength;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.parser.c99.C99ParserAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EMPTY_CHAR_ARRAY = new char[0];
    }

    public C99ParserAction(IParserActionTokenProvider parser, String[] orderedTerminalSymbols) {
        this.parser = parser;
        this.tokenMap = new C99TokenMap(orderedTerminalSymbols);
        this.nodeFactory = this.createNodeFactory();
    }

    protected IASTNodeFactory createNodeFactory() {
        return new C99ASTNodeFactory();
    }

    protected IASTNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    protected ASTStack getASTStack() {
        return this.astStack;
    }

    public IASTTranslationUnit getAST() {
        if (this.astStack.isEmpty()) {
            return null;
        }
        IASTTranslationUnit tu = (IASTTranslationUnit)this.astStack.peek();
        this.generateCommentNodes(tu);
        this.forceAmbiguityResolution(tu);
        return tu;
    }

    private void forceAmbiguityResolution(IASTTranslationUnit tu) {
        CASTVisitor emptyVisitor = new CASTVisitor(){
            {
                this.shouldVisitStatements = true;
            }
        };
        tu.accept((ASTVisitor)emptyVisitor);
    }

    private void generateCommentNodes(IASTTranslationUnit tu) {
        List commentTokens = this.parser.getCommentTokens();
        if (commentTokens == null || commentTokens.isEmpty()) {
            return;
        }
        IASTComment[] commentNodes = new IASTComment[commentTokens.size()];
        int i = 0;
        while (i < commentNodes.length) {
            IToken token = (IToken)commentTokens.get(i);
            IASTComment comment = this.nodeFactory.newComment();
            comment.setParent((IASTNode)tu);
            comment.setComment(token.toString().toCharArray());
            this.setOffsetAndLength((IASTNode)comment, token);
            commentNodes[i] = comment;
            ++i;
        }
        tu.setComments(commentNodes);
    }

    public boolean encounteredError() {
        return this.encounteredRecoverableProblem || this.astStack.isEmpty();
    }

    public void openASTScope() {
        this.astStack.openASTScope();
    }

    public IASTCompletionNode getASTCompletionNode() {
        if (this.completionNode != null) {
            this.completionNode.setTranslationUnit(this.getAST());
        }
        return this.completionNode;
    }

    protected int asC99Kind(IToken token) {
        return this.tokenMap.asC99Kind(token);
    }

    private boolean matchKinds(List tokens, int[] kinds) {
        if (tokens.size() != kinds.length) {
            return false;
        }
        int i = 0;
        while (i < kinds.length) {
            int kind = this.asC99Kind((IToken)tokens.get(i));
            if ((kinds[i] != 2 || kind != 2 && kind != 8) && kind != kinds[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static int offset(IToken token) {
        return token.getStartOffset();
    }

    protected static int offset(IASTNode node) {
        return ((ASTNode)node).getOffset();
    }

    protected static int length(IToken token) {
        return C99ParserAction.endOffset(token) - C99ParserAction.offset(token);
    }

    protected static int length(IASTNode node) {
        return ((ASTNode)node).getLength();
    }

    protected static int endOffset(IASTNode node) {
        return C99ParserAction.offset(node) + C99ParserAction.length(node);
    }

    protected static int endOffset(IToken token) {
        return token.getEndOffset() + 1;
    }

    protected void setOffsetAndLength(IASTNode node) {
        ((ASTNode)node).setOffsetAndLength(this.ruleOffset, this.ruleLength);
    }

    protected void setOffsetAndLength(IASTNode node, IToken token) {
        ((ASTNode)node).setOffsetAndLength(C99ParserAction.offset(token), C99ParserAction.length(token));
    }

    protected void setOffsetAndLength(IASTNode node, int offset, int length) {
        ((ASTNode)node).setOffsetAndLength(offset, length);
    }

    public void beforeConsume() {
        this.ruleOffset = this.parser.getLeftIToken().getStartOffset();
        this.ruleLength = this.parser.getRightIToken().getEndOffset() + 1 - this.ruleOffset;
    }

    public void consumeName() {
        IASTName name = this.createName(this.parser.getRightIToken());
        this.astStack.push(name);
    }

    public IASTName createName(IToken token) {
        IASTName name = this.nodeFactory.newName(token.toString().toCharArray());
        this.setOffsetAndLength((IASTNode)name, token);
        if (this.asC99Kind(token) == 8) {
            String prefix = token.toString();
            if (this.completionNode == null) {
                this.completionNode = this.nodeFactory.newCompletionNode(prefix.length() == 0 ? null : prefix);
            }
            this.completionNode.addName(name);
        }
        return name;
    }

    public void consumeToken() {
        this.astStack.push(this.parser.getRightIToken());
    }

    public void consumeExpressionConstant(int kind) {
        IASTLiteralExpression expr = this.nodeFactory.newLiteralExpression();
        IToken token = this.parser.getRightIToken();
        String rep = token.toString();
        if (kind == 3 && rep.startsWith("\"") && rep.endsWith("\"")) {
            rep = rep.substring(1, rep.length() - 1);
        }
        expr.setKind(kind);
        expr.setValue(rep);
        this.setOffsetAndLength((IASTNode)expr, token);
        this.astStack.push(expr);
    }

    public void consumeExpressionID() {
        IASTIdExpression expr = this.nodeFactory.newIdExpression();
        IASTName name = this.createName(this.parser.getRightIToken());
        expr.setName(name);
        name.setParent((IASTNode)expr);
        name.setPropertyInParent(IASTIdExpression.ID_NAME);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionBinaryOperator(int op) {
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTExpression expr1 = (IASTExpression)this.astStack.pop();
        IASTBinaryExpression binExpr = this.nodeFactory.newBinaryExpression();
        binExpr.setOperator(op);
        binExpr.setOperand1(expr1);
        expr1.setParent((IASTNode)binExpr);
        expr1.setPropertyInParent(IASTBinaryExpression.OPERAND_ONE);
        binExpr.setOperand2(expr2);
        expr2.setParent((IASTNode)binExpr);
        expr2.setPropertyInParent(IASTBinaryExpression.OPERAND_TWO);
        this.setOffsetAndLength((IASTNode)binExpr);
        this.astStack.push(binExpr);
    }

    public void consumeExpressionConditional() {
        IASTExpression expr3 = (IASTExpression)this.astStack.pop();
        IASTExpression expr2 = (IASTExpression)this.astStack.pop();
        IASTExpression expr1 = (IASTExpression)this.astStack.pop();
        IASTConditionalExpression condExpr = this.nodeFactory.newConditionalExpession();
        condExpr.setLogicalConditionExpression(expr1);
        expr1.setParent((IASTNode)condExpr);
        expr1.setPropertyInParent(IASTConditionalExpression.LOGICAL_CONDITION);
        condExpr.setPositiveResultExpression(expr2);
        expr2.setParent((IASTNode)condExpr);
        expr2.setPropertyInParent(IASTConditionalExpression.POSITIVE_RESULT);
        condExpr.setNegativeResultExpression(expr3);
        expr3.setParent((IASTNode)condExpr);
        expr3.setPropertyInParent(IASTConditionalExpression.NEGATIVE_RESULT);
        this.setOffsetAndLength((IASTNode)condExpr);
        this.astStack.push(condExpr);
    }

    public void consumeExpressionArraySubscript() {
        IASTArraySubscriptExpression expr = this.nodeFactory.newArraySubscriptExpression();
        IASTExpression subscript = (IASTExpression)this.astStack.pop();
        IASTExpression arrayExpr = (IASTExpression)this.astStack.pop();
        expr.setArrayExpression(arrayExpr);
        arrayExpr.setParent((IASTNode)expr);
        arrayExpr.setPropertyInParent(IASTArraySubscriptExpression.ARRAY);
        expr.setSubscriptExpression(subscript);
        subscript.setParent((IASTNode)expr);
        arrayExpr.setPropertyInParent(IASTArraySubscriptExpression.SUBSCRIPT);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionFunctionCall(boolean hasArgs) {
        IASTFunctionCallExpression expr = this.nodeFactory.newFunctionCallExpression();
        if (hasArgs) {
            IASTExpressionList argList = (IASTExpressionList)this.astStack.pop();
            expr.setParameterExpression((IASTExpression)argList);
            argList.setParent((IASTNode)expr);
            argList.setPropertyInParent(IASTFunctionCallExpression.PARAMETERS);
        }
        IASTExpression idExpr = (IASTExpression)this.astStack.pop();
        expr.setFunctionNameExpression(idExpr);
        idExpr.setParent((IASTNode)expr);
        idExpr.setPropertyInParent(IASTFunctionCallExpression.FUNCTION_NAME);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionFieldReference(boolean isPointerDereference) {
        IASTExpression idExpression = (IASTExpression)this.astStack.pop();
        IASTFieldReference expr = this.nodeFactory.newFieldReference();
        IASTName name = this.createName(this.parser.getRightIToken());
        expr.setIsPointerDereference(isPointerDereference);
        expr.setFieldName(name);
        name.setParent((IASTNode)expr);
        name.setPropertyInParent(IASTFieldReference.FIELD_NAME);
        expr.setFieldOwner(idExpression);
        idExpression.setParent((IASTNode)expr);
        idExpression.setPropertyInParent(IASTFieldReference.FIELD_OWNER);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionUnaryOperator(int operator) {
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTUnaryExpression expr = this.nodeFactory.newUnaryExpression();
        expr.setOperator(operator);
        expr.setOperand(operand);
        operand.setParent((IASTNode)expr);
        operand.setPropertyInParent(IASTUnaryExpression.OPERAND);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionUnarySizeofTypeName() {
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        IASTTypeIdExpression expr = this.nodeFactory.newTypeIdExpression();
        expr.setTypeId(typeId);
        typeId.setParent((IASTNode)expr);
        typeId.setPropertyInParent(IASTTypeIdExpression.TYPE_ID);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
        this.disambiguateHackSizofTypeName();
    }

    private void disambiguateHackSizofTypeName() {
        List tokens = this.parser.getRuleTokens();
        if (tokens.size() != 4) {
            return;
        }
        IToken typeName = (IToken)tokens.get(2);
        int kind = this.asC99Kind(typeName);
        if (kind != 2 && kind != 8) {
            return;
        }
        IASTName name = this.createName(typeName);
        IASTIdExpression idExpr = this.nodeFactory.newIdExpression();
        idExpr.setName(name);
        name.setParent((IASTNode)idExpr);
        name.setPropertyInParent(IASTIdExpression.ID_NAME);
        IASTUnaryExpression secondExpr = this.nodeFactory.newUnaryExpression();
        secondExpr.setOperator(8);
        secondExpr.setOperand((IASTExpression)idExpr);
        idExpr.setParent((IASTNode)secondExpr);
        idExpr.setPropertyInParent(IASTUnaryExpression.OPERAND);
        IASTAmbiguousExpression ambExpr = this.nodeFactory.newAmbiguousExpression();
        IASTExpression firstExpr = (IASTExpression)this.astStack.pop();
        ambExpr.addExpression(firstExpr);
        firstExpr.setParent((IASTNode)ambExpr);
        firstExpr.setPropertyInParent(IASTAmbiguousExpression.SUBEXPRESSION);
        ambExpr.addExpression((IASTExpression)secondExpr);
        secondExpr.setParent((IASTNode)ambExpr);
        secondExpr.setPropertyInParent(IASTAmbiguousExpression.SUBEXPRESSION);
        this.astStack.push(ambExpr);
    }

    public void consumeExpressionTypeIdInitializer() {
        this.consumeInitializerList();
        IASTInitializerList list = (IASTInitializerList)this.astStack.pop();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        ICASTTypeIdInitializerExpression expr = this.nodeFactory.newCTypeIdInitializerExpression();
        expr.setInitializer((IASTInitializer)list);
        list.setParent((IASTNode)expr);
        list.setPropertyInParent(ICASTTypeIdInitializerExpression.INITIALIZER);
        expr.setTypeId(typeId);
        typeId.setParent((IASTNode)expr);
        typeId.setPropertyInParent(ICASTTypeIdInitializerExpression.TYPE_ID);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpressionCast() {
        IASTCastExpression expr = this.nodeFactory.newCastExpression();
        expr.setOperator(0);
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        IASTTypeId typeId = (IASTTypeId)this.astStack.pop();
        if (this.disambiguateHackCastExpression(typeId, operand)) {
            return;
        }
        expr.setTypeId(typeId);
        typeId.setParent((IASTNode)expr);
        typeId.setPropertyInParent(IASTCastExpression.TYPE_ID);
        expr.setOperand(operand);
        operand.setParent((IASTNode)expr);
        operand.setPropertyInParent(IASTCastExpression.OPERAND);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    private boolean disambiguateHackCastExpression(IASTTypeId typeId, IASTExpression operand) {
        if (operand instanceof IASTUnaryExpression) {
            int binaryOperator;
            IASTUnaryExpression unaryExpression = (IASTUnaryExpression)operand;
            IASTExpression unaryOperand = unaryExpression.getOperand();
            List ruleTokens = this.parser.getRuleTokens();
            IToken openParen = (IToken)ruleTokens.get(0);
            IToken ident = (IToken)ruleTokens.get(1);
            IToken closeParen = (IToken)ruleTokens.get(2);
            if (this.asC99Kind(openParen) != 1 || this.asC99Kind(ident) != 2 || this.asC99Kind(closeParen) != 48) {
                return false;
            }
            IToken operator = (IToken)ruleTokens.get(3);
            switch (this.asC99Kind(operator)) {
                case 15: {
                    binaryOperator = 4;
                    break;
                }
                case 16: {
                    binaryOperator = 5;
                    break;
                }
                case 17: {
                    binaryOperator = 12;
                    break;
                }
                case 3: {
                    binaryOperator = 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            IASTDeclSpecifier declSpecifier = typeId.getDeclSpecifier();
            if (!(declSpecifier instanceof IASTNamedTypeSpecifier)) {
                return false;
            }
            IASTIdExpression idExpression = this.nodeFactory.newIdExpression();
            IASTName name = ((IASTNamedTypeSpecifier)declSpecifier).getName();
            idExpression.setName(name);
            name.setParent((IASTNode)idExpression);
            name.setPropertyInParent(IASTIdExpression.ID_NAME);
            IASTUnaryExpression operand1 = this.nodeFactory.newUnaryExpression();
            operand1.setOperator(11);
            operand1.setOperand((IASTExpression)idExpression);
            idExpression.setParent((IASTNode)operand1);
            idExpression.setPropertyInParent(IASTUnaryExpression.OPERAND);
            this.setOffsetAndLength((IASTNode)idExpression, C99ParserAction.offset((IASTNode)typeId), C99ParserAction.length((IASTNode)typeId));
            IASTBinaryExpression binaryExpression = this.nodeFactory.newBinaryExpression();
            binaryExpression.setOperator(binaryOperator);
            binaryExpression.setOperand1((IASTExpression)operand1);
            operand1.setParent((IASTNode)binaryExpression);
            operand1.setPropertyInParent(IASTBinaryExpression.OPERAND_ONE);
            int closingParenthesisOffset = closeParen.getEndOffset();
            int openingParenthesisOffset = openParen.getStartOffset();
            this.setOffsetAndLength((IASTNode)operand1, openingParenthesisOffset, closingParenthesisOffset - openingParenthesisOffset + 1);
            binaryExpression.setOperand2(unaryOperand);
            unaryOperand.setParent((IASTNode)binaryExpression);
            unaryOperand.setPropertyInParent(IASTBinaryExpression.OPERAND_TWO);
            this.setOffsetAndLength((IASTNode)binaryExpression);
            this.astStack.push(binaryExpression);
            return true;
        }
        return false;
    }

    public void consumeExpressionBracketed() {
        IASTUnaryExpression expr = this.nodeFactory.newUnaryExpression();
        expr.setOperator(11);
        IASTExpression operand = (IASTExpression)this.astStack.pop();
        expr.setOperand(operand);
        operand.setParent((IASTNode)expr);
        operand.setPropertyInParent(IASTUnaryExpression.OPERAND);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeExpression() {
        IASTExpressionList exprList = (IASTExpressionList)this.astStack.pop();
        IASTExpression[] expressions = exprList.getExpressions();
        if (expressions.length == 1) {
            this.astStack.push(expressions[0]);
        } else {
            this.astStack.push(exprList);
        }
    }

    public void consumeExpressionList(boolean baseCase) {
        IASTExpressionList exprList;
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        if (baseCase) {
            exprList = this.nodeFactory.newExpressionList();
            this.astStack.push(exprList);
        } else {
            exprList = (IASTExpressionList)this.astStack.peek();
        }
        exprList.addExpression(expr);
        expr.setParent((IASTNode)exprList);
        expr.setPropertyInParent(IASTExpressionList.NESTED_EXPRESSION);
        this.setOffsetAndLength((IASTNode)exprList);
    }

    protected void setSpecifier(ICASTDeclSpecifier node, Object o) {
        if (!(o instanceof IToken)) {
            return;
        }
        IToken token = (IToken)o;
        int kind = this.asC99Kind(token);
        switch (kind) {
            case 14: {
                node.setStorageClass(1);
                return;
            }
            case 11: {
                node.setStorageClass(2);
                return;
            }
            case 9: {
                node.setStorageClass(3);
                return;
            }
            case 10: {
                node.setStorageClass(4);
                return;
            }
            case 13: {
                node.setStorageClass(5);
                return;
            }
            case 12: {
                node.setInline(true);
                return;
            }
            case 5: {
                node.setConst(true);
                return;
            }
            case 6: {
                node.setRestrict(true);
                return;
            }
            case 7: {
                node.setVolatile(true);
                return;
            }
        }
        if (node instanceof ICASTSimpleDeclSpecifier) {
            ICASTSimpleDeclSpecifier n = (ICASTSimpleDeclSpecifier)node;
            switch (kind) {
                case 39: {
                    n.setType(1);
                    break;
                }
                case 31: {
                    n.setType(2);
                    break;
                }
                case 36: {
                    n.setShort(true);
                    break;
                }
                case 34: {
                    n.setType(3);
                    break;
                }
                case 35: {
                    boolean isLong = n.isLong();
                    n.setLongLong(isLong);
                    n.setLong(!isLong);
                    break;
                }
                case 33: {
                    n.setType(4);
                    break;
                }
                case 32: {
                    n.setType(5);
                    break;
                }
                case 37: {
                    n.setSigned(true);
                    break;
                }
                case 38: {
                    n.setUnsigned(true);
                    break;
                }
                case 40: {
                    n.setType(6);
                    break;
                }
                case 41: {
                    n.setComplex(true);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void consumeTypeId(boolean hasDeclarator) {
        IASTDeclarator declarator;
        IASTTypeId typeId = this.nodeFactory.newTypeId();
        if (hasDeclarator) {
            declarator = (IASTDeclarator)this.astStack.pop();
        } else {
            declarator = this.nodeFactory.newDeclarator();
            IASTName name = this.nodeFactory.newName();
            declarator.setName(name);
            name.setParent((IASTNode)declarator);
            name.setPropertyInParent(IASTFunctionDeclarator.DECLARATOR_NAME);
        }
        typeId.setAbstractDeclarator(declarator);
        declarator.setParent((IASTNode)typeId);
        declarator.setPropertyInParent(IASTTypeId.ABSTRACT_DECLARATOR);
        IASTDeclSpecifier declSpecifier = (IASTDeclSpecifier)this.astStack.pop();
        typeId.setDeclSpecifier(declSpecifier);
        declSpecifier.setParent((IASTNode)typeId);
        declSpecifier.setPropertyInParent(IASTTypeId.DECL_SPECIFIER);
        this.setOffsetAndLength((IASTNode)typeId);
        this.astStack.push(typeId);
    }

    public void consumeDeclaratorWithPointer(boolean hasDeclarator) {
        IASTDeclarator decl;
        if (hasDeclarator) {
            decl = (IASTDeclarator)this.astStack.pop();
        } else {
            decl = this.nodeFactory.newDeclarator();
            IASTName name = this.nodeFactory.newName();
            decl.setName(name);
            name.setParent((IASTNode)decl);
            name.setPropertyInParent(IASTDeclarator.DECLARATOR_NAME);
        }
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            ICASTPointer pointer = (ICASTPointer)iter.next();
            decl.addPointerOperator((IASTPointerOperator)pointer);
            pointer.setParent((IASTNode)decl);
            pointer.setPropertyInParent(IASTDeclarator.POINTER_OPERATOR);
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)decl);
        this.astStack.push(decl);
    }

    private void consumeDeclaratorArray(IASTArrayModifier arrayModifier) {
        IASTDeclarator node = (IASTDeclarator)this.astStack.pop();
        if (node.getNestedDeclarator() != null) {
            IASTArrayDeclarator declarator = this.nodeFactory.newArrayDeclarator();
            IASTName name = this.nodeFactory.newName();
            declarator.setName(name);
            name.setParent((IASTNode)declarator);
            name.setPropertyInParent(IASTFunctionDeclarator.DECLARATOR_NAME);
            IASTDeclarator nested = node;
            declarator.setNestedDeclarator(nested);
            nested.setParent((IASTNode)declarator);
            int offset = C99ParserAction.offset((IASTNode)nested);
            int length = C99ParserAction.endOffset((IASTNode)arrayModifier) - offset;
            this.setOffsetAndLength((IASTNode)declarator, offset, length);
            this.addArrayModifier(declarator, arrayModifier);
            this.astStack.push(declarator);
        } else if (node instanceof IASTArrayDeclarator) {
            IASTArrayDeclarator decl = (IASTArrayDeclarator)node;
            ((ASTNode)decl).setLength(C99ParserAction.endOffset((IASTNode)arrayModifier) - C99ParserAction.offset((IASTNode)decl));
            this.addArrayModifier(decl, arrayModifier);
            this.astStack.push(decl);
        } else if (node instanceof IASTDeclarator) {
            IASTArrayDeclarator decl = this.nodeFactory.newArrayDeclarator();
            IASTName name = node.getName();
            decl.setName(name);
            name.setParent((IASTNode)decl);
            name.setPropertyInParent(IASTArrayDeclarator.DECLARATOR_NAME);
            int offset = C99ParserAction.offset((IASTNode)name);
            int length = C99ParserAction.endOffset((IASTNode)arrayModifier) - offset;
            this.setOffsetAndLength((IASTNode)decl, offset, length);
            this.addArrayModifier(decl, arrayModifier);
            this.astStack.push(decl);
        } else {
            IASTProblemDeclaration problem = this.nodeFactory.newProblemDeclaration();
            this.setOffsetAndLength((IASTNode)problem);
            this.astStack.push(problem);
            this.encounteredRecoverableProblem = true;
        }
    }

    private void addArrayModifier(IASTArrayDeclarator decl, IASTArrayModifier modifier) {
        decl.addArrayModifier(modifier);
        modifier.setParent((IASTNode)decl);
        modifier.setPropertyInParent(IASTArrayDeclarator.ARRAY_MODIFIER);
    }

    private void collectArrayModifierTypeQualifiers(ICASTArrayModifier arrayModifier) {
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            switch (this.asC99Kind((IToken)iter.next())) {
                case 5: {
                    arrayModifier.setConst(true);
                    break;
                }
                case 6: {
                    arrayModifier.setRestrict(true);
                    break;
                }
                case 7: {
                    arrayModifier.setVolatile(true);
                }
            }
        }
        this.astStack.closeASTScope();
    }

    public void consumeDirectDeclaratorModifiedArrayModifier(boolean isStatic, boolean isVarSized, boolean hasTypeQualifierList, boolean hasAssignmentExpr) {
        if (!($assertionsDisabled || isStatic || isVarSized || hasTypeQualifierList)) {
            throw new AssertionError();
        }
        ICASTArrayModifier arrayModifier = this.nodeFactory.newCArrayModifier();
        arrayModifier.setStatic(isStatic);
        arrayModifier.setVariableSized(isVarSized);
        if (hasAssignmentExpr) {
            IASTExpression expr = (IASTExpression)this.astStack.pop();
            arrayModifier.setConstantExpression(expr);
            expr.setParent((IASTNode)arrayModifier);
            expr.setPropertyInParent(ICASTArrayModifier.CONSTANT_EXPRESSION);
        }
        if (hasTypeQualifierList) {
            this.collectArrayModifierTypeQualifiers(arrayModifier);
        }
        this.setOffsetAndLength((IASTNode)arrayModifier);
        this.astStack.push(arrayModifier);
    }

    public void consumeDirectDeclaratorArrayModifier(boolean hasAssignmentExpr) {
        IASTArrayModifier arrayModifier = this.nodeFactory.newArrayModifier();
        if (hasAssignmentExpr) {
            IASTExpression expr = (IASTExpression)this.astStack.pop();
            arrayModifier.setConstantExpression(expr);
            expr.setParent((IASTNode)arrayModifier);
            expr.setPropertyInParent(ICASTArrayModifier.CONSTANT_EXPRESSION);
        }
        this.setOffsetAndLength((IASTNode)arrayModifier);
        this.astStack.push(arrayModifier);
    }

    public void consumeDirectDeclaratorArrayDeclarator() {
        IASTArrayModifier arrayModifier = (IASTArrayModifier)this.astStack.pop();
        this.consumeDeclaratorArray(arrayModifier);
    }

    public void consumeDirectDeclaratorBracketed() {
        IASTDeclarator nested = (IASTDeclarator)this.astStack.pop();
        IASTDeclarator declarator = this.nodeFactory.newDeclarator();
        IASTName name = this.nodeFactory.newName();
        declarator.setName(name);
        name.setParent((IASTNode)declarator);
        name.setPropertyInParent(IASTFunctionDeclarator.DECLARATOR_NAME);
        declarator.setNestedDeclarator(nested);
        nested.setParent((IASTNode)declarator);
        nested.setPropertyInParent(IASTDeclarator.NESTED_DECLARATOR);
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeDeclaratorWithInitializer() {
        IASTInitializer expr = (IASTInitializer)this.astStack.pop();
        IASTDeclarator declarator = (IASTDeclarator)this.astStack.peek();
        declarator.setInitializer(expr);
        expr.setParent((IASTNode)declarator);
        expr.setPropertyInParent(IASTDeclarator.INITIALIZER);
        this.setOffsetAndLength((IASTNode)declarator);
    }

    public void consumeDirectDeclaratorIdentifier() {
        IASTName name = this.createName(this.parser.getRightIToken());
        IASTDeclarator declarator = this.nodeFactory.newDeclarator();
        declarator.setName(name);
        name.setParent((IASTNode)declarator);
        name.setPropertyInParent(IASTDeclarator.DECLARATOR_NAME);
        this.setOffsetAndLength((IASTNode)declarator);
        this.astStack.push(declarator);
    }

    public void consumeDirectDeclaratorFunctionDeclarator(boolean hasParameters) {
        IASTStandardFunctionDeclarator declarator = this.nodeFactory.newFunctionDeclarator();
        if (hasParameters) {
            Iterator iter = this.astStack.topScopeIterator();
            while (iter.hasNext()) {
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)iter.next();
                declarator.addParameterDeclaration(parameter);
                parameter.setParent((IASTNode)declarator);
                parameter.setPropertyInParent(IASTStandardFunctionDeclarator.FUNCTION_PARAMETER);
            }
            this.astStack.closeASTScope();
        }
        IASTName name = this.nodeFactory.newName();
        declarator.setName(name);
        name.setParent((IASTNode)declarator);
        name.setPropertyInParent(IASTFunctionDeclarator.DECLARATOR_NAME);
        int endOffset = C99ParserAction.endOffset(this.parser.getRightIToken());
        this.consumeDirectDeclaratorFunctionDeclarator((IASTFunctionDeclarator)declarator, endOffset);
    }

    public void consumeDirectDeclaratorFunctionDeclaratorKnR() {
        ICASTKnRFunctionDeclarator declarator = this.nodeFactory.newCKnRFunctionDeclarator();
        IASTName[] names = (IASTName[])this.astStack.topScopeArray(new IASTName[0]);
        declarator.setParameterNames(names);
        int i = 0;
        while (i < names.length) {
            names[i].setParent((IASTNode)declarator);
            names[i].setPropertyInParent(ICASTKnRFunctionDeclarator.FUNCTION_PARAMETER);
            ++i;
        }
        this.astStack.closeASTScope();
        int endOffset = C99ParserAction.endOffset(this.parser.getRightIToken());
        this.consumeDirectDeclaratorFunctionDeclarator((IASTFunctionDeclarator)declarator, endOffset);
    }

    private void consumeDirectDeclaratorFunctionDeclarator(IASTFunctionDeclarator declarator, int endOffset) {
        IASTDeclarator decl = (IASTDeclarator)this.astStack.pop();
        if (decl.getNestedDeclarator() != null) {
            decl = decl.getNestedDeclarator();
            declarator.setNestedDeclarator(decl);
            decl.setParent((IASTNode)declarator);
            IASTName name = this.nodeFactory.newName();
            declarator.setName(name);
            name.setParent((IASTNode)declarator);
            name.setPropertyInParent(IASTFunctionDeclarator.DECLARATOR_NAME);
            int offset = C99ParserAction.offset((IASTNode)decl);
            this.setOffsetAndLength((IASTNode)declarator, offset, endOffset - offset);
            this.astStack.push(declarator);
        } else if (decl instanceof IASTDeclarator) {
            IASTName name = decl.getName();
            if (name == null) {
                name = this.nodeFactory.newName();
            }
            declarator.setName(name);
            name.setParent((IASTNode)declarator);
            name.setPropertyInParent(IASTFunctionDeclarator.DECLARATOR_NAME);
            IASTPointerOperator[] pointers = decl.getPointerOperators();
            int i = 0;
            while (i < pointers.length) {
                IASTPointerOperator pointer = pointers[i];
                declarator.addPointerOperator(pointer);
                pointer.setParent((IASTNode)declarator);
                pointer.setPropertyInParent(IASTFunctionDeclarator.POINTER_OPERATOR);
                ++i;
            }
            int offset = C99ParserAction.offset((IASTNode)name);
            this.setOffsetAndLength((IASTNode)declarator, offset, endOffset - offset);
            this.astStack.push(declarator);
        } else {
            IASTProblemDeclaration problem = this.nodeFactory.newProblemDeclaration();
            this.setOffsetAndLength((IASTNode)problem);
            this.astStack.push(problem);
            this.encounteredRecoverableProblem = true;
        }
    }

    public void consumePointer() {
        ICASTPointer pointer = this.nodeFactory.newCPointer();
        IToken star = this.parser.getRightIToken();
        this.setOffsetAndLength((IASTNode)pointer, star);
        this.astStack.push(pointer);
    }

    public void consumePointerTypeQualifierList() {
        ICASTPointer pointer = this.nodeFactory.newCPointer();
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            switch (this.asC99Kind(token)) {
                case 5: {
                    pointer.setConst(true);
                    break;
                }
                case 6: {
                    pointer.setRestrict(true);
                    break;
                }
                case 7: {
                    pointer.setVolatile(true);
                }
            }
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)pointer);
        this.astStack.push(pointer);
    }

    public void consumeParameterDeclaration(boolean hasDeclarator) {
        IASTDeclarator declarator;
        IASTParameterDeclaration declaration = this.nodeFactory.newParameterDeclaration();
        if (hasDeclarator) {
            declarator = (IASTDeclarator)this.astStack.pop();
        } else {
            declarator = this.nodeFactory.newDeclarator();
            this.setOffsetAndLength((IASTNode)declarator, this.ruleOffset + this.ruleLength, 0);
            IASTName name = this.nodeFactory.newName();
            this.setOffsetAndLength((IASTNode)name, this.ruleOffset + this.ruleLength, 0);
            declarator.setName(name);
            name.setParent((IASTNode)declarator);
            name.setPropertyInParent(IASTDeclarator.DECLARATOR_NAME);
        }
        declaration.setDeclarator(declarator);
        declarator.setParent((IASTNode)declaration);
        declarator.setPropertyInParent(IASTParameterDeclaration.DECLARATOR);
        IASTDeclSpecifier declSpecifier = (IASTDeclSpecifier)this.astStack.pop();
        declaration.setDeclSpecifier(declSpecifier);
        declSpecifier.setParent((IASTNode)declaration);
        declSpecifier.setPropertyInParent(IASTParameterDeclaration.DECL_SPECIFIER);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeAbstractDeclaratorArrayModifier(boolean hasDeclarator) {
        IASTArrayModifier arrayModifier = (IASTArrayModifier)this.astStack.pop();
        if (hasDeclarator) {
            this.consumeDeclaratorArray(arrayModifier);
        } else {
            IASTArrayDeclarator decl = this.nodeFactory.newArrayDeclarator();
            IASTName name = this.nodeFactory.newName();
            decl.setName(name);
            name.setParent((IASTNode)decl);
            name.setPropertyInParent(IASTArrayDeclarator.DECLARATOR_NAME);
            decl.addArrayModifier(arrayModifier);
            arrayModifier.setParent((IASTNode)decl);
            arrayModifier.setPropertyInParent(IASTArrayDeclarator.ARRAY_MODIFIER);
            this.setOffsetAndLength((IASTNode)decl);
            this.astStack.push(decl);
        }
    }

    public void consumeAbstractDeclaratorFunctionDeclarator(boolean hasDeclarator, boolean hasParameters) {
        IASTStandardFunctionDeclarator declarator = this.nodeFactory.newFunctionDeclarator();
        if (hasParameters) {
            Iterator iter = this.astStack.topScopeIterator();
            while (iter.hasNext()) {
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)iter.next();
                declarator.addParameterDeclaration(parameter);
                parameter.setParent((IASTNode)declarator);
                parameter.setPropertyInParent(IASTStandardFunctionDeclarator.FUNCTION_PARAMETER);
            }
            this.astStack.closeASTScope();
        }
        IASTName name = this.nodeFactory.newName();
        declarator.setName(name);
        name.setParent((IASTNode)declarator);
        name.setPropertyInParent(IASTFunctionDeclarator.DECLARATOR_NAME);
        if (hasDeclarator) {
            this.consumeDirectDeclaratorFunctionDeclarator((IASTFunctionDeclarator)declarator, C99ParserAction.endOffset(this.parser.getRightIToken()));
        } else {
            this.setOffsetAndLength((IASTNode)declarator);
            this.astStack.push(declarator);
        }
    }

    public void consumeInitializer() {
        IASTExpression assignmentExpression = (IASTExpression)this.astStack.pop();
        IASTInitializerExpression expr = this.nodeFactory.newInitializerExpression();
        expr.setExpression(assignmentExpression);
        assignmentExpression.setParent((IASTNode)expr);
        assignmentExpression.setPropertyInParent(IASTInitializerExpression.INITIALIZER_EXPRESSION);
        this.setOffsetAndLength((IASTNode)expr);
        this.astStack.push(expr);
    }

    public void consumeInitializerList() {
        IASTInitializerList list = this.nodeFactory.newInitializerList();
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            IASTInitializer initializer = (IASTInitializer)iter.next();
            list.addInitializer(initializer);
            initializer.setParent((IASTNode)list);
            initializer.setPropertyInParent(IASTInitializerList.NESTED_INITIALIZER);
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)list);
        this.astStack.push(list);
    }

    public void consumeInitializerDesignated() {
        ICASTDesignatedInitializer result = this.nodeFactory.newCDesignatedInitializer();
        IASTInitializer initializer = (IASTInitializer)this.astStack.pop();
        result.setOperandInitializer(initializer);
        initializer.setParent((IASTNode)result);
        initializer.setPropertyInParent(ICASTDesignatedInitializer.OPERAND);
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            ICASTDesignator designator = (ICASTDesignator)iter.next();
            result.addDesignator(designator);
            designator.setParent((IASTNode)result);
            designator.setPropertyInParent(ICASTDesignatedInitializer.DESIGNATOR);
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)result);
        this.astStack.push(result);
    }

    public void consumeDesignatorArrayDesignator() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        ICASTArrayDesignator designator = this.nodeFactory.newCArrayDesignator();
        designator.setSubscriptExpression(expr);
        expr.setParent((IASTNode)designator);
        expr.setPropertyInParent(ICASTArrayDesignator.SUBSCRIPT_EXPRESSION);
        this.setOffsetAndLength((IASTNode)designator);
        this.astStack.push(designator);
    }

    public void consumeDesignatorFieldDesignator() {
        ICASTFieldDesignator designator = this.nodeFactory.newCFieldDesignator();
        IASTName name = this.createName(this.parser.getRightIToken());
        designator.setName(name);
        name.setParent((IASTNode)designator);
        name.setPropertyInParent(ICASTFieldDesignator.FIELD_NAME);
        this.setOffsetAndLength((IASTNode)designator);
        this.astStack.push(designator);
    }

    public void consumeDeclarationSpecifiersSimple() {
        ICASTSimpleDeclSpecifier declSpec = this.nodeFactory.newCSimpleDeclSpecifier();
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            this.setSpecifier((ICASTDeclSpecifier)declSpec, iter.next());
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersStructUnionEnum() {
        ICASTDeclSpecifier declSpec = null;
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof ICASTDeclSpecifier)) continue;
            declSpec = (ICASTDeclSpecifier)o;
            iter.remove();
            break;
        }
        iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            this.setSpecifier(declSpec, iter.next());
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclarationSpecifiersTypedefName() {
        ICASTTypedefNameSpecifier declSpec = this.nodeFactory.newCTypedefNameSpecifier();
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof IToken) {
                IToken token = (IToken)o;
                int kind = this.asC99Kind(token);
                if (kind == 2 || kind == 8) {
                    IASTName name = this.createName(token);
                    declSpec.setName(name);
                    name.setParent((IASTNode)declSpec);
                    name.setPropertyInParent(IASTNamedTypeSpecifier.NAME);
                    continue;
                }
                this.setSpecifier((ICASTDeclSpecifier)declSpec, token);
                continue;
            }
            this.setSpecifier((ICASTDeclSpecifier)declSpec, o);
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    public void consumeDeclaration(boolean hasDeclaratorList) {
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration();
        if (hasDeclaratorList) {
            Iterator iter = this.astStack.topScopeIterator();
            while (iter.hasNext()) {
                IASTDeclarator declarator = (IASTDeclarator)iter.next();
                declaration.addDeclarator(declarator);
                declarator.setParent((IASTNode)declaration);
                declarator.setPropertyInParent(IASTSimpleDeclaration.DECLARATOR);
            }
            this.astStack.closeASTScope();
        }
        ICASTDeclSpecifier declSpecifier = (ICASTDeclSpecifier)this.astStack.pop();
        declaration.setDeclSpecifier((IASTDeclSpecifier)declSpecifier);
        declSpecifier.setParent((IASTNode)declaration);
        declSpecifier.setPropertyInParent(IASTSimpleDeclaration.DECL_SPECIFIER);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeDeclarationEmpty() {
        IASTSimpleDeclaration declaration = this.nodeFactory.newSimpleDeclaration();
        ICASTSimpleDeclSpecifier declSpecifier = this.nodeFactory.newCSimpleDeclSpecifier();
        declaration.setDeclSpecifier((IASTDeclSpecifier)declSpecifier);
        declSpecifier.setParent((IASTNode)declaration);
        declSpecifier.setPropertyInParent(IASTSimpleDeclaration.DECL_SPECIFIER);
        this.setOffsetAndLength((IASTNode)declSpecifier);
        this.setOffsetAndLength((IASTNode)declaration);
        this.astStack.push(declaration);
    }

    public void consumeStructDeclaration(boolean hasDeclaration) {
        this.consumeDeclaration(hasDeclaration);
    }

    public void consumeStructBitField(boolean hasDeclarator) {
        IASTName name;
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTFieldDeclarator fieldDecl = this.nodeFactory.newFieldDeclarator();
        fieldDecl.setBitFieldSize(expr);
        expr.setParent((IASTNode)fieldDecl);
        expr.setPropertyInParent(IASTFieldDeclarator.FIELD_SIZE);
        if (hasDeclarator) {
            IASTDeclarator decl = (IASTDeclarator)this.astStack.pop();
            name = decl.getName();
        } else {
            name = this.nodeFactory.newName();
        }
        fieldDecl.setName(name);
        name.setParent((IASTNode)fieldDecl);
        name.setPropertyInParent(IASTFieldDeclarator.DECLARATOR_NAME);
        this.setOffsetAndLength((IASTNode)fieldDecl);
        this.astStack.push(fieldDecl);
    }

    public void consumeTypeSpecifierComposite(boolean hasName, int key) {
        ICASTCompositeTypeSpecifier typeSpec = this.nodeFactory.newCCompositeTypeSpecifier();
        typeSpec.setKey(key);
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            IASTDeclaration declaration = (IASTDeclaration)iter.next();
            typeSpec.addMemberDeclaration(declaration);
            declaration.setParent((IASTNode)typeSpec);
            declaration.setPropertyInParent(IASTCompositeTypeSpecifier.MEMBER_DECLARATION);
        }
        this.astStack.closeASTScope();
        IASTName name = hasName ? (IASTName)this.astStack.pop() : this.nodeFactory.newName();
        typeSpec.setName(name);
        name.setParent((IASTNode)typeSpec);
        name.setPropertyInParent(IASTCompositeTypeSpecifier.TYPE_NAME);
        this.setOffsetAndLength((IASTNode)typeSpec);
        this.astStack.push(typeSpec);
    }

    public void consumeTypeSpecifierElaborated(int kind) {
        ICASTElaboratedTypeSpecifier typeSpec = this.nodeFactory.newCElaboratedTypeSpecifier();
        typeSpec.setKind(kind);
        IASTName name = (IASTName)this.astStack.pop();
        typeSpec.setName(name);
        name.setParent((IASTNode)typeSpec);
        name.setPropertyInParent(IASTElaboratedTypeSpecifier.TYPE_NAME);
        this.setOffsetAndLength((IASTNode)typeSpec);
        this.astStack.push(typeSpec);
    }

    public void consumeTypeSpecifierEnumeration(boolean hasIdentifier) {
        ICASTEnumerationSpecifier enumSpec = this.nodeFactory.newCEnumerationSpecifier();
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            IASTEnumerationSpecifier.IASTEnumerator enumerator = (IASTEnumerationSpecifier.IASTEnumerator)iter.next();
            enumSpec.addEnumerator(enumerator);
            enumerator.setParent((IASTNode)enumSpec);
            enumerator.setPropertyInParent(ICASTEnumerationSpecifier.ENUMERATOR);
        }
        this.astStack.closeASTScope();
        IASTName name = hasIdentifier ? (IASTName)this.astStack.pop() : this.nodeFactory.newName();
        enumSpec.setName(name);
        name.setParent((IASTNode)enumSpec);
        name.setPropertyInParent(ICASTEnumerationSpecifier.ENUMERATION_NAME);
        this.setOffsetAndLength((IASTNode)enumSpec);
        this.astStack.push(enumSpec);
    }

    public void consumeEnumerator(boolean hasInitializer) {
        IASTEnumerationSpecifier.IASTEnumerator enumerator = this.nodeFactory.newEnumerator();
        if (hasInitializer) {
            IASTExpression expr = (IASTExpression)this.astStack.pop();
            enumerator.setValue(expr);
            expr.setParent((IASTNode)enumerator);
            expr.setPropertyInParent(IASTEnumerationSpecifier.IASTEnumerator.ENUMERATOR_VALUE);
        }
        IASTName name = (IASTName)this.astStack.pop();
        enumerator.setName(name);
        name.setParent((IASTNode)enumerator);
        name.setPropertyInParent(IASTEnumerationSpecifier.IASTEnumerator.ENUMERATOR_NAME);
        this.setOffsetAndLength((IASTNode)enumerator);
        this.astStack.push(enumerator);
    }

    public void consumeStatementCompoundStatement() {
        IASTCompoundStatement block = this.nodeFactory.newCompoundStatement();
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            IASTStatement statement = (IASTStatement)iter.next();
            block.addStatement(statement);
            statement.setParent((IASTNode)block);
            statement.setPropertyInParent(IASTCompoundStatement.NESTED_STATEMENT);
        }
        this.astStack.closeASTScope();
        this.setOffsetAndLength((IASTNode)block);
        this.astStack.push(block);
    }

    public void consumeStatementEmptyCompoundStatement() {
        IASTCompoundStatement block = this.nodeFactory.newCompoundStatement();
        this.setOffsetAndLength((IASTNode)block);
        this.astStack.push(block);
    }

    public void consumeStatementForLoop(boolean hasExpr1, boolean hasExpr2, boolean hasExpr3) {
        IASTExpression expr;
        IASTForStatement forStat = this.nodeFactory.newForStatement();
        IASTStatement body = (IASTStatement)this.astStack.pop();
        forStat.setBody(body);
        body.setParent((IASTNode)forStat);
        body.setPropertyInParent(IASTForStatement.BODY);
        if (hasExpr3) {
            expr = (IASTExpression)this.astStack.pop();
            forStat.setIterationExpression(expr);
            expr.setParent((IASTNode)forStat);
            expr.setPropertyInParent(IASTForStatement.ITERATION);
        }
        if (hasExpr2) {
            expr = (IASTExpression)this.astStack.pop();
            forStat.setConditionExpression(expr);
            expr.setParent((IASTNode)forStat);
            expr.setPropertyInParent(IASTForStatement.CONDITION);
        }
        if (hasExpr1) {
            IASTNode node = (IASTNode)this.astStack.pop();
            if (node instanceof IASTExpression) {
                IASTExpressionStatement stat = this.nodeFactory.newExpressionStatement();
                IASTExpression expr2 = (IASTExpression)node;
                stat.setExpression(expr2);
                expr2.setParent((IASTNode)stat);
                expr2.setPropertyInParent(IASTExpressionStatement.EXPFRESSION);
                forStat.setInitializerStatement((IASTStatement)stat);
                stat.setParent((IASTNode)forStat);
                stat.setPropertyInParent(IASTForStatement.INITIALIZER);
            } else if (node instanceof IASTDeclaration) {
                IASTDeclarationStatement stat = this.nodeFactory.newDeclarationStatement();
                IASTDeclaration declaration = (IASTDeclaration)node;
                stat.setDeclaration(declaration);
                declaration.setParent((IASTNode)stat);
                declaration.setPropertyInParent(IASTDeclarationStatement.DECLARATION);
                forStat.setInitializerStatement((IASTStatement)stat);
                stat.setParent((IASTNode)forStat);
                stat.setPropertyInParent(IASTForStatement.INITIALIZER);
            }
        } else {
            forStat.setInitializerStatement((IASTStatement)this.nodeFactory.newNullStatement());
        }
        this.setOffsetAndLength((IASTNode)forStat);
        this.astStack.push(forStat);
    }

    public void consumeStatementWhileLoop() {
        IASTWhileStatement stat = this.nodeFactory.newWhileStatement();
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        stat.setBody(body);
        body.setParent((IASTNode)stat);
        body.setPropertyInParent(IASTWhileStatement.BODY);
        stat.setCondition(condition);
        condition.setParent((IASTNode)stat);
        condition.setPropertyInParent(IASTWhileStatement.CONDITIONEXPRESSION);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementDoLoop() {
        IASTDoStatement stat = this.nodeFactory.newDoStatement();
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        IASTStatement body = (IASTStatement)this.astStack.pop();
        stat.setCondition(condition);
        condition.setParent((IASTNode)stat);
        condition.setPropertyInParent(IASTDoStatement.CONDITION);
        stat.setBody(body);
        body.setParent((IASTNode)stat);
        body.setPropertyInParent(IASTDoStatement.BODY);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementDeclaration() {
        IASTDeclaration decl = (IASTDeclaration)this.astStack.pop();
        if (this.disambiguateHackIdentifierExpression(decl)) {
            return;
        }
        if (this.disambiguateHackFunctionCall(decl)) {
            return;
        }
        IASTDeclarationStatement stat = this.nodeFactory.newDeclarationStatement();
        stat.setDeclaration(decl);
        decl.setParent((IASTNode)stat);
        decl.setPropertyInParent(IASTDeclarationStatement.DECLARATION);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
        this.disambiguateHackMultiplicationExpression();
    }

    private void disambiguateHackMultiplicationExpression() {
        List tokens = this.parser.getRuleTokens();
        if (!this.matchKinds(tokens, new int[]{2, 3, 2, 30})) {
            return;
        }
        IASTDeclarationStatement declStat = (IASTDeclarationStatement)this.astStack.pop();
        IToken ident1 = (IToken)tokens.get(0);
        IASTName name1 = this.createName(ident1);
        IASTIdExpression id1 = this.nodeFactory.newIdExpression();
        id1.setName(name1);
        name1.setParent((IASTNode)id1);
        name1.setPropertyInParent(IASTIdExpression.ID_NAME);
        this.setOffsetAndLength((IASTNode)id1, ident1);
        IToken ident2 = (IToken)tokens.get(2);
        IASTName name2 = this.createName(ident2);
        IASTIdExpression id2 = this.nodeFactory.newIdExpression();
        id2.setName(name2);
        name2.setParent((IASTNode)id2);
        name2.setPropertyInParent(IASTIdExpression.ID_NAME);
        this.setOffsetAndLength((IASTNode)id2);
        this.astStack.push(id1);
        this.astStack.push(id2);
        this.consumeExpressionBinaryOperator(1);
        this.consumeStatementExpression();
        IASTExpressionStatement exprStat = (IASTExpressionStatement)this.astStack.pop();
        IASTAmbiguousStatement ambiguousStatement = this.nodeFactory.newAmbiguousStatement();
        ambiguousStatement.addStatement((IASTStatement)declStat);
        declStat.setParent((IASTNode)ambiguousStatement);
        declStat.setPropertyInParent(IASTAmbiguousExpression.SUBEXPRESSION);
        ambiguousStatement.addStatement((IASTStatement)exprStat);
        exprStat.setParent((IASTNode)ambiguousStatement);
        exprStat.setPropertyInParent(IASTAmbiguousExpression.SUBEXPRESSION);
        this.astStack.push(ambiguousStatement);
    }

    private boolean disambiguateHackIdentifierExpression(IASTDeclaration decl) {
        ICASTTypedefNameSpecifier typedefNameSpec;
        IASTName name;
        IASTDeclSpecifier declSpec;
        IASTSimpleDeclaration declaration;
        if (decl instanceof IASTSimpleDeclaration && (declaration = (IASTSimpleDeclaration)decl).getDeclarators() == IASTDeclarator.EMPTY_DECLARATOR_ARRAY && (declSpec = declaration.getDeclSpecifier()) instanceof ICASTTypedefNameSpecifier && C99ParserAction.offset((IASTNode)(name = (typedefNameSpec = (ICASTTypedefNameSpecifier)declSpec).getName())) == C99ParserAction.offset((IASTNode)typedefNameSpec) && C99ParserAction.length((IASTNode)name) == C99ParserAction.length((IASTNode)typedefNameSpec)) {
            IASTExpressionStatement stat = this.nodeFactory.newExpressionStatement();
            IASTIdExpression idExpr = this.nodeFactory.newIdExpression();
            idExpr.setName(name);
            name.setParent((IASTNode)idExpr);
            name.setPropertyInParent(IASTIdExpression.ID_NAME);
            stat.setExpression((IASTExpression)idExpr);
            idExpr.setParent((IASTNode)stat);
            idExpr.setPropertyInParent(IASTExpressionStatement.EXPFRESSION);
            this.setOffsetAndLength((IASTNode)stat);
            this.astStack.push(stat);
            return true;
        }
        return false;
    }

    private boolean disambiguateHackFunctionCall(IASTDeclaration decl) {
        if (!(decl instanceof IASTSimpleDeclaration)) {
            return false;
        }
        List tokens = this.parser.getRuleTokens();
        if (!this.matchKinds(tokens, new int[]{2, 1, 2, 48, 30})) {
            return false;
        }
        IASTName name = this.createName((IToken)tokens.get(0));
        IASTIdExpression functionName = this.nodeFactory.newIdExpression();
        functionName.setName(name);
        name.setParent((IASTNode)functionName);
        name.setPropertyInParent(IASTIdExpression.ID_NAME);
        this.setOffsetAndLength((IASTNode)functionName, C99ParserAction.offset((IASTNode)name), C99ParserAction.length((IASTNode)name));
        IASTName name2 = this.createName((IToken)tokens.get(2));
        IASTIdExpression parameter = this.nodeFactory.newIdExpression();
        parameter.setName(name2);
        name2.setParent((IASTNode)parameter);
        name2.setPropertyInParent(IASTIdExpression.ID_NAME);
        this.setOffsetAndLength((IASTNode)parameter, C99ParserAction.offset((IASTNode)name2), C99ParserAction.length((IASTNode)name2));
        IASTFunctionCallExpression expr = this.nodeFactory.newFunctionCallExpression();
        expr.setFunctionNameExpression((IASTExpression)functionName);
        functionName.setParent((IASTNode)expr);
        functionName.setPropertyInParent(IASTFunctionCallExpression.FUNCTION_NAME);
        expr.setParameterExpression((IASTExpression)parameter);
        parameter.setParent((IASTNode)expr);
        parameter.setPropertyInParent(IASTFunctionCallExpression.PARAMETERS);
        IToken rightParen = (IToken)tokens.get(3);
        this.setOffsetAndLength((IASTNode)expr, C99ParserAction.offset((IASTNode)name), C99ParserAction.endOffset(rightParen) - C99ParserAction.offset((IASTNode)name));
        IASTExpressionStatement stat = this.nodeFactory.newExpressionStatement();
        stat.setExpression((IASTExpression)expr);
        expr.setParent((IASTNode)stat);
        expr.setPropertyInParent(IASTExpressionStatement.EXPFRESSION);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
        return true;
    }

    public void consumeStatementGoto() {
        IASTName name = (IASTName)this.astStack.pop();
        IASTGotoStatement gotoStat = this.nodeFactory.newGotoStatement();
        gotoStat.setName(name);
        name.setParent((IASTNode)gotoStat);
        name.setPropertyInParent(IASTGotoStatement.NAME);
        this.setOffsetAndLength((IASTNode)gotoStat);
        this.astStack.push(gotoStat);
    }

    public void consumeStatementContinue() {
        IASTContinueStatement stat = this.nodeFactory.newContinueStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementBreak() {
        IASTBreakStatement stat = this.nodeFactory.newBreakStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementReturn(boolean hasExpression) {
        IASTReturnStatement returnStat = this.nodeFactory.newReturnStatement();
        if (hasExpression) {
            IASTExpression expr = (IASTExpression)this.astStack.pop();
            returnStat.setReturnValue(expr);
            expr.setParent((IASTNode)returnStat);
            expr.setPropertyInParent(IASTReturnStatement.RETURNVALUE);
        }
        this.setOffsetAndLength((IASTNode)returnStat);
        this.astStack.push(returnStat);
    }

    public void consumeStatementNull() {
        IASTNullStatement stat = this.nodeFactory.newNullStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementExpression() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTExpressionStatement stat = this.nodeFactory.newExpressionStatement();
        stat.setExpression(expr);
        expr.setParent((IASTNode)stat);
        expr.setPropertyInParent(IASTExpressionStatement.EXPFRESSION);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementLabeled() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTName label = (IASTName)this.astStack.pop();
        IASTLabelStatement stat = this.nodeFactory.newLabelStatement();
        stat.setNestedStatement(body);
        body.setParent((IASTNode)stat);
        body.setPropertyInParent(IASTLabelStatement.NESTED_STATEMENT);
        stat.setName(label);
        label.setParent((IASTNode)stat);
        label.setPropertyInParent(IASTLabelStatement.NAME);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementCase() {
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTCaseStatement caseStatement = this.nodeFactory.newCaseStatement();
        caseStatement.setExpression(expr);
        expr.setParent((IASTNode)caseStatement);
        expr.setPropertyInParent(IASTCaseStatement.EXPRESSION);
        this.setOffsetAndLength((IASTNode)caseStatement);
        this.astStack.push(caseStatement);
    }

    public void consumeStatementDefault() {
        IASTDefaultStatement stat = this.nodeFactory.newDefaultStatement();
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementSwitch() {
        IASTStatement body = (IASTStatement)this.astStack.pop();
        IASTExpression expr = (IASTExpression)this.astStack.pop();
        IASTSwitchStatement stat = this.nodeFactory.newSwitchStatment();
        stat.setBody(body);
        body.setParent((IASTNode)stat);
        body.setPropertyInParent(IASTSwitchStatement.BODY);
        stat.setControllerExpression(expr);
        expr.setParent((IASTNode)stat);
        expr.setPropertyInParent(IASTSwitchStatement.CONTROLLER_EXP);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementIfThen() {
        IASTStatement thenClause = (IASTStatement)this.astStack.pop();
        IASTExpression condition = (IASTExpression)this.astStack.pop();
        IASTIfStatement stat = this.nodeFactory.newIfStatement();
        stat.setConditionExpression(condition);
        condition.setParent((IASTNode)stat);
        condition.setPropertyInParent(IASTIfStatement.CONDITION);
        stat.setThenClause(thenClause);
        thenClause.setParent((IASTNode)stat);
        thenClause.setPropertyInParent(IASTIfStatement.THEN);
        this.setOffsetAndLength((IASTNode)stat);
        this.astStack.push(stat);
    }

    public void consumeStatementIfThenElse() {
        IASTStatement elseClause = (IASTStatement)this.astStack.pop();
        this.consumeStatementIfThen();
        IASTIfStatement stat = (IASTIfStatement)this.astStack.pop();
        stat.setElseClause(elseClause);
        elseClause.setParent((IASTNode)stat);
        elseClause.setPropertyInParent(IASTIfStatement.ELSE);
        this.astStack.push(stat);
    }

    public void consumeTranslationUnit() {
        IASTTranslationUnit tu = this.nodeFactory.newTranslationUnit();
        tu.setParent(null);
        tu.setPropertyInParent(null);
        Iterator iter = this.astStack.topScopeIterator();
        while (iter.hasNext()) {
            IASTDeclaration declaration = (IASTDeclaration)iter.next();
            tu.addDeclaration(declaration);
            declaration.setParent((IASTNode)tu);
            declaration.setPropertyInParent(IASTTranslationUnit.OWNED_DECLARATION);
        }
        IToken eof = this.parser.getEOFToken();
        this.setOffsetAndLength((IASTNode)tu, 0, eof.getEndOffset());
        this.astStack.push(tu);
    }

    public void consumeFunctionDefinition(boolean hasDeclSpecifiers) {
        ICASTSimpleDeclSpecifier declSpecifier;
        IASTFunctionDefinition def = this.nodeFactory.newFunctionDefinition();
        IASTCompoundStatement body = (IASTCompoundStatement)this.astStack.pop();
        IASTFunctionDeclarator decl = (IASTFunctionDeclarator)this.astStack.pop();
        if (hasDeclSpecifiers) {
            this.astStack.closeASTScope();
            declSpecifier = (IASTDeclSpecifier)this.astStack.pop();
        } else {
            declSpecifier = this.nodeFactory.newCSimpleDeclSpecifier();
        }
        def.setBody((IASTStatement)body);
        body.setParent((IASTNode)def);
        body.setPropertyInParent(IASTFunctionDefinition.FUNCTION_BODY);
        def.setDeclarator(decl);
        decl.setParent((IASTNode)def);
        decl.setPropertyInParent(IASTFunctionDefinition.DECLARATOR);
        def.setDeclSpecifier((IASTDeclSpecifier)declSpecifier);
        declSpecifier.setParent((IASTNode)def);
        declSpecifier.setPropertyInParent(IASTFunctionDefinition.DECL_SPECIFIER);
        this.setOffsetAndLength((IASTNode)def);
        this.astStack.push(def);
    }

    public void consumeFunctionDefinitionKnR() {
        IASTFunctionDefinition def = this.nodeFactory.newFunctionDefinition();
        IASTCompoundStatement body = (IASTCompoundStatement)this.astStack.pop();
        IASTDeclaration[] declarations = (IASTDeclaration[])this.astStack.topScopeArray(new IASTDeclaration[0]);
        this.astStack.closeASTScope();
        ICASTKnRFunctionDeclarator decl = (ICASTKnRFunctionDeclarator)this.astStack.pop();
        this.astStack.closeASTScope();
        ICASTSimpleDeclSpecifier declSpecifier = (ICASTSimpleDeclSpecifier)this.astStack.pop();
        decl.setParameterDeclarations(declarations);
        int i = 0;
        while (i < declarations.length) {
            declarations[i].setParent((IASTNode)decl);
            declarations[i].setPropertyInParent(ICASTKnRFunctionDeclarator.FUNCTION_PARAMETER);
            ++i;
        }
        ASTNode lastDeclaration = (ASTNode)declarations[declarations.length - 1];
        int endOffset = lastDeclaration.getOffset() + lastDeclaration.getLength();
        ((ASTNode)decl).setLength(endOffset - C99ParserAction.offset((IASTNode)decl));
        def.setBody((IASTStatement)body);
        body.setParent((IASTNode)def);
        body.setPropertyInParent(IASTFunctionDefinition.FUNCTION_BODY);
        def.setDeclarator((IASTFunctionDeclarator)decl);
        decl.setParent((IASTNode)def);
        decl.setPropertyInParent(IASTFunctionDefinition.DECLARATOR);
        def.setDeclSpecifier((IASTDeclSpecifier)declSpecifier);
        declSpecifier.setParent((IASTNode)def);
        declSpecifier.setPropertyInParent(IASTFunctionDefinition.DECL_SPECIFIER);
        this.setOffsetAndLength((IASTNode)def);
        this.astStack.push(def);
    }

    public void consumeStatementProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemStatement());
    }

    public void consumeExpressionProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemExpression());
    }

    public void consumeDeclarationProblem() {
        this.consumeProblem((IASTProblemHolder)this.nodeFactory.newProblemDeclaration());
    }

    private void consumeProblem(IASTProblemHolder problemHolder) {
        this.encounteredRecoverableProblem = true;
        IASTProblem problem = this.nodeFactory.newProblem(0x4000001, EMPTY_CHAR_ARRAY, false, true);
        problemHolder.setProblem(problem);
        problem.setParent((IASTNode)problemHolder);
        problem.setPropertyInParent(IASTProblemStatement.PROBLEM);
        this.setOffsetAndLength((IASTNode)problem);
        this.setOffsetAndLength((IASTNode)((ASTNode)problemHolder));
        this.astStack.push(problemHolder);
    }
}

