/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IMacroCollector;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.c99.ILexer;
import org.eclipse.cdt.core.dom.c99.ILexerFactory;
import org.eclipse.cdt.core.dom.c99.IPreprocessorExtensionConfiguration;
import org.eclipse.cdt.core.dom.c99.IPreprocessorTokenCollector;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c99.C99ExprEvaluator;
import org.eclipse.cdt.internal.core.dom.parser.c99.C99Parsersym;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.C99Token;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.IPreprocessorLog;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.InputTokenStream;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Macro;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.MacroArgument;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.MacroEnvironment;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Messages;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.TokenList;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerASTProblem;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerUtility;

public class C99Preprocessor
implements C99Parsersym {
    public static final int OPTION_GENERATE_COMMENTS_FOR_ACTIVE_CODE = 1;
    public static final int OPTION_GENERATE_ALL_COMMENTS = 2;
    private static final String DEFINED_OPERATOR = "defined";
    private static final String DIRECTIVE_COMPLETION_TOKEN_PREFIX = "#";
    private static final int NUM_EOC_TOKENS = 20;
    private final CodeReader codeReader;
    private final IScannerInfo scanInfo;
    private final ILexerFactory lexerFactory;
    private final ICodeReaderFactory codeReaderFactory;
    private final boolean generateAllComments;
    private final boolean generateActiveComments;
    private MacroEnvironment env;
    private TokenList argumentOutputStream;
    private InputTokenStream inputTokenStream;
    private IPreprocessorTokenCollector parser;
    private IPreprocessorLog log;
    private IToken lastTokenOutput = null;
    private int lastKindOutput;
    private boolean encounteredError = false;
    private int macroInvokationDepth = 0;
    static final int PPTOKEN = 0;
    static final int HASH = 1;
    static final int HASHHASH = 2;
    static final int LPAREN = 3;
    static final int NEWLINE = 4;
    static final int IDENT = 5;
    static final int COMMA = 6;
    static final int RPAREN = 7;
    static final int DOTDOTDOT = 8;
    static final int EOF = 99;
    static final String IF = "if";
    static final String IFDEF = "ifdef";
    static final String IFNDEF = "ifndef";
    static final String ELIF = "elif";
    static final String ELSE = "else";
    static final String ENDIF = "endif";
    static final String DEFINE = "define";
    static final String UNDEF = "undef";
    static final String INCLUDE = "include";
    static final String INCLUDE_NEXT = "include_next";
    static final String PRAGMA = "pragma";
    static final String ERROR = "error";
    static final String WARNING = "warning";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.C99Preprocessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public C99Preprocessor(ILexerFactory lexerFactory, CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, int options) {
        this.codeReader = reader;
        this.scanInfo = scanInfo;
        this.lexerFactory = lexerFactory;
        this.codeReaderFactory = fileCreator;
        this.generateActiveComments = (options & 1) != 0;
        this.generateAllComments = (options & 2) != 0;
    }

    public boolean encounteredError() {
        return this.encounteredError;
    }

    public synchronized void preprocess(IPreprocessorTokenCollector parser, IPreprocessorLog log, IPreprocessorExtensionConfiguration extensionConfiguration) {
        if (parser == null) {
            throw new IllegalArgumentException(Messages.getString("C99Preprocessor.0"));
        }
        this.preprocess(parser, log, extensionConfiguration, new InputTokenStream(parser));
    }

    public synchronized void preprocess(IPreprocessorTokenCollector parser, IPreprocessorLog log, IPreprocessorExtensionConfiguration extensionConfiguration, int contentAssistOffset) {
        if (parser == null) {
            throw new IllegalArgumentException(Messages.getString("C99Preprocessor.0"));
        }
        if (contentAssistOffset < 0) {
            throw new IllegalArgumentException(Messages.getString("C99Preprocessor.2"));
        }
        InputTokenStream inputTokenStream = new InputTokenStream(parser);
        inputTokenStream.setContentAssistOffset(contentAssistOffset);
        this.preprocess(parser, log, extensionConfiguration, inputTokenStream);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void preprocess(IPreprocessorTokenCollector parser, IPreprocessorLog log, IPreprocessorExtensionConfiguration extensionConfiguration, InputTokenStream inputTokenStream) {
        if (!$assertionsDisabled && inputTokenStream == null) {
            throw new AssertionError();
        }
        this.log = log;
        this.parser = parser;
        this.env = new MacroEnvironment();
        this.inputTokenStream = inputTokenStream;
        try {
            try {
                inputTokenStream.setCollectCommentTokens(this.generateActiveComments | this.generateAllComments);
                if (this.scanInfo != null) {
                    this.addMacroDefinitions(this.scanInfo.getDefinedSymbols());
                }
                if (extensionConfiguration != null) {
                    this.addMacroDefinitions(extensionConfiguration.getAdditionalMacros());
                }
                parser.addToken(C99Token.DUMMY_TOKEN);
                if (log != null) {
                    log.startTranslationUnit(this.codeReader);
                }
                TokenList tokenList = this.lex(this.codeReader);
                inputTokenStream.pushIncludeContext(tokenList, this.codeReader, 0, false, null);
                this.processExtendedScannerInfoMacrosAndIncludes();
                this.process();
                int tuSize = inputTokenStream.getTranslationUnitSize();
                parser.addToken(new C99Token(tuSize, tuSize, 73, "<EOF>"));
                if (log != null) {
                    log.endTranslationUnit(tuSize);
                }
            }
            catch (PreprocessorAbortParseException preprocessorAbortParseException) {
                this.encounteredError = true;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.parser = null;
            this.inputTokenStream = null;
            this.log = null;
            this.env = null;
            this.lastTokenOutput = null;
            this.macroInvokationDepth = 0;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.parser = null;
            this.inputTokenStream = null;
            this.log = null;
            this.env = null;
            this.lastTokenOutput = null;
            this.macroInvokationDepth = 0;
            return;
        }
    }

    private TokenList lex(CodeReader codeReader) {
        ILexer lexer = this.lexerFactory.createLexer(codeReader);
        boolean generateComments = this.generateActiveComments | this.generateAllComments;
        int lexerOptions = generateComments ? 1 : 0;
        return lexer.lex(lexerOptions);
    }

    private void processExtendedScannerInfoMacrosAndIncludes() {
        if (this.scanInfo instanceof IExtendedScannerInfo) {
            IExtendedScannerInfo einfo = (IExtendedScannerInfo)this.scanInfo;
            this.addExtendedScannerInfoIncludes(einfo.getMacroFiles());
            this.addExtendedScannerInfoIncludes(einfo.getIncludeFiles());
        }
    }

    private void addExtendedScannerInfoIncludes(String[] paths) {
        if (paths == null) {
            return;
        }
        int i = 0;
        while (i < paths.length) {
            CodeReader cr = this.codeReaderFactory.createCodeReaderForInclusion(null, paths[i]);
            if (cr != null) {
                int offset = this.inputTokenStream.getCurrentOffset();
                this.addIncludedFileToInputStream(cr, offset, offset, offset, offset, "", true, true);
                this.process();
                this.inputTokenStream.resume();
            }
            ++i;
        }
    }

    private void addMacroDefinitions(Map definedSymbols) {
        if (definedSymbols == null) {
            return;
        }
        Iterator iter = definedSymbols.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.registerMacro((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private Macro registerMacroInLocalEnvironment(String signature, String expansion) {
        String define = String.valueOf(signature) + " " + expansion;
        TokenList tokenList = this.lex(new CodeReader(define.toCharArray()));
        this.inputTokenStream.pushIsolatedContext(tokenList, null);
        Macro macro = this.defineDirective(0, false);
        this.inputTokenStream.resume();
        return macro;
    }

    private void registerMacro(String signature, String expansion) {
        Macro macro = this.registerMacroInLocalEnvironment(signature, expansion);
        if (macro != null && this.log != null) {
            this.log.registerBuiltinMacro(macro);
        }
    }

    private void registerMacro(IMacro m) {
        if (m == null) {
            return;
        }
        String signature = new String(m.getSignature());
        String expansion = new String(m.getExpansion());
        this.registerMacroInLocalEnvironment(signature, expansion);
        if (this.log != null) {
            this.log.registerIndexMacro(m);
        }
    }

    private CodeReader createCodeReader(String path, String fileName) {
        String finalPath = ScannerUtility.createReconciledPath((String)path, (String)fileName);
        IMacroCollector indexMacroCollector = new IMacroCollector(){

            public void addDefinition(IMacro macro) {
                C99Preprocessor.this.registerMacro(macro);
            }
        };
        return this.codeReaderFactory.createCodeReaderForInclusion(indexMacroCollector, finalPath);
    }

    private void addIncludedFileToInputStream(final CodeReader reader, int directiveStartOffset, int directiveEndOffset, int nameStartOffset, int nameEndOffset, String name, boolean systemInclude, boolean isolated) {
        TokenList tokens = this.lex(reader);
        if (this.log != null) {
            this.log.startInclusion(reader, directiveStartOffset, directiveEndOffset, nameStartOffset, nameEndOffset, name.toCharArray(), systemInclude);
        }
        InputTokenStream.IIncludeContextCallback callback = null;
        if (this.log != null) {
            callback = new InputTokenStream.IIncludeContextCallback(){

                public void contextClosed() {
                    C99Preprocessor.this.log.endInclusion(reader, C99Preprocessor.this.inputTokenStream.adjust(reader.buffer.length));
                }
            };
        }
        this.inputTokenStream.pushIncludeContext(tokens, reader, directiveEndOffset, isolated, callback);
    }

    public String toString() {
        return this.inputTokenStream.toString();
    }

    private void addToOutputStream(IToken t) {
        if (this.argumentOutputStream != null) {
            this.argumentOutputStream.add(t);
            return;
        }
        switch (t.getKind()) {
            case 95: 
            case 97: {
                return;
            }
            case 99: {
                t.setKind(2);
                break;
            }
            case 98: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        IToken toOutput = t;
        if (this.lastTokenOutput != null && t.getKind() == 27 && this.lastKindOutput == 27) {
            String s1 = this.lastTokenOutput.toString();
            String s2 = toOutput.toString();
            if (!($assertionsDisabled || s1.length() >= 2 && s2.length() != 2)) {
                throw new AssertionError();
            }
            String rep = String.valueOf(s1.substring(0, s1.length() - 1)) + s2.substring(1);
            ((C99Token)this.lastTokenOutput).setRepresentation(rep);
            this.lastTokenOutput.setEndOffset(toOutput.getEndOffset());
        } else {
            this.lastTokenOutput = toOutput;
            this.lastKindOutput = toOutput.getKind();
            this.parser.addToken(toOutput);
        }
    }

    private static int toPPToken(IToken token) {
        if (token == null) {
            return 99;
        }
        switch (token.getKind()) {
            case 93: {
                return 1;
            }
            case 94: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 95: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 29: {
                return 6;
            }
            case 48: {
                return 7;
            }
            case 63: {
                return 8;
            }
            case 73: {
                return 99;
            }
        }
        return 0;
    }

    private boolean check(int pptoken) {
        IToken token = this.inputTokenStream.peek();
        if (token == null) {
            return false;
        }
        return pptoken == C99Preprocessor.toPPToken(token);
    }

    private boolean check(String directive) {
        IToken token = this.inputTokenStream.peek();
        if (token == null) {
            return false;
        }
        return directive.equals(token.toString());
    }

    private boolean done() {
        IToken token = this.inputTokenStream.peek();
        return token == null || token.getKind() == 73;
    }

    private IToken expect(int pptoken) {
        if (this.check(pptoken)) {
            return this.next();
        }
        throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
    }

    private IToken expect(String directive) {
        if (this.check(directive)) {
            return this.next();
        }
        throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
    }

    private IToken next() {
        return this.inputTokenStream.next(true);
    }

    private IToken next(boolean adjust) {
        return this.inputTokenStream.next(adjust);
    }

    private void encounterProblem(int id, IToken token) {
        if (token != null) {
            this.encounterProblem(id, token.getStartOffset(), token.getEndOffset(), null);
        } else {
            int offset = this.inputTokenStream.getCurrentOffset();
            this.encounterProblem(id, offset, offset, null);
        }
    }

    private void encounterProblem(int id, int startOffset, int endOffset) {
        this.encounterProblem(id, startOffset, endOffset, null);
    }

    private void encounterProblem(int id, TokenList tokenList) {
        int start = tokenList.first().getStartOffset();
        int end = tokenList.last().getEndOffset();
        this.encounterProblem(id, start, end, C99Preprocessor.createProblemArg(tokenList));
    }

    private void encounterProblem(int id, int startOffset, int endOffset, char[] arg) {
        ScannerASTProblem problem = new ScannerASTProblem(id, arg, true, false);
        problem.setOffsetAndLength(startOffset, endOffset - startOffset + 1);
        if (this.log != null) {
            this.log.encounterProblem((IASTProblem)problem);
        }
    }

    private static char[] createProblemArg(TokenList tokenList) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = tokenList.iterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            sb.append(token.toString());
            if (!iter.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString().toCharArray();
    }

    /*
     * Unable to fully structure code
     */
    private void process() {
        while (!this.done()) {
            try {
                if (this.check(1)) {
                    encounteredPoundElse = this.controlLine();
                    if (!encounteredPoundElse) continue;
                    throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
                }
                this.textLine();
                continue;
            }
            catch (PreprocessorInternalParseException v0) {
                if (this.inputTokenStream.isContentAssistMode()) {
                    throw new PreprocessorAbortParseException();
                }
                if (this.done()) {
                    offset = this.inputTokenStream.getCurrentOffset();
                    this.encounterProblem(0x4000001, offset, offset);
                    continue;
                }
                if (this.check(4)) {
                    token = this.next();
                    this.encounterProblem(0x4000001, token);
                    return;
                }
                token = this.next();
                this.encounterProblem(0x4000001, token);
                ** while (!this.check((int)4) && !this.done())
            }
lbl-1000:
            // 1 sources

            {
                token = this.next();
                continue;
            }
lbl25:
            // 1 sources

            if (!this.check(4)) continue;
            var1_4 = this.next();
        }
    }

    private int processBranch() {
        while (!this.done()) {
            if (this.check(1)) {
                int hashOffset = this.inputTokenStream.adjust(this.inputTokenStream.peek().getStartOffset());
                boolean encounteredPoundElse = this.controlLine();
                if (!encounteredPoundElse) continue;
                return hashOffset;
            }
            this.textLine();
        }
        throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
    }

    private int skipBranch() {
        if (!this.generateAllComments) {
            this.inputTokenStream.setCollectCommentTokens(false);
        }
        int depth = 0;
        while (!this.done()) {
            if (this.check(1)) {
                IToken hash = this.next();
                int directiveStartOffset = hash.getStartOffset();
                if (this.check(INCLUDE) || this.check(INCLUDE_NEXT)) {
                    boolean includeNext = this.check(INCLUDE_NEXT);
                    this.next();
                    this.includeDirective(directiveStartOffset, false, includeNext);
                    continue;
                }
                if (this.check(IF)) {
                    this.handleIf(directiveStartOffset, false);
                    ++depth;
                    continue;
                }
                if (this.check(IFDEF) || this.check(IFNDEF)) {
                    this.handleIfDef(directiveStartOffset);
                    ++depth;
                    continue;
                }
                if (this.check(ELIF)) {
                    if (depth == 0) {
                        return directiveStartOffset;
                    }
                    this.handleIf(directiveStartOffset, false);
                    continue;
                }
                if (this.check(ELSE)) {
                    if (depth == 0) {
                        return directiveStartOffset;
                    }
                    this.handleElse(directiveStartOffset, false);
                    continue;
                }
                if (!this.check(ENDIF)) continue;
                if (depth == 0) {
                    this.inputTokenStream.setCollectCommentTokens(this.generateActiveComments || this.generateAllComments);
                    return directiveStartOffset;
                }
                --depth;
                this.handleEndif(directiveStartOffset);
                continue;
            }
            this.skipLine();
        }
        throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
    }

    String spaces(int x) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < x) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private void skipLine() {
        while (!this.check(4) && !this.done()) {
            this.next();
        }
        if (!this.done()) {
            this.next();
        }
    }

    private void handleBasicContentAssistOffsetReached() {
        C99Token completionToken;
        if (!$assertionsDisabled && !this.inputTokenStream.isContentAssistOffsetReached()) {
            throw new AssertionError();
        }
        if (this.inputTokenStream.isEmpty()) {
            int endOffset = this.inputTokenStream.getTranslationUnitSize();
            C99Token completionToken2 = new C99Token(endOffset, endOffset, 8, "");
            this.addCompletionTokenToOutputAndQuit(completionToken2);
            return;
        }
        IToken token = this.inputTokenStream.peek();
        int cursorOffset = this.inputTokenStream.getContentAssistOffset();
        int adjustedOffset = this.inputTokenStream.adjust(cursorOffset) - 1;
        if (token.getStartOffset() >= cursorOffset) {
            completionToken = new C99Token(adjustedOffset, adjustedOffset, 8, "");
        } else if (token.getKind() == 2) {
            int startOffset = token.getStartOffset();
            int prefixLength = cursorOffset - startOffset;
            String prefix = token.toString().substring(0, prefixLength);
            int newStartOffset = this.inputTokenStream.adjust(startOffset);
            int newEndOffset = this.inputTokenStream.adjust(startOffset + prefixLength);
            completionToken = new C99Token(newStartOffset, newEndOffset, 8, prefix);
        } else if (token.getEndOffset() == cursorOffset - 1) {
            completionToken = new C99Token(adjustedOffset, adjustedOffset, 8, "");
            this.addToOutputStream(this.next());
        } else {
            throw new PreprocessorAbortParseException();
        }
        this.addCompletionTokenToOutputAndQuit(completionToken);
    }

    private void addCompletionTokenToOutputAndQuit(IToken completionToken) {
        if (!$assertionsDisabled && completionToken.getKind() != 8) {
            throw new AssertionError();
        }
        this.addToOutputStream(completionToken);
        int offset = completionToken.getEndOffset() + 1;
        int i = 0;
        while (i < 20) {
            this.addToOutputStream(new C99Token(offset, offset, 4, ""));
            ++i;
        }
        this.inputTokenStream = new InputTokenStream(this.parser);
    }

    private void addCompletionTokenToOutputAndQuit(int offset, String prefix) {
        this.addCompletionTokenToOutputAndQuit(new C99Token(offset, offset, 8, prefix));
    }

    private void textLine(boolean handleDefined) {
        while (true) {
            if (this.inputTokenStream.isContentAssistOffsetReached() && !handleDefined) {
                this.handleBasicContentAssistOffsetReached();
                return;
            }
            if (this.check(4) || this.done()) break;
            IToken currentToken = this.inputTokenStream.peek();
            if (handleDefined && this.check(5) && DEFINED_OPERATOR.equals(currentToken.toString())) {
                this.next();
                this.handleDefinedOperator();
                continue;
            }
            if (this.check(5) && this.env.hasMacro(currentToken.toString())) {
                Macro macro = this.env.get(currentToken.toString());
                this.macroCall(macro);
                continue;
            }
            this.addToOutputStream(this.next());
        }
        if (this.check(4)) {
            this.next();
        }
    }

    private void textLine() {
        this.textLine(false);
    }

    private void handleDefinedOperator() {
        IToken ident;
        if (this.check(3)) {
            this.next();
            ident = this.expect(5);
            this.expect(7);
        } else if (this.check(5)) {
            ident = this.next();
        } else {
            throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
        }
        String val = this.env.hasMacro(ident.toString()) ? "1" : "0";
        this.addToOutputStream(new C99Token(0, 0, 24, val));
    }

    private void macroCall(Macro macro) {
        int expansionLocationOffset;
        TokenList replacement;
        IToken macroId = this.next();
        int startOffset = macroId.getStartOffset();
        char[][] argsAsChar = null;
        if (macro.isObjectLike()) {
            replacement = this.invoke(macro, null);
            if (replacement == null) {
                this.encounterProblem(0x2000009, macroId);
            }
            expansionLocationOffset = macroId.getEndOffset() + 1;
        } else {
            MacroExpansionCallback callback = null;
            if (this.inputTokenStream.inMacroExpansionContext()) {
                callback = (MacroExpansionCallback)this.inputTokenStream.getCurrentContextCallback();
                callback.disabled = true;
            }
            while (this.check(4)) {
                this.next();
            }
            if (!this.check(3)) {
                if (callback != null && callback.popped && callback.disabled) {
                    callback.disabled = false;
                    callback.contextClosed();
                }
                this.addToOutputStream(macroId);
                return;
            }
            this.next();
            List arguments = this.collectArgumentsToFunctionLikeMacro(macroId, macro);
            if (arguments == null) {
                this.encounterProblem(0x2000009, macroId);
                return;
            }
            argsAsChar = C99Preprocessor.convertArgsToCharArrays(arguments);
            replacement = this.invoke(macro, arguments);
            if (replacement == null) {
                this.encounterProblem(0x2000009, macroId);
                return;
            }
            IToken rparen = this.next();
            expansionLocationOffset = rparen.getEndOffset() + 1;
            if (callback != null) {
                callback.disabled = false;
            }
            if (callback != null && callback.popped) {
                callback.macroOverlapClose();
                int replacementLength = callback.expansionEndOffset - callback.directiveEndOffset;
                startOffset = callback.directiveStartOffset;
                expansionLocationOffset -= replacementLength;
                this.inputTokenStream.adjustGlobalOffsets(-replacementLength);
            }
        }
        if (replacement == null || replacement.isEmpty()) {
            if (this.log != null) {
                this.log.startMacroExpansion(macro, startOffset, expansionLocationOffset, argsAsChar);
                this.log.endMacroExpansion(macro, expansionLocationOffset);
            }
        } else {
            int replacementLength = replacement.last().getEndOffset();
            MacroExpansionCallback callback = new MacroExpansionCallback(macro, startOffset, expansionLocationOffset, replacementLength);
            callback.startExpansion(argsAsChar);
            this.inputTokenStream.pushMacroExpansionContext(replacement, expansionLocationOffset, callback, this.macroInvokationDepth == 0);
        }
    }

    private TokenList invoke(Macro macro, List arguments) {
        ++this.macroInvokationDepth;
        TokenList result = macro.invoke(arguments);
        --this.macroInvokationDepth;
        return result;
    }

    private static char[][] convertArgsToCharArrays(List arguments) {
        char[][] chars = new char[arguments.size()][];
        int i = 0;
        while (i < arguments.size()) {
            MacroArgument arg = (MacroArgument)arguments.get(i);
            chars[i] = arg.getRawTokens().toString().toCharArray();
            ++i;
        }
        return chars;
    }

    private List collectArgumentsToFunctionLikeMacro(IToken macroName, Macro macro) {
        ArrayList<TokenList> arguments = new ArrayList<TokenList>();
        int numParams = macro.getNumParams();
        TokenList arg = new TokenList();
        int parenLevel = 0;
        if (this.check(7)) {
            if (macro.getNumParams() > 0) {
                arguments.add(arg);
            }
        } else {
            while (true) {
                if (this.done()) {
                    return null;
                }
                if (this.check(1) || this.check(2)) {
                    return null;
                }
                if (this.check(4)) {
                    this.next();
                    continue;
                }
                if (this.check(6)) {
                    if (parenLevel == 0 && arguments.size() < numParams) {
                        arguments.add(arg);
                        arg = new TokenList();
                        this.next();
                        continue;
                    }
                    arg.add(this.next());
                    continue;
                }
                if (this.check(3)) {
                    ++parenLevel;
                    arg.add(this.next());
                    continue;
                }
                if (this.check(7)) {
                    if (parenLevel == 0) {
                        arguments.add(arg);
                        break;
                    }
                    --parenLevel;
                    arg.add(this.next());
                    continue;
                }
                arg.add(this.next());
            }
        }
        ArrayList<MacroArgument> macroArguments = new ArrayList<MacroArgument>(arguments.size());
        int i = 0;
        while (i < arguments.size()) {
            TokenList its = (TokenList)arguments.get(i);
            macroArguments.add(new MacroArgument(its, new MacroArgument.IProcessCallback(){

                public TokenList process(TokenList tokens) {
                    return C99Preprocessor.this.pushContextAndProcess(tokens, false, false);
                }
            }));
            ++i;
        }
        if (macro.isCorrectNumberOfArguments(macroArguments.size())) {
            return macroArguments;
        }
        return null;
    }

    private IToken findPrefixTokenOnCurrentLine() {
        int contentAssistOffset = this.inputTokenStream.getContentAssistOffset() - 1;
        while (!this.check(4) && !this.done()) {
            IToken token = this.next(false);
            int endOffset = token.getEndOffset();
            if (token.getKind() == 2 && endOffset == contentAssistOffset) {
                return token;
            }
            if (endOffset <= contentAssistOffset) continue;
            return null;
        }
        return null;
    }

    private boolean controlLine() {
        IToken hash = this.next();
        int directiveStartOffset = hash.getStartOffset();
        if (this.inputTokenStream.isContentAssistOffsetReached()) {
            this.addCompletionTokenToOutputAndQuit(directiveStartOffset, DIRECTIVE_COMPLETION_TOKEN_PREFIX);
        } else if (this.inputTokenStream.isContentAssistOffsetOnCurrentLine()) {
            IToken token = this.findPrefixTokenOnCurrentLine();
            this.addCompletionTokenToOutputAndQuit(directiveStartOffset, token == null ? "" : token.toString());
        } else if (this.check(4)) {
            this.next();
        } else if (this.check(DEFINE)) {
            this.next();
            this.defineDirective(directiveStartOffset, true);
        } else if (this.check(UNDEF)) {
            this.next();
            IToken macroName = this.expect(5);
            String name = macroName.toString();
            if (this.log != null) {
                this.log.undefineMacro(directiveStartOffset, macroName.getEndOffset() + 1, name, macroName.getStartOffset());
            }
            this.env.removeMacro(name);
            if (!this.done()) {
                this.expect(4);
            }
        } else if (this.check(INCLUDE) || this.check(INCLUDE_NEXT)) {
            boolean includeNext = this.check(INCLUDE_NEXT);
            this.next();
            this.includeDirective(directiveStartOffset, true, includeNext);
        } else if (this.check(IF) || this.check(IFDEF) || this.check(IFNDEF)) {
            this.ifSection(directiveStartOffset);
        } else {
            if (this.check(ELIF) || this.check(ELSE) || this.check(ENDIF)) {
                return true;
            }
            if (this.check(PRAGMA) || this.check(ERROR) || this.check(WARNING)) {
                boolean isPragma = this.check(PRAGMA);
                boolean isError = this.check(ERROR);
                IToken token = this.next();
                TokenList tokens = this.collectTokensUntilNewlineOrDone();
                int endOffset = 1 + (tokens.isEmpty() ? token.getEndOffset() : tokens.last().getEndOffset());
                char[] body = tokens.toString().toCharArray();
                if (isPragma) {
                    if (this.log != null) {
                        this.log.encounterPoundPragma(directiveStartOffset, endOffset, body);
                    }
                } else if (isError) {
                    if (this.log != null) {
                        this.log.encounterPoundError(directiveStartOffset, endOffset, body);
                    }
                    this.encounterProblem(0x2000001, tokens);
                } else {
                    if (this.log != null) {
                        this.log.encounterPoundError(directiveStartOffset, endOffset, body);
                    }
                    this.encounterProblem(0x200000E, tokens);
                }
                if (!this.done()) {
                    this.expect(4);
                }
            } else {
                IToken invalidDirective = this.next();
                this.encounterProblem(0x2000006, invalidDirective);
                this.skipLine();
            }
        }
        return false;
    }

    private void ifSection(int directiveStartOffset) {
        boolean takeIfBranch = this.check(IFDEF) || this.check(IFNDEF) ? this.handleIfDef(directiveStartOffset) : this.handleIf(directiveStartOffset, true);
        int hashOffset = takeIfBranch ? this.processBranch() : this.skipBranch();
        this.elseGroups(takeIfBranch, hashOffset);
    }

    private void elseGroups(boolean skipRest, int hashOffset) {
        while (!this.done()) {
            if (this.check(ENDIF)) {
                this.handleEndif(hashOffset);
                return;
            }
            if (this.check(ELIF)) {
                boolean followBranch = this.handleIf(hashOffset, !skipRest);
                if (followBranch) {
                    skipRest = true;
                    hashOffset = this.processBranch();
                    continue;
                }
                hashOffset = this.skipBranch();
                continue;
            }
            if (this.check(ELSE)) {
                this.handleElse(hashOffset, !skipRest);
                if (skipRest) {
                    hashOffset = this.skipBranch();
                    continue;
                }
                hashOffset = this.processBranch();
                continue;
            }
            throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
        }
    }

    private boolean handleIfDef(int directiveStartOffset) {
        boolean takeIfBranch;
        boolean isIfdef = this.check(IFDEF);
        this.next();
        IToken ident = this.expect(5);
        this.skipLine();
        boolean bl = takeIfBranch = isIfdef == this.env.hasMacro(ident.toString());
        if (this.log != null) {
            int directiveEndOffset = ident.getEndOffset() + 1;
            char[] condition = ident.toString().toCharArray();
            if (isIfdef) {
                this.log.encounterPoundIfdef(directiveStartOffset, directiveEndOffset, takeIfBranch, condition);
            } else {
                this.log.encounterPoundIfndef(directiveStartOffset, directiveEndOffset, takeIfBranch, condition);
            }
        }
        return takeIfBranch;
    }

    private boolean handleIf(int directiveStartOffset, boolean evaluate) {
        boolean followBranch;
        boolean isIf = this.check(IF);
        IToken ifToken = this.next();
        TokenList expressionTokens = this.collectTokensUntilNewlineOrDone();
        char[] expressionChars = expressionTokens.toString().toCharArray();
        int endOffset = 1 + (expressionTokens.isEmpty() ? ifToken.getEndOffset() : expressionTokens.last().getEndOffset());
        Long value = evaluate ? this.evaluateConstantExpression(expressionTokens) : new Long(0L);
        if (value == null) {
            this.encounterProblem(0x2000008, directiveStartOffset, endOffset);
        }
        if (!this.done()) {
            this.expect(4);
        }
        boolean bl = followBranch = value != null && value != 0L;
        if (this.log != null) {
            if (isIf) {
                this.log.encounterPoundIf(directiveStartOffset, endOffset, followBranch, expressionChars);
            } else {
                this.log.encounterPoundElif(directiveStartOffset, endOffset, followBranch, expressionChars);
            }
        }
        return followBranch;
    }

    private Long evaluateConstantExpression(TokenList expressionTokens) {
        TokenList constantExpression;
        if (expressionTokens == null || expressionTokens.isEmpty()) {
            return null;
        }
        try {
            if (this.log != null) {
                this.log.setIgnoreMacroExpansions(true);
            }
            constantExpression = this.pushContextAndProcess(expressionTokens, true, true);
            if (this.log != null) {
                this.log.setIgnoreMacroExpansions(false);
            }
        }
        catch (PreprocessorInternalParseException preprocessorInternalParseException) {
            return null;
        }
        C99ExprEvaluator evaluator = new C99ExprEvaluator(constantExpression);
        return evaluator.evaluate();
    }

    private void handleElse(int directiveStartOffset, boolean taken) {
        IToken els = this.next();
        if (this.log != null) {
            this.log.encounterPoundElse(directiveStartOffset, els.getEndOffset() + 1, taken);
        }
    }

    private void handleEndif(int directiveStartOffset) {
        IToken endif = this.next();
        if (this.log != null) {
            this.log.encounterPoundEndIf(directiveStartOffset, endif.getEndOffset() + 1);
        }
        if (!this.done()) {
            this.expect(4);
        }
    }

    private void includeDirective(int directiveStart, boolean active, boolean includeNext) {
        TokenList includeBody;
        int directiveEnd;
        int fileNameEnd;
        int fileNameStart;
        File currentDirectory = this.inputTokenStream.getCurrentDirectory();
        String currentFileName = this.inputTokenStream.getCurrentFileName();
        TokenList tokens = this.collectTokensUntilNewlineOrDone();
        if (tokens.isEmpty()) {
            int code = 0x2000002;
            this.encounterProblemInclude(code, directiveStart, directiveStart, directiveStart, directiveStart, null, false);
            return;
        }
        if (tokens.first().getKind() == 69 && tokens.last().getKind() == 70 || tokens.size() == 1 && tokens.first().getKind() == 27) {
            fileNameStart = tokens.first().getStartOffset() + 1;
            fileNameEnd = tokens.last().getEndOffset();
            directiveEnd = fileNameEnd + 1;
            includeBody = tokens;
        } else {
            fileNameStart = tokens.first().getStartOffset();
            directiveEnd = fileNameEnd = tokens.last().getEndOffset() + 1;
            if (this.log != null) {
                this.log.setIgnoreMacroExpansions(true);
            }
            includeBody = this.pushContextAndProcess(tokens, true, false);
            if (this.log != null) {
                this.log.setIgnoreMacroExpansions(false);
            }
        }
        String fileName = C99Preprocessor.computeIncludeFileName(includeBody);
        if (fileName == null) {
            int code = 0x2000002;
            this.encounterProblemInclude(code, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, false);
            return;
        }
        if (!$assertionsDisabled && fileName.length() < 2) {
            throw new AssertionError();
        }
        boolean local = fileName.startsWith("\"");
        fileName = fileName.substring(1, fileName.length() - 1);
        if (!active) {
            if (this.log != null) {
                this.log.encounterPoundInclude(directiveStart, fileNameStart, fileNameEnd, directiveEnd, fileName.toCharArray(), !local, false);
            }
            return;
        }
        CodeReader reader = this.computeCodeReaderForInclusion(fileName, currentDirectory, includeNext, local);
        if (reader == null) {
            this.encounterProblemInclude(0x2000002, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, !local);
        } else if (this.inputTokenStream.isCircularInclusion(reader) || new String(reader.filename).equals(currentFileName)) {
            this.encounterProblemInclude(0x200000B, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, !local);
        } else {
            this.addIncludedFileToInputStream(reader, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, !local, false);
        }
    }

    private CodeReader computeCodeReaderForInclusion(String fileName, File currentDirectory, boolean includeNext, boolean local) {
        String[] standardIncludePaths;
        if (new File(fileName).isAbsolute() || fileName.startsWith("/")) {
            return this.createCodeReader("", fileName);
        }
        if (includeNext) {
            return this.computeCodeReaderForIncludeNext(fileName, currentDirectory);
        }
        CodeReader reader = null;
        if (local && currentDirectory != null && (reader = this.createCodeReader(currentDirectory.getAbsolutePath(), fileName)) != null) {
            return reader;
        }
        if (this.scanInfo != null && (standardIncludePaths = this.scanInfo.getIncludePaths()) != null) {
            int i = 0;
            while (i < standardIncludePaths.length) {
                reader = this.createCodeReader(standardIncludePaths[i], fileName);
                if (reader != null) break;
                ++i;
            }
        }
        return reader;
    }

    private CodeReader computeCodeReaderForIncludeNext(String fileName, File currentDirectory) {
        if (!(this.scanInfo instanceof IExtendedScannerInfo)) {
            return null;
        }
        IExtendedScannerInfo extendedScannerInfo = (IExtendedScannerInfo)this.scanInfo;
        String[] localPaths = extendedScannerInfo.getLocalIncludePath();
        String[] systemPaths = extendedScannerInfo.getIncludePaths();
        String[] allPaths = new String[localPaths.length + systemPaths.length];
        System.arraycopy(localPaths, 0, allPaths, 0, localPaths.length);
        System.arraycopy(systemPaths, 0, allPaths, localPaths.length, systemPaths.length);
        try {
            String parent = currentDirectory.getCanonicalPath();
            int pathIndex = -1;
            int i = 0;
            while (i < allPaths.length) {
                String path = new File(allPaths[i]).getCanonicalPath();
                if (path.equals(parent)) {
                    pathIndex = i;
                    break;
                }
                ++i;
            }
            i = pathIndex + 1;
            while (i < allPaths.length) {
                CodeReader reader = this.createCodeReader(allPaths[i], fileName);
                if (reader != null) {
                    return reader;
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private void encounterProblemInclude(int problemCode, int directiveStart, int directiveEnd, int nameStart, int nameEnd, String fileName, boolean systemInclude) {
        this.encounterProblem(problemCode, directiveStart, directiveEnd - 1);
        if (this.log != null) {
            char[] chars = fileName == null ? null : fileName.toCharArray();
            this.log.encounterPoundInclude(directiveStart, nameStart, nameEnd, directiveEnd, chars, systemInclude, true);
        }
    }

    private static String computeIncludeFileName(TokenList includeBody) {
        if (includeBody == null || includeBody.isEmpty() || includeBody.size() == 2) {
            return null;
        }
        if (includeBody.size() == 1) {
            IToken token = includeBody.first();
            if (token.getKind() == 27) {
                return token.toString();
            }
            return null;
        }
        IToken first = includeBody.first();
        IToken last = includeBody.last();
        if (first.getKind() != 69 || last.getKind() != 70) {
            return null;
        }
        return includeBody.toString();
    }

    private TokenList collectTokensUntilNewlineOrDone() {
        TokenList result = new TokenList();
        while (!this.check(4) && !this.done()) {
            result.add(this.next());
        }
        return result;
    }

    private TokenList pushContextAndProcess(TokenList newInput, boolean singleLine, boolean handleDefined) {
        if (newInput == null || newInput.isEmpty()) {
            return new TokenList();
        }
        TokenList savedArgumentOutputStream = this.argumentOutputStream;
        this.inputTokenStream.pushIsolatedContext(newInput, null);
        this.argumentOutputStream = new TokenList();
        if (singleLine) {
            this.textLine(handleDefined);
        } else {
            this.process();
        }
        this.inputTokenStream.peek();
        if (!this.inputTokenStream.isStuck()) {
            throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
        }
        this.inputTokenStream.resume();
        TokenList result = this.argumentOutputStream;
        this.argumentOutputStream = savedArgumentOutputStream;
        return result;
    }

    private Macro defineDirective(int startOffset, boolean logMacro) {
        Macro macro;
        if (!this.check(5)) {
            IToken badToken = this.next();
            this.encounterProblem(0x2000005, badToken.getStartOffset(), badToken.getEndOffset());
            this.skipLine();
            return null;
        }
        IToken macroName = this.next();
        if (this.check(3) && this.inputTokenStream.getCurrentOffset() == macroName.getEndOffset() + 1) {
            boolean problem;
            IToken rparen;
            LinkedHashSet<String> paramNames;
            String varArgParamName;
            block20: {
                this.next();
                varArgParamName = null;
                paramNames = new LinkedHashSet<String>();
                rparen = null;
                problem = false;
                if (this.check(7)) {
                    rparen = this.next();
                } else {
                    while (this.check(5)) {
                        String paramName = this.next().toString();
                        if (this.check(8)) {
                            this.next();
                            varArgParamName = paramName;
                            if (this.check(7)) {
                                rparen = this.next();
                            } else {
                                problem = true;
                            }
                        } else {
                            paramNames.add(paramName);
                            if (this.check(6)) {
                                this.next();
                                continue;
                            }
                            if (this.check(7)) {
                                rparen = this.next();
                            } else {
                                problem = true;
                            }
                        }
                        break block20;
                    }
                    if (this.check(8)) {
                        this.next();
                        varArgParamName = "__VA_ARGS__";
                        if (this.check(7)) {
                            rparen = this.next();
                        } else {
                            problem = true;
                        }
                    } else {
                        problem = true;
                    }
                }
            }
            if (problem) {
                this.encounterProblem(0x2000005, startOffset, this.inputTokenStream.getCurrentOffset());
                this.skipLine();
                return null;
            }
            TokenList replacementList = this.replacementListTokens(paramNames, varArgParamName);
            if (C99Preprocessor.startsOrEndsWithHashHash(replacementList)) {
                this.encounterProblem(0x200000A, startOffset, this.inputTokenStream.getCurrentOffset());
                this.skipLine();
                return null;
            }
            int endOffset = this.calculateMacroDefinitionEndOffset(rparen, replacementList);
            macro = new Macro(macroName, replacementList, startOffset, endOffset, paramNames, varArgParamName);
        } else {
            TokenList replacementList = this.replacementListTokens(null, null);
            int endOffset = this.calculateMacroDefinitionEndOffset(macroName, replacementList);
            macro = new Macro(macroName, replacementList, startOffset, endOffset);
        }
        this.env.addMacro(macro);
        if (this.log != null && logMacro) {
            this.log.defineMacro(macro);
        }
        return macro;
    }

    private static boolean startsOrEndsWithHashHash(TokenList tokens) {
        if (tokens.isEmpty()) {
            return false;
        }
        return tokens.first().getKind() == 94 || tokens.last().getKind() == 94;
    }

    private int calculateMacroDefinitionEndOffset(IToken tokenBeforeReplacementList, TokenList replacementList) {
        if (replacementList == null || replacementList.isEmpty()) {
            return tokenBeforeReplacementList.getEndOffset() + 1;
        }
        IToken last = replacementList.last();
        if (last.getKind() == 95) {
            return last.getStartOffset();
        }
        return replacementList.last().getEndOffset() + 1;
    }

    private TokenList replacementListTokens(Set paramNames, String varArgParamName) {
        TokenList tokens = new TokenList();
        while (!this.check(4) && !this.done()) {
            IToken token = this.next();
            if (C99Preprocessor.isParamName(token, paramNames, varArgParamName)) {
                token.setKind(98);
            }
            tokens.add(token);
        }
        if (!this.done()) {
            this.next();
        }
        return tokens;
    }

    private static boolean isParamName(IToken token, Set paramNames, String varArgParamName) {
        if (token.getKind() != 2) {
            return false;
        }
        if (paramNames == null) {
            return false;
        }
        String ident = token.toString();
        return paramNames.contains(ident) || ident.equals(varArgParamName);
    }

    private class MacroExpansionCallback
    implements InputTokenStream.IIncludeContextCallback {
        boolean popped = false;
        boolean disabled = false;
        int directiveStartOffset;
        int directiveEndOffset;
        int replacementLength;
        int expansionEndOffset;
        Macro macro;

        MacroExpansionCallback(Macro macro, int directiveStartOffset, int directiveEndOffset, int replacementLength) {
            this.directiveStartOffset = directiveStartOffset;
            this.directiveEndOffset = directiveEndOffset;
            this.replacementLength = replacementLength;
            this.macro = macro;
        }

        public void startExpansion(char[][] args) {
            if (C99Preprocessor.this.log != null && C99Preprocessor.this.macroInvokationDepth == 0) {
                C99Preprocessor.this.log.startMacroExpansion(this.macro, this.directiveStartOffset, this.directiveEndOffset, args);
            }
        }

        public void contextClosed() {
            if (!this.popped) {
                this.expansionEndOffset = C99Preprocessor.this.inputTokenStream.adjust(this.replacementLength) + 1;
            }
            this.popped = true;
            if (this.disabled) {
                return;
            }
            if (C99Preprocessor.this.log != null && C99Preprocessor.this.macroInvokationDepth == 0) {
                C99Preprocessor.this.log.endMacroExpansion(this.macro, this.expansionEndOffset);
            }
        }

        public void macroOverlapClose() {
            if (C99Preprocessor.this.log != null && C99Preprocessor.this.macroInvokationDepth == 0) {
                C99Preprocessor.this.log.endMacroExpansion(this.macro, this.directiveEndOffset);
            }
        }

        public int getSourceLength() {
            return this.directiveEndOffset - this.directiveStartOffset + 1;
        }
    }

    private static class PreprocessorAbortParseException
    extends RuntimeException {
        private PreprocessorAbortParseException() {
        }
    }

    private static class PreprocessorInternalParseException
    extends RuntimeException {
        public PreprocessorInternalParseException() {
        }

        public PreprocessorInternalParseException(String message) {
            super(message);
        }
    }
}

