 -----------------------------------------------------------------------------------
-- Copyright (c) 2006, 2007 IBM Corporation and others.
-- All rights reserved. This program and the accompanying materials
-- are made available under the terms of the Eclipse Public License v1.0
-- which accompanies this distribution, and is available at
-- http://www.eclipse.org/legal/epl-v10.html
--
-- Contributors:
--     IBM Corporation - initial API and implementation
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Grammar file for preprocessor #if and #elif conditional expressions.
--
-- When the LPG generator is run on this file it must then be run on C99Parser.g
-- or the parser will not work properly.
-----------------------------------------------------------------------------------


%options la=1
%options package=org.eclipse.cdt.internal.core.dom.parser.c99
%options template=dtParserTemplateD.g
%options import_terminals=C99Lexer.g


$Notice
/./*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
 
  // This file was generated by LPG
./
$End


$Terminals

RightBracket ::= ']'
LeftBracket  ::= '['
RightParen   ::= ')'
LeftParen    ::= '('
RightBrace   ::= '}'
LeftBrace    ::= '{'
Dot          ::= '.'
Arrow        ::= '->'
PlusPlus     ::= '++'
MinusMinus   ::= '--'
And          ::= '&'
Star         ::= '*'
Plus         ::= '+'
Minus        ::= '-'
Tilde        ::= '~'
Bang         ::= '!'
Slash        ::= '/'
Percent      ::= '%'
RightShift   ::= '>>'
LeftShift    ::= '<<'
LT           ::= '<'
GT           ::= '>'
LE           ::= '<='
GE           ::= '>='
EQ           ::= '=='
NE           ::= '!='
Caret        ::= '^'
Or           ::= '|'
AndAnd       ::= '&&'
OrOr         ::= '||'
Question     ::= '?'
Colon        ::= ':'
SemiColon    ::= ';'
DotDotDot    ::= '...'
Assign           ::= '='
StarAssign       ::= '*='
SlashAssign      ::= '/='
PercentAssign    ::= '%='
PlusAssign       ::= '+='
MinusAssign      ::= '-='
RightShiftAssign ::= '>>='
LeftShiftAssign  ::= '<<='
AndAssign        ::= '&='
CaretAssign      ::= '^='
OrAssign         ::= '|='
Comma            ::= ','
Hash             ::= '#'
HashHash         ::= '##'
NewLine          ::= 'nl'

$End

$Globals
/.	
	import java.util.*;
	import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.*;
./
$End	

$Define
	$ast_class /.Object./
	$ba /.$BeginAction action. ./
	$ea /.$EndAction./
$End


$Headers
/.
	private C99ExprEvaluatorAction action = new C99ExprEvaluatorAction(this);
	
	public C99ExprEvaluator(TokenList tokens) {
		this(new C99Lexer() {
			public String[] orderedExportedSymbols() {
				return C99Parsersym.orderedTerminalSymbols;
			}
		});
		addToken(C99Token.DUMMY_TOKEN);
		for(Iterator iter = tokens.iterator(); iter.hasNext();) {
			C99Token token = new C99Token((IToken)iter.next());
			// Map token kinds defined in the C99Parser to those defined in the C99ExprEvaluator
			token.setKind(mapKind(token.getKind()));
			addToken(token);
		}
		addToken(new C99Token(0, 0, C99ExprEvaluatorsym.TK_EOF_TOKEN, "<EOF>"));
		setStreamLength(getSize());
	}

	
	public void addToken(IToken token) {
		ArrayList tokens = getTokens();
		ArrayList adjuncts = getAdjuncts();
		tokens.add(token);
		token.setTokenIndex(tokens.size());
        token.setAdjunctIndex(adjuncts.size());
	}
	
	public Long evaluate() {
		parser(null, -1);
		return action.result();	
	}
./
$End


$Start
	constant_expression
$End

$Rules
     

-------------------------------------------------------------------------------------------
-- Expressions
-------------------------------------------------------------------------------------------


constant
    ::= 'integer'                    
          /.$ba  evalExpressionConstantInteger();  $ea./
      | 'charconst'                  
          /.$ba  evalExpressionConstantChar();     $ea./

primary_expression 
    ::= constant 
      | 'identifier'                 
          /.$ba  evalExpressionID();  $ea./
      | '(' constant_expression ')'         
      
      
unary_expression
    ::= primary_expression
      | '+' unary_expression
          /.$ba  evalExpressionUnaryOperator(C99ExprEvaluatorAction.op_plus);   $ea./
      | '-' unary_expression
          /.$ba  evalExpressionUnaryOperator(C99ExprEvaluatorAction.op_minus);  $ea./
      | '~' unary_expression
          /.$ba  evalExpressionUnaryOperator(C99ExprEvaluatorAction.op_tilde);  $ea./
      | '!' unary_expression
          /.$ba  evalExpressionUnaryOperator(C99ExprEvaluatorAction.op_not);    $ea./
 
multiplicative_expression
    ::= unary_expression
      | multiplicative_expression '*' unary_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_multiply); $ea./
      | multiplicative_expression '/' unary_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_divide);   $ea./
      | multiplicative_expression '%' unary_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_modulo);   $ea./

additive_expression
    ::= multiplicative_expression
      | additive_expression '+' multiplicative_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_plus);  $ea./
      | additive_expression '-' multiplicative_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_minus); $ea./

shift_expression
    ::= additive_expression
      | shift_expression '<<' additive_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_shiftLeft);   $ea./
      | shift_expression '>>' additive_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_shiftRight);  $ea./
      
relational_expression
    ::= shift_expression
      | relational_expression '<' shift_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_lessThan);     $ea./
      | relational_expression '>' shift_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_greaterThan);  $ea./
      | relational_expression '<=' shift_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_lessEqual);    $ea./
      | relational_expression '>=' shift_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_greaterEqual); $ea./

equality_expression
    ::= relational_expression
      | equality_expression '==' relational_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_equals);  $ea./
      | equality_expression '!=' relational_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_notequals);  $ea./

AND_expression
    ::= equality_expression
      | AND_expression '&' equality_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_binaryAnd);  $ea./

exclusive_OR_expression
    ::= AND_expression
      | exclusive_OR_expression '^' AND_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_binaryXor);  $ea./

inclusive_OR_expression
    ::= exclusive_OR_expression
      | inclusive_OR_expression '|' exclusive_OR_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_binaryOr);  $ea./

logical_AND_expression
    ::= inclusive_OR_expression
      | logical_AND_expression '&&' inclusive_OR_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_logicalAnd);  $ea./

logical_OR_expression
    ::= logical_AND_expression
      | logical_OR_expression '||' logical_AND_expression
          /.$ba  evalExpressionBinaryOperator(C99ExprEvaluatorAction.op_logicalOr);  $ea./

conditional_expression
    ::= logical_OR_expression
      | logical_OR_expression '?' constant_expression ':' conditional_expression
          /.$ba  evalExpressionConditional();  $ea./

constant_expression
    ::= conditional_expression

$End

