/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor;

import java.io.File;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.cdt.core.dom.c99.IPPTokenComparator;
import org.eclipse.cdt.core.dom.c99.IPreprocessorTokenCollector;
import org.eclipse.cdt.core.dom.parser.c99.IToken;
import org.eclipse.cdt.core.dom.parser.c99.PPToken;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Messages;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.TokenList;

class InputTokenStream {
    public static final int NO_CONTENT_ASSIST_OFFSET = -1;
    private final Stack contextStack = new Stack();
    private Context topContext = null;
    private boolean stuck = false;
    private int contentAssistOffset = -1;
    private int translationUnitSize = 0;
    private IPreprocessorTokenCollector parser;
    private IPPTokenComparator comparator;
    private boolean collectCommentTokens = false;
    private IToken lastCommentToken = null;

    public InputTokenStream(IPreprocessorTokenCollector parser, IPPTokenComparator comparator) {
        this.parser = parser;
        this.comparator = comparator;
    }

    private void popContext() {
        this.contextStack.pop();
        this.topContext = this.contextStack.isEmpty() ? null : this.contextStack.peek();
    }

    private void pushContext(Context context) {
        this.contextStack.push(context);
        this.topContext = context;
    }

    public void setContentAssistOffset(int offset) {
        if (offset == -1) {
            this.contentAssistOffset = offset;
        } else {
            if (offset < 0) {
                throw new IllegalArgumentException(String.valueOf(Messages.getString("InputTokenStream.0")) + offset);
            }
            this.contentAssistOffset = offset;
        }
    }

    public boolean isCircularInclusion(CodeReader readerToTest) {
        Iterator iter = this.contextStack.iterator();
        while (iter.hasNext()) {
            Context context = (Context)iter.next();
            if (!CharArrayUtils.equals((char[])context.reader.filename, (char[])readerToTest.filename)) continue;
            return true;
        }
        return false;
    }

    public int getContentAssistOffset() {
        return this.contentAssistOffset;
    }

    public boolean isContentAssistMode() {
        return this.contentAssistOffset != -1;
    }

    public void pushIncludeContext(TokenList tokenList, CodeReader reader, int inclusionLocaionOffset, boolean isolated, IIncludeContextCallback callback) {
        this.adjustGlobalOffsets(reader.buffer.length);
        Context context = new Context(reader, tokenList, callback, inclusionLocaionOffset);
        context.isolated = isolated;
        this.pushContext(context);
        if (this.lastCommentToken != null && this.lastCommentToken.getStartOffset() >= inclusionLocaionOffset) {
            int adjust = reader.buffer.length;
            this.lastCommentToken.setStartOffset(this.lastCommentToken.getStartOffset() + adjust);
            this.lastCommentToken.setEndOffset(this.lastCommentToken.getEndOffset() + adjust);
        }
    }

    public void pushMacroExpansionContext(TokenList expansion, int expansionLocationOffset, IIncludeContextCallback callback, boolean recordOffsets) {
        if (expansion == null || expansion.isEmpty()) {
            return;
        }
        if (recordOffsets) {
            int expansionSize = expansion.last().getEndOffset() - expansion.first().getStartOffset() + 1;
            this.adjustGlobalOffsets(expansionSize);
        }
        Context context = new Context(this.topContext.reader, expansion, callback, expansionLocationOffset);
        context.macroExpansion = true;
        this.pushContext(context);
    }

    public void adjustGlobalOffsets(int contextSize) {
        int i = this.contextStack.size() - 1;
        while (i >= 0) {
            Context context = (Context)this.contextStack.get(i);
            if (context.isolated) {
                return;
            }
            context.adjustedGlobalOffset += contextSize;
            --i;
        }
        this.translationUnitSize += contextSize;
    }

    public void pushIsolatedContext(TokenList tokenList, IIncludeContextCallback callback) {
        if (tokenList != null) {
            Context context = new Context(this.topContext == null ? null : this.topContext.reader, tokenList, callback, 0);
            context.isolated = true;
            this.pushContext(context);
        }
    }

    public int adjust(int localOffset) {
        return localOffset + this.topContext.adjustedGlobalOffset;
    }

    public int getCurrentOffset() {
        IToken token = this.peek();
        if (token == null) {
            return this.getTranslationUnitSize();
        }
        return this.adjust(token.getStartOffset());
    }

    public String getCurrentFileName() {
        if (this.topContext == null) {
            return null;
        }
        return new String(this.topContext.reader.filename);
    }

    public File getCurrentDirectory() {
        String fileName = this.getCurrentFileName();
        if (fileName == null) {
            return null;
        }
        File file = new File(this.getCurrentFileName());
        return file.getParentFile();
    }

    public boolean isStuck() {
        return this.stuck;
    }

    public void resume() {
        this.stuck = false;
    }

    public int getTranslationUnitSize() {
        return this.translationUnitSize;
    }

    public IToken peek() {
        this.consumeCommentTokens();
        return this.nextToken(true);
    }

    public IToken next(boolean adjust) {
        this.consumeCommentTokens();
        IToken token = this.nextToken(false);
        if (adjust && this.topContext != null && token != null) {
            this.adjustToken(token);
        }
        return token;
    }

    private void adjustToken(IToken token) {
        int offset = this.topContext.adjustedGlobalOffset;
        token.setStartOffset(token.getStartOffset() + offset);
        token.setEndOffset(token.getEndOffset() + offset);
    }

    private void consumeCommentTokens() {
        IToken token;
        while ((token = this.nextToken(true)) != null) {
            if (!this.comparator.compare(PPToken.SINGLE_LINE_COMMENT, token) && !this.comparator.compare(PPToken.MULTI_LINE_COMMENT, token)) break;
            if (this.collectCommentTokens && this.parser != null) {
                this.adjustToken(token);
                this.parser.addCommentToken(token);
                this.lastCommentToken = token;
            }
            this.nextToken(false);
        }
    }

    private IToken nextToken(boolean peek) {
        if (this.stuck || this.topContext == null) {
            return null;
        }
        TokenList topList = this.topContext.tokenList;
        if (topList.isEmpty()) {
            if (this.topContext.callback != null) {
                this.topContext.callback.contextClosed();
            }
            if (this.topContext.isolated) {
                this.stuck = true;
            }
            this.popContext();
            return this.nextToken(peek);
        }
        return peek ? topList.first() : topList.removeFirst();
    }

    public boolean isContentAssistOffsetOnCurrentLine() {
        if (this.contentAssistOffset == -1) {
            return false;
        }
        if (this.contextStack.isEmpty()) {
            return true;
        }
        if (this.contextStack.size() != 1) {
            return false;
        }
        Iterator iter = this.topContext.tokenList.iterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            if (!this.comparator.compare(PPToken.NEWLINE, token)) continue;
            return token.getEndOffset() >= this.contentAssistOffset - 1;
        }
        return true;
    }

    public boolean isContentAssistOffsetReached() {
        if (this.contentAssistOffset == -1) {
            return false;
        }
        this.peek();
        if (this.contextStack.isEmpty()) {
            return true;
        }
        if (this.isStuck()) {
            return false;
        }
        if (this.contextStack.size() != 1) {
            return false;
        }
        return this.contextStack.size() == 1 && this.peek().getEndOffset() >= this.contentAssistOffset - 1;
    }

    public boolean isEmpty() {
        return this.peek() == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("InputTokenStream { \n");
        Iterator iter = this.contextStack.iterator();
        while (iter.hasNext()) {
            Context context = (Context)iter.next();
            sb.append("Context: ");
            sb.append("(stop ").append(context.isolated).append(")");
            sb.append(context.tokenList.toString()).append("\n");
        }
        return sb.append("\n}\n").toString();
    }

    public boolean isCollectCommentTokens() {
        return this.collectCommentTokens;
    }

    public void setCollectCommentTokens(boolean collectCommentTokens) {
        this.collectCommentTokens = collectCommentTokens;
    }

    public boolean inMacroExpansionContext() {
        return this.topContext.macroExpansion;
    }

    public IIncludeContextCallback getCurrentContextCallback() {
        return this.topContext.callback;
    }

    public void setCurrentContextCallback(IIncludeContextCallback callback) {
        this.topContext.callback = callback;
    }

    private class Context {
        CodeReader reader;
        TokenList tokenList;
        boolean isolated = false;
        boolean macroExpansion = false;
        IIncludeContextCallback callback;
        int adjustedGlobalOffset;

        Context(CodeReader reader, TokenList tokenList, IIncludeContextCallback callback, int startingOffset) {
            this.reader = reader;
            this.tokenList = tokenList;
            this.callback = callback;
            this.adjustedGlobalOffset = startingOffset;
        }
    }

    public static interface IIncludeContextCallback {
        public void contextClosed();
    }
}

