/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.c99.IASTNodeFactory;
import org.eclipse.cdt.core.dom.c99.IParserActionTokenProvider;
import org.eclipse.cdt.core.dom.parser.c99.ASTStack;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.c99.ASTCompletionNode;

public abstract class ParserAction {
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    protected final ASTStack astStack = new ASTStack();
    protected final IASTNodeFactory nodeFactory;
    protected final IParserActionTokenProvider parser;
    private boolean encounteredRecoverableProblem = false;
    private ASTCompletionNode completionNode;
    private int ruleOffset;
    private int ruleLength;

    protected abstract IASTNodeFactory createNodeFactory();

    public ParserAction(IParserActionTokenProvider parser) {
        this.parser = parser;
        this.nodeFactory = this.createNodeFactory();
    }

    protected IASTNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    protected ASTStack getASTStack() {
        return this.astStack;
    }

    protected void setEncounteredRecoverableProblem(boolean problem) {
        this.encounteredRecoverableProblem = problem;
    }

    public IASTTranslationUnit getAST() {
        if (this.astStack.isEmpty()) {
            return null;
        }
        IASTTranslationUnit tu = (IASTTranslationUnit)this.astStack.peek();
        this.generateCommentNodes(tu);
        this.forceAmbiguityResolution(tu);
        return tu;
    }

    private void forceAmbiguityResolution(IASTTranslationUnit tu) {
        CASTVisitor emptyVisitor = new CASTVisitor(){
            {
                this.shouldVisitStatements = true;
            }
        };
        tu.accept((ASTVisitor)emptyVisitor);
    }

    private void generateCommentNodes(IASTTranslationUnit tu) {
        List commentTokens = this.parser.getCommentTokens();
        if (commentTokens == null || commentTokens.isEmpty()) {
            return;
        }
        IASTComment[] commentNodes = new IASTComment[commentTokens.size()];
        int i = 0;
        while (i < commentNodes.length) {
            IToken token = (IToken)commentTokens.get(i);
            IASTComment comment = this.nodeFactory.newComment();
            comment.setParent((IASTNode)tu);
            comment.setComment(token.toString().toCharArray());
            this.setOffsetAndLength((IASTNode)comment, token);
            commentNodes[i] = comment;
            ++i;
        }
        tu.setComments(commentNodes);
    }

    public boolean encounteredError() {
        return this.encounteredRecoverableProblem || this.astStack.isEmpty();
    }

    public void openASTScope() {
        this.astStack.openASTScope();
    }

    public IASTCompletionNode getASTCompletionNode() {
        if (this.completionNode != null) {
            this.completionNode.setTranslationUnit(this.getAST());
        }
        return this.completionNode;
    }

    protected void addNameToCompletionNode(IASTName name, String prefix) {
        if (this.completionNode == null) {
            this.completionNode = this.nodeFactory.newCompletionNode(prefix.length() == 0 ? null : prefix);
        }
        this.completionNode.addName(name);
    }

    protected static int offset(IToken token) {
        return token.getStartOffset();
    }

    protected static int offset(IASTNode node) {
        return ((ASTNode)node).getOffset();
    }

    protected static int length(IToken token) {
        return ParserAction.endOffset(token) - ParserAction.offset(token);
    }

    protected static int length(IASTNode node) {
        return ((ASTNode)node).getLength();
    }

    protected static int endOffset(IASTNode node) {
        return ParserAction.offset(node) + ParserAction.length(node);
    }

    protected static int endOffset(IToken token) {
        return token.getEndOffset() + 1;
    }

    protected void setOffsetAndLength(IASTNode node) {
        ((ASTNode)node).setOffsetAndLength(this.ruleOffset, this.ruleLength);
    }

    protected void setOffsetAndLength(IASTNode node, IToken token) {
        ((ASTNode)node).setOffsetAndLength(ParserAction.offset(token), ParserAction.length(token));
    }

    protected void setOffsetAndLength(IASTNode node, int offset, int length) {
        ((ASTNode)node).setOffsetAndLength(offset, length);
    }

    public void beforeConsume() {
        this.ruleOffset = this.parser.getLeftIToken().getStartOffset();
        this.ruleLength = this.parser.getRightIToken().getEndOffset() + 1 - this.ruleOffset;
    }

    protected int getRuleOffset() {
        return this.ruleOffset;
    }

    protected int getRuleLength() {
        return this.ruleLength;
    }

    public void consumeToken() {
        this.astStack.push(this.parser.getRightIToken());
    }
}

