/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IMacroCollector;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.c99.ILexer;
import org.eclipse.cdt.core.dom.c99.ILexerFactory;
import org.eclipse.cdt.core.dom.c99.IPPTokenComparator;
import org.eclipse.cdt.core.dom.c99.IPreprocessorExtensionConfiguration;
import org.eclipse.cdt.core.dom.c99.IPreprocessorTokenCollector;
import org.eclipse.cdt.core.dom.parser.c99.IToken;
import org.eclipse.cdt.core.dom.parser.c99.PPToken;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c99.C99ExprEvaluator;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.IPreprocessorLog;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.InputTokenStream;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Macro;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.MacroArgument;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.MacroEnvironment;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Messages;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.Token;
import org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.TokenList;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerASTProblem;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerUtility;

public class C99Preprocessor {
    public static final int OPTION_GENERATE_COMMENTS_FOR_ACTIVE_CODE = 1;
    public static final int OPTION_GENERATE_ALL_COMMENTS = 2;
    private static final String DEFINED_OPERATOR = "defined";
    private static final String DIRECTIVE_COMPLETION_TOKEN_PREFIX = "#";
    private static final int NUM_EOC_TOKENS = 20;
    private final CodeReader codeReader;
    private final IScannerInfo scanInfo;
    private final ILexerFactory lexerFactory;
    private final ICodeReaderFactory codeReaderFactory;
    private final IPPTokenComparator comparator;
    private final boolean generateAllComments;
    private final boolean generateActiveComments;
    private MacroEnvironment env;
    private TokenList argumentOutputStream;
    private InputTokenStream inputTokenStream;
    private IPreprocessorTokenCollector parser;
    private IPreprocessorLog log;
    private IToken lastTokenOutput = null;
    private boolean encounteredError = false;
    private int macroInvokationDepth = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.dom.parser.c99.preprocessor.C99Preprocessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public C99Preprocessor(ILexerFactory lexerFactory, IPPTokenComparator ppTokenComparator, CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, int options) {
        this.codeReader = reader;
        this.scanInfo = scanInfo;
        this.lexerFactory = lexerFactory;
        this.codeReaderFactory = fileCreator;
        this.comparator = ppTokenComparator;
        this.generateActiveComments = (options & 1) != 0;
        this.generateAllComments = (options & 2) != 0;
    }

    public boolean encounteredError() {
        return this.encounteredError;
    }

    public synchronized void preprocess(IPreprocessorTokenCollector parser, IPreprocessorLog log, IPreprocessorExtensionConfiguration extensionConfiguration) {
        if (parser == null) {
            throw new IllegalArgumentException(Messages.getString("C99Preprocessor.0"));
        }
        this.preprocess(parser, log, extensionConfiguration, new InputTokenStream(parser, this.comparator));
    }

    public synchronized void preprocess(IPreprocessorTokenCollector parser, IPreprocessorLog log, IPreprocessorExtensionConfiguration extensionConfiguration, int contentAssistOffset) {
        if (parser == null) {
            throw new IllegalArgumentException(Messages.getString("C99Preprocessor.0"));
        }
        if (contentAssistOffset < 0) {
            throw new IllegalArgumentException(Messages.getString("C99Preprocessor.2"));
        }
        if (log == null) {
            throw new IllegalArgumentException();
        }
        InputTokenStream inputTokenStream = new InputTokenStream(parser, this.comparator);
        inputTokenStream.setContentAssistOffset(contentAssistOffset);
        this.preprocess(parser, log, extensionConfiguration, inputTokenStream);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void preprocess(IPreprocessorTokenCollector parser, IPreprocessorLog log, IPreprocessorExtensionConfiguration extensionConfiguration, InputTokenStream inputTokenStream) {
        if (!$assertionsDisabled && inputTokenStream == null) {
            throw new AssertionError();
        }
        this.log = log;
        this.parser = parser;
        this.env = new MacroEnvironment();
        this.inputTokenStream = inputTokenStream;
        try {
            try {
                inputTokenStream.setCollectCommentTokens(this.generateActiveComments | this.generateAllComments);
                if (this.scanInfo != null) {
                    this.addMacroDefinitions(this.scanInfo.getDefinedSymbols());
                }
                if (extensionConfiguration != null) {
                    this.addMacroDefinitions(extensionConfiguration.getAdditionalMacros());
                }
                parser.addToken(Token.DUMMY_TOKEN);
                log.startTranslationUnit(this.codeReader);
                System.out.println("Lexing the codeReader");
                TokenList tokenList = this.lex(this.codeReader);
                inputTokenStream.pushIncludeContext(tokenList, this.codeReader, 0, false, null);
                this.processExtendedScannerInfoMacrosAndIncludes();
                this.process();
                int tuSize = inputTokenStream.getTranslationUnitSize();
                parser.addToken(new Token(tuSize, tuSize, this.comparator.getKind(1), "<EOF>"));
                log.endTranslationUnit(tuSize);
            }
            catch (PreprocessorAbortParseException preprocessorAbortParseException) {
                this.encounteredError = true;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.parser = null;
            this.inputTokenStream = null;
            this.log = null;
            this.env = null;
            this.lastTokenOutput = null;
            this.macroInvokationDepth = 0;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.parser = null;
            this.inputTokenStream = null;
            this.log = null;
            this.env = null;
            this.lastTokenOutput = null;
            this.macroInvokationDepth = 0;
            return;
        }
    }

    private TokenList lex(CodeReader codeReader) {
        ILexer lexer = this.lexerFactory.createLexer(codeReader);
        boolean generateComments = this.generateActiveComments | this.generateAllComments;
        int lexerOptions = generateComments ? 1 : 0;
        TokenList tokens = lexer.lex(lexerOptions);
        return tokens;
    }

    private void processExtendedScannerInfoMacrosAndIncludes() {
        if (this.scanInfo instanceof IExtendedScannerInfo) {
            IExtendedScannerInfo einfo = (IExtendedScannerInfo)this.scanInfo;
            this.addExtendedScannerInfoIncludes(einfo.getMacroFiles());
            this.addExtendedScannerInfoIncludes(einfo.getIncludeFiles());
        }
    }

    private void addExtendedScannerInfoIncludes(String[] paths) {
        if (paths == null) {
            return;
        }
        int i = 0;
        while (i < paths.length) {
            CodeReader cr = this.codeReaderFactory.createCodeReaderForInclusion(null, paths[i]);
            if (cr != null) {
                int offset = this.inputTokenStream.getCurrentOffset();
                this.addIncludedFileToInputStream(cr, offset, offset, offset, offset, "", true, true);
                this.process();
                this.inputTokenStream.resume();
            }
            ++i;
        }
    }

    private void addMacroDefinitions(Map definedSymbols) {
        if (definedSymbols == null) {
            return;
        }
        Iterator iter = definedSymbols.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.registerMacro((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private Macro registerMacroInLocalEnvironment(String signature, String expansion) {
        String define = String.valueOf(signature) + " " + expansion;
        TokenList tokenList = this.lex(new CodeReader(define.toCharArray()));
        if (tokenList == null || tokenList.isEmpty()) {
            return null;
        }
        this.inputTokenStream.pushIsolatedContext(tokenList, null);
        Macro macro = this.defineDirective(0, false);
        this.inputTokenStream.resume();
        return macro;
    }

    private void registerMacro(String signature, String expansion) {
        Macro macro = this.registerMacroInLocalEnvironment(signature, expansion);
        if (macro != null) {
            this.log.registerBuiltinMacro(macro);
        }
    }

    private void registerMacro(IMacro m) {
        if (m == null) {
            return;
        }
        String signature = new String(m.getSignature());
        String expansion = new String(m.getExpansion());
        this.registerMacroInLocalEnvironment(signature, expansion);
        this.log.registerIndexMacro(m);
    }

    private CodeReader createCodeReader(String path, String fileName) {
        String finalPath = ScannerUtility.createReconciledPath((String)path, (String)fileName);
        IMacroCollector indexMacroCollector = new IMacroCollector(){

            public void addDefinition(IMacro macro) {
                C99Preprocessor.this.registerMacro(macro);
            }
        };
        return this.codeReaderFactory.createCodeReaderForInclusion(indexMacroCollector, finalPath);
    }

    private void addIncludedFileToInputStream(final CodeReader reader, int directiveStartOffset, int directiveEndOffset, int nameStartOffset, int nameEndOffset, String name, boolean systemInclude, boolean isolated) {
        TokenList tokens = this.lex(reader);
        this.log.startInclusion(reader, directiveStartOffset, directiveEndOffset, nameStartOffset, nameEndOffset, name.toCharArray(), systemInclude);
        InputTokenStream.IIncludeContextCallback callback = null;
        callback = new InputTokenStream.IIncludeContextCallback(){

            public void contextClosed() {
                C99Preprocessor.this.log.endInclusion(reader, C99Preprocessor.this.inputTokenStream.adjust(reader.buffer.length));
            }
        };
        this.inputTokenStream.pushIncludeContext(tokens, reader, directiveEndOffset, isolated, callback);
    }

    public String toString() {
        return this.inputTokenStream.toString();
    }

    private void addToOutputStream(IToken t) {
        if (this.argumentOutputStream != null) {
            this.argumentOutputStream.add(t);
            return;
        }
        if (this.check(PPToken.NEWLINE, t)) {
            return;
        }
        if (t.getPreprocessorAttribute() == 1) {
            return;
        }
        IToken toOutput = t;
        if (this.lastTokenOutput != null && this.check(PPToken.STRINGLIT, t) && this.check(PPToken.STRINGLIT, this.lastTokenOutput)) {
            String s1 = this.lastTokenOutput.toString();
            String s2 = toOutput.toString();
            if (!($assertionsDisabled || s1.length() >= 2 && s2.length() != 2)) {
                throw new AssertionError();
            }
            String rep = String.valueOf(s1.substring(0, s1.length() - 1)) + s2.substring(1);
            ((Token)this.lastTokenOutput).setRepresentation(rep);
            this.lastTokenOutput.setEndOffset(toOutput.getEndOffset());
        } else {
            this.lastTokenOutput = toOutput;
            System.out.println("Token: (" + toOutput.getKind() + ", " + toOutput.getStartOffset() + ", " + toOutput.getEndOffset() + ") " + toOutput);
            this.parser.addToken(toOutput);
        }
    }

    private boolean check(PPToken ppTokenKind) {
        return this.check(ppTokenKind, this.inputTokenStream.peek());
    }

    private boolean check(PPToken ppTokenKind, IToken token) {
        return this.comparator.compare(ppTokenKind, token);
    }

    private boolean done() {
        IToken token = this.inputTokenStream.peek();
        if (token == null) {
            return true;
        }
        return this.comparator.compare(PPToken.EOF, token);
    }

    private IToken expect(PPToken pptoken) {
        if (this.check(pptoken)) {
            return this.next();
        }
        throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
    }

    private IToken next() {
        return this.inputTokenStream.next(true);
    }

    private IToken next(boolean adjust) {
        return this.inputTokenStream.next(adjust);
    }

    private void encounterProblem(int id, IToken token) {
        if (token != null) {
            this.encounterProblem(id, token.getStartOffset(), token.getEndOffset(), null);
        } else {
            int offset = this.inputTokenStream.getCurrentOffset();
            this.encounterProblem(id, offset, offset, null);
        }
    }

    private void encounterProblem(int id, int startOffset, int endOffset) {
        this.encounterProblem(id, startOffset, endOffset, null);
    }

    private void encounterProblem(int id, TokenList tokenList) {
        int start = tokenList.first().getStartOffset();
        int end = tokenList.last().getEndOffset();
        this.encounterProblem(id, start, end, C99Preprocessor.createProblemArg(tokenList));
    }

    private void encounterProblem(int id, int startOffset, int endOffset, char[] arg) {
        ScannerASTProblem problem = new ScannerASTProblem(id, arg, true, false);
        problem.setOffsetAndLength(startOffset, endOffset - startOffset + 1);
        this.log.encounterProblem((IASTProblem)problem);
    }

    private static char[] createProblemArg(TokenList tokenList) {
        StringBuffer sb = new StringBuffer();
        Iterator iter = tokenList.iterator();
        while (iter.hasNext()) {
            IToken token = (IToken)iter.next();
            sb.append(token.toString());
            if (!iter.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString().toCharArray();
    }

    /*
     * Unable to fully structure code
     */
    private void process() {
        while (!this.done()) {
            try {
                if (this.check(PPToken.HASH)) {
                    encounteredPoundElse = this.controlLine();
                    if (!encounteredPoundElse) continue;
                    throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
                }
                this.textLine();
                continue;
            }
            catch (PreprocessorInternalParseException v0) {
                if (this.inputTokenStream.isContentAssistMode()) {
                    throw new PreprocessorAbortParseException();
                }
                if (this.done()) {
                    offset = this.inputTokenStream.getCurrentOffset();
                    this.encounterProblem(0x4000001, offset, offset);
                    continue;
                }
                if (this.check(PPToken.NEWLINE)) {
                    token = this.next();
                    this.encounterProblem(0x4000001, token);
                    return;
                }
                token = this.next();
                this.encounterProblem(0x4000001, token);
                ** while (!this.check((PPToken)PPToken.NEWLINE) && !this.done())
            }
lbl-1000:
            // 1 sources

            {
                token = this.next();
                continue;
            }
lbl25:
            // 1 sources

            if (!this.check(PPToken.NEWLINE)) continue;
            var1_4 = this.next();
        }
    }

    private int processBranch() {
        while (!this.done()) {
            if (this.check(PPToken.HASH)) {
                int hashOffset = this.inputTokenStream.adjust(this.inputTokenStream.peek().getStartOffset());
                boolean encounteredPoundElse = this.controlLine();
                if (!encounteredPoundElse) continue;
                return hashOffset;
            }
            this.textLine();
        }
        throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
    }

    private int skipBranch() {
        if (!this.generateAllComments) {
            this.inputTokenStream.setCollectCommentTokens(false);
        }
        int depth = 0;
        while (!this.done()) {
            if (this.check(PPToken.HASH)) {
                IToken hash = this.next();
                int directiveStartOffset = hash.getStartOffset();
                if (this.check(PPToken.INCLUDE) || this.check(PPToken.INCLUDE_NEXT)) {
                    boolean includeNext = this.check(PPToken.INCLUDE_NEXT);
                    this.next();
                    this.includeDirective(directiveStartOffset, false, includeNext);
                    continue;
                }
                if (this.check(PPToken.IF)) {
                    this.handleIf(directiveStartOffset, false);
                    ++depth;
                    continue;
                }
                if (this.check(PPToken.IFDEF) || this.check(PPToken.IFNDEF)) {
                    this.handleIfDef(directiveStartOffset);
                    ++depth;
                    continue;
                }
                if (this.check(PPToken.ELIF)) {
                    if (depth == 0) {
                        return directiveStartOffset;
                    }
                    this.handleIf(directiveStartOffset, false);
                    continue;
                }
                if (this.check(PPToken.ELSE)) {
                    if (depth == 0) {
                        return directiveStartOffset;
                    }
                    this.handleElse(directiveStartOffset, false);
                    continue;
                }
                if (!this.check(PPToken.ENDIF)) continue;
                if (depth == 0) {
                    this.inputTokenStream.setCollectCommentTokens(this.generateActiveComments || this.generateAllComments);
                    return directiveStartOffset;
                }
                --depth;
                this.handleEndif(directiveStartOffset);
                continue;
            }
            this.skipLine();
        }
        throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
    }

    String spaces(int x) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < x) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private void skipLine() {
        while (!this.check(PPToken.NEWLINE) && !this.done()) {
            this.next();
        }
        if (!this.done()) {
            this.next();
        }
    }

    private void handleBasicContentAssistOffsetReached() {
        Token completionToken;
        if (!$assertionsDisabled && !this.inputTokenStream.isContentAssistOffsetReached()) {
            throw new AssertionError();
        }
        int completionKind = this.comparator.getKind(2);
        if (this.inputTokenStream.isEmpty()) {
            int endOffset = this.inputTokenStream.getTranslationUnitSize();
            Token completionToken2 = new Token(endOffset, endOffset, completionKind, "");
            this.addCompletionTokenToOutputAndQuit(completionToken2);
            return;
        }
        IToken token = this.inputTokenStream.peek();
        int cursorOffset = this.inputTokenStream.getContentAssistOffset();
        int adjustedOffset = this.inputTokenStream.adjust(cursorOffset) - 1;
        if (token.getStartOffset() >= cursorOffset) {
            completionToken = new Token(adjustedOffset, adjustedOffset, completionKind, "");
        } else if (this.check(PPToken.IDENT, token)) {
            int startOffset = token.getStartOffset();
            int prefixLength = cursorOffset - startOffset;
            String prefix = token.toString().substring(0, prefixLength);
            int newStartOffset = this.inputTokenStream.adjust(startOffset);
            int newEndOffset = this.inputTokenStream.adjust(startOffset + prefixLength);
            completionToken = new Token(newStartOffset, newEndOffset, completionKind, prefix);
        } else if (token.getEndOffset() == cursorOffset - 1) {
            completionToken = new Token(adjustedOffset, adjustedOffset, completionKind, "");
            this.addToOutputStream(this.next());
        } else {
            throw new PreprocessorAbortParseException();
        }
        this.addCompletionTokenToOutputAndQuit(completionToken);
    }

    private void addCompletionTokenToOutputAndQuit(IToken completionToken) {
        this.addToOutputStream(completionToken);
        int offset = completionToken.getEndOffset() + 1;
        int i = 0;
        while (i < 20) {
            this.addToOutputStream(new Token(offset, offset, this.comparator.getKind(3), ""));
            ++i;
        }
        this.inputTokenStream = new InputTokenStream(this.parser, this.comparator);
    }

    private void addCompletionTokenToOutputAndQuit(int offset, String prefix) {
        this.addCompletionTokenToOutputAndQuit(new Token(offset, offset, this.comparator.getKind(2), prefix));
    }

    private void textLine(boolean handleDefined) {
        while (true) {
            if (this.inputTokenStream.isContentAssistOffsetReached() && !handleDefined) {
                this.handleBasicContentAssistOffsetReached();
                return;
            }
            if (this.check(PPToken.NEWLINE) || this.done()) break;
            IToken currentToken = this.inputTokenStream.peek();
            if (handleDefined && this.check(PPToken.IDENT) && DEFINED_OPERATOR.equals(currentToken.toString())) {
                this.next();
                this.handleDefinedOperator();
                continue;
            }
            if (this.check(PPToken.IDENT) && this.env.hasMacro(currentToken.toString()) && currentToken.getPreprocessorAttribute() != 2) {
                Macro macro = this.env.get(currentToken.toString());
                this.macroCall(macro);
                continue;
            }
            this.addToOutputStream(this.next());
        }
        if (this.check(PPToken.NEWLINE)) {
            this.next();
        }
    }

    private void textLine() {
        this.textLine(false);
    }

    private void handleDefinedOperator() {
        IToken ident;
        if (this.check(PPToken.LPAREN)) {
            this.next();
            ident = this.expect(PPToken.IDENT);
            this.expect(PPToken.RPAREN);
        } else if (this.check(PPToken.IDENT)) {
            ident = this.next();
        } else {
            throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
        }
        String val = this.env.hasMacro(ident.toString()) ? "1" : "0";
        this.addToOutputStream(new Token(0, 0, this.comparator.getKind(4), val));
    }

    private void macroCall(Macro macro) {
        int expansionLocationOffset;
        TokenList replacement;
        IToken macroId = this.next();
        int startOffset = macroId.getStartOffset();
        char[][] argsAsChar = null;
        if (macro.isObjectLike()) {
            replacement = this.invoke(macro, null);
            if (replacement == null) {
                this.encounterProblem(0x2000009, macroId);
            }
            expansionLocationOffset = macroId.getEndOffset() + 1;
        } else {
            MacroExpansionCallback callback = null;
            if (this.inputTokenStream.inMacroExpansionContext()) {
                callback = (MacroExpansionCallback)this.inputTokenStream.getCurrentContextCallback();
                callback.disabled = true;
            }
            while (this.check(PPToken.NEWLINE)) {
                this.next();
            }
            if (!this.check(PPToken.LPAREN)) {
                if (callback != null && callback.popped && callback.disabled) {
                    callback.disabled = false;
                    callback.contextClosed();
                }
                this.addToOutputStream(macroId);
                return;
            }
            this.next();
            List arguments = this.collectArgumentsToFunctionLikeMacro(macroId, macro);
            if (arguments == null) {
                this.encounterProblem(0x2000009, macroId);
                return;
            }
            argsAsChar = C99Preprocessor.convertArgsToCharArrays(arguments);
            replacement = this.invoke(macro, arguments);
            if (replacement == null) {
                this.encounterProblem(0x2000009, macroId);
                return;
            }
            IToken rparen = this.next();
            expansionLocationOffset = rparen.getEndOffset() + 1;
            if (callback != null) {
                callback.disabled = false;
            }
            if (callback != null && callback.popped) {
                callback.macroOverlapClose();
                int replacementLength = callback.expansionEndOffset - callback.directiveEndOffset;
                startOffset = callback.directiveStartOffset;
                expansionLocationOffset -= replacementLength;
                this.inputTokenStream.adjustGlobalOffsets(-replacementLength);
            }
        }
        if (replacement == null || replacement.isEmpty()) {
            this.log.startMacroExpansion(macro, startOffset, expansionLocationOffset, argsAsChar);
            this.log.endMacroExpansion(macro, expansionLocationOffset);
        } else {
            int replacementLength = replacement.last().getEndOffset();
            MacroExpansionCallback callback = new MacroExpansionCallback(macro, startOffset, expansionLocationOffset, replacementLength);
            callback.startExpansion(argsAsChar);
            this.inputTokenStream.pushMacroExpansionContext(replacement, expansionLocationOffset, callback, this.macroInvokationDepth == 0);
        }
    }

    private TokenList invoke(Macro macro, List arguments) {
        ++this.macroInvokationDepth;
        TokenList result = macro.invoke(arguments);
        --this.macroInvokationDepth;
        return result;
    }

    private static char[][] convertArgsToCharArrays(List arguments) {
        char[][] chars = new char[arguments.size()][];
        int i = 0;
        while (i < arguments.size()) {
            MacroArgument arg = (MacroArgument)arguments.get(i);
            chars[i] = arg.getRawTokens().toString().toCharArray();
            ++i;
        }
        return chars;
    }

    private List collectArgumentsToFunctionLikeMacro(IToken macroName, Macro macro) {
        ArrayList<TokenList> arguments = new ArrayList<TokenList>();
        int numParams = macro.getNumParams();
        TokenList arg = new TokenList();
        int parenLevel = 0;
        if (this.check(PPToken.RPAREN)) {
            if (macro.getNumParams() > 0) {
                arguments.add(arg);
            }
        } else {
            while (true) {
                if (this.done()) {
                    return null;
                }
                if (this.check(PPToken.HASH) || this.check(PPToken.HASHHASH)) {
                    return null;
                }
                if (this.check(PPToken.NEWLINE)) {
                    this.next();
                    continue;
                }
                if (this.check(PPToken.COMMA)) {
                    if (parenLevel == 0 && arguments.size() < numParams) {
                        arguments.add(arg);
                        arg = new TokenList();
                        this.next();
                        continue;
                    }
                    arg.add(this.next());
                    continue;
                }
                if (this.check(PPToken.LPAREN)) {
                    ++parenLevel;
                    arg.add(this.next());
                    continue;
                }
                if (this.check(PPToken.RPAREN)) {
                    if (parenLevel == 0) {
                        arguments.add(arg);
                        break;
                    }
                    --parenLevel;
                    arg.add(this.next());
                    continue;
                }
                arg.add(this.next());
            }
        }
        ArrayList<MacroArgument> macroArguments = new ArrayList<MacroArgument>(arguments.size());
        int i = 0;
        while (i < arguments.size()) {
            TokenList its = (TokenList)arguments.get(i);
            macroArguments.add(new MacroArgument(its, new MacroArgument.IProcessCallback(){

                public TokenList process(TokenList tokens) {
                    return C99Preprocessor.this.pushContextAndProcess(tokens, false, false);
                }
            }));
            ++i;
        }
        if (macro.isCorrectNumberOfArguments(macroArguments.size())) {
            return macroArguments;
        }
        return null;
    }

    private IToken findPrefixTokenOnCurrentLine() {
        int contentAssistOffset = this.inputTokenStream.getContentAssistOffset() - 1;
        while (!this.check(PPToken.NEWLINE) && !this.done()) {
            IToken token = this.next(false);
            int endOffset = token.getEndOffset();
            if (this.check(PPToken.IDENT, token) && endOffset == contentAssistOffset) {
                return token;
            }
            if (endOffset <= contentAssistOffset) continue;
            return null;
        }
        return null;
    }

    private boolean controlLine() {
        IToken hash = this.next();
        int directiveStartOffset = hash.getStartOffset();
        if (this.inputTokenStream.isContentAssistOffsetReached()) {
            this.addCompletionTokenToOutputAndQuit(directiveStartOffset, DIRECTIVE_COMPLETION_TOKEN_PREFIX);
        } else if (this.inputTokenStream.isContentAssistOffsetOnCurrentLine()) {
            IToken token = this.findPrefixTokenOnCurrentLine();
            this.addCompletionTokenToOutputAndQuit(directiveStartOffset, token == null ? "" : token.toString());
        } else if (this.check(PPToken.NEWLINE)) {
            this.next();
        } else if (this.check(PPToken.DEFINE)) {
            this.next();
            this.defineDirective(directiveStartOffset, true);
        } else if (this.check(PPToken.UNDEF)) {
            this.next();
            IToken macroName = this.expect(PPToken.IDENT);
            String name = macroName.toString();
            this.log.undefineMacro(directiveStartOffset, macroName.getEndOffset() + 1, name, macroName.getStartOffset());
            this.env.removeMacro(name);
            if (!this.done()) {
                this.expect(PPToken.NEWLINE);
            }
        } else if (this.check(PPToken.INCLUDE) || this.check(PPToken.INCLUDE_NEXT)) {
            boolean includeNext = this.check(PPToken.INCLUDE_NEXT);
            this.next();
            this.includeDirective(directiveStartOffset, true, includeNext);
        } else if (this.check(PPToken.IF) || this.check(PPToken.IFDEF) || this.check(PPToken.IFNDEF)) {
            this.ifSection(directiveStartOffset);
        } else {
            if (this.check(PPToken.ELIF) || this.check(PPToken.ELSE) || this.check(PPToken.ENDIF)) {
                return true;
            }
            if (this.check(PPToken.PRAGMA) || this.check(PPToken.ERROR) || this.check(PPToken.WARNING)) {
                boolean isPragma = this.check(PPToken.PRAGMA);
                boolean isError = this.check(PPToken.ERROR);
                IToken token = this.next();
                TokenList tokens = this.collectTokensUntilNewlineOrDone();
                int endOffset = 1 + (tokens.isEmpty() ? token.getEndOffset() : tokens.last().getEndOffset());
                char[] body = tokens.toString().toCharArray();
                if (isPragma) {
                    this.log.encounterPoundPragma(directiveStartOffset, endOffset, body);
                } else if (isError) {
                    this.log.encounterPoundError(directiveStartOffset, endOffset, body);
                    this.encounterProblem(0x2000001, tokens);
                } else {
                    this.log.encounterPoundError(directiveStartOffset, endOffset, body);
                    this.encounterProblem(0x200000E, tokens);
                }
                if (!this.done()) {
                    this.expect(PPToken.NEWLINE);
                }
            } else {
                IToken invalidDirective = this.next();
                this.encounterProblem(0x2000006, invalidDirective);
                this.skipLine();
            }
        }
        return false;
    }

    private void ifSection(int directiveStartOffset) {
        boolean takeIfBranch = this.check(PPToken.IFDEF) || this.check(PPToken.IFNDEF) ? this.handleIfDef(directiveStartOffset) : this.handleIf(directiveStartOffset, true);
        int hashOffset = takeIfBranch ? this.processBranch() : this.skipBranch();
        this.elseGroups(takeIfBranch, hashOffset);
    }

    private void elseGroups(boolean skipRest, int hashOffset) {
        while (!this.done()) {
            if (this.check(PPToken.ENDIF)) {
                this.handleEndif(hashOffset);
                return;
            }
            if (this.check(PPToken.ELIF)) {
                boolean followBranch = this.handleIf(hashOffset, !skipRest);
                if (followBranch) {
                    skipRest = true;
                    hashOffset = this.processBranch();
                    continue;
                }
                hashOffset = this.skipBranch();
                continue;
            }
            if (this.check(PPToken.ELSE)) {
                this.handleElse(hashOffset, !skipRest);
                if (skipRest) {
                    hashOffset = this.skipBranch();
                    continue;
                }
                hashOffset = this.processBranch();
                continue;
            }
            throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
        }
    }

    private boolean handleIfDef(int directiveStartOffset) {
        boolean isIfdef = this.check(PPToken.IFDEF);
        this.next();
        IToken ident = this.expect(PPToken.IDENT);
        this.skipLine();
        boolean takeIfBranch = isIfdef == this.env.hasMacro(ident.toString());
        int directiveEndOffset = ident.getEndOffset() + 1;
        char[] condition = ident.toString().toCharArray();
        if (isIfdef) {
            this.log.encounterPoundIfdef(directiveStartOffset, directiveEndOffset, takeIfBranch, condition);
        } else {
            this.log.encounterPoundIfndef(directiveStartOffset, directiveEndOffset, takeIfBranch, condition);
        }
        return takeIfBranch;
    }

    private boolean handleIf(int directiveStartOffset, boolean evaluate) {
        boolean followBranch;
        boolean isIf = this.check(PPToken.IF);
        IToken ifToken = this.next();
        TokenList expressionTokens = this.collectTokensUntilNewlineOrDone();
        char[] expressionChars = expressionTokens.toString().toCharArray();
        int endOffset = 1 + (expressionTokens.isEmpty() ? ifToken.getEndOffset() : expressionTokens.last().getEndOffset());
        Long value = evaluate ? this.evaluateConstantExpression(expressionTokens) : new Long(0L);
        if (value == null) {
            this.encounterProblem(0x2000008, directiveStartOffset, endOffset);
        }
        if (!this.done()) {
            this.expect(PPToken.NEWLINE);
        }
        boolean bl = followBranch = value != null && value != 0L;
        if (isIf) {
            this.log.encounterPoundIf(directiveStartOffset, endOffset, followBranch, expressionChars);
        } else {
            this.log.encounterPoundElif(directiveStartOffset, endOffset, followBranch, expressionChars);
        }
        return followBranch;
    }

    private Long evaluateConstantExpression(TokenList expressionTokens) {
        TokenList constantExpression;
        if (expressionTokens == null || expressionTokens.isEmpty()) {
            return null;
        }
        try {
            this.log.setIgnoreMacroExpansions(true);
            constantExpression = this.pushContextAndProcess(expressionTokens, true, true);
            this.log.setIgnoreMacroExpansions(false);
        }
        catch (PreprocessorInternalParseException preprocessorInternalParseException) {
            return null;
        }
        C99ExprEvaluator evaluator = new C99ExprEvaluator(constantExpression, this.comparator);
        return evaluator.evaluate();
    }

    private void handleElse(int directiveStartOffset, boolean taken) {
        IToken els = this.next();
        this.log.encounterPoundElse(directiveStartOffset, els.getEndOffset() + 1, taken);
    }

    private void handleEndif(int directiveStartOffset) {
        IToken endif = this.next();
        this.log.encounterPoundEndIf(directiveStartOffset, endif.getEndOffset() + 1);
        if (!this.done()) {
            this.expect(PPToken.NEWLINE);
        }
    }

    private void includeDirective(int directiveStart, boolean active, boolean includeNext) {
        TokenList includeBody;
        int directiveEnd;
        int fileNameEnd;
        int fileNameStart;
        File currentDirectory = this.inputTokenStream.getCurrentDirectory();
        String currentFileName = this.inputTokenStream.getCurrentFileName();
        TokenList tokens = this.collectTokensUntilNewlineOrDone();
        if (tokens.isEmpty()) {
            int code = 0x2000002;
            this.encounterProblemInclude(code, directiveStart, directiveStart, directiveStart, directiveStart, null, false);
            return;
        }
        if (this.check(PPToken.LEFT_ANGLE_BRACKET, tokens.first()) && this.check(PPToken.RIGHT_ANGLE_BRACKET, tokens.last()) || tokens.size() == 1 && this.check(PPToken.STRINGLIT, tokens.first())) {
            fileNameStart = tokens.first().getStartOffset() + 1;
            fileNameEnd = tokens.last().getEndOffset();
            directiveEnd = fileNameEnd + 1;
            includeBody = tokens;
        } else {
            fileNameStart = tokens.first().getStartOffset();
            directiveEnd = fileNameEnd = tokens.last().getEndOffset() + 1;
            this.log.setIgnoreMacroExpansions(true);
            includeBody = this.pushContextAndProcess(tokens, true, false);
            this.log.setIgnoreMacroExpansions(false);
        }
        String fileName = this.computeIncludeFileName(includeBody);
        if (fileName == null) {
            int code = 0x2000002;
            this.encounterProblemInclude(code, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, false);
            return;
        }
        if (!$assertionsDisabled && fileName.length() < 2) {
            throw new AssertionError();
        }
        boolean local = fileName.startsWith("\"");
        fileName = fileName.substring(1, fileName.length() - 1);
        if (!active) {
            this.log.encounterPoundInclude(directiveStart, fileNameStart, fileNameEnd, directiveEnd, fileName.toCharArray(), !local, false);
            return;
        }
        CodeReader reader = this.computeCodeReaderForInclusion(fileName, currentDirectory, includeNext, local);
        if (reader == null) {
            this.encounterProblemInclude(0x2000002, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, !local);
        } else if (this.inputTokenStream.isCircularInclusion(reader) || new String(reader.filename).equals(currentFileName)) {
            this.encounterProblemInclude(0x200000B, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, !local);
        } else {
            this.addIncludedFileToInputStream(reader, directiveStart, directiveEnd, fileNameStart, fileNameEnd, fileName, !local, false);
        }
    }

    private CodeReader computeCodeReaderForInclusion(String fileName, File currentDirectory, boolean includeNext, boolean local) {
        String[] standardIncludePaths;
        if (new File(fileName).isAbsolute() || fileName.startsWith("/")) {
            return this.createCodeReader("", fileName);
        }
        if (includeNext) {
            return this.computeCodeReaderForIncludeNext(fileName, currentDirectory);
        }
        CodeReader reader = null;
        if (local && currentDirectory != null && (reader = this.createCodeReader(currentDirectory.getAbsolutePath(), fileName)) != null) {
            return reader;
        }
        if (this.scanInfo != null && (standardIncludePaths = this.scanInfo.getIncludePaths()) != null) {
            int i = 0;
            while (i < standardIncludePaths.length) {
                reader = this.createCodeReader(standardIncludePaths[i], fileName);
                if (reader != null) break;
                ++i;
            }
        }
        return reader;
    }

    private CodeReader computeCodeReaderForIncludeNext(String fileName, File currentDirectory) {
        if (!(this.scanInfo instanceof IExtendedScannerInfo)) {
            return null;
        }
        IExtendedScannerInfo extendedScannerInfo = (IExtendedScannerInfo)this.scanInfo;
        String[] localPaths = extendedScannerInfo.getLocalIncludePath();
        String[] systemPaths = extendedScannerInfo.getIncludePaths();
        String[] allPaths = new String[localPaths.length + systemPaths.length];
        System.arraycopy(localPaths, 0, allPaths, 0, localPaths.length);
        System.arraycopy(systemPaths, 0, allPaths, localPaths.length, systemPaths.length);
        try {
            String parent = currentDirectory.getCanonicalPath();
            int pathIndex = -1;
            int i = 0;
            while (i < allPaths.length) {
                String path = new File(allPaths[i]).getCanonicalPath();
                if (path.equals(parent)) {
                    pathIndex = i;
                    break;
                }
                ++i;
            }
            i = pathIndex + 1;
            while (i < allPaths.length) {
                CodeReader reader = this.createCodeReader(allPaths[i], fileName);
                if (reader != null) {
                    return reader;
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private void encounterProblemInclude(int problemCode, int directiveStart, int directiveEnd, int nameStart, int nameEnd, String fileName, boolean systemInclude) {
        this.encounterProblem(problemCode, directiveStart, directiveEnd - 1);
        char[] chars = fileName == null ? null : fileName.toCharArray();
        this.log.encounterPoundInclude(directiveStart, nameStart, nameEnd, directiveEnd, chars, systemInclude, true);
    }

    private String computeIncludeFileName(TokenList includeBody) {
        if (includeBody == null || includeBody.isEmpty() || includeBody.size() == 2) {
            return null;
        }
        if (includeBody.size() == 1) {
            IToken token = includeBody.first();
            if (this.check(PPToken.STRINGLIT, token)) {
                return token.toString();
            }
            return null;
        }
        IToken first = includeBody.first();
        IToken last = includeBody.last();
        if (!this.check(PPToken.LEFT_ANGLE_BRACKET, first) || !this.check(PPToken.RIGHT_ANGLE_BRACKET, last)) {
            return null;
        }
        return includeBody.toString();
    }

    private TokenList collectTokensUntilNewlineOrDone() {
        TokenList result = new TokenList();
        while (!this.check(PPToken.NEWLINE) && !this.done()) {
            result.add(this.next());
        }
        return result;
    }

    private TokenList pushContextAndProcess(TokenList newInput, boolean singleLine, boolean handleDefined) {
        if (newInput == null || newInput.isEmpty()) {
            return new TokenList();
        }
        TokenList savedArgumentOutputStream = this.argumentOutputStream;
        this.inputTokenStream.pushIsolatedContext(newInput, null);
        this.argumentOutputStream = new TokenList();
        if (singleLine) {
            this.textLine(handleDefined);
        } else {
            this.process();
        }
        this.inputTokenStream.peek();
        if (!this.inputTokenStream.isStuck()) {
            throw new PreprocessorInternalParseException(this.inputTokenStream.getCurrentFileName());
        }
        this.inputTokenStream.resume();
        TokenList result = this.argumentOutputStream;
        this.argumentOutputStream = savedArgumentOutputStream;
        return result;
    }

    private Macro defineDirective(int startOffset, boolean logMacro) {
        Macro macro;
        if (!this.check(PPToken.IDENT)) {
            IToken badToken = this.next();
            this.encounterProblem(0x2000005, badToken.getStartOffset(), badToken.getEndOffset());
            this.skipLine();
            return null;
        }
        IToken macroName = this.next();
        if (this.check(PPToken.LPAREN) && this.inputTokenStream.getCurrentOffset() == macroName.getEndOffset() + 1) {
            boolean problem;
            IToken rparen;
            LinkedHashSet<String> paramNames;
            String varArgParamName;
            block20: {
                this.next();
                varArgParamName = null;
                paramNames = new LinkedHashSet<String>();
                rparen = null;
                problem = false;
                if (this.check(PPToken.RPAREN)) {
                    rparen = this.next();
                } else {
                    while (this.check(PPToken.IDENT)) {
                        String paramName = this.next().toString();
                        if (this.check(PPToken.DOTDOTDOT)) {
                            this.next();
                            varArgParamName = paramName;
                            if (this.check(PPToken.RPAREN)) {
                                rparen = this.next();
                            } else {
                                problem = true;
                            }
                        } else {
                            paramNames.add(paramName);
                            if (this.check(PPToken.COMMA)) {
                                this.next();
                                continue;
                            }
                            if (this.check(PPToken.RPAREN)) {
                                rparen = this.next();
                            } else {
                                problem = true;
                            }
                        }
                        break block20;
                    }
                    if (this.check(PPToken.DOTDOTDOT)) {
                        this.next();
                        varArgParamName = "__VA_ARGS__";
                        if (this.check(PPToken.RPAREN)) {
                            rparen = this.next();
                        } else {
                            problem = true;
                        }
                    } else {
                        problem = true;
                    }
                }
            }
            if (problem) {
                this.encounterProblem(0x2000005, startOffset, this.inputTokenStream.getCurrentOffset());
                this.skipLine();
                return null;
            }
            TokenList replacementList = this.replacementListTokens(paramNames, varArgParamName);
            if (this.startsOrEndsWithHashHash(replacementList)) {
                this.encounterProblem(0x200000A, startOffset, this.inputTokenStream.getCurrentOffset());
                this.skipLine();
                return null;
            }
            int endOffset = this.calculateMacroDefinitionEndOffset(rparen, replacementList);
            macro = new Macro(macroName, replacementList, startOffset, endOffset, paramNames, varArgParamName, this.comparator);
        } else {
            TokenList replacementList = this.replacementListTokens(null, null);
            int endOffset = this.calculateMacroDefinitionEndOffset(macroName, replacementList);
            macro = new Macro(macroName, replacementList, startOffset, endOffset, this.comparator);
        }
        this.env.addMacro(macro);
        if (logMacro) {
            this.log.defineMacro(macro);
        }
        return macro;
    }

    private boolean startsOrEndsWithHashHash(TokenList tokens) {
        if (tokens.isEmpty()) {
            return false;
        }
        return this.check(PPToken.HASHHASH, tokens.first()) || this.check(PPToken.HASHHASH, tokens.last());
    }

    private int calculateMacroDefinitionEndOffset(IToken tokenBeforeReplacementList, TokenList replacementList) {
        if (replacementList == null || replacementList.isEmpty()) {
            return tokenBeforeReplacementList.getEndOffset() + 1;
        }
        IToken last = replacementList.last();
        if (this.check(PPToken.NEWLINE, last)) {
            return last.getStartOffset();
        }
        return replacementList.last().getEndOffset() + 1;
    }

    private TokenList replacementListTokens(Set paramNames, String varArgParamName) {
        TokenList tokens = new TokenList();
        while (!this.check(PPToken.NEWLINE) && !this.done()) {
            IToken token = this.next();
            if (this.isParamName(token, paramNames, varArgParamName)) {
                token.setPreprocessorAttribute(3);
            }
            tokens.add(token);
        }
        if (!this.done()) {
            this.next();
        }
        return tokens;
    }

    private boolean isParamName(IToken token, Set paramNames, String varArgParamName) {
        if (!this.check(PPToken.IDENT, token)) {
            return false;
        }
        if (paramNames == null) {
            return false;
        }
        String ident = token.toString();
        return paramNames.contains(ident) || ident.equals(varArgParamName);
    }

    private class MacroExpansionCallback
    implements InputTokenStream.IIncludeContextCallback {
        boolean popped = false;
        boolean disabled = false;
        int directiveStartOffset;
        int directiveEndOffset;
        int replacementLength;
        int expansionEndOffset;
        Macro macro;

        MacroExpansionCallback(Macro macro, int directiveStartOffset, int directiveEndOffset, int replacementLength) {
            this.directiveStartOffset = directiveStartOffset;
            this.directiveEndOffset = directiveEndOffset;
            this.replacementLength = replacementLength;
            this.macro = macro;
        }

        public void startExpansion(char[][] args) {
            if (C99Preprocessor.this.macroInvokationDepth == 0) {
                C99Preprocessor.this.log.startMacroExpansion(this.macro, this.directiveStartOffset, this.directiveEndOffset, args);
            }
        }

        public void contextClosed() {
            if (!this.popped) {
                this.expansionEndOffset = C99Preprocessor.this.inputTokenStream.adjust(this.replacementLength) + 1;
            }
            this.popped = true;
            if (this.disabled) {
                return;
            }
            if (C99Preprocessor.this.macroInvokationDepth == 0) {
                C99Preprocessor.this.log.endMacroExpansion(this.macro, this.expansionEndOffset);
            }
        }

        public void macroOverlapClose() {
            if (C99Preprocessor.this.macroInvokationDepth == 0) {
                C99Preprocessor.this.log.endMacroExpansion(this.macro, this.directiveEndOffset);
            }
        }

        public int getSourceLength() {
            return this.directiveEndOffset - this.directiveStartOffset + 1;
        }
    }

    private static class PreprocessorAbortParseException
    extends RuntimeException {
        private PreprocessorAbortParseException() {
        }
    }

    private static class PreprocessorInternalParseException
    extends RuntimeException {
        public PreprocessorInternalParseException() {
        }

        public PreprocessorInternalParseException(String message) {
            super(message);
        }
    }
}

