/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultBuildData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFileData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultFolderData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDefaultTargetPlatformData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.runtime.IPath;

public class CDataFacroty {
    private static CDataFacroty fInstance;

    public static CDataFacroty getDefault() {
        if (fInstance == null) {
            fInstance = new CDataFacroty();
        }
        return fInstance;
    }

    public CConfigurationData createConfigurationdata(String id, String name, CConfigurationData base, boolean clone) {
        if (clone) {
            id = base.getId();
        } else if (id == null) {
            id = CDataUtil.genId(null);
        }
        return new CDefaultConfigurationData(id, name, base, this, clone);
    }

    public CFolderData createFolderData(CConfigurationData cfg, CFolderData base, String id, boolean clone, IPath path) {
        if (id == null) {
            id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
        }
        return new CDefaultFolderData(id, path, base, cfg, this, clone);
    }

    public CFileData createFileData(CConfigurationData cfg, CResourceData base, CLanguageData lBase, String id, boolean clone, IPath path) {
        if (id == null) {
            String string = id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
        }
        if (base != null && base.getType() == 8) {
            return new CDefaultFileData(id, path, (CFileData)base, cfg, this, clone);
        }
        return new CDefaultFileData(id, path, (CFolderData)base, lBase, cfg, this);
    }

    public CLanguageData createLanguageData(CConfigurationData cfg, CResourceData rcBase, CLanguageData base, String id, boolean clone) {
        if (id == null) {
            id = clone ? base.getId() : CDataUtil.genId(rcBase.getId());
        }
        return new CDefaultLanguageData(id, base);
    }

    public CLanguageData createLanguageData(CConfigurationData cfg, CResourceData rcBase, String id, String name, String languageId, int supportedEntryKinds, String[] rcTypes, boolean isContentTypes) {
        if (id == null) {
            id = CDataUtil.genId(rcBase.getId());
        }
        CDefaultLanguageData lData = new CDefaultLanguageData(id, languageId, rcTypes, isContentTypes);
        lData.fName = name;
        lData.fSupportedKinds = supportedEntryKinds;
        return lData;
    }

    public CBuildData createBuildData(CConfigurationData cfg, CBuildData base, String id, String name, boolean clone) {
        if (id == null) {
            id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
        }
        CDefaultBuildData data = new CDefaultBuildData(id, base);
        data.fName = name;
        return data;
    }

    public CTargetPlatformData createTargetPlatformData(CConfigurationData cfg, CTargetPlatformData base, String id, String name, boolean clone) {
        if (id == null) {
            id = clone ? base.getId() : CDataUtil.genId(cfg.getId());
        }
        CDefaultTargetPlatformData tpData = new CDefaultTargetPlatformData(id, base);
        tpData.fName = name;
        return tpData;
    }

    public boolean isModified(CDataObject data) {
        switch (data.getType()) {
            case 2: {
                return ((CDefaultConfigurationData)data).isModified();
            }
            case 4: {
                return ((CDefaultFolderData)data).isModified();
            }
            case 8: {
                return ((CDefaultFileData)data).isModified();
            }
            case 16: {
                return ((CDefaultLanguageData)data).isModified();
            }
            case 32: {
                return ((CDefaultTargetPlatformData)data).isModified();
            }
            case 64: {
                return ((CDefaultBuildData)data).isModified();
            }
        }
        return false;
    }

    public void setModified(CDataObject data, boolean modified) {
        if (data == null) {
            return;
        }
        switch (data.getType()) {
            case 2: {
                ((CDefaultConfigurationData)data).setModified(modified);
                break;
            }
            case 4: {
                ((CDefaultFolderData)data).setModified(modified);
                break;
            }
            case 8: {
                ((CDefaultFileData)data).setModified(modified);
                break;
            }
            case 16: {
                ((CDefaultLanguageData)data).setModified(modified);
                break;
            }
            case 32: {
                ((CDefaultTargetPlatformData)data).setModified(modified);
                break;
            }
            case 64: {
                ((CDefaultBuildData)data).setModified(modified);
            }
        }
    }

    public void link(CDataObject parent, CDataObject child) {
        switch (parent.getType()) {
            case 2: {
                switch (child.getType()) {
                    case 4: 
                    case 8: {
                        ((CDefaultConfigurationData)parent).addRcData((CResourceData)child);
                        break;
                    }
                    case 32: {
                        ((CDefaultConfigurationData)parent).fTargetPlatformData = (CTargetPlatformData)child;
                        break;
                    }
                    case 64: {
                        ((CDefaultConfigurationData)parent).fBuildData = (CBuildData)child;
                    }
                }
                break;
            }
            case 4: {
                ((CDefaultFolderData)parent).fLanguageDatas.add(child);
                break;
            }
            case 8: {
                ((CDefaultFileData)parent).fLanguageData = (CLanguageData)child;
            }
        }
    }
}

