/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.core.templateengine.process.ProcessParameter;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ProcessRunnerFactory {
    private static final String EXTENSION_POINT_PROCESSES = "org.eclipse.cdt.core.templateProcessTypes";
    private static final String ELEM_NAME = "name";
    private static final String ELEM_PROCESS_RUNNER = "processRunner";
    private static ProcessRunnerFactory instance = new ProcessRunnerFactory();
    private Map processRunnerMap;

    private ProcessRunnerFactory() {
        this.initializeProcessRunners();
    }

    private synchronized void initializeProcessRunners() {
        this.processRunnerMap = new HashMap();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_PROCESSES);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String prefix = String.valueOf(extension.getNamespaceIdentifier()) + ".";
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                IConfigurationElement element = configurationElements[j];
                String processType = element.getAttribute(ELEM_NAME);
                if (processType != null) {
                    try {
                        ProcessRunner runner = (ProcessRunner)element.createExecutableExtension(ELEM_PROCESS_RUNNER);
                        ArrayList<ProcessParameter> params = null;
                        IConfigurationElement[] elementChildren = element.getChildren();
                        int k = 0;
                        while (k < elementChildren.length) {
                            if (params == null) {
                                params = new ArrayList<ProcessParameter>();
                            }
                            params.add(new ProcessParameter(elementChildren[k]));
                            ++k;
                        }
                        if (params != null) {
                            runner.setProcessParameters(params.toArray(new ProcessParameter[params.size()]));
                        }
                        this.processRunnerMap.put(String.valueOf(prefix) + processType, runner);
                    }
                    catch (CoreException e) {
                        TemplateEngineUtil.log(e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static ProcessRunnerFactory getDefault() {
        return instance;
    }

    public ProcessRunner getProcessRunner(String processType) {
        return (ProcessRunner)this.processRunnerMap.get(processType);
    }
}

