/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.XmlStorageElement;
import org.eclipse.cdt.internal.core.cdtvariables.CoreMacroSupplierBase;
import org.eclipse.cdt.internal.core.cdtvariables.ICdtVariableChangeListener;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.internal.core.cdtvariables.VariableChangeEvent;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationSpecSettings;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserDefinedVariableSupplier
extends CoreMacroSupplierBase {
    public static final String NODENAME = "macros";
    public static final String PREFNAME_WORKSPACE = "workspace";
    static final String OLD_VARIABLE_PREFIX = "pathEntryVariable.";
    private static UserDefinedVariableSupplier fInstance;
    private StorableCdtVariables fWorkspaceMacros;
    private Set fListeners = Collections.synchronizedSet(new HashSet());

    private StorableCdtVariables getStorableMacros(int contextType, Object contextData) {
        StorableCdtVariables macros = null;
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof IInternalCCfgInfo)) break;
                try {
                    CConfigurationSpecSettings settings = ((IInternalCCfgInfo)contextData).getSpecSettings();
                    macros = settings.getMacros();
                }
                catch (CoreException coreException) {}
                break;
            }
            case 5: {
                if (contextData != null && !(contextData instanceof IWorkspace)) break;
                if (this.fWorkspaceMacros == null) {
                    this.fWorkspaceMacros = this.loadWorkspaceMacros();
                }
                macros = this.fWorkspaceMacros;
            }
        }
        return macros;
    }

    private UserDefinedVariableSupplier() {
    }

    public static UserDefinedVariableSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new UserDefinedVariableSupplier();
        }
        return fInstance;
    }

    public ICdtVariable getMacro(String macroName, int contextType, Object contextData) {
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros != null) {
            return macros.getMacro(macroName);
        }
        return null;
    }

    public ICdtVariable[] getMacros(int contextType, Object contextData) {
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros != null) {
            return macros.getMacros();
        }
        return null;
    }

    public ICdtVariable createMacro(String macroName, int type, String value, int contextType, Object contextData) {
        VariableChangeEvent event;
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        ICdtVariable oldVar = macros.getMacro(macroName);
        ICdtVariable macro = macros.createMacro(macroName, type, value);
        if (macros.isChanged()) {
            macros.setChanged(false);
        }
        if (macro != null && (event = UserDefinedVariableSupplier.createVariableChangeEvent(macro, oldVar)) != null) {
            this.notifyListeners(event);
        }
        return macro;
    }

    public ICdtVariable createMacro(String macroName, int type, String[] value, int contextType, Object contextData) {
        VariableChangeEvent event;
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        ICdtVariable oldVar = macros.getMacro(macroName);
        ICdtVariable macro = macros.createMacro(macroName, type, value);
        if (macros.isChanged()) {
            macros.setChanged(false);
        }
        if (macro != null && (event = UserDefinedVariableSupplier.createVariableChangeEvent(macro, oldVar)) != null) {
            this.notifyListeners(event);
        }
        return macro;
    }

    public ICdtVariable createMacro(ICdtVariable copy, int contextType, Object contextData) {
        VariableChangeEvent event;
        if (copy == null) {
            return null;
        }
        String macroName = copy.getName();
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        ICdtVariable oldVar = macros.getMacro(macroName);
        ICdtVariable macro = macros.createMacro(copy);
        if (macros.isChanged()) {
            macros.setChanged(false);
        }
        if (macro != null && (event = UserDefinedVariableSupplier.createVariableChangeEvent(macro, oldVar)) != null) {
            this.notifyListeners(event);
        }
        return macro;
    }

    public ICdtVariable deleteMacro(String name, int contextType, Object contextData) {
        VariableChangeEvent event;
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        ICdtVariable macro = macros.deleteMacro(name);
        if (macro != null && (event = UserDefinedVariableSupplier.createVariableChangeEvent(null, macro)) != null) {
            this.notifyListeners(event);
        }
        return macro;
    }

    public void deleteAll(int contextType, Object contextData) {
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return;
        }
        ICdtVariable[] oldVars = macros.getMacros();
        macros.deleteAll();
        VariableChangeEvent event = UserDefinedVariableSupplier.createVariableChangeEvent(null, oldVars);
        if (event != null) {
            this.notifyListeners(event);
        }
    }

    public void setMacros(ICdtVariable[] m, int contextType, Object contextData) {
        StorableCdtVariables macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return;
        }
        ICdtVariable[] oldVars = macros.getMacros();
        macros.setMacros(m);
        if (macros.isChanged()) {
            macros.setChanged(false);
            VariableChangeEvent event = UserDefinedVariableSupplier.createVariableChangeEvent(m, oldVars);
            if (event != null) {
                this.notifyListeners(event);
            }
        }
    }

    static VariableChangeEvent createVariableChangeEvent(ICdtVariable newVar, ICdtVariable oldVar) {
        ICdtVariable[] iCdtVariableArray;
        ICdtVariable[] newVars;
        ICdtVariable[] iCdtVariableArray2;
        if (newVar != null) {
            ICdtVariable[] iCdtVariableArray3 = new ICdtVariable[1];
            iCdtVariableArray2 = iCdtVariableArray3;
            iCdtVariableArray3[0] = newVar;
        } else {
            iCdtVariableArray2 = newVars = null;
        }
        if (oldVar != null) {
            ICdtVariable[] iCdtVariableArray4 = new ICdtVariable[1];
            iCdtVariableArray = iCdtVariableArray4;
            iCdtVariableArray4[0] = oldVar;
        } else {
            iCdtVariableArray = null;
        }
        ICdtVariable[] oldVars = iCdtVariableArray;
        return UserDefinedVariableSupplier.createVariableChangeEvent(newVars, oldVars);
    }

    static ICdtVariable[] varsFromKeySet(Set set) {
        ICdtVariable[] vars = new ICdtVariable[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            VarKey key = (VarKey)iter.next();
            vars[i] = key.getVariable();
            ++i;
        }
        return vars;
    }

    static VariableChangeEvent createVariableChangeEvent(ICdtVariable[] newVars, ICdtVariable[] oldVars) {
        ICdtVariable[] addedVars = null;
        ICdtVariable[] removedVars = null;
        ICdtVariable[] changedVars = null;
        if (oldVars == null || oldVars.length == 0) {
            if (newVars != null && newVars.length != 0) {
                addedVars = (ICdtVariable[])newVars.clone();
            }
        } else if (newVars == null || newVars.length == 0) {
            removedVars = (ICdtVariable[])oldVars.clone();
        } else {
            HashSet<VarKey> newSet = new HashSet<VarKey>(newVars.length);
            HashSet<VarKey> oldSet = new HashSet<VarKey>(oldVars.length);
            int i = 0;
            while (i < newVars.length) {
                newSet.add(new VarKey(newVars[i], true));
                ++i;
            }
            i = 0;
            while (i < oldVars.length) {
                oldSet.add(new VarKey(oldVars[i], true));
                ++i;
            }
            HashSet newSetCopy = (HashSet)newSet.clone();
            newSet.removeAll(oldSet);
            oldSet.removeAll(newSetCopy);
            if (newSet.size() != 0) {
                addedVars = UserDefinedVariableSupplier.varsFromKeySet(newSet);
            }
            if (oldSet.size() != 0) {
                removedVars = UserDefinedVariableSupplier.varsFromKeySet(oldSet);
            }
            newSetCopy.removeAll(newSet);
            HashSet<VarKey> modifiedSet = new HashSet<VarKey>(newSetCopy.size());
            Iterator iter = newSetCopy.iterator();
            while (iter.hasNext()) {
                VarKey key = (VarKey)iter.next();
                modifiedSet.add(new VarKey(key.getVariable(), false));
            }
            int i2 = 0;
            while (i2 < oldVars.length) {
                modifiedSet.remove(new VarKey(oldVars[i2], false));
                ++i2;
            }
            if (modifiedSet.size() != 0) {
                changedVars = UserDefinedVariableSupplier.varsFromKeySet(modifiedSet);
            }
        }
        if (addedVars != null || removedVars != null || changedVars != null) {
            return new VariableChangeEvent(addedVars, removedVars, changedVars);
        }
        return null;
    }

    public void storeWorkspaceVariables(boolean force) {
        try {
            if (this.fWorkspaceMacros != null) {
                this.storeWorkspaceMacros(this.fWorkspaceMacros, force);
            }
        }
        catch (CoreException coreException) {}
    }

    public StorableCdtVariables getWorkspaceVariablesCopy() {
        StorableCdtVariables vars = this.getStorableMacros(5, null);
        return new StorableCdtVariables(vars, false);
    }

    public boolean setWorkspaceVariables(StorableCdtVariables vars) throws CoreException {
        StorableCdtVariables old = this.getStorableMacros(5, null);
        ICdtVariable[] oldVars = null;
        if (old != null) {
            oldVars = old.getMacros();
        }
        ICdtVariable[] newVars = vars.getMacros();
        this.fWorkspaceMacros = new StorableCdtVariables(vars, false);
        VariableChangeEvent event = UserDefinedVariableSupplier.createVariableChangeEvent(newVars, oldVars);
        if (event != null) {
            this.notifyListeners(event);
        }
        this.storeWorkspaceVariables(true);
        return event != null;
    }

    private org.osgi.service.prefs.Preferences getWorkspaceNode() {
        IEclipsePreferences prefNode = new InstanceScope().getNode("org.eclipse.cdt.core");
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    protected StorableCdtVariables loadWorkspaceMacros() {
        StorableCdtVariables macros = this.loadNewStileWorkspaceMacros();
        this.loadPathEntryVariables(macros);
        if (macros.isDirty()) {
            try {
                this.storeWorkspaceMacros(macros, true);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return macros;
    }

    protected void loadPathEntryVariables(StorableCdtVariables vars) {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String[] names = prefs.propertyNames();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (name.startsWith(OLD_VARIABLE_PREFIX)) {
                String value = prefs.getString(name);
                prefs.setToDefault(name);
                if (value.length() != 0) {
                    name = name.substring(OLD_VARIABLE_PREFIX.length());
                    vars.createMacro(name, 7, value);
                }
            }
            ++i;
        }
    }

    protected StorableCdtVariables loadNewStileWorkspaceMacros() {
        InputStream stream = this.loadInputStream(this.getWorkspaceNode(), PREFNAME_WORKSPACE);
        if (stream == null) {
            return new StorableCdtVariables(false);
        }
        return this.loadMacrosFromStream(stream, false);
    }

    protected void storeWorkspaceMacros(StorableCdtVariables macros, boolean force) throws CoreException {
        if (!macros.isDirty() && !force) {
            return;
        }
        ByteArrayOutputStream stream = this.storeMacrosToStream(macros);
        if (stream == null) {
            return;
        }
        this.storeOutputStream(stream, this.getWorkspaceNode(), PREFNAME_WORKSPACE);
    }

    private StorableCdtVariables loadMacrosFromStream(InputStream stream, boolean readOnly) {
        Element rootElement;
        block5: {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(stream);
            Document document = parser.parse(inputSource);
            rootElement = document.getDocumentElement();
            if (NODENAME.equals(rootElement.getNodeName())) break block5;
            return null;
        }
        try {
            return new StorableCdtVariables(new XmlStorageElement(rootElement), readOnly);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private ByteArrayOutputStream storeMacrosToStream(StorableCdtVariables macros) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(NODENAME);
            document.appendChild(rootElement);
            XmlStorageElement storageElement = new XmlStorageElement(rootElement);
            macros.serialize(storageElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream;
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw ExceptionFactory.createCoreException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw ExceptionFactory.createCoreException(e.getMessage(), e);
        }
    }

    private InputStream loadInputStream(org.osgi.service.prefs.Preferences node, String key) {
        byte[] bytes;
        if (node == null || key == null) {
            return null;
        }
        String value = node.get(key, null);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = value.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private void storeOutputStream(ByteArrayOutputStream stream, org.osgi.service.prefs.Preferences node, String key) throws CoreException {
        if (stream == null || node == null || key == null) {
            throw ExceptionFactory.createCoreException(new IllegalArgumentException());
        }
        byte[] bytes = stream.toByteArray();
        String val = null;
        try {
            val = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            val = new String(bytes);
        }
        node.put(key, val);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw ExceptionFactory.createCoreException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void addListener(ICdtVariableChangeListener listener) {
        this.fListeners.add(listener);
    }

    public void removeListener(ICdtVariableChangeListener listener) {
        this.fListeners.remove(listener);
    }

    private void notifyListeners(VariableChangeEvent event) {
        ICdtVariableChangeListener[] listeners = this.fListeners.toArray(new ICdtVariableChangeListener[this.fListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].variablesChanged(event);
            ++i;
        }
    }

    public boolean containsVariable(int context, Object data, ICdtVariable var) {
        ICdtVariable varContained = this.getMacro(var.getName(), context, data);
        if (varContained == null) {
            return false;
        }
        return new VarKey(varContained, false).equals(new VarKey(var, false));
    }

    static class VarKey {
        private ICdtVariable fVar;
        private boolean fNameOnly;

        VarKey(ICdtVariable var, boolean nameOnly) {
            this.fVar = var;
            this.fNameOnly = nameOnly;
        }

        public ICdtVariable getVariable() {
            return this.fVar;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VarKey)) {
                return false;
            }
            VarKey other = (VarKey)obj;
            ICdtVariable otherVar = other.fVar;
            if (this.fVar == otherVar) {
                return true;
            }
            if (!CDataUtil.objectsEqual(this.fVar.getName(), otherVar.getName())) {
                return false;
            }
            if (this.fNameOnly) {
                return true;
            }
            if (this.fVar.getValueType() != otherVar.getValueType()) {
                return false;
            }
            if (CdtVariableResolver.isStringListVariable(this.fVar.getValueType())) {
                try {
                    if (Arrays.equals(this.fVar.getStringListValue(), otherVar.getStringListValue())) return true;
                    return false;
                }
                catch (CdtVariableException e) {
                    CCorePlugin.log((Throwable)((Object)e));
                    return true;
                }
            } else {
                try {
                    if (CDataUtil.objectsEqual(this.fVar.getStringValue(), otherVar.getStringValue())) return true;
                    return false;
                }
                catch (CdtVariableException e) {
                    CCorePlugin.log((Throwable)((Object)e));
                }
            }
            return true;
        }

        public int hashCode() {
            int code = 51;
            String name = this.fVar.getName();
            if (name != null) {
                code += name.hashCode();
            }
            if (this.fNameOnly) {
                return code;
            }
            code += this.fVar.getValueType();
            if (CdtVariableResolver.isStringListVariable(this.fVar.getValueType())) {
                try {
                    String[] value = this.fVar.getStringListValue();
                    if (value != null) {
                        int i = 0;
                        while (i < value.length) {
                            code += value[i].hashCode();
                            ++i;
                        }
                    }
                }
                catch (CdtVariableException e) {
                    CCorePlugin.log((Throwable)((Object)e));
                }
            } else {
                try {
                    String value = this.fVar.getStringValue();
                    if (value != null) {
                        code += value.hashCode();
                    }
                }
                catch (CdtVariableException e) {
                    CCorePlugin.log((Throwable)((Object)e));
                }
            }
            return code;
        }
    }
}

