/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.PlatformObject;

public class CTypedef
extends PlatformObject
implements ITypedef,
ITypeContainer {
    private final IASTName name;
    private IType type = null;

    public CTypedef(IASTName name) {
        this.name = name;
    }

    public IASTNode getPhysicalNode() {
        return this.name;
    }

    public IType getType() {
        if (this.type == null && this.name.getParent() instanceof IASTDeclarator) {
            this.type = CVisitor.createType((IASTDeclarator)this.name.getParent());
        }
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public String getName() {
        return this.name.toString();
    }

    public char[] getNameCharArray() {
        return this.name.toCharArray();
    }

    public IScope getScope() {
        IASTDeclarator declarator = (IASTDeclarator)this.name.getParent();
        return CVisitor.getContainingScope(declarator.getParent());
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public boolean isSameType(IType t) {
        if (t == this) {
            return true;
        }
        if (t instanceof ITypedef) {
            try {
                IType temp = this.getType();
                if (temp != null) {
                    return temp.isSameType(((ITypedef)t).getType());
                }
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        IType temp = this.getType();
        if (temp != null) {
            return temp.isSameType(t);
        }
        return false;
    }

    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }
}

