/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class CPPScope
implements ICPPScope,
IASTInternalScope {
    private static final IProgressMonitor NPM = new NullProgressMonitor();
    private IASTNode physicalNode;
    protected CharArrayObjectMap bindings = null;
    private boolean isfull = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CPPScope(IASTNode physicalNode) {
        this.physicalNode = physicalNode;
    }

    public IScope getParent() throws DOMException {
        return CPPVisitor.getContainingScope(this.physicalNode);
    }

    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    public void addName(IASTName name) {
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if (name instanceof ICPPASTQualifiedName) {
            return;
        }
        char[] c = name.toCharArray();
        Object o = this.bindings.get(c);
        if (o != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(name);
            } else {
                ObjectSet temp = new ObjectSet(2);
                temp.put(o);
                temp.put(name);
                this.bindings.put(c, temp);
            }
        } else {
            this.bindings.put(c, name);
        }
    }

    public IBinding getBinding(IASTName name, boolean forceResolve) throws DOMException {
        IIndex index;
        IBinding binding = this.getBindingInAST(name, forceResolve);
        if (binding == null && (index = name.getTranslationUnit().getIndex()) != null) {
            ICPPNamespace nsbindingAdapted;
            ICPPASTNamespaceDefinition nsdef;
            IASTName nsname;
            IBinding nsbinding;
            if (this.physicalNode instanceof IASTTranslationUnit) {
                try {
                    Object[] bindings = index.findBindings(name.toCharArray(), IndexFilter.getFilter("C++"), NPM);
                    binding = CPPSemantics.resolveAmbiguities(name, bindings);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            } else if (this.physicalNode instanceof ICPPASTNamespaceDefinition && (nsbinding = (nsname = (nsdef = (ICPPASTNamespaceDefinition)this.physicalNode).getName()).resolveBinding()) instanceof ICPPNamespace && (nsbindingAdapted = (ICPPNamespace)((Object)index.adaptBinding(nsbinding))) != null) {
                Object[] bindings = nsbindingAdapted.getNamespaceScope().find(name.toString());
                binding = CPPSemantics.resolveAmbiguities(name, bindings);
            }
        }
        return binding;
    }

    public IBinding getBindingInAST(IASTName name, boolean forceResolve) throws DOMException {
        Object obj;
        char[] c = name.toCharArray();
        if (c.length == 0) {
            return null;
        }
        Object object = obj = this.bindings != null ? this.bindings.get(c) : null;
        if (obj != null) {
            if (obj instanceof ObjectSet) {
                ObjectSet os = (ObjectSet)obj;
                if (forceResolve) {
                    return CPPSemantics.resolveAmbiguities(name, os.keyArray());
                }
                Object[] bs = null;
                int i = 0;
                while (i < os.size()) {
                    Object o = os.keyAt(i);
                    if (o instanceof IASTName) {
                        Class<?> clazz;
                        IASTName n = (IASTName)o;
                        if (n instanceof ICPPASTQualifiedName) {
                            IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                            n = ns[ns.length - 1];
                        }
                        if ((clazz = class$0) == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        bs = (IBinding[])ArrayUtil.append(clazz, bs, n.getBinding());
                    } else {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        bs = (IBinding[])ArrayUtil.append(clazz, bs, o);
                    }
                    ++i;
                }
                return CPPSemantics.resolveAmbiguities(name, bs);
            }
            if (obj instanceof IASTName) {
                IBinding binding = null;
                if (forceResolve && obj != name && obj != name.getParent()) {
                    binding = CPPSemantics.resolveAmbiguities(name, new Object[]{obj});
                } else {
                    IASTName n = (IASTName)obj;
                    if (n instanceof ICPPASTQualifiedName) {
                        IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                        n = ns[ns.length - 1];
                    }
                    binding = n.getBinding();
                }
                if (binding instanceof ICPPUsingDeclaration) {
                    return CPPSemantics.resolveAmbiguities(name, ((ICPPUsingDeclaration)binding).getDelegates());
                }
                return binding;
            }
            return (IBinding)obj;
        }
        return null;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) throws DOMException {
        Class<?> clazz;
        Object[] result;
        block18: {
            result = this.getBindingsInAST(name, resolve, prefixLookup);
            IIndex index = name.getTranslationUnit().getIndex();
            if (index != null) {
                if (this.physicalNode instanceof IASTTranslationUnit) {
                    try {
                        IndexFilter filter = IndexFilter.getFilter("C++");
                        Object[] bindings = prefixLookup ? index.findBindingsForPrefix(name.toCharArray(), true, filter, null) : index.findBindings(name.toCharArray(), filter, null);
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        result = (IBinding[])ArrayUtil.addAll(clazz2, result, bindings);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                } else if (this.physicalNode instanceof ICPPASTNamespaceDefinition) {
                    ICPPASTNamespaceDefinition ns = (ICPPASTNamespaceDefinition)this.physicalNode;
                    try {
                        IIndexBinding binding = index.findBinding(ns.getName());
                        if (!(binding instanceof ICPPNamespace)) break block18;
                        ICPPNamespaceScope indexNs = ((ICPPNamespace)((Object)binding)).getNamespaceScope();
                        Object[] bindings = indexNs.getBindings(name, resolve, prefixLookup);
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        result = (IBinding[])ArrayUtil.addAll(clazz3, result, bindings);
                    }
                    catch (CoreException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBinding[])ArrayUtil.trim(clazz, result);
    }

    public IBinding[] getBindingsInAST(IASTName name, boolean forceResolve, boolean prefixLookup) throws DOMException {
        Class<?> clazz;
        Object[] objectArray;
        char[] c = name.toCharArray();
        Object[] result = null;
        Object[] obj = null;
        if (prefixLookup) {
            Object[] keys = this.bindings != null ? this.bindings.keyArray() : new Object[]{};
            int i = 0;
            while (i < keys.length) {
                char[] key = (char[])keys[i];
                if (CharArrayUtils.equals(key, 0, c.length, c, true)) {
                    obj = ArrayUtil.append(obj, this.bindings.get(key));
                }
                ++i;
            }
        } else if (this.bindings != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.bindings.get(c);
        } else {
            objectArray = obj = null;
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        obj = ArrayUtil.trim(clazz, obj);
        int i = 0;
        while (i < obj.length) {
            if (obj[i] instanceof ObjectSet) {
                ObjectSet os = (ObjectSet)obj[i];
                int j = 0;
                while (j < os.size()) {
                    Object o = os.keyAt(j);
                    if (o instanceof IASTName) {
                        IASTName n = (IASTName)o;
                        if (n instanceof ICPPASTQualifiedName) {
                            IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                            n = ns[ns.length - 1];
                        }
                        IBinding binding = forceResolve ? n.resolveBinding() : n.getBinding();
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        result = (IBinding[])ArrayUtil.append(clazz2, result, binding);
                    } else {
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        result = (IBinding[])ArrayUtil.append(clazz3, result, o);
                    }
                    ++j;
                }
            } else if (obj[i] instanceof IASTName) {
                Class<?> clazz4;
                IBinding binding = null;
                if (forceResolve && obj[i] != name && obj[i] != name.getParent()) {
                    binding = ((IASTName)obj[i]).resolveBinding();
                } else {
                    IASTName n = (IASTName)obj[i];
                    if (n instanceof ICPPASTQualifiedName) {
                        IASTName[] ns = ((ICPPASTQualifiedName)n).getNames();
                        n = ns[ns.length - 1];
                    }
                    binding = n.getBinding();
                }
                if (binding instanceof ICPPUsingDeclaration) {
                    Class<?> clazz5 = class$0;
                    if (clazz5 == null) {
                        try {
                            clazz5 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = (IBinding[])ArrayUtil.addAll(clazz5, result, ((ICPPUsingDeclaration)binding).getDelegates());
                }
                if ((clazz4 = class$0) == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = (IBinding[])ArrayUtil.append(clazz4, result, binding);
            } else {
                Class<?> clazz6 = class$0;
                if (clazz6 == null) {
                    try {
                        clazz6 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = (IBinding[])ArrayUtil.append(clazz6, result, obj[i]);
            }
            ++i;
        }
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IBinding[])ArrayUtil.trim(clazz7, result);
    }

    public void setFullyCached(boolean full) {
        this.isfull = full;
    }

    public boolean isFullyCached() {
        return this.isfull;
    }

    public void removeBinding(IBinding binding) {
        char[] key = binding.getNameCharArray();
        this.removeBinding(key, binding);
    }

    protected void removeBinding(char[] key, IBinding binding) {
        if (this.bindings == null || !this.bindings.containsKey(key)) {
            return;
        }
        Object obj = this.bindings.get(key);
        if (obj instanceof ObjectSet) {
            ObjectSet set = (ObjectSet)obj;
            int i = set.size() - 1;
            while (i > 0) {
                Object o = set.keyAt(i);
                if (o instanceof IBinding && o == binding || o instanceof IASTName && ((IASTName)o).getBinding() == binding) {
                    set.remove(o);
                }
                --i;
            }
            if (set.size() == 0) {
                this.bindings.remove(key, 0, key.length);
            }
        } else if (obj instanceof IBinding && obj == binding || obj instanceof IASTName && ((IASTName)obj).getBinding() == binding) {
            this.bindings.remove(key, 0, key.length);
        }
        this.isfull = false;
    }

    public IBinding[] find(String name) throws DOMException {
        return CPPSemantics.findBindings((IScope)this, name, false);
    }

    public void flushCache() {
        this.isfull = false;
        if (this.bindings != null) {
            this.bindings.clear();
        }
    }

    public void addBinding(IBinding binding) {
        char[] c;
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((o = this.bindings.get(c = binding.getNameCharArray())) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(binding);
            } else {
                ObjectSet set = new ObjectSet(2);
                set.put(o);
                set.put(binding);
                this.bindings.put(c, set);
            }
        } else {
            this.bindings.put(c, binding);
        }
    }

    public static class CPPScopeProblem
    extends ProblemBinding
    implements ICPPScope {
        public CPPScopeProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }
    }
}

