/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public class ASTCache {
    private static final boolean DEBUG;
    private static final String DEBUG_PREFIX = "[ASTCache] ";
    public static int PARSE_MODE_FULL;
    public static int PARSE_MODE_FAST;
    private final int fParseMode;
    private final Object fCacheMutex = new Object();
    private ITranslationUnit fActiveTU;
    private IASTTranslationUnit fAST;
    private long fLastWriteOnIndex;
    private boolean fIsReconciling;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.model.ASTCache");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/ASTCache"));
        PARSE_MODE_FULL = 32;
        PARSE_MODE_FAST = 34;
    }

    public ASTCache() {
        this.fParseMode = PARSE_MODE_FAST;
    }

    /*
     * Exception decompiling
     */
    private IASTTranslationUnit getAST(ITranslationUnit tUnit, IIndex index, boolean wait, IProgressMonitor progressMonitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [10 : 580->583)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus runOnAST(ITranslationUnit tUnit, boolean wait, IProgressMonitor monitor, ASTRunnable astRunnable) {
        IStatus iStatus;
        IIndex index;
        try {
            index = CCorePlugin.getIndexManager().getIndex(tUnit.getCProject(), 1);
            index.acquireReadLock();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        try {
            try {
                ILanguage lang;
                IASTTranslationUnit ast = this.getAST(tUnit, index, wait, monitor);
                ILanguage iLanguage = lang = tUnit instanceof TranslationUnit ? ((TranslationUnit)tUnit).getLanguageOfContext() : tUnit.getLanguage();
                if (ast == null) {
                    IStatus iStatus2 = astRunnable.runOnAST(lang, ast);
                    Object var9_13 = null;
                    index.releaseReadLock();
                    return iStatus2;
                }
                IASTTranslationUnit iASTTranslationUnit = ast;
                synchronized (iASTTranslationUnit) {
                    iStatus = astRunnable.runOnAST(lang, ast);
                }
            }
            catch (CoreException e) {
                IStatus iStatus3 = e.getStatus();
                Object var9_15 = null;
                index.releaseReadLock();
                return iStatus3;
            }
        }
        catch (Throwable throwable2) {
            Object var9_16 = null;
            index.releaseReadLock();
            throw throwable2;
        }
        Object var9_14 = null;
        index.releaseReadLock();
        return iStatus;
    }

    private void cache(IASTTranslationUnit ast, ITranslationUnit tUnit) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.fCacheMutex)) {
            throw new AssertionError();
        }
        if (this.fActiveTU != null && !this.fActiveTU.equals(tUnit)) {
            if (DEBUG && tUnit != null) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "don't cache AST for inactive: " + ASTCache.toString(tUnit));
            }
            return;
        }
        if (DEBUG && (tUnit != null || ast != null)) {
            System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "caching AST: " + ASTCache.toString(ast) + " for: " + ASTCache.toString(tUnit));
        }
        if (this.fAST != null) {
            this.disposeAST();
        }
        this.fAST = ast;
        this.fLastWriteOnIndex = this.fAST == null ? 0L : this.fAST.getIndex().getLastWriteAccess();
        this.fCacheMutex.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAST() {
        Object object = this.fCacheMutex;
        synchronized (object) {
            if (this.fAST == null) {
                return;
            }
            if (DEBUG) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "disposing AST: " + ASTCache.toString(this.fAST) + " for: " + ASTCache.toString(this.fActiveTU));
            }
            this.fAST = null;
            this.cache(null, null);
        }
    }

    public IASTTranslationUnit createAST(final ITranslationUnit tUnit, final IIndex index, final IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return null;
        }
        final IASTTranslationUnit[] root = new IASTTranslationUnit[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws CoreException {
                try {
                    root[0] = progressMonitor != null && progressMonitor.isCanceled() ? null : tUnit.getAST(index, ASTCache.this.fParseMode);
                }
                catch (OperationCanceledException operationCanceledException) {
                    root[0] = null;
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.cdt.core", 0, "Error in CDT Core during AST creation", ex);
                CCorePlugin.getDefault().getLog().log((IStatus)status);
            }
        });
        return root[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveElement(ITranslationUnit tUnit) {
        if (tUnit == this.fActiveTU) {
            return;
        }
        Object object = this.fCacheMutex;
        synchronized (object) {
            this.fIsReconciling = false;
            this.fActiveTU = tUnit;
            this.cache(null, tUnit);
        }
        if (DEBUG) {
            System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "active element is: " + ASTCache.toString(tUnit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActiveElement(ITranslationUnit tUnit) {
        Object object = this.fCacheMutex;
        synchronized (object) {
            return this.fActiveTU != null && this.fActiveTU.equals(tUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aboutToBeReconciled(ITranslationUnit tUnit) {
        if (tUnit == null) {
            return;
        }
        Object object = this.fCacheMutex;
        synchronized (object) {
            if (this.fActiveTU == null || !this.fActiveTU.equals(tUnit)) {
                return;
            }
            if (DEBUG) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "about to reconcile: " + ASTCache.toString(tUnit));
            }
            this.fIsReconciling = true;
            this.cache(null, tUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconciled(IASTTranslationUnit ast, ITranslationUnit tUnit) {
        Object object = this.fCacheMutex;
        synchronized (object) {
            if (tUnit == null || !tUnit.equals(this.fActiveTU)) {
                if (DEBUG) {
                    System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "ignoring AST of out-dated element");
                }
                return;
            }
            if (DEBUG) {
                System.out.println(DEBUG_PREFIX + ASTCache.getThreadName() + "reconciled: " + ASTCache.toString(tUnit) + ", AST: " + ASTCache.toString(ast));
            }
            this.fIsReconciling = false;
            this.cache(ast, tUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReconciling(ITranslationUnit tUnit) {
        Object object = this.fCacheMutex;
        synchronized (object) {
            block4: {
                if (this.fActiveTU != null && tUnit != null) break block4;
                return false;
            }
            return this.fIsReconciling && this.fActiveTU.equals(tUnit);
        }
    }

    private static String getThreadName() {
        String name = Thread.currentThread().getName();
        if (name != null) {
            return String.valueOf(name) + ": ";
        }
        return String.valueOf(Thread.currentThread().toString()) + ": ";
    }

    private static String toString(ITranslationUnit tUnit) {
        if (tUnit == null) {
            return "null";
        }
        return tUnit.getElementName();
    }

    private static String toString(IASTTranslationUnit ast) {
        if (ast == null) {
            return "null";
        }
        return ast.getFilePath();
    }

    public static interface ASTRunnable {
        public IStatus runOnAST(ILanguage var1, IASTTranslationUnit var2) throws CoreException;
    }
}

