/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.BinaryContainerInfo;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class BinaryContainer
extends Openable
implements IBinaryContainer {
    public BinaryContainer(CProject cProject) {
        super(cProject, null, CCorePlugin.getResourceString("CoreModel.BinaryContainer.Binaries"), 30);
    }

    synchronized void sync() {
        BinaryRunner runner = CModelManager.getDefault().getBinaryRunner(this.getCProject());
        if (runner != null) {
            runner.waitIfRunning();
        }
    }

    public IBinary[] getBinaries() throws CModelException {
        this.sync();
        ICElement[] e = this.getChildren();
        ArrayList<IBinary> list = new ArrayList<IBinary>(e.length);
        int i = 0;
        while (i < e.length) {
            IBinary bin;
            if (e[i] instanceof IBinary && ((bin = (IBinary)e[i]).isExecutable() || bin.isSharedLib())) {
                list.add(bin);
            }
            ++i;
        }
        IBinary[] b = new IBinary[list.size()];
        list.toArray(b);
        return b;
    }

    public CElementInfo createElementInfo() {
        return new BinaryContainerInfo(this);
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        CModelManager.getDefault().getBinaryRunner(this.getCProject());
        return true;
    }
}

