/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.Archive;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CContainer
extends Openable
implements ICContainer {
    CModelManager factory = CModelManager.getDefault();

    public CContainer(ICElement parent, IResource res) {
        this(parent, res, 12);
    }

    public CContainer(ICElement parent, IResource res, int type) {
        super(parent, res, type);
    }

    public IBinary[] getBinaries() throws CModelException {
        List list = this.getChildrenOfType(14);
        IBinary[] array = new IBinary[list.size()];
        list.toArray(array);
        return array;
    }

    public IBinary getBinary(String name) {
        IFile file = this.getContainer().getFile((IPath)new Path(name));
        return this.getBinary(file);
    }

    public IBinary getBinary(IFile file) {
        IBinaryParser.IBinaryFile bin = this.factory.createBinaryFile(file);
        if (bin instanceof IBinaryParser.IBinaryObject) {
            return new Binary((ICElement)this, file, (IBinaryParser.IBinaryObject)bin);
        }
        return new Binary((ICElement)this, file, null);
    }

    public IArchive[] getArchives() throws CModelException {
        List list = this.getChildrenOfType(18);
        IArchive[] array = new IArchive[list.size()];
        list.toArray(array);
        return array;
    }

    public IArchive getArchive(String name) {
        IFile file = this.getContainer().getFile((IPath)new Path(name));
        return this.getArchive(file);
    }

    public IArchive getArchive(IFile file) {
        IBinaryParser.IBinaryFile ar = this.factory.createBinaryFile(file);
        if (ar != null && ar.getType() == 8) {
            return new Archive((ICElement)this, file, (IBinaryParser.IBinaryArchive)ar);
        }
        return new Archive((ICElement)this, file, null);
    }

    public ITranslationUnit[] getTranslationUnits() throws CModelException {
        List list = this.getChildrenOfType(60);
        ITranslationUnit[] array = new ITranslationUnit[list.size()];
        list.toArray(array);
        return array;
    }

    public ITranslationUnit getTranslationUnit(String name) {
        IFile file = this.getContainer().getFile((IPath)new Path(name));
        return this.getTranslationUnit(file);
    }

    public ITranslationUnit getTranslationUnit(IFile file) {
        String id = CoreModel.getRegistedContentTypeId(file.getProject(), file.getName());
        return new TranslationUnit((ICElement)this, file, id);
    }

    public ICContainer[] getCContainers() throws CModelException {
        List list = this.getChildrenOfType(12);
        ICContainer[] array = new ICContainer[list.size()];
        list.toArray(array);
        return array;
    }

    public ICContainer getCContainer(String name) {
        IFolder folder = this.getContainer().getFolder((IPath)new Path(name));
        return this.getCContainer(folder);
    }

    public ICContainer getCContainer(IFolder folder) {
        return new CContainer(this, (IResource)folder);
    }

    public IContainer getContainer() {
        return (IContainer)this.getResource();
    }

    protected CElementInfo createElementInfo() {
        return new CContainerInfo(this);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    /*
     * Exception decompiling
     */
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 65->68)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object[] getNonCResources() throws CModelException {
        return ((CContainerInfo)this.getElementInfo()).getNonCResources(this.getResource());
    }

    protected boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        ArrayList<ICElement> vChildren = new ArrayList<ICElement>();
        try {
            IResource[] resources = null;
            if (res instanceof IContainer) {
                IContainer container = (IContainer)res;
                resources = container.members(false);
            }
            if (resources != null) {
                ICProject cproject = this.getCProject();
                int i = 0;
                while (i < resources.length) {
                    ICElement celement = this.computeChild(resources[i], cproject);
                    if (celement != null) {
                        vChildren.add(celement);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        info.setChildren(vChildren);
        if (info instanceof CContainerInfo) {
            ((CContainerInfo)info).setNonCResources(null);
        }
        return true;
    }

    protected ICElement computeChild(IResource res, ICProject cproject) throws CModelException {
        Openable celement = null;
        SourceRoot sroot = this.getSourceRoot();
        switch (res.getType()) {
            case 1: {
                IBinaryParser.IBinaryFile bin;
                IFile file = (IFile)res;
                boolean checkBinary = true;
                if (sroot != null && sroot.isOnSourceEntry(res)) {
                    String id = CoreModel.getRegistedContentTypeId(file.getProject(), file.getName());
                    if (id != null) {
                        celement = new TranslationUnit((ICElement)this, file, id);
                        checkBinary = false;
                    } else {
                        checkBinary = true;
                    }
                }
                if (!checkBinary || !cproject.isOnOutputEntry((IResource)file) || (bin = this.factory.createBinaryFile(file)) == null) break;
                if (bin.getType() == 8) {
                    celement = new Archive((ICElement)this, file, (IBinaryParser.IBinaryArchive)bin);
                    ArchiveContainer vlib = (ArchiveContainer)cproject.getArchiveContainer();
                    vlib.addChild(celement);
                    break;
                }
                celement = new Binary((ICElement)this, file, (IBinaryParser.IBinaryObject)bin);
                if (bin.getType() != 2 && bin.getType() != 4) break;
                BinaryContainer vbin = (BinaryContainer)cproject.getBinaryContainer();
                vbin.addChild(celement);
                break;
            }
            case 2: {
                if ((sroot == null || !sroot.isOnSourceEntry(res)) && !cproject.isOnOutputEntry(res)) break;
                celement = new CContainer(this, res);
            }
        }
        return celement;
    }
}

