/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.ResourceContainerRelativeLocationConverter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.pdom.Checksums;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.TeamPDOMImportOperation;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class TeamPDOMExportOperation
implements IWorkspaceRunnable {
    private ICProject fProject;
    private String fTargetLocation;
    private File fTargetLocationFile;
    private MessageDigest fMessageDigest;

    public TeamPDOMExportOperation(ICProject project) {
        this.fProject = project;
    }

    public void setTargetLocation(String location) {
        this.fTargetLocation = location;
    }

    public void setOptions(int options) {
    }

    public void setAlgorithm(MessageDigest md) {
        this.fMessageDigest = md;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        File tmpChecksums;
        block9: {
            this.getMessageDigest();
            this.getTargetLocation();
            File tmpPDOM = null;
            tmpChecksums = null;
            try {
                tmpPDOM = File.createTempFile("tmp", ".pdom");
                tmpChecksums = File.createTempFile("checksums", ".dat");
            }
            catch (IOException e) {
                throw new CoreException(CCorePlugin.createStatus(Messages.TeamPDOMExportOperation_errorCreatingTempFile, e));
            }
            try {
                PDOMManager pdomManager = CCoreInternals.getPDOMManager();
                monitor.beginTask("", 100);
                pdomManager.joinIndexer(Integer.MAX_VALUE, (IProgressMonitor)this.subMonitor(monitor, 1));
                this.checkMonitor(monitor);
                ResourceContainerRelativeLocationConverter converter = new ResourceContainerRelativeLocationConverter((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                pdomManager.exportProjectPDOM(this.fProject, tmpPDOM, converter);
                this.checkMonitor(monitor);
                monitor.worked(5);
                PDOM pdom = new PDOM(tmpPDOM, converter, LanguageManager.getInstance().getPDOMLinkageFactoryMappings());
                try {
                    monitor.setTaskName(Messages.Checksums_taskComputeChecksums);
                    this.createChecksums(this.fProject, pdom, tmpChecksums, (IProgressMonitor)this.subMonitor(monitor, 94));
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    pdom.close();
                    throw throwable;
                }
                {
                    Object var7_10 = null;
                }
                pdom.close();
                this.createArchive(tmpPDOM, tmpChecksums);
                monitor.setTaskName(Messages.TeamPDOMExportOperation_taskExportIndex);
                IndexerPreferences.setIndexImportLocation(this.fProject.getProject(), this.fTargetLocation.toString());
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (tmpPDOM != null) {
                    tmpPDOM.delete();
                }
                if (tmpChecksums == null) throw throwable;
                tmpChecksums.delete();
                throw throwable;
            }
            {
                Object var9_13 = null;
                if (tmpPDOM == null) break block9;
                tmpPDOM.delete();
            }
        }
        if (tmpChecksums == null) return;
        tmpChecksums.delete();
    }

    private void getTargetLocation() throws CoreException {
        this.fTargetLocationFile = TeamPDOMImportOperation.expandLocation(this.fProject.getProject(), this.fTargetLocation);
    }

    private void getMessageDigest() throws CoreException {
        if (this.fMessageDigest == null) {
            try {
                this.fMessageDigest = Checksums.getDefaultAlgorithm();
            }
            catch (NoSuchAlgorithmException e) {
                throw new CoreException(CCorePlugin.createStatus(e.getMessage(), e));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createChecksums(ICProject cproject, PDOM pdom, File target, IProgressMonitor monitor) throws CoreException {
        List locs;
        try {
            pdom.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        try {
            locs = pdom.getAllFileLocations();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            pdom.releaseReadLock();
            throw throwable;
        }
        {
            Object var6_9 = null;
            pdom.releaseReadLock();
            int i = 0;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = new IFile[locs.size()];
        Iterator iterator = locs.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Map map = Checksums.createChecksumMap(files, this.fMessageDigest, monitor);
                this.writeChecksums(map, target);
                return;
            }
            IndexFileLocation floc = (IndexFileLocation)iterator.next();
            String fullPath = floc.getFullPath();
            if (fullPath == null) continue;
            files[i++] = root.getFile((IPath)new Path(fullPath));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeChecksums(Map map, File target) throws CoreException {
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(new FileOutputStream(target));
                out.writeObject(map);
            }
            catch (IOException e) {
                throw new CoreException(CCorePlugin.createStatus(Messages.TeamPDOMExportOperation_errorWriteTempFile, e));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.close(out);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.close(out);
            return;
        }
    }

    private void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    private void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createArchive(File tmpPDOM, File tmpChecksums) throws CoreException {
        this.fTargetLocationFile.delete();
        ZipOutputStream out = null;
        try {
            try {
                this.fTargetLocationFile.getParentFile().mkdirs();
                out = new ZipOutputStream(new FileOutputStream(this.fTargetLocationFile));
                out.setLevel(9);
                this.writeEntry(out, "cdt-index.pdom", tmpPDOM);
                this.writeEntry(out, "checksums.dat", tmpChecksums);
            }
            catch (IOException e) {
                throw new CoreException(CCorePlugin.createStatus(Messages.TeamPDOMExportOperation_errorCreateArchive, e));
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.close(out);
            throw throwable;
        }
        {
            Object var5_9 = null;
            this.close(out);
        }
        IFile[] wsResource = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(this.fTargetLocationFile.getAbsolutePath()));
        int i = 0;
        while (i < wsResource.length) {
            IFile file = wsResource[i];
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeEntry(ZipOutputStream out, String name, File input) throws IOException {
        ZipEntry e = new ZipEntry(name);
        out.putNextEntry(e);
        int read = 0;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(input);
        try {
            while (true) {
                block4: {
                    if ((read = ((InputStream)in).read(buffer)) >= 0) break block4;
                    out.closeEntry();
                    break;
                }
                out.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.close(in);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.close(in);
            return;
        }
    }

    private SubProgressMonitor subMonitor(IProgressMonitor monitor, int ticks) {
        return new SubProgressMonitor(monitor, ticks);
    }

    private void checkMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }
}

