/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.pdom.Checksums;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class TeamPDOMImportOperation
implements IWorkspaceRunnable {
    static final String CHECKSUMS_NAME = "checksums.dat";
    static final String INDEX_NAME = "cdt-index.pdom";
    private static final Pattern PROJECT_VAR_PATTERN = Pattern.compile("\\$\\{(project_[a-zA-Z0-9]*)\\}");
    private static final String PROJECT_VAR_REPLACEMENT_BEGIN = "\\${$1:";
    private static final String PROJECT_VAR_REPLACEMENT_END = "}";
    private static final String DOLLAR_OR_BACKSLASH_REPLACEMENT = "\\\\$0";
    private static final Pattern DOLLAR_OR_BACKSLASH_PATTERN = Pattern.compile("[\\$\\\\]");
    private ICProject fProject;
    private boolean fSuccess;
    private boolean fShowActivity;

    public TeamPDOMImportOperation(ICProject project) {
        this.fProject = project;
        this.fShowActivity = PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/activity", "true");
    }

    public void run(IProgressMonitor pm) {
        if (this.fShowActivity) {
            System.out.println("Indexer: PDOMImporter start");
        }
        this.fSuccess = false;
        Throwable ex = null;
        try {
            File importFile = this.getImportLocation();
            if (importFile.exists()) {
                this.doImportIndex(importFile, pm);
                this.fSuccess = true;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        catch (ZipException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (CoreException e) {
            ex = e;
        }
        if (ex != null) {
            CCorePlugin.log(ex);
        }
        if (this.fShowActivity) {
            System.out.println("Indexer: PDOMImporter completed, ok=" + this.fSuccess);
        }
    }

    public boolean wasSuccessful() {
        return this.fSuccess;
    }

    private File getImportLocation() throws CoreException {
        IProject project = this.fProject.getProject();
        String locationString = IndexerPreferences.getIndexImportLocation(project);
        return TeamPDOMImportOperation.expandLocation(project, locationString);
    }

    static File expandLocation(IProject project, String loc) throws CoreException {
        String replacement = PROJECT_VAR_REPLACEMENT_BEGIN + DOLLAR_OR_BACKSLASH_PATTERN.matcher(project.getName()).replaceAll(DOLLAR_OR_BACKSLASH_REPLACEMENT) + PROJECT_VAR_REPLACEMENT_END;
        loc = PROJECT_VAR_PATTERN.matcher(loc).replaceAll(replacement);
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        Path location = new Path(varManager.performStringSubstitution(loc));
        if (!location.isAbsolute()) {
            location = project.getLocation().append((IPath)location);
        }
        return location.toFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doImportIndex(File importFile, IProgressMonitor monitor) throws CoreException, InterruptedException, IOException {
        block6: {
            zip = new ZipFile(importFile);
            checksums = null;
            try {
                this.importIndex(zip, monitor);
                checksums = this.getChecksums(zip);
            }
            catch (Throwable var6_5) {
                var5_6 = null;
                try {
                    zip.close();
                    throw var6_5;
                }
                catch (IOException e) {
                    CCorePlugin.log(e);
                }
                throw var6_5;
            }
            {
                var5_7 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 38->45)] { 
lbl18:
            // 1 sources

            zip.close();
            break block6;
lbl20:
            // 1 sources

            catch (IOException e) {
                CCorePlugin.log(e);
            }
        }
        this.checkIndex(checksums, monitor);
    }

    private void importIndex(ZipFile zip, IProgressMonitor monitor) throws CoreException, IOException {
        ZipEntry indexEntry = zip.getEntry(INDEX_NAME);
        if (indexEntry == null) {
            throw new CoreException(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMImportTask_errorInvalidArchive, (Object)zip.getName())));
        }
        InputStream stream = zip.getInputStream(indexEntry);
        CCoreInternals.getPDOMManager().importProjectPDOM(this.fProject, stream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getChecksums(ZipFile zip) {
        ZipEntry indexEntry = zip.getEntry(CHECKSUMS_NAME);
        if (indexEntry == null) return Collections.EMPTY_MAP;
        try {
            ObjectInputStream input;
            block5: {
                Map map;
                input = new ObjectInputStream(zip.getInputStream(indexEntry));
                try {
                    Object obj = input.readObject();
                    if (!(obj instanceof Map)) break block5;
                    map = (Map)obj;
                    Object var5_7 = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    input.close();
                    throw throwable;
                }
                input.close();
                return map;
            }
            Object var5_9 = null;
            input.close();
            return Collections.EMPTY_MAP;
        }
        catch (Exception e) {
            CCorePlugin.log(e);
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkIndex(Map checksums, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ArrayList<FileAndChecksum> filesToCheck = new ArrayList<FileAndChecksum>();
        WritablePDOM pdom = (WritablePDOM)CCoreInternals.getPDOMManager().getPDOM(this.fProject);
        pdom.acquireReadLock();
        try {
            if (pdom.versionMismatch()) {
                throw new CoreException(CCorePlugin.createStatus(NLS.bind((String)Messages.PDOMImportTask_errorInvalidPDOMVersion, (Object)this.fProject.getElementName())));
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            List filesToDelete = pdom.getAllFileLocations();
            Iterator i = filesToDelete.iterator();
            while (i.hasNext()) {
                this.checkMonitor(monitor);
                byte[] checksum = null;
                ITranslationUnit tu = null;
                IIndexFileLocation ifl = (IIndexFileLocation)i.next();
                String fullPathStr = ifl.getFullPath();
                if (fullPathStr != null) {
                    Path fullPath = new Path(fullPathStr);
                    IFile file = root.getFile((IPath)fullPath);
                    boolean exists = file.exists();
                    if (!exists) {
                        try {
                            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                            exists = file.exists();
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    }
                    if (exists && (tu = (ITranslationUnit)CoreModel.getDefault().create(file)) != null) {
                        checksum = Checksums.getChecksum(checksums, file);
                    }
                }
                if (checksum == null) continue;
                filesToCheck.add(new FileAndChecksum(tu, checksum));
                i.remove();
            }
            try {
                this.removeOutdatedFiles(checksums, filesToCheck, monitor);
            }
            catch (NoSuchAlgorithmException e) {
                CCorePlugin.log(e);
            }
            this.deleteFiles(pdom, 1, filesToDelete, filesToCheck, monitor);
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            pdom.releaseReadLock();
            throw throwable;
        }
        pdom.releaseReadLock();
    }

    private void checkMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteFiles(WritablePDOM pdom, int giveupReadlocks, List filesToDelete, List updateTimestamps, IProgressMonitor monitor) throws InterruptedException, CoreException {
        pdom.acquireWriteLock(giveupReadlocks);
        try {
            IIndexFragmentFile file;
            Iterator i = filesToDelete.iterator();
            while (true) {
                if (!i.hasNext()) {
                    i = updateTimestamps.iterator();
                    break;
                }
                this.checkMonitor(monitor);
                IndexFileLocation ifl = (IndexFileLocation)i.next();
                file = pdom.getFile(ifl);
                pdom.clearFile(file, null);
            }
            while (i.hasNext()) {
                IResource r;
                this.checkMonitor(monitor);
                FileAndChecksum fc = (FileAndChecksum)i.next();
                file = pdom.getFile(IndexLocationFactory.getIFL(fc.fFile));
                if (file == null || (r = fc.fFile.getResource()) == null) continue;
                file.setTimestamp(r.getLocalTimeStamp());
                file.setScannerConfigurationHashcode(0);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            pdom.releaseWriteLock(giveupReadlocks, true);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        pdom.releaseWriteLock(giveupReadlocks, true);
    }

    private void removeOutdatedFiles(Map checksums, List filesToCheck, IProgressMonitor monitor) throws NoSuchAlgorithmException {
        MessageDigest md = Checksums.getAlgorithm(checksums);
        Iterator i = filesToCheck.iterator();
        while (i.hasNext()) {
            IPath location;
            this.checkMonitor(monitor);
            FileAndChecksum cs = (FileAndChecksum)i.next();
            ITranslationUnit tu = cs.fFile;
            if (tu == null || (location = tu.getLocation()) == null) continue;
            try {
                byte[] checksum = Checksums.computeChecksum(md, location.toFile());
                if (Arrays.equals(checksum, cs.fChecksum)) continue;
                i.remove();
            }
            catch (IOException e) {
                CCorePlugin.log(e);
            }
        }
    }

    private static final class FileAndChecksum {
        public ITranslationUnit fFile;
        public byte[] fChecksum;

        public FileAndChecksum(ITranslationUnit tu, byte[] checksum) {
            this.fFile = tu;
            this.fChecksum = checksum;
        }
    }
}

