/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBProperties;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class WritablePDOM
extends PDOM
implements IWritableIndexFragment {
    private boolean fClearedBecauseOfVersionMismatch = false;
    private boolean fCreatedFromScratch = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.WritablePDOM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, Map linkageFactoryMappings) throws CoreException {
        this(dbPath, locationConverter, ChunkCache.getSharedInstance(), linkageFactoryMappings);
    }

    public WritablePDOM(File dbPath, IIndexLocationConverter locationConverter, ChunkCache cache, Map linkageFactoryMappings) throws CoreException {
        super(dbPath, locationConverter, cache, linkageFactoryMappings);
    }

    public IIndexFragmentFile addFile(IIndexFileLocation location) throws CoreException {
        return super.addFile(location);
    }

    public void addFileContent(IIndexFragmentFile sourceFile, IWritableIndex.IncludeInformation[] includes, IASTPreprocessorMacroDefinition[] macros, IASTName[][] names) throws CoreException {
        if (!$assertionsDisabled && sourceFile.getIndexFragment() != this) {
            throw new AssertionError();
        }
        PDOMFile pdomFile = (PDOMFile)sourceFile;
        pdomFile.addIncludesTo(includes);
        pdomFile.addMacros(macros);
        pdomFile.addNames(names);
    }

    public void clearFile(IIndexFragmentFile file, Collection contextsRemoved) throws CoreException {
        if (!$assertionsDisabled && file.getIndexFragment() != this) {
            throw new AssertionError();
        }
        ((PDOMFile)file).clear(contextsRemoved);
    }

    public void clear() throws CoreException {
        super.clear();
    }

    public void flush() throws CoreException {
        super.flush();
    }

    public PDOMBinding addBinding(IASTName name) throws CoreException {
        PDOMBinding result = null;
        PDOMLinkage linkage = this.createLinkage(name.getLinkage().getID());
        if (linkage == null) {
            CCorePlugin.log(MessageFormat.format(Messages.WritablePDOM_error_unknownLinkage, name.getLinkage()));
        } else {
            result = linkage.addBinding(name);
        }
        return result;
    }

    public void setProperty(String propertyName, String value) throws CoreException {
        new DBProperties(this.db, 1036).setProperty(propertyName, value);
    }

    public void rewriteLocations(IIndexLocationConverter newConverter) throws CoreException {
        PDOMFile file;
        final ArrayList pdomfiles = new ArrayList();
        this.getFileIndex().accept(new IBTreeVisitor(){

            public int compare(int record) throws CoreException {
                return 0;
            }

            public boolean visit(int record) throws CoreException {
                PDOMFile file = new PDOMFile((PDOM)WritablePDOM.this, record);
                pdomfiles.add(file);
                return true;
            }
        });
        this.clearFileIndex();
        ArrayList<PDOMFile> notConverted = new ArrayList<PDOMFile>();
        Iterator i = pdomfiles.iterator();
        while (i.hasNext()) {
            file = (PDOMFile)i.next();
            String internalFormat = newConverter.toInternalFormat(file.getLocation());
            if (internalFormat != null) {
                file.setInternalLocation(internalFormat);
                this.getFileIndex().insert(file.getRecord());
                continue;
            }
            notConverted.add(file);
        }
        i = notConverted.iterator();
        while (i.hasNext()) {
            file = (PDOMFile)i.next();
            file.convertIncludersToUnresolved();
            file.clear(null);
        }
    }

    boolean isClearedBecauseOfVersionMismatch() {
        return this.fClearedBecauseOfVersionMismatch;
    }

    void setClearedBecauseOfVersionMismatch(boolean clearedBecauseOfVersionMismatch) {
        this.fClearedBecauseOfVersionMismatch = clearedBecauseOfVersionMismatch;
    }

    boolean isCreatedFromScratch() {
        return this.fCreatedFromScratch;
    }

    void setCreatedFromScratch(boolean createdFromScratch) {
        this.fCreatedFromScratch = createdFromScratch;
    }

    protected final boolean isPermanentlyReadOnly() {
        return false;
    }
}

