/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.ListItem;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMNodeLinkedList {
    private PDOM pdom;
    private int offset;
    private PDOMLinkage linkage;
    private boolean allowsNull;
    private static final int FIRST_MEMBER = 0;
    protected static final int RECORD_SIZE = 4;

    public PDOMNodeLinkedList(PDOM pdom, int offset, PDOMLinkage linkage, boolean allowsNulls) {
        this.pdom = pdom;
        this.offset = offset;
        this.linkage = linkage;
        this.allowsNull = allowsNulls;
    }

    public PDOMNodeLinkedList(PDOM pdom, int offset, PDOMLinkage linkage) {
        this(pdom, offset, linkage, false);
    }

    protected int getRecordSize() {
        return 4;
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        ListItem firstItem = this.getFirstMemberItem();
        if (firstItem == null) {
            return;
        }
        ListItem item = firstItem;
        do {
            PDOMNode node;
            int record;
            if ((record = item.getItem()) == 0) {
                if (!this.allowsNull) {
                    throw new NullPointerException();
                }
                node = null;
            } else {
                node = this.linkage.getNode(item.getItem());
            }
            if (visitor.visit(node) && node != null) {
                node.accept(visitor);
            }
            visitor.leave(node);
        } while (!(item = item.getNext()).equals(firstItem));
    }

    private ListItem getFirstMemberItem() throws CoreException {
        Database db = this.pdom.getDB();
        int item = db.getInt(this.offset + 0);
        return item != 0 ? new ListItem(db, item) : null;
    }

    public void addMember(PDOMNode member) throws CoreException {
        this.addMember(this.allowsNull && member == null ? 0 : member.getRecord());
    }

    protected void addMember(int record) throws CoreException {
        Database db = this.pdom.getDB();
        ListItem firstMember = this.getFirstMemberItem();
        if (firstMember == null) {
            firstMember = new ListItem(db);
            firstMember.setItem(record);
            firstMember.setNext(firstMember);
            firstMember.setPrev(firstMember);
            db.putInt(this.offset + 0, firstMember.getRecord());
        } else {
            ListItem newMember = new ListItem(db);
            newMember.setItem(record);
            ListItem prevMember = firstMember.getPrev();
            prevMember.setNext(newMember);
            firstMember.setPrev(newMember);
            newMember.setPrev(prevMember);
            newMember.setNext(firstMember);
        }
    }
}

